/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
 * SalesOrderWithoutChargeItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SalesOrderWithoutChargeItemField
 * SalesOrderWithoutChargeItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SalesOrderWithoutChargeItemLink
 * SalesOrderWithoutChargeItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SALES_ORDER_WITHOUT_CHARGE
 * SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SALES_ORDER_WITHOUT_CHARGE_ITEM
 * SALES_ORDER_WITHOUT_CHARGE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SLS_ORD_WTHOUT_CHRG_ITEM_CATEGORY
 * SLS_ORD_WTHOUT_CHRG_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SALES_ORDER_WTHOUT_CHRG_ITEM_TEXT
 * SALES_ORDER_WTHOUT_CHRG_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REQUESTED_QUANTITY_SAP_UNIT
 * REQUESTED_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REQUESTED_QUANTITY_ISO_UNIT
 * REQUESTED_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_WEIGHT_SAP_UNIT
 * ITEM_WEIGHT_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_WEIGHT_ISO_UNIT
 * ITEM_WEIGHT_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_VOLUME_SAP_UNIT
 * ITEM_VOLUME_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#ITEM_VOLUME_ISO_UNIT
 * ITEM_VOLUME_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#MATERIAL_PRICING_GROUP
 * MATERIAL_PRICING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SHIPPING_TYPE
 * SHIPPING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#DELIVERY_PRIORITY
 * DELIVERY_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#DELIVERY_DATE_TYPE_RULE
 * DELIVERY_DATE_TYPE_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#DELIVERY_STATUS
 * DELIVERY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#TO_SALES_ORDER_WITHOUT_CHARGE
 * TO_SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#TO_SCHEDULE_LINE
 * TO_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface SalesOrderWithoutChargeItemSelectable extends EntitySelectable<SalesOrderWithoutChargeItem>
{

}
