/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
 * SlsOrdWthoutChrgItmPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgItmPartnerField
 * SlsOrdWthoutChrgItmPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgItmPartnerLink
 * SlsOrdWthoutChrgItmPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#SALES_ORDER_WITHOUT_CHARGE
 * SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#SALES_ORDER_WITHOUT_CHARGE_ITEM
 * SALES_ORDER_WITHOUT_CHARGE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner#TO_SALES_ORDER_WITHOUT_CHARGE
 * TO_SALES_ORDER_WITHOUT_CHARGE}</li>
 * </ul>
 *
 */
public interface SlsOrdWthoutChrgItmPartnerSelectable extends EntitySelectable<SlsOrdWthoutChrgItmPartner>
{

}
