/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
 * SlsOrdWthoutChrgItmText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgItmTextField
 * SlsOrdWthoutChrgItmTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgItmTextLink
 * SlsOrdWthoutChrgItmTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#SALES_ORDER_WITHOUT_CHARGE
 * SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#SALES_ORDER_WITHOUT_CHARGE_ITEM
 * SALES_ORDER_WITHOUT_CHARGE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#TO_SALES_ORDER_WITHOUT_CHARGE
 * TO_SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText#TO_SALES_ORDER_WITHOUT_CHARGE_ITEM
 * TO_SALES_ORDER_WITHOUT_CHARGE_ITEM}</li>
 * </ul>
 *
 */
public interface SlsOrdWthoutChrgItmTextSelectable extends EntitySelectable<SlsOrdWthoutChrgItmText>
{

}
