/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
 * SlsOrdWthoutChrgPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgPartnerField
 * SlsOrdWthoutChrgPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgPartnerLink
 * SlsOrdWthoutChrgPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#SALES_ORDER_WITHOUT_CHARGE
 * SALES_ORDER_WITHOUT_CHARGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner#TO_SALES_ORDER_WITHOUT_CHARGE
 * TO_SALES_ORDER_WITHOUT_CHARGE}</li>
 * </ul>
 *
 */
public interface SlsOrdWthoutChrgPartnerSelectable extends EntitySelectable<SlsOrdWthoutChrgPartner>
{

}
