/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.field.SalesOrganizationTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.link.SalesOrganizationTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.selectable.SalesOrganizationTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Organization Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrganizationTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrganizationText extends VdmEntity<SalesOrganizationText>
{

    /**
     * Selector for all available fields of SalesOrganizationText.
     *
     */
    public final static SalesOrganizationTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> SALES_ORGANIZATION =
        new SalesOrganizationTextField<String>("SalesOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> LANGUAGE =
        new SalesOrganizationTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationName</b>
     * </p>
     *
     * @return Sales Organization Description
     */
    @SerializedName( "SalesOrganizationName" )
    @JsonProperty( "SalesOrganizationName" )
    @Nullable
    @ODataField( odataName = "SalesOrganizationName" )
    private String salesOrganizationName;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationName</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> SALES_ORGANIZATION_NAME =
        new SalesOrganizationTextField<String>("SalesOrganizationName");
    /**
     * Navigation property <b>to_SalesOrganization</b> for <b>SalesOrganizationText</b> to single
     * <b>SalesOrganization</b>.
     *
     */
    @SerializedName( "to_SalesOrganization" )
    @JsonProperty( "to_SalesOrganization" )
    @ODataField( odataName = "to_SalesOrganization" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrganization toSalesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrganization</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrganizationTextOneToOneLink<SalesOrganization> TO_SALES_ORGANIZATION =
        new SalesOrganizationTextOneToOneLink<SalesOrganization>("to_SalesOrganization");

    @Nonnull
    @Override
    public Class<SalesOrganizationText> getType()
    {
        return SalesOrganizationText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationName</b>
     * </p>
     *
     * @param salesOrganizationName
     *            Sales Organization Description
     */
    public void setSalesOrganizationName( @Nullable final String salesOrganizationName )
    {
        rememberChangedField("SalesOrganizationName", this.salesOrganizationName);
        this.salesOrganizationName = salesOrganizationName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrganizationText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrganization", getSalesOrganization());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrganization", getSalesOrganization());
        values.put("Language", getLanguage());
        values.put("SalesOrganizationName", getSalesOrganizationName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SalesOrganizationName") ) {
                final Object value = values.remove("SalesOrganizationName");
                if( (value == null) || (!value.equals(getSalesOrganizationName())) ) {
                    setSalesOrganizationName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesOrganization") ) {
                final Object value = (values).remove("to_SalesOrganization");
                if( value instanceof Map ) {
                    if( toSalesOrganization == null ) {
                        toSalesOrganization = new SalesOrganization();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrganization.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrganizationTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrganizationTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrganizationTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrganizationTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesOrganization != null ) {
            (values).put("to_SalesOrganization", toSalesOrganization);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrganization</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesOrganization</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrganization</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization fetchSalesOrganization()
    {
        return fetchFieldAsSingle("to_SalesOrganization", SalesOrganization.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrganization</b>.
     * <p>
     * If the navigation property <b>to_SalesOrganization</b> of a queried <b>SalesOrganizationText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganization</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization getSalesOrganizationOrFetch()
    {
        if( toSalesOrganization == null ) {
            toSalesOrganization = fetchSalesOrganization();
        }
        return toSalesOrganization;
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrganization</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganizationText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrganization</b> is already loaded, the result will
     *         contain the <b>SalesOrganization</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrganization> getSalesOrganizationIfPresent()
    {
        return Option.of(toSalesOrganization);
    }

    /**
     * Overwrites the associated <b>SalesOrganization</b> entity for the loaded navigation property
     * <b>to_SalesOrganization</b>.
     *
     * @param value
     *            New <b>SalesOrganization</b> entity.
     */
    public void setSalesOrganization( final SalesOrganization value )
    {
        toSalesOrganization = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrganizationText instances.
     *
     */
    public final static class SalesOrganizationTextBuilder
    {

        private SalesOrganization toSalesOrganization;
        private String salesOrganization = null;

        private SalesOrganizationText.SalesOrganizationTextBuilder toSalesOrganization( final SalesOrganization value )
        {
            toSalesOrganization = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrganization</b> for <b>SalesOrganizationText</b> to single
         * <b>SalesOrganization</b>.
         *
         * @param value
         *            The SalesOrganization to build this SalesOrganizationText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganizationText.SalesOrganizationTextBuilder salesOrganization( final SalesOrganization value )
        {
            return toSalesOrganization(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrganization</b>
         * </p>
         *
         * @param value
         *            The salesOrganization to build this SalesOrganizationText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganizationText.SalesOrganizationTextBuilder salesOrganization( final String value )
        {
            salesOrganization = value;
            return this;
        }

    }

}
