/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesOrganizationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService SalesOrganizationService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesOrganizationServiceBatch
    extends
    BatchFluentHelperBasic<SalesOrganizationServiceBatch, SalesOrganizationServiceBatchChangeSet>
    implements
    SalesOrganizationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesOrganizationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrganizationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesOrganizationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrganizationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrganizationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrganizationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesOrganizationServiceBatchChangeSet(this, service);
    }

}
