/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SalesOrganizationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService SalesOrganizationService}.
 *
 */
public class DefaultSalesOrganizationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesOrganizationServiceBatch, SalesOrganizationServiceBatchChangeSet>
    implements
    SalesOrganizationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesOrganizationServiceBatchChangeSet(
        @Nonnull final DefaultSalesOrganizationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrganizationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrganizationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
