/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization SalesOrganization}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.field.SalesOrganizationField
 * SalesOrganizationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.link.SalesOrganizationLink
 * SalesOrganizationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization#SALES_ORGANIZATION_CURRENCY
 * SALES_ORGANIZATION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization#INTERCOMPANY_BILLING_CUSTOMER
 * INTERCOMPANY_BILLING_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganization#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface SalesOrganizationSelectable extends EntitySelectable<SalesOrganization>
{

}
