/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText
 * SalesOrganizationText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.field.SalesOrganizationTextField
 * SalesOrganizationTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.link.SalesOrganizationTextLink
 * SalesOrganizationTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText#SALES_ORGANIZATION_NAME
 * SALES_ORGANIZATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorganization.SalesOrganizationText#TO_SALES_ORGANIZATION
 * TO_SALES_ORGANIZATION}</li>
 * </ul>
 *
 */
public interface SalesOrganizationTextSelectable extends EntitySelectable<SalesOrganizationText>
{

}
