/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgCndnRecdValidityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgCndnRecdValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgCndnRecdValidityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable.SlsPrcgCndnRecdValiditySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Record Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgCndnRecdValidityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgCndnRecdValidity extends VdmEntity<SlsPrcgCndnRecdValidity>
{

    /**
     * Selector for all available fields of SlsPrcgCndnRecdValidity.
     *
     */
    public final static SlsPrcgCndnRecdValiditySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_RECORD =
        new SlsPrcgCndnRecdValidityField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new SlsPrcgCndnRecdValidityField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new SlsPrcgCndnRecdValidityField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_APPLICATION =
        new SlsPrcgCndnRecdValidityField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ConditionReleaseStatus" )
    @JsonProperty( "ConditionReleaseStatus" )
    @Nullable
    @ODataField( odataName = "ConditionReleaseStatus" )
    private String conditionReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionReleaseStatus</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_RELEASE_STATUS =
        new SlsPrcgCndnRecdValidityField<String>("ConditionReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @return Departure Country/Region (from which the goods are sent)
     */
    @SerializedName( "DepartureCountry" )
    @JsonProperty( "DepartureCountry" )
    @Nullable
    @ODataField( odataName = "DepartureCountry" )
    private String departureCountry;
    /**
     * Use with available fluent helpers to apply the <b>DepartureCountry</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> DEPARTURE_COUNTRY =
        new SlsPrcgCndnRecdValidityField<String>("DepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_DOCUMENT =
        new SlsPrcgCndnRecdValidityField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_DOCUMENT_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BILLABLE_CONTROL =
        new SlsPrcgCndnRecdValidityField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @return Industry key
     */
    @SerializedName( "Industry" )
    @JsonProperty( "Industry" )
    @Nullable
    @ODataField( odataName = "Industry" )
    private String industry;
    /**
     * Use with available fluent helpers to apply the <b>Industry</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> INDUSTRY =
        new SlsPrcgCndnRecdValidityField<String>("Industry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @return City Code
     */
    @SerializedName( "CityCode" )
    @JsonProperty( "CityCode" )
    @Nullable
    @ODataField( odataName = "CityCode" )
    private String cityCode;
    /**
     * Use with available fluent helpers to apply the <b>CityCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CITY_CODE =
        new SlsPrcgCndnRecdValidityField<String>("CityCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @return Condition Contract
     */
    @SerializedName( "ConditionContract" )
    @JsonProperty( "ConditionContract" )
    @Nullable
    @ODataField( odataName = "ConditionContract" )
    private String conditionContract;
    /**
     * Use with available fluent helpers to apply the <b>ConditionContract</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_CONTRACT =
        new SlsPrcgCndnRecdValidityField<String>("ConditionContract");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @return County Code
     */
    @SerializedName( "County" )
    @JsonProperty( "County" )
    @Nullable
    @ODataField( odataName = "County" )
    private String county;
    /**
     * Use with available fluent helpers to apply the <b>County</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> COUNTY =
        new SlsPrcgCndnRecdValidityField<String>("County");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @return Commercial Project ID
     */
    @SerializedName( "EngagementProject" )
    @JsonProperty( "EngagementProject" )
    @Nullable
    @ODataField( odataName = "EngagementProject" )
    private String engagementProject;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProject</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ENGAGEMENT_PROJECT =
        new SlsPrcgCndnRecdValidityField<String>("EngagementProject");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @return Configuration (Internal Object Number)
     */
    @SerializedName( "ConfigurationNumber" )
    @JsonProperty( "ConfigurationNumber" )
    @Nullable
    @ODataField( odataName = "ConfigurationNumber" )
    private String configurationNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurationNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONFIGURATION_NUMBER =
        new SlsPrcgCndnRecdValidityField<String>("ConfigurationNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentType</b>
     * </p>
     *
     * @return Document type
     */
    @SerializedName( "BR_NFDocumentType" )
    @JsonProperty( "BR_NFDocumentType" )
    @Nullable
    @ODataField( odataName = "BR_NFDocumentType" )
    private String bR_NFDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BR_NFDocumentType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BRNF_DOCUMENT_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("BR_NFDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField1</b>
     * </p>
     *
     * @return Dynamic Key Field 1
     */
    @SerializedName( "BRSpcfcFreeDefinedField1" )
    @JsonProperty( "BRSpcfcFreeDefinedField1" )
    @Nullable
    @ODataField( odataName = "BRSpcfcFreeDefinedField1" )
    private String bRSpcfcFreeDefinedField1;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcFreeDefinedField1</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_FREE_DEFINED_FIELD1 =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcFreeDefinedField1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField2</b>
     * </p>
     *
     * @return Dynamic Key Field 2
     */
    @SerializedName( "BRSpcfcFreeDefinedField2" )
    @JsonProperty( "BRSpcfcFreeDefinedField2" )
    @Nullable
    @ODataField( odataName = "BRSpcfcFreeDefinedField2" )
    private String bRSpcfcFreeDefinedField2;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcFreeDefinedField2</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_FREE_DEFINED_FIELD2 =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcFreeDefinedField2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField3</b>
     * </p>
     *
     * @return Dynamic Key Field 3
     */
    @SerializedName( "BRSpcfcFreeDefinedField3" )
    @JsonProperty( "BRSpcfcFreeDefinedField3" )
    @Nullable
    @ODataField( odataName = "BRSpcfcFreeDefinedField3" )
    private String bRSpcfcFreeDefinedField3;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcFreeDefinedField3</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_FREE_DEFINED_FIELD3 =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcFreeDefinedField3");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @return International Article Number (EAN/UPC)
     */
    @SerializedName( "InternationalArticleNumber" )
    @JsonProperty( "InternationalArticleNumber" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumber" )
    private String internationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> INTERNATIONAL_ARTICLE_NUMBER =
        new SlsPrcgCndnRecdValidityField<String>("InternationalArticleNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @return Type of Technical Object
     */
    @SerializedName( "TechnicalObjectType" )
    @JsonProperty( "TechnicalObjectType" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectType" )
    private String technicalObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TECHNICAL_OBJECT_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("TechnicalObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> EQUIPMENT =
        new SlsPrcgCndnRecdValidityField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchy</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "CustomerHierarchy" )
    @JsonProperty( "CustomerHierarchy" )
    @Nullable
    @ODataField( odataName = "CustomerHierarchy" )
    private String customerHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>CustomerHierarchy</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_HIERARCHY =
        new SlsPrcgCndnRecdValidityField<String>("CustomerHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> INCOTERMS_CLASSIFICATION =
        new SlsPrcgCndnRecdValidityField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> INCOTERMS_TRANSFER_LOCATION =
        new SlsPrcgCndnRecdValidityField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @return Tax Type
     */
    @SerializedName( "AccountTaxType" )
    @JsonProperty( "AccountTaxType" )
    @Nullable
    @ODataField( odataName = "AccountTaxType" )
    private String accountTaxType;
    /**
     * Use with available fluent helpers to apply the <b>AccountTaxType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ACCOUNT_TAX_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("AccountTaxType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TxRlvnceClassfctnForArgentina</b>
     * </p>
     *
     * @return Tax relevant classification
     */
    @SerializedName( "TxRlvnceClassfctnForArgentina" )
    @JsonProperty( "TxRlvnceClassfctnForArgentina" )
    @Nullable
    @ODataField( odataName = "TxRlvnceClassfctnForArgentina" )
    private String txRlvnceClassfctnForArgentina;
    /**
     * Use with available fluent helpers to apply the <b>TxRlvnceClassfctnForArgentina</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TX_RLVNCE_CLASSFCTN_FOR_ARGENTINA =
        new SlsPrcgCndnRecdValidityField<String>("TxRlvnceClassfctnForArgentina");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxCode</b>
     * </p>
     *
     * @return SD tax code
     */
    @SerializedName( "BR_TaxCode" )
    @JsonProperty( "BR_TaxCode" )
    @Nullable
    @ODataField( odataName = "BR_TaxCode" )
    private String bR_TaxCode;
    /**
     * Use with available fluent helpers to apply the <b>BR_TaxCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_TAX_CODE =
        new SlsPrcgCndnRecdValidityField<String>("BR_TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LocalSalesTaxApplicabilityCode</b>
     * </p>
     *
     * @return LST CST Applicability Code
     */
    @SerializedName( "LocalSalesTaxApplicabilityCode" )
    @JsonProperty( "LocalSalesTaxApplicabilityCode" )
    @Nullable
    @ODataField( odataName = "LocalSalesTaxApplicabilityCode" )
    private String localSalesTaxApplicabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>LocalSalesTaxApplicabilityCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> LOCAL_SALES_TAX_APPLICABILITY_CODE =
        new SlsPrcgCndnRecdValidityField<String>("LocalSalesTaxApplicabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @return Customer Price Group
     */
    @SerializedName( "CustomerPriceGroup" )
    @JsonProperty( "CustomerPriceGroup" )
    @Nullable
    @ODataField( odataName = "CustomerPriceGroup" )
    private String customerPriceGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPriceGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_PRICE_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("CustomerPriceGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MATERIAL_PRICING_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SOLD_TO_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSoldToParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForSoldToParty" )
    @JsonProperty( "BPForSoldToParty" )
    @Nullable
    @ODataField( odataName = "BPForSoldToParty" )
    private String bPForSoldToParty;
    /**
     * Use with available fluent helpers to apply the <b>BPForSoldToParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BP_FOR_SOLD_TO_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("BPForSoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER =
        new SlsPrcgCndnRecdValidityField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForCustomer</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForCustomer" )
    @JsonProperty( "BPForCustomer" )
    @Nullable
    @ODataField( odataName = "BPForCustomer" )
    private String bPForCustomer;
    /**
     * Use with available fluent helpers to apply the <b>BPForCustomer</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BP_FOR_CUSTOMER =
        new SlsPrcgCndnRecdValidityField<String>("BPForCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PAYER_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForPayerParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForPayerParty" )
    @JsonProperty( "BPForPayerParty" )
    @Nullable
    @ODataField( odataName = "BPForPayerParty" )
    private String bPForPayerParty;
    /**
     * Use with available fluent helpers to apply the <b>BPForPayerParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BP_FOR_PAYER_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("BPForPayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SHIP_TO_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForShipToParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForShipToParty" )
    @JsonProperty( "BPForShipToParty" )
    @Nullable
    @ODataField( odataName = "BPForShipToParty" )
    private String bPForShipToParty;
    /**
     * Use with available fluent helpers to apply the <b>BPForShipToParty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BP_FOR_SHIP_TO_PARTY =
        new SlsPrcgCndnRecdValidityField<String>("BPForShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SUPPLIER =
        new SlsPrcgCndnRecdValidityField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSupplier</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForSupplier" )
    @JsonProperty( "BPForSupplier" )
    @Nullable
    @ODataField( odataName = "BPForSupplier" )
    private String bPForSupplier;
    /**
     * Use with available fluent helpers to apply the <b>BPForSupplier</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BP_FOR_SUPPLIER =
        new SlsPrcgCndnRecdValidityField<String>("BPForSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DestinationCountry</b>
     * </p>
     *
     * @return Destination Country/Region
     */
    @SerializedName( "DestinationCountry" )
    @JsonProperty( "DestinationCountry" )
    @Nullable
    @ODataField( odataName = "DestinationCountry" )
    private String destinationCountry;
    /**
     * Use with available fluent helpers to apply the <b>DestinationCountry</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> DESTINATION_COUNTRY =
        new SlsPrcgCndnRecdValidityField<String>("DestinationCountry");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MATERIAL_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MATERIAL =
        new SlsPrcgCndnRecdValidityField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundExtent</b>
     * </p>
     *
     * @return Returns Refund Code
     */
    @SerializedName( "ReturnsRefundExtent" )
    @JsonProperty( "ReturnsRefundExtent" )
    @Nullable
    @ODataField( odataName = "ReturnsRefundExtent" )
    private String returnsRefundExtent;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsRefundExtent</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> RETURNS_REFUND_EXTENT =
        new SlsPrcgCndnRecdValidityField<String>("ReturnsRefundExtent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @return Material Group 1
     */
    @SerializedName( "AdditionalMaterialGroup1" )
    @JsonProperty( "AdditionalMaterialGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup1" )
    private String additionalMaterialGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup1</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_MATERIAL_GROUP1 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalMaterialGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @return Material Group 2
     */
    @SerializedName( "AdditionalMaterialGroup2" )
    @JsonProperty( "AdditionalMaterialGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup2" )
    private String additionalMaterialGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup2</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_MATERIAL_GROUP2 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalMaterialGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @return Material Group 3
     */
    @SerializedName( "AdditionalMaterialGroup3" )
    @JsonProperty( "AdditionalMaterialGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup3" )
    private String additionalMaterialGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup3</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_MATERIAL_GROUP3 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalMaterialGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @return Material Group 4
     */
    @SerializedName( "AdditionalMaterialGroup4" )
    @JsonProperty( "AdditionalMaterialGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup4" )
    private String additionalMaterialGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup4</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_MATERIAL_GROUP4 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalMaterialGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @return Material Group 5
     */
    @SerializedName( "AdditionalMaterialGroup5" )
    @JsonProperty( "AdditionalMaterialGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup5" )
    private String additionalMaterialGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup5</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_MATERIAL_GROUP5 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalMaterialGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PERSONNEL =
        new SlsPrcgCndnRecdValidityField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @return Price List Type
     */
    @SerializedName( "PriceListType" )
    @JsonProperty( "PriceListType" )
    @Nullable
    @ODataField( odataName = "PriceListType" )
    private String priceListType;
    /**
     * Use with available fluent helpers to apply the <b>PriceListType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRICE_LIST_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("PriceListType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> POSTAL_CODE =
        new SlsPrcgCndnRecdValidityField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> REGION =
        new SlsPrcgCndnRecdValidityField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectServiceOrg</b>
     * </p>
     *
     * @return Service Organization
     */
    @SerializedName( "EngagementProjectServiceOrg" )
    @JsonProperty( "EngagementProjectServiceOrg" )
    @Nullable
    @ODataField( odataName = "EngagementProjectServiceOrg" )
    private String engagementProjectServiceOrg;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProjectServiceOrg</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ENGAGEMENT_PROJECT_SERVICE_ORG =
        new SlsPrcgCndnRecdValidityField<String>("EngagementProjectServiceOrg");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @return Requirement Segment
     */
    @SerializedName( "RequirementSegment" )
    @JsonProperty( "RequirementSegment" )
    @Nullable
    @ODataField( odataName = "RequirementSegment" )
    private String requirementSegment;
    /**
     * Use with available fluent helpers to apply the <b>RequirementSegment</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> REQUIREMENT_SEGMENT =
        new SlsPrcgCndnRecdValidityField<String>("RequirementSegment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @return Stock Segment
     */
    @SerializedName( "StockSegment" )
    @JsonProperty( "StockSegment" )
    @Nullable
    @ODataField( odataName = "StockSegment" )
    private String stockSegment;
    /**
     * Use with available fluent helpers to apply the <b>StockSegment</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> STOCK_SEGMENT =
        new SlsPrcgCndnRecdValidityField<String>("StockSegment");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> DIVISION =
        new SlsPrcgCndnRecdValidityField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CommodityCode</b>
     * </p>
     *
     * @return Commodity Code
     */
    @SerializedName( "CommodityCode" )
    @JsonProperty( "CommodityCode" )
    @Nullable
    @ODataField( odataName = "CommodityCode" )
    private String commodityCode;
    /**
     * Use with available fluent helpers to apply the <b>CommodityCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> COMMODITY_CODE =
        new SlsPrcgCndnRecdValidityField<String>("CommodityCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @return Control code for consumption taxes in foreign trade
     */
    @SerializedName( "ConsumptionTaxCtrlCode" )
    @JsonProperty( "ConsumptionTaxCtrlCode" )
    @Nullable
    @ODataField( odataName = "ConsumptionTaxCtrlCode" )
    private String consumptionTaxCtrlCode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionTaxCtrlCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONSUMPTION_TAX_CTRL_CODE =
        new SlsPrcgCndnRecdValidityField<String>("ConsumptionTaxCtrlCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxBasePercentageCode</b>
     * </p>
     *
     * @return Tax Base in Percentage
     */
    @SerializedName( "BRSpcfcTaxBasePercentageCode" )
    @JsonProperty( "BRSpcfcTaxBasePercentageCode" )
    @Nullable
    @ODataField( odataName = "BRSpcfcTaxBasePercentageCode" )
    private String bRSpcfcTaxBasePercentageCode;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcTaxBasePercentageCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_TAX_BASE_PERCENTAGE_CODE =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcTaxBasePercentageCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTxGrpDynTaxExceptions</b>
     * </p>
     *
     * @return Tax Group for Dynamic Tax Exceptions
     */
    @SerializedName( "BRSpcfcTxGrpDynTaxExceptions" )
    @JsonProperty( "BRSpcfcTxGrpDynTaxExceptions" )
    @Nullable
    @ODataField( odataName = "BRSpcfcTxGrpDynTaxExceptions" )
    private String bRSpcfcTxGrpDynTaxExceptions;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcTxGrpDynTaxExceptions</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_TX_GRP_DYN_TAX_EXCEPTIONS =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcTxGrpDynTaxExceptions");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification 1 for Customer
     */
    @SerializedName( "CustomerTaxClassification1" )
    @JsonProperty( "CustomerTaxClassification1" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification1" )
    private String customerTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification1</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION1 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Customer
     */
    @SerializedName( "CustomerTaxClassification2" )
    @JsonProperty( "CustomerTaxClassification2" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification2" )
    private String customerTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification2</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION2 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Customer
     */
    @SerializedName( "CustomerTaxClassification3" )
    @JsonProperty( "CustomerTaxClassification3" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification3" )
    private String customerTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification3</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION3 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Customer
     */
    @SerializedName( "CustomerTaxClassification4" )
    @JsonProperty( "CustomerTaxClassification4" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification4" )
    private String customerTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification4</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION4 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Customer
     */
    @SerializedName( "CustomerTaxClassification5" )
    @JsonProperty( "CustomerTaxClassification5" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification5" )
    private String customerTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification5</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION5 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Customer
     */
    @SerializedName( "CustomerTaxClassification6" )
    @JsonProperty( "CustomerTaxClassification6" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification6" )
    private String customerTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification6</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION6 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Customer
     */
    @SerializedName( "CustomerTaxClassification7" )
    @JsonProperty( "CustomerTaxClassification7" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification7" )
    private String customerTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification7</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION7 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Customer
     */
    @SerializedName( "CustomerTaxClassification8" )
    @JsonProperty( "CustomerTaxClassification8" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification8" )
    private String customerTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification8</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION8 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Customer
     */
    @SerializedName( "CustomerTaxClassification9" )
    @JsonProperty( "CustomerTaxClassification9" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification9" )
    private String customerTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification9</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_TAX_CLASSIFICATION9 =
        new SlsPrcgCndnRecdValidityField<String>("CustomerTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification of Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new SlsPrcgCndnRecdValidityField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TradingContract</b>
     * </p>
     *
     * @return Trading Contract
     */
    @SerializedName( "TradingContract" )
    @JsonProperty( "TradingContract" )
    @Nullable
    @ODataField( odataName = "TradingContract" )
    private String tradingContract;
    /**
     * Use with available fluent helpers to apply the <b>TradingContract</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TRADING_CONTRACT =
        new SlsPrcgCndnRecdValidityField<String>("TradingContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingContractItem</b>
     * </p>
     *
     * @return Item Number of Trading Contract
     */
    @SerializedName( "TradingContractItem" )
    @JsonProperty( "TradingContractItem" )
    @Nullable
    @ODataField( odataName = "TradingContractItem" )
    private String tradingContractItem;
    /**
     * Use with available fluent helpers to apply the <b>TradingContractItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TRADING_CONTRACT_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("TradingContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TAX_JURISDICTION =
        new SlsPrcgCndnRecdValidityField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxDepartureRegion</b>
     * </p>
     *
     * @return Ship from location (tax region)
     */
    @SerializedName( "BRSpcfcTaxDepartureRegion" )
    @JsonProperty( "BRSpcfcTaxDepartureRegion" )
    @Nullable
    @ODataField( odataName = "BRSpcfcTaxDepartureRegion" )
    private String bRSpcfcTaxDepartureRegion;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcTaxDepartureRegion</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_TAX_DEPARTURE_REGION =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcTaxDepartureRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxDestinationRegion</b>
     * </p>
     *
     * @return Ship to location (tax region)
     */
    @SerializedName( "BRSpcfcTaxDestinationRegion" )
    @JsonProperty( "BRSpcfcTaxDestinationRegion" )
    @Nullable
    @ODataField( odataName = "BRSpcfcTaxDestinationRegion" )
    private String bRSpcfcTaxDestinationRegion;
    /**
     * Use with available fluent helpers to apply the <b>BRSpcfcTaxDestinationRegion</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BR_SPCFC_TAX_DESTINATION_REGION =
        new SlsPrcgCndnRecdValidityField<String>("BRSpcfcTaxDestinationRegion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainItemMaterialPricingGroup</b>
     * </p>
     *
     * @return Material pricing group of main item
     */
    @SerializedName( "MainItemMaterialPricingGroup" )
    @JsonProperty( "MainItemMaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MainItemMaterialPricingGroup" )
    private String mainItemMaterialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MainItemMaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MAIN_ITEM_MATERIAL_PRICING_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("MainItemMaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainItemPricingRefMaterial</b>
     * </p>
     *
     * @return Pricing reference material of main item
     */
    @SerializedName( "MainItemPricingRefMaterial" )
    @JsonProperty( "MainItemPricingRefMaterial" )
    @Nullable
    @ODataField( odataName = "MainItemPricingRefMaterial" )
    private String mainItemPricingRefMaterial;
    /**
     * Use with available fluent helpers to apply the <b>MainItemPricingRefMaterial</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MAIN_ITEM_PRICING_REF_MATERIAL =
        new SlsPrcgCndnRecdValidityField<String>("MainItemPricingRefMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @return Variant Condition Key
     */
    @SerializedName( "VariantCondition" )
    @JsonProperty( "VariantCondition" )
    @Nullable
    @ODataField( odataName = "VariantCondition" )
    private String variantCondition;
    /**
     * Use with available fluent helpers to apply the <b>VariantCondition</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> VARIANT_CONDITION =
        new SlsPrcgCndnRecdValidityField<String>("VariantCondition");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValueAddedServiceChargeCode</b>
     * </p>
     *
     * @return VAS Charge Codes
     */
    @SerializedName( "ValueAddedServiceChargeCode" )
    @JsonProperty( "ValueAddedServiceChargeCode" )
    @Nullable
    @ODataField( odataName = "ValueAddedServiceChargeCode" )
    private String valueAddedServiceChargeCode;
    /**
     * Use with available fluent helpers to apply the <b>ValueAddedServiceChargeCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> VALUE_ADDED_SERVICE_CHARGE_CODE =
        new SlsPrcgCndnRecdValidityField<String>("ValueAddedServiceChargeCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SDDocument" )
    @JsonProperty( "SDDocument" )
    @Nullable
    @ODataField( odataName = "SDDocument" )
    private String sDDocument;
    /**
     * Use with available fluent helpers to apply the <b>SDDocument</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SD_DOCUMENT =
        new SlsPrcgCndnRecdValidityField<String>("SDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> REFERENCE_SD_DOCUMENT =
        new SlsPrcgCndnRecdValidityField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_OFFICE =
        new SlsPrcgCndnRecdValidityField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_ORGANIZATION =
        new SlsPrcgCndnRecdValidityField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesOrganization</b>
     * </p>
     *
     * @return Sales organization of sales order
     */
    @SerializedName( "SalesOrderSalesOrganization" )
    @JsonProperty( "SalesOrderSalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrderSalesOrganization" )
    private String salesOrderSalesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderSalesOrganization</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_ORDER_SALES_ORGANIZATION =
        new SlsPrcgCndnRecdValidityField<String>("SalesOrderSalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ORDER_QUANTITY_UNIT =
        new SlsPrcgCndnRecdValidityField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> DISTRIBUTION_CHANNEL =
        new SlsPrcgCndnRecdValidityField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TRANSACTION_CURRENCY =
        new SlsPrcgCndnRecdValidityField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Billing Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WBS_ELEMENT_INTERNAL_ID =
        new SlsPrcgCndnRecdValidityField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WBS_ELEMENT_EXTERNAL_ID =
        new SlsPrcgCndnRecdValidityField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return WBS Work Package
     */
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WORK_PACKAGE =
        new SlsPrcgCndnRecdValidityField<String>("WorkPackage");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PLANT = new SlsPrcgCndnRecdValidityField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @return Region in which plant is located
     */
    @SerializedName( "PlantRegion" )
    @JsonProperty( "PlantRegion" )
    @Nullable
    @ODataField( odataName = "PlantRegion" )
    private String plantRegion;
    /**
     * Use with available fluent helpers to apply the <b>PlantRegion</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PLANT_REGION =
        new SlsPrcgCndnRecdValidityField<String>("PlantRegion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Use with available fluent helpers to apply the <b>WorkItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WORK_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("WorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionProcessingStatus</b>
     * </p>
     *
     * @return Processing status for conditions
     */
    @SerializedName( "ConditionProcessingStatus" )
    @JsonProperty( "ConditionProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ConditionProcessingStatus" )
    private String conditionProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionProcessingStatus</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_PROCESSING_STATUS =
        new SlsPrcgCndnRecdValidityField<String>("ConditionProcessingStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Condition Pricing Date
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<LocalDateTime> PRICING_DATE =
        new SlsPrcgCndnRecdValidityField<LocalDateTime>("PricingDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsExclusive</b>
     * </p>
     *
     * @return Indicator condition exclusive
     */
    @SerializedName( "ConditionIsExclusive" )
    @JsonProperty( "ConditionIsExclusive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsExclusive" )
    private Boolean conditionIsExclusive;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsExclusive</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<Boolean> CONDITION_IS_EXCLUSIVE =
        new SlsPrcgCndnRecdValidityField<Boolean>("ConditionIsExclusive");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @return Condition Scale Base Value
     */
    @SerializedName( "ConditionScaleBasisValue" )
    @JsonProperty( "ConditionScaleBasisValue" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisValue" )
    private String conditionScaleBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisValue</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CONDITION_SCALE_BASIS_VALUE =
        new SlsPrcgCndnRecdValidityField<String>("ConditionScaleBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TAX_CODE =
        new SlsPrcgCndnRecdValidityField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceDocument" )
    @JsonProperty( "ServiceDocument" )
    @Nullable
    @ODataField( odataName = "ServiceDocument" )
    private String serviceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocument</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SERVICE_DOCUMENT =
        new SlsPrcgCndnRecdValidityField<String>("ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ServiceDocumentItem" )
    @JsonProperty( "ServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItem" )
    private String serviceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SERVICE_DOCUMENT_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("ServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @return Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOvertimeCategory</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> TIME_SHEET_OVERTIME_CATEGORY =
        new SlsPrcgCndnRecdValidityField<String>("TimeSheetOvertimeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSDDocumentCategory</b>
     * </p>
     *
     * @return SD Document Category
     */
    @SerializedName( "SalesSDDocumentCategory" )
    @JsonProperty( "SalesSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SalesSDDocumentCategory" )
    private String salesSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesSDDocumentCategory</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_SD_DOCUMENT_CATEGORY =
        new SlsPrcgCndnRecdValidityField<String>("SalesSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnReason</b>
     * </p>
     *
     * @return Return Reason
     */
    @SerializedName( "ReturnReason" )
    @JsonProperty( "ReturnReason" )
    @Nullable
    @ODataField( odataName = "ReturnReason" )
    private String returnReason;
    /**
     * Use with available fluent helpers to apply the <b>ReturnReason</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> RETURN_REASON =
        new SlsPrcgCndnRecdValidityField<String>("ReturnReason");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchyNode</b>
     * </p>
     *
     * @return Product Hierarchy Node
     */
    @SerializedName( "ProdUnivHierarchyNode" )
    @JsonProperty( "ProdUnivHierarchyNode" )
    @Nullable
    @ODataField( odataName = "ProdUnivHierarchyNode" )
    private String prodUnivHierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>ProdUnivHierarchyNode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PROD_UNIV_HIERARCHY_NODE =
        new SlsPrcgCndnRecdValidityField<String>("ProdUnivHierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @return Product Hierarchy Node
     */
    @SerializedName( "ProductHierarchyNode" )
    @JsonProperty( "ProductHierarchyNode" )
    @Nullable
    @ODataField( odataName = "ProductHierarchyNode" )
    private String productHierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchyNode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRODUCT_HIERARCHY_NODE =
        new SlsPrcgCndnRecdValidityField<String>("ProductHierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup</b>
     * </p>
     *
     * @return Customer Attribute for Condition Groups
     */
    @SerializedName( "CustomerConditionGroup" )
    @JsonProperty( "CustomerConditionGroup" )
    @Nullable
    @ODataField( odataName = "CustomerConditionGroup" )
    private String customerConditionGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerConditionGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_CONDITION_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("CustomerConditionGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SHIPPING_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionContractDuration</b>
     * </p>
     *
     * @return Numerical Value of Duration
     */
    @SerializedName( "SubscriptionContractDuration" )
    @JsonProperty( "SubscriptionContractDuration" )
    @Nullable
    @ODataField( odataName = "SubscriptionContractDuration" )
    private String subscriptionContractDuration;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionContractDuration</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SUBSCRIPTION_CONTRACT_DURATION =
        new SlsPrcgCndnRecdValidityField<String>("SubscriptionContractDuration");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnContrDurationUnit</b>
     * </p>
     *
     * @return IS-T: Unit of Duration for a Telco Contract
     */
    @SerializedName( "SubscrpnContrDurationUnit" )
    @JsonProperty( "SubscrpnContrDurationUnit" )
    @Nullable
    @ODataField( odataName = "SubscrpnContrDurationUnit" )
    private String subscrpnContrDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnContrDurationUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SUBSCRPN_CONTR_DURATION_UNIT =
        new SlsPrcgCndnRecdValidityField<String>("SubscrpnContrDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionContractLockReason</b>
     * </p>
     *
     * @return Lock Reason
     */
    @SerializedName( "SubscriptionContractLockReason" )
    @JsonProperty( "SubscriptionContractLockReason" )
    @Nullable
    @ODataField( odataName = "SubscriptionContractLockReason" )
    private String subscriptionContractLockReason;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionContractLockReason</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SUBSCRIPTION_CONTRACT_LOCK_REASON =
        new SlsPrcgCndnRecdValidityField<String>("SubscriptionContractLockReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CrsCtlgMappgPriceVersionNumber</b>
     * </p>
     *
     * @return Price Version
     */
    @SerializedName( "CrsCtlgMappgPriceVersionNumber" )
    @JsonProperty( "CrsCtlgMappgPriceVersionNumber" )
    @Nullable
    @ODataField( odataName = "CrsCtlgMappgPriceVersionNumber" )
    private String crsCtlgMappgPriceVersionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CrsCtlgMappgPriceVersionNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CRS_CTLG_MAPPG_PRICE_VERSION_NUMBER =
        new SlsPrcgCndnRecdValidityField<String>("CrsCtlgMappgPriceVersionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Use with available fluent helpers to apply the <b>OrderType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ORDER_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("OrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentType</b>
     * </p>
     *
     * @return Sales Document Type
     */
    @SerializedName( "SalesDocumentType" )
    @JsonProperty( "SalesDocumentType" )
    @Nullable
    @ODataField( odataName = "SalesDocumentType" )
    private String salesDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_DOCUMENT_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("SalesDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SD_DOCUMENT_REASON =
        new SlsPrcgCndnRecdValidityField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @return Volume rebate group
     */
    @SerializedName( "VolumeRebateGroup" )
    @JsonProperty( "VolumeRebateGroup" )
    @Nullable
    @ODataField( odataName = "VolumeRebateGroup" )
    private String volumeRebateGroup;
    /**
     * Use with available fluent helpers to apply the <b>VolumeRebateGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> VOLUME_REBATE_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("VolumeRebateGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> VALUATION_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("ValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SALES_DISTRICT =
        new SlsPrcgCndnRecdValidityField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> BATCH = new SlsPrcgCndnRecdValidityField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocSupplyingPlant</b>
     * </p>
     *
     * @return Supplying (issuing) plant in case of stock transport order
     */
    @SerializedName( "PurgDocSupplyingPlant" )
    @JsonProperty( "PurgDocSupplyingPlant" )
    @Nullable
    @ODataField( odataName = "PurgDocSupplyingPlant" )
    private String purgDocSupplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocSupplyingPlant</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PURG_DOC_SUPPLYING_PLANT =
        new SlsPrcgCndnRecdValidityField<String>("PurgDocSupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatUsageIndicator</b>
     * </p>
     *
     * @return Usage Indicator
     */
    @SerializedName( "MatUsageIndicator" )
    @JsonProperty( "MatUsageIndicator" )
    @Nullable
    @ODataField( odataName = "MatUsageIndicator" )
    private String matUsageIndicator;
    /**
     * Use with available fluent helpers to apply the <b>MatUsageIndicator</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MAT_USAGE_INDICATOR =
        new SlsPrcgCndnRecdValidityField<String>("MatUsageIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SHIPPING_CONDITION =
        new SlsPrcgCndnRecdValidityField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantCounty</b>
     * </p>
     *
     * @return County in which plant is located
     */
    @SerializedName( "PlantCounty" )
    @JsonProperty( "PlantCounty" )
    @Nullable
    @ODataField( odataName = "PlantCounty" )
    private String plantCounty;
    /**
     * Use with available fluent helpers to apply the <b>PlantCounty</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PLANT_COUNTY =
        new SlsPrcgCndnRecdValidityField<String>("PlantCounty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlantCity</b>
     * </p>
     *
     * @return City in which plant is located
     */
    @SerializedName( "PlantCity" )
    @JsonProperty( "PlantCity" )
    @Nullable
    @ODataField( odataName = "PlantCity" )
    private String plantCity;
    /**
     * Use with available fluent helpers to apply the <b>PlantCity</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PLANT_CITY =
        new SlsPrcgCndnRecdValidityField<String>("PlantCity");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalGroup</b>
     * </p>
     *
     * @return External Material Group
     */
    @SerializedName( "MaterialExternalGroup" )
    @JsonProperty( "MaterialExternalGroup" )
    @Nullable
    @ODataField( odataName = "MaterialExternalGroup" )
    private String materialExternalGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialExternalGroup</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MATERIAL_EXTERNAL_GROUP =
        new SlsPrcgCndnRecdValidityField<String>("MaterialExternalGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyRootNode</b>
     * </p>
     *
     * @return Customer Hierarchy Root Node ID (Hier ID)
     */
    @SerializedName( "CustomerHierarchyRootNode" )
    @JsonProperty( "CustomerHierarchyRootNode" )
    @Nullable
    @ODataField( odataName = "CustomerHierarchyRootNode" )
    private String customerHierarchyRootNode;
    /**
     * Use with available fluent helpers to apply the <b>CustomerHierarchyRootNode</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_HIERARCHY_ROOT_NODE =
        new SlsPrcgCndnRecdValidityField<String>("CustomerHierarchyRootNode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyNodeID</b>
     * </p>
     *
     * @return Customer Hierarchy Node ID
     */
    @SerializedName( "CustomerHierarchyNodeID" )
    @JsonProperty( "CustomerHierarchyNodeID" )
    @Nullable
    @ODataField( odataName = "CustomerHierarchyNodeID" )
    private String customerHierarchyNodeID;
    /**
     * Use with available fluent helpers to apply the <b>CustomerHierarchyNodeID</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_HIERARCHY_NODE_ID =
        new SlsPrcgCndnRecdValidityField<String>("CustomerHierarchyNodeID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyNodeType</b>
     * </p>
     *
     * @return Customer Hierarchy Node Type
     */
    @SerializedName( "CustomerHierarchyNodeType" )
    @JsonProperty( "CustomerHierarchyNodeType" )
    @Nullable
    @ODataField( odataName = "CustomerHierarchyNodeType" )
    private String customerHierarchyNodeType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerHierarchyNodeType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CUSTOMER_HIERARCHY_NODE_TYPE =
        new SlsPrcgCndnRecdValidityField<String>("CustomerHierarchyNodeType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @return Customer Group 1
     */
    @SerializedName( "AdditionalCustomerGroup1" )
    @JsonProperty( "AdditionalCustomerGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup1" )
    private String additionalCustomerGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup1</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_CUSTOMER_GROUP1 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalCustomerGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @return Customer Group 2
     */
    @SerializedName( "AdditionalCustomerGroup2" )
    @JsonProperty( "AdditionalCustomerGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup2" )
    private String additionalCustomerGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup2</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_CUSTOMER_GROUP2 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalCustomerGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @return Customer Group 3
     */
    @SerializedName( "AdditionalCustomerGroup3" )
    @JsonProperty( "AdditionalCustomerGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup3" )
    private String additionalCustomerGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup3</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_CUSTOMER_GROUP3 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalCustomerGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @return Customer Group 4
     */
    @SerializedName( "AdditionalCustomerGroup4" )
    @JsonProperty( "AdditionalCustomerGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup4" )
    private String additionalCustomerGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup4</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_CUSTOMER_GROUP4 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalCustomerGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @return Customer Group 5
     */
    @SerializedName( "AdditionalCustomerGroup5" )
    @JsonProperty( "AdditionalCustomerGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup5" )
    private String additionalCustomerGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup5</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> ADDITIONAL_CUSTOMER_GROUP5 =
        new SlsPrcgCndnRecdValidityField<String>("AdditionalCustomerGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @return Item number of the SD document
     */
    @SerializedName( "SDDocumentItem" )
    @JsonProperty( "SDDocumentItem" )
    @Nullable
    @ODataField( odataName = "SDDocumentItem" )
    private String sDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentItem</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> SD_DOCUMENT_ITEM =
        new SlsPrcgCndnRecdValidityField<String>("SDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnBillingDocumentCategory</b>
     * </p>
     *
     * @return Billing Category
     */
    @SerializedName( "CndnBillingDocumentCategory" )
    @JsonProperty( "CndnBillingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "CndnBillingDocumentCategory" )
    private String cndnBillingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>CndnBillingDocumentCategory</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> CNDN_BILLING_DOCUMENT_CATEGORY =
        new SlsPrcgCndnRecdValidityField<String>("CndnBillingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> COUNTRY =
        new SlsPrcgCndnRecdValidityField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PRAContract</b>
     * </p>
     *
     * @return Contract Number
     */
    @SerializedName( "PRAContract" )
    @JsonProperty( "PRAContract" )
    @Nullable
    @ODataField( odataName = "PRAContract" )
    private String pRAContract;
    /**
     * Use with available fluent helpers to apply the <b>PRAContract</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRA_CONTRACT =
        new SlsPrcgCndnRecdValidityField<String>("PRAContract");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Well</b>
     * </p>
     *
     * @return Well ID number
     */
    @SerializedName( "Well" )
    @JsonProperty( "Well" )
    @Nullable
    @ODataField( odataName = "Well" )
    private String well;
    /**
     * Use with available fluent helpers to apply the <b>Well</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WELL = new SlsPrcgCndnRecdValidityField<String>("Well");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletion</b>
     * </p>
     *
     * @return Well Completion Number
     */
    @SerializedName( "WellCompletion" )
    @JsonProperty( "WellCompletion" )
    @Nullable
    @ODataField( odataName = "WellCompletion" )
    private String wellCompletion;
    /**
     * Use with available fluent helpers to apply the <b>WellCompletion</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> WELL_COMPLETION =
        new SlsPrcgCndnRecdValidityField<String>("WellCompletion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementPoint</b>
     * </p>
     *
     * @return Measurement point number
     */
    @SerializedName( "MeasurementPoint" )
    @JsonProperty( "MeasurementPoint" )
    @Nullable
    @ODataField( odataName = "MeasurementPoint" )
    private String measurementPoint;
    /**
     * Use with available fluent helpers to apply the <b>MeasurementPoint</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> MEASUREMENT_POINT =
        new SlsPrcgCndnRecdValidityField<String>("MeasurementPoint");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingFormulaNumber</b>
     * </p>
     *
     * @return Formula ID
     */
    @SerializedName( "PricingFormulaNumber" )
    @JsonProperty( "PricingFormulaNumber" )
    @Nullable
    @ODataField( odataName = "PricingFormulaNumber" )
    private String pricingFormulaNumber;
    /**
     * Use with available fluent helpers to apply the <b>PricingFormulaNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> PRICING_FORMULA_NUMBER =
        new SlsPrcgCndnRecdValidityField<String>("PricingFormulaNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityField<String> E_TAG = new SlsPrcgCndnRecdValidityField<String>("ETag");
    /**
     * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgCndnRecdValidity</b> to multiple
     * <b>SlsPrcgCndnRecdSuplmnt</b>.
     *
     */
    @SerializedName( "to_SlsPrcgCndnRecdSuplmnt" )
    @JsonProperty( "to_SlsPrcgCndnRecdSuplmnt" )
    @ODataField( odataName = "to_SlsPrcgCndnRecdSuplmnt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgCndnRecdSuplmnt> toSlsPrcgCndnRecdSuplmnt;
    /**
     * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgCndnRecdValidity</b> to single
     * <b>SlsPrcgConditionRecord</b>.
     *
     */
    @SerializedName( "to_SlsPrcgConditionRecord" )
    @JsonProperty( "to_SlsPrcgConditionRecord" )
    @ODataField( odataName = "to_SlsPrcgConditionRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SlsPrcgConditionRecord toSlsPrcgConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgCndnRecdSuplmnt</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityLink<SlsPrcgCndnRecdSuplmnt> TO_SLS_PRCG_CNDN_RECD_SUPLMNT =
        new SlsPrcgCndnRecdValidityLink<SlsPrcgCndnRecdSuplmnt>("to_SlsPrcgCndnRecdSuplmnt");
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgConditionRecord</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgCndnRecdValidityOneToOneLink<SlsPrcgConditionRecord> TO_SLS_PRCG_CONDITION_RECORD =
        new SlsPrcgCndnRecdValidityOneToOneLink<SlsPrcgConditionRecord>("to_SlsPrcgConditionRecord");

    @Nonnull
    @Override
    public Class<SlsPrcgCndnRecdValidity> getType()
    {
        return SlsPrcgCndnRecdValidity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @param conditionReleaseStatus
     *            Release Status
     */
    public void setConditionReleaseStatus( @Nullable final String conditionReleaseStatus )
    {
        rememberChangedField("ConditionReleaseStatus", this.conditionReleaseStatus);
        this.conditionReleaseStatus = conditionReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     */
    public void setDepartureCountry( @Nullable final String departureCountry )
    {
        rememberChangedField("DepartureCountry", this.departureCountry);
        this.departureCountry = departureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Accounting Indicator
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @param industry
     *            Industry key
     */
    public void setIndustry( @Nullable final String industry )
    {
        rememberChangedField("Industry", this.industry);
        this.industry = industry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @param cityCode
     *            City Code
     */
    public void setCityCode( @Nullable final String cityCode )
    {
        rememberChangedField("CityCode", this.cityCode);
        this.cityCode = cityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @param county
     *            County Code
     */
    public void setCounty( @Nullable final String county )
    {
        rememberChangedField("County", this.county);
        this.county = county;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @param engagementProject
     *            Commercial Project ID
     */
    public void setEngagementProject( @Nullable final String engagementProject )
    {
        rememberChangedField("EngagementProject", this.engagementProject);
        this.engagementProject = engagementProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @param configurationNumber
     *            Configuration (Internal Object Number)
     */
    public void setConfigurationNumber( @Nullable final String configurationNumber )
    {
        rememberChangedField("ConfigurationNumber", this.configurationNumber);
        this.configurationNumber = configurationNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_NFDocumentType</b>
     * </p>
     *
     * @param bR_NFDocumentType
     *            Document type
     */
    public void setBR_NFDocumentType( @Nullable final String bR_NFDocumentType )
    {
        rememberChangedField("BR_NFDocumentType", this.bR_NFDocumentType);
        this.bR_NFDocumentType = bR_NFDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField1</b>
     * </p>
     *
     * @param bRSpcfcFreeDefinedField1
     *            Dynamic Key Field 1
     */
    public void setBRSpcfcFreeDefinedField1( @Nullable final String bRSpcfcFreeDefinedField1 )
    {
        rememberChangedField("BRSpcfcFreeDefinedField1", this.bRSpcfcFreeDefinedField1);
        this.bRSpcfcFreeDefinedField1 = bRSpcfcFreeDefinedField1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField2</b>
     * </p>
     *
     * @param bRSpcfcFreeDefinedField2
     *            Dynamic Key Field 2
     */
    public void setBRSpcfcFreeDefinedField2( @Nullable final String bRSpcfcFreeDefinedField2 )
    {
        rememberChangedField("BRSpcfcFreeDefinedField2", this.bRSpcfcFreeDefinedField2);
        this.bRSpcfcFreeDefinedField2 = bRSpcfcFreeDefinedField2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcFreeDefinedField3</b>
     * </p>
     *
     * @param bRSpcfcFreeDefinedField3
     *            Dynamic Key Field 3
     */
    public void setBRSpcfcFreeDefinedField3( @Nullable final String bRSpcfcFreeDefinedField3 )
    {
        rememberChangedField("BRSpcfcFreeDefinedField3", this.bRSpcfcFreeDefinedField3);
        this.bRSpcfcFreeDefinedField3 = bRSpcfcFreeDefinedField3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @param internationalArticleNumber
     *            International Article Number (EAN/UPC)
     */
    public void setInternationalArticleNumber( @Nullable final String internationalArticleNumber )
    {
        rememberChangedField("InternationalArticleNumber", this.internationalArticleNumber);
        this.internationalArticleNumber = internationalArticleNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @param technicalObjectType
     *            Type of Technical Object
     */
    public void setTechnicalObjectType( @Nullable final String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchy</b>
     * </p>
     *
     * @param customerHierarchy
     *            Customer
     */
    public void setCustomerHierarchy( @Nullable final String customerHierarchy )
    {
        rememberChangedField("CustomerHierarchy", this.customerHierarchy);
        this.customerHierarchy = customerHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @param accountTaxType
     *            Tax Type
     */
    public void setAccountTaxType( @Nullable final String accountTaxType )
    {
        rememberChangedField("AccountTaxType", this.accountTaxType);
        this.accountTaxType = accountTaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TxRlvnceClassfctnForArgentina</b>
     * </p>
     *
     * @param txRlvnceClassfctnForArgentina
     *            Tax relevant classification
     */
    public void setTxRlvnceClassfctnForArgentina( @Nullable final String txRlvnceClassfctnForArgentina )
    {
        rememberChangedField("TxRlvnceClassfctnForArgentina", this.txRlvnceClassfctnForArgentina);
        this.txRlvnceClassfctnForArgentina = txRlvnceClassfctnForArgentina;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_TaxCode</b>
     * </p>
     *
     * @param bR_TaxCode
     *            SD tax code
     */
    public void setBR_TaxCode( @Nullable final String bR_TaxCode )
    {
        rememberChangedField("BR_TaxCode", this.bR_TaxCode);
        this.bR_TaxCode = bR_TaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LocalSalesTaxApplicabilityCode</b>
     * </p>
     *
     * @param localSalesTaxApplicabilityCode
     *            LST CST Applicability Code
     */
    public void setLocalSalesTaxApplicabilityCode( @Nullable final String localSalesTaxApplicabilityCode )
    {
        rememberChangedField("LocalSalesTaxApplicabilityCode", this.localSalesTaxApplicabilityCode);
        this.localSalesTaxApplicabilityCode = localSalesTaxApplicabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @param customerPriceGroup
     *            Customer Price Group
     */
    public void setCustomerPriceGroup( @Nullable final String customerPriceGroup )
    {
        rememberChangedField("CustomerPriceGroup", this.customerPriceGroup);
        this.customerPriceGroup = customerPriceGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSoldToParty</b>
     * </p>
     *
     * @param bPForSoldToParty
     *            Business Partner Number
     */
    public void setBPForSoldToParty( @Nullable final String bPForSoldToParty )
    {
        rememberChangedField("BPForSoldToParty", this.bPForSoldToParty);
        this.bPForSoldToParty = bPForSoldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForCustomer</b>
     * </p>
     *
     * @param bPForCustomer
     *            Business Partner Number
     */
    public void setBPForCustomer( @Nullable final String bPForCustomer )
    {
        rememberChangedField("BPForCustomer", this.bPForCustomer);
        this.bPForCustomer = bPForCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForPayerParty</b>
     * </p>
     *
     * @param bPForPayerParty
     *            Business Partner Number
     */
    public void setBPForPayerParty( @Nullable final String bPForPayerParty )
    {
        rememberChangedField("BPForPayerParty", this.bPForPayerParty);
        this.bPForPayerParty = bPForPayerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForShipToParty</b>
     * </p>
     *
     * @param bPForShipToParty
     *            Business Partner Number
     */
    public void setBPForShipToParty( @Nullable final String bPForShipToParty )
    {
        rememberChangedField("BPForShipToParty", this.bPForShipToParty);
        this.bPForShipToParty = bPForShipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSupplier</b>
     * </p>
     *
     * @param bPForSupplier
     *            Business Partner Number
     */
    public void setBPForSupplier( @Nullable final String bPForSupplier )
    {
        rememberChangedField("BPForSupplier", this.bPForSupplier);
        this.bPForSupplier = bPForSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DestinationCountry</b>
     * </p>
     *
     * @param destinationCountry
     *            Destination Country/Region
     */
    public void setDestinationCountry( @Nullable final String destinationCountry )
    {
        rememberChangedField("DestinationCountry", this.destinationCountry);
        this.destinationCountry = destinationCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundExtent</b>
     * </p>
     *
     * @param returnsRefundExtent
     *            Returns Refund Code
     */
    public void setReturnsRefundExtent( @Nullable final String returnsRefundExtent )
    {
        rememberChangedField("ReturnsRefundExtent", this.returnsRefundExtent);
        this.returnsRefundExtent = returnsRefundExtent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @param additionalMaterialGroup1
     *            Material Group 1
     */
    public void setAdditionalMaterialGroup1( @Nullable final String additionalMaterialGroup1 )
    {
        rememberChangedField("AdditionalMaterialGroup1", this.additionalMaterialGroup1);
        this.additionalMaterialGroup1 = additionalMaterialGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @param additionalMaterialGroup2
     *            Material Group 2
     */
    public void setAdditionalMaterialGroup2( @Nullable final String additionalMaterialGroup2 )
    {
        rememberChangedField("AdditionalMaterialGroup2", this.additionalMaterialGroup2);
        this.additionalMaterialGroup2 = additionalMaterialGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @param additionalMaterialGroup3
     *            Material Group 3
     */
    public void setAdditionalMaterialGroup3( @Nullable final String additionalMaterialGroup3 )
    {
        rememberChangedField("AdditionalMaterialGroup3", this.additionalMaterialGroup3);
        this.additionalMaterialGroup3 = additionalMaterialGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @param additionalMaterialGroup4
     *            Material Group 4
     */
    public void setAdditionalMaterialGroup4( @Nullable final String additionalMaterialGroup4 )
    {
        rememberChangedField("AdditionalMaterialGroup4", this.additionalMaterialGroup4);
        this.additionalMaterialGroup4 = additionalMaterialGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @param additionalMaterialGroup5
     *            Material Group 5
     */
    public void setAdditionalMaterialGroup5( @Nullable final String additionalMaterialGroup5 )
    {
        rememberChangedField("AdditionalMaterialGroup5", this.additionalMaterialGroup5);
        this.additionalMaterialGroup5 = additionalMaterialGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @param priceListType
     *            Price List Type
     */
    public void setPriceListType( @Nullable final String priceListType )
    {
        rememberChangedField("PriceListType", this.priceListType);
        this.priceListType = priceListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectServiceOrg</b>
     * </p>
     *
     * @param engagementProjectServiceOrg
     *            Service Organization
     */
    public void setEngagementProjectServiceOrg( @Nullable final String engagementProjectServiceOrg )
    {
        rememberChangedField("EngagementProjectServiceOrg", this.engagementProjectServiceOrg);
        this.engagementProjectServiceOrg = engagementProjectServiceOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @param requirementSegment
     *            Requirement Segment
     */
    public void setRequirementSegment( @Nullable final String requirementSegment )
    {
        rememberChangedField("RequirementSegment", this.requirementSegment);
        this.requirementSegment = requirementSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @param stockSegment
     *            Stock Segment
     */
    public void setStockSegment( @Nullable final String stockSegment )
    {
        rememberChangedField("StockSegment", this.stockSegment);
        this.stockSegment = stockSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CommodityCode</b>
     * </p>
     *
     * @param commodityCode
     *            Commodity Code
     */
    public void setCommodityCode( @Nullable final String commodityCode )
    {
        rememberChangedField("CommodityCode", this.commodityCode);
        this.commodityCode = commodityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @param consumptionTaxCtrlCode
     *            Control code for consumption taxes in foreign trade
     */
    public void setConsumptionTaxCtrlCode( @Nullable final String consumptionTaxCtrlCode )
    {
        rememberChangedField("ConsumptionTaxCtrlCode", this.consumptionTaxCtrlCode);
        this.consumptionTaxCtrlCode = consumptionTaxCtrlCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxBasePercentageCode</b>
     * </p>
     *
     * @param bRSpcfcTaxBasePercentageCode
     *            Tax Base in Percentage
     */
    public void setBRSpcfcTaxBasePercentageCode( @Nullable final String bRSpcfcTaxBasePercentageCode )
    {
        rememberChangedField("BRSpcfcTaxBasePercentageCode", this.bRSpcfcTaxBasePercentageCode);
        this.bRSpcfcTaxBasePercentageCode = bRSpcfcTaxBasePercentageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTxGrpDynTaxExceptions</b>
     * </p>
     *
     * @param bRSpcfcTxGrpDynTaxExceptions
     *            Tax Group for Dynamic Tax Exceptions
     */
    public void setBRSpcfcTxGrpDynTaxExceptions( @Nullable final String bRSpcfcTxGrpDynTaxExceptions )
    {
        rememberChangedField("BRSpcfcTxGrpDynTaxExceptions", this.bRSpcfcTxGrpDynTaxExceptions);
        this.bRSpcfcTxGrpDynTaxExceptions = bRSpcfcTxGrpDynTaxExceptions;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @param customerTaxClassification1
     *            Tax Classification 1 for Customer
     */
    public void setCustomerTaxClassification1( @Nullable final String customerTaxClassification1 )
    {
        rememberChangedField("CustomerTaxClassification1", this.customerTaxClassification1);
        this.customerTaxClassification1 = customerTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @param customerTaxClassification2
     *            Tax Classification 2 for Customer
     */
    public void setCustomerTaxClassification2( @Nullable final String customerTaxClassification2 )
    {
        rememberChangedField("CustomerTaxClassification2", this.customerTaxClassification2);
        this.customerTaxClassification2 = customerTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @param customerTaxClassification3
     *            Tax Classification 3 for Customer
     */
    public void setCustomerTaxClassification3( @Nullable final String customerTaxClassification3 )
    {
        rememberChangedField("CustomerTaxClassification3", this.customerTaxClassification3);
        this.customerTaxClassification3 = customerTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @param customerTaxClassification4
     *            Tax Classification 4 for Customer
     */
    public void setCustomerTaxClassification4( @Nullable final String customerTaxClassification4 )
    {
        rememberChangedField("CustomerTaxClassification4", this.customerTaxClassification4);
        this.customerTaxClassification4 = customerTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @param customerTaxClassification5
     *            Tax Classification 5 for Customer
     */
    public void setCustomerTaxClassification5( @Nullable final String customerTaxClassification5 )
    {
        rememberChangedField("CustomerTaxClassification5", this.customerTaxClassification5);
        this.customerTaxClassification5 = customerTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @param customerTaxClassification6
     *            Tax Classification 6 for Customer
     */
    public void setCustomerTaxClassification6( @Nullable final String customerTaxClassification6 )
    {
        rememberChangedField("CustomerTaxClassification6", this.customerTaxClassification6);
        this.customerTaxClassification6 = customerTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @param customerTaxClassification7
     *            Tax Classification 7 for Customer
     */
    public void setCustomerTaxClassification7( @Nullable final String customerTaxClassification7 )
    {
        rememberChangedField("CustomerTaxClassification7", this.customerTaxClassification7);
        this.customerTaxClassification7 = customerTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @param customerTaxClassification8
     *            Tax Classification 8 for Customer
     */
    public void setCustomerTaxClassification8( @Nullable final String customerTaxClassification8 )
    {
        rememberChangedField("CustomerTaxClassification8", this.customerTaxClassification8);
        this.customerTaxClassification8 = customerTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @param customerTaxClassification9
     *            Tax Classification 9 for Customer
     */
    public void setCustomerTaxClassification9( @Nullable final String customerTaxClassification9 )
    {
        rememberChangedField("CustomerTaxClassification9", this.customerTaxClassification9);
        this.customerTaxClassification9 = customerTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification of Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification 2 for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification 3 for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification 4 for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification 5 for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification 6 for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification 7 for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification 8 for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification 9 for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TradingContract</b>
     * </p>
     *
     * @param tradingContract
     *            Trading Contract
     */
    public void setTradingContract( @Nullable final String tradingContract )
    {
        rememberChangedField("TradingContract", this.tradingContract);
        this.tradingContract = tradingContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingContractItem</b>
     * </p>
     *
     * @param tradingContractItem
     *            Item Number of Trading Contract
     */
    public void setTradingContractItem( @Nullable final String tradingContractItem )
    {
        rememberChangedField("TradingContractItem", this.tradingContractItem);
        this.tradingContractItem = tradingContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxDepartureRegion</b>
     * </p>
     *
     * @param bRSpcfcTaxDepartureRegion
     *            Ship from location (tax region)
     */
    public void setBRSpcfcTaxDepartureRegion( @Nullable final String bRSpcfcTaxDepartureRegion )
    {
        rememberChangedField("BRSpcfcTaxDepartureRegion", this.bRSpcfcTaxDepartureRegion);
        this.bRSpcfcTaxDepartureRegion = bRSpcfcTaxDepartureRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BRSpcfcTaxDestinationRegion</b>
     * </p>
     *
     * @param bRSpcfcTaxDestinationRegion
     *            Ship to location (tax region)
     */
    public void setBRSpcfcTaxDestinationRegion( @Nullable final String bRSpcfcTaxDestinationRegion )
    {
        rememberChangedField("BRSpcfcTaxDestinationRegion", this.bRSpcfcTaxDestinationRegion);
        this.bRSpcfcTaxDestinationRegion = bRSpcfcTaxDestinationRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MainItemMaterialPricingGroup</b>
     * </p>
     *
     * @param mainItemMaterialPricingGroup
     *            Material pricing group of main item
     */
    public void setMainItemMaterialPricingGroup( @Nullable final String mainItemMaterialPricingGroup )
    {
        rememberChangedField("MainItemMaterialPricingGroup", this.mainItemMaterialPricingGroup);
        this.mainItemMaterialPricingGroup = mainItemMaterialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MainItemPricingRefMaterial</b>
     * </p>
     *
     * @param mainItemPricingRefMaterial
     *            Pricing reference material of main item
     */
    public void setMainItemPricingRefMaterial( @Nullable final String mainItemPricingRefMaterial )
    {
        rememberChangedField("MainItemPricingRefMaterial", this.mainItemPricingRefMaterial);
        this.mainItemPricingRefMaterial = mainItemPricingRefMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @param variantCondition
     *            Variant Condition Key
     */
    public void setVariantCondition( @Nullable final String variantCondition )
    {
        rememberChangedField("VariantCondition", this.variantCondition);
        this.variantCondition = variantCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValueAddedServiceChargeCode</b>
     * </p>
     *
     * @param valueAddedServiceChargeCode
     *            VAS Charge Codes
     */
    public void setValueAddedServiceChargeCode( @Nullable final String valueAddedServiceChargeCode )
    {
        rememberChangedField("ValueAddedServiceChargeCode", this.valueAddedServiceChargeCode);
        this.valueAddedServiceChargeCode = valueAddedServiceChargeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @param sDDocument
     *            Sales and Distribution Document Number
     */
    public void setSDDocument( @Nullable final String sDDocument )
    {
        rememberChangedField("SDDocument", this.sDDocument);
        this.sDDocument = sDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderSalesOrganization</b>
     * </p>
     *
     * @param salesOrderSalesOrganization
     *            Sales organization of sales order
     */
    public void setSalesOrderSalesOrganization( @Nullable final String salesOrderSalesOrganization )
    {
        rememberChangedField("SalesOrderSalesOrganization", this.salesOrderSalesOrganization);
        this.salesOrderSalesOrganization = salesOrderSalesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Billing Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            WBS Work Package
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @param plantRegion
     *            Region in which plant is located
     */
    public void setPlantRegion( @Nullable final String plantRegion )
    {
        rememberChangedField("PlantRegion", this.plantRegion);
        this.plantRegion = plantRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item ID
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionProcessingStatus</b>
     * </p>
     *
     * @param conditionProcessingStatus
     *            Processing status for conditions
     */
    public void setConditionProcessingStatus( @Nullable final String conditionProcessingStatus )
    {
        rememberChangedField("ConditionProcessingStatus", this.conditionProcessingStatus);
        this.conditionProcessingStatus = conditionProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Condition Pricing Date
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsExclusive</b>
     * </p>
     *
     * @param conditionIsExclusive
     *            Indicator condition exclusive
     */
    public void setConditionIsExclusive( @Nullable final Boolean conditionIsExclusive )
    {
        rememberChangedField("ConditionIsExclusive", this.conditionIsExclusive);
        this.conditionIsExclusive = conditionIsExclusive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @param conditionScaleBasisValue
     *            Condition Scale Base Value
     */
    public void setConditionScaleBasisValue( @Nullable final String conditionScaleBasisValue )
    {
        rememberChangedField("ConditionScaleBasisValue", this.conditionScaleBasisValue);
        this.conditionScaleBasisValue = conditionScaleBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @param serviceDocument
     *            Transaction ID
     */
    public void setServiceDocument( @Nullable final String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @param serviceDocumentItem
     *            Shortened Item Number in Document
     */
    public void setServiceDocumentItem( @Nullable final String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSDDocumentCategory</b>
     * </p>
     *
     * @param salesSDDocumentCategory
     *            SD Document Category
     */
    public void setSalesSDDocumentCategory( @Nullable final String salesSDDocumentCategory )
    {
        rememberChangedField("SalesSDDocumentCategory", this.salesSDDocumentCategory);
        this.salesSDDocumentCategory = salesSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnReason</b>
     * </p>
     *
     * @param returnReason
     *            Return Reason
     */
    public void setReturnReason( @Nullable final String returnReason )
    {
        rememberChangedField("ReturnReason", this.returnReason);
        this.returnReason = returnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchyNode</b>
     * </p>
     *
     * @param prodUnivHierarchyNode
     *            Product Hierarchy Node
     */
    public void setProdUnivHierarchyNode( @Nullable final String prodUnivHierarchyNode )
    {
        rememberChangedField("ProdUnivHierarchyNode", this.prodUnivHierarchyNode);
        this.prodUnivHierarchyNode = prodUnivHierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchyNode</b>
     * </p>
     *
     * @param productHierarchyNode
     *            Product Hierarchy Node
     */
    public void setProductHierarchyNode( @Nullable final String productHierarchyNode )
    {
        rememberChangedField("ProductHierarchyNode", this.productHierarchyNode);
        this.productHierarchyNode = productHierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerConditionGroup</b>
     * </p>
     *
     * @param customerConditionGroup
     *            Customer Attribute for Condition Groups
     */
    public void setCustomerConditionGroup( @Nullable final String customerConditionGroup )
    {
        rememberChangedField("CustomerConditionGroup", this.customerConditionGroup);
        this.customerConditionGroup = customerConditionGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionContractDuration</b>
     * </p>
     *
     * @param subscriptionContractDuration
     *            Numerical Value of Duration
     */
    public void setSubscriptionContractDuration( @Nullable final String subscriptionContractDuration )
    {
        rememberChangedField("SubscriptionContractDuration", this.subscriptionContractDuration);
        this.subscriptionContractDuration = subscriptionContractDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnContrDurationUnit</b>
     * </p>
     *
     * @param subscrpnContrDurationUnit
     *            IS-T: Unit of Duration for a Telco Contract
     */
    public void setSubscrpnContrDurationUnit( @Nullable final String subscrpnContrDurationUnit )
    {
        rememberChangedField("SubscrpnContrDurationUnit", this.subscrpnContrDurationUnit);
        this.subscrpnContrDurationUnit = subscrpnContrDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionContractLockReason</b>
     * </p>
     *
     * @param subscriptionContractLockReason
     *            Lock Reason
     */
    public void setSubscriptionContractLockReason( @Nullable final String subscriptionContractLockReason )
    {
        rememberChangedField("SubscriptionContractLockReason", this.subscriptionContractLockReason);
        this.subscriptionContractLockReason = subscriptionContractLockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CrsCtlgMappgPriceVersionNumber</b>
     * </p>
     *
     * @param crsCtlgMappgPriceVersionNumber
     *            Price Version
     */
    public void setCrsCtlgMappgPriceVersionNumber( @Nullable final String crsCtlgMappgPriceVersionNumber )
    {
        rememberChangedField("CrsCtlgMappgPriceVersionNumber", this.crsCtlgMappgPriceVersionNumber);
        this.crsCtlgMappgPriceVersionNumber = crsCtlgMappgPriceVersionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentType</b>
     * </p>
     *
     * @param salesDocumentType
     *            Sales Document Type
     */
    public void setSalesDocumentType( @Nullable final String salesDocumentType )
    {
        rememberChangedField("SalesDocumentType", this.salesDocumentType);
        this.salesDocumentType = salesDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>VolumeRebateGroup</b>
     * </p>
     *
     * @param volumeRebateGroup
     *            Volume rebate group
     */
    public void setVolumeRebateGroup( @Nullable final String volumeRebateGroup )
    {
        rememberChangedField("VolumeRebateGroup", this.volumeRebateGroup);
        this.volumeRebateGroup = volumeRebateGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocSupplyingPlant</b>
     * </p>
     *
     * @param purgDocSupplyingPlant
     *            Supplying (issuing) plant in case of stock transport order
     */
    public void setPurgDocSupplyingPlant( @Nullable final String purgDocSupplyingPlant )
    {
        rememberChangedField("PurgDocSupplyingPlant", this.purgDocSupplyingPlant);
        this.purgDocSupplyingPlant = purgDocSupplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatUsageIndicator</b>
     * </p>
     *
     * @param matUsageIndicator
     *            Usage Indicator
     */
    public void setMatUsageIndicator( @Nullable final String matUsageIndicator )
    {
        rememberChangedField("MatUsageIndicator", this.matUsageIndicator);
        this.matUsageIndicator = matUsageIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantCounty</b>
     * </p>
     *
     * @param plantCounty
     *            County in which plant is located
     */
    public void setPlantCounty( @Nullable final String plantCounty )
    {
        rememberChangedField("PlantCounty", this.plantCounty);
        this.plantCounty = plantCounty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlantCity</b>
     * </p>
     *
     * @param plantCity
     *            City in which plant is located
     */
    public void setPlantCity( @Nullable final String plantCity )
    {
        rememberChangedField("PlantCity", this.plantCity);
        this.plantCity = plantCity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>MaterialExternalGroup</b>
     * </p>
     *
     * @param materialExternalGroup
     *            External Material Group
     */
    public void setMaterialExternalGroup( @Nullable final String materialExternalGroup )
    {
        rememberChangedField("MaterialExternalGroup", this.materialExternalGroup);
        this.materialExternalGroup = materialExternalGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyRootNode</b>
     * </p>
     *
     * @param customerHierarchyRootNode
     *            Customer Hierarchy Root Node ID (Hier ID)
     */
    public void setCustomerHierarchyRootNode( @Nullable final String customerHierarchyRootNode )
    {
        rememberChangedField("CustomerHierarchyRootNode", this.customerHierarchyRootNode);
        this.customerHierarchyRootNode = customerHierarchyRootNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyNodeID</b>
     * </p>
     *
     * @param customerHierarchyNodeID
     *            Customer Hierarchy Node ID
     */
    public void setCustomerHierarchyNodeID( @Nullable final String customerHierarchyNodeID )
    {
        rememberChangedField("CustomerHierarchyNodeID", this.customerHierarchyNodeID);
        this.customerHierarchyNodeID = customerHierarchyNodeID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchyNodeType</b>
     * </p>
     *
     * @param customerHierarchyNodeType
     *            Customer Hierarchy Node Type
     */
    public void setCustomerHierarchyNodeType( @Nullable final String customerHierarchyNodeType )
    {
        rememberChangedField("CustomerHierarchyNodeType", this.customerHierarchyNodeType);
        this.customerHierarchyNodeType = customerHierarchyNodeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @param additionalCustomerGroup1
     *            Customer Group 1
     */
    public void setAdditionalCustomerGroup1( @Nullable final String additionalCustomerGroup1 )
    {
        rememberChangedField("AdditionalCustomerGroup1", this.additionalCustomerGroup1);
        this.additionalCustomerGroup1 = additionalCustomerGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @param additionalCustomerGroup2
     *            Customer Group 2
     */
    public void setAdditionalCustomerGroup2( @Nullable final String additionalCustomerGroup2 )
    {
        rememberChangedField("AdditionalCustomerGroup2", this.additionalCustomerGroup2);
        this.additionalCustomerGroup2 = additionalCustomerGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @param additionalCustomerGroup3
     *            Customer Group 3
     */
    public void setAdditionalCustomerGroup3( @Nullable final String additionalCustomerGroup3 )
    {
        rememberChangedField("AdditionalCustomerGroup3", this.additionalCustomerGroup3);
        this.additionalCustomerGroup3 = additionalCustomerGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @param additionalCustomerGroup4
     *            Customer Group 4
     */
    public void setAdditionalCustomerGroup4( @Nullable final String additionalCustomerGroup4 )
    {
        rememberChangedField("AdditionalCustomerGroup4", this.additionalCustomerGroup4);
        this.additionalCustomerGroup4 = additionalCustomerGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @param additionalCustomerGroup5
     *            Customer Group 5
     */
    public void setAdditionalCustomerGroup5( @Nullable final String additionalCustomerGroup5 )
    {
        rememberChangedField("AdditionalCustomerGroup5", this.additionalCustomerGroup5);
        this.additionalCustomerGroup5 = additionalCustomerGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @param sDDocumentItem
     *            Item number of the SD document
     */
    public void setSDDocumentItem( @Nullable final String sDDocumentItem )
    {
        rememberChangedField("SDDocumentItem", this.sDDocumentItem);
        this.sDDocumentItem = sDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnBillingDocumentCategory</b>
     * </p>
     *
     * @param cndnBillingDocumentCategory
     *            Billing Category
     */
    public void setCndnBillingDocumentCategory( @Nullable final String cndnBillingDocumentCategory )
    {
        rememberChangedField("CndnBillingDocumentCategory", this.cndnBillingDocumentCategory);
        this.cndnBillingDocumentCategory = cndnBillingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PRAContract</b>
     * </p>
     *
     * @param pRAContract
     *            Contract Number
     */
    public void setPRAContract( @Nullable final String pRAContract )
    {
        rememberChangedField("PRAContract", this.pRAContract);
        this.pRAContract = pRAContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Well</b>
     * </p>
     *
     * @param well
     *            Well ID number
     */
    public void setWell( @Nullable final String well )
    {
        rememberChangedField("Well", this.well);
        this.well = well;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>WellCompletion</b>
     * </p>
     *
     * @param wellCompletion
     *            Well Completion Number
     */
    public void setWellCompletion( @Nullable final String wellCompletion )
    {
        rememberChangedField("WellCompletion", this.wellCompletion);
        this.wellCompletion = wellCompletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementPoint</b>
     * </p>
     *
     * @param measurementPoint
     *            Measurement point number
     */
    public void setMeasurementPoint( @Nullable final String measurementPoint )
    {
        rememberChangedField("MeasurementPoint", this.measurementPoint);
        this.measurementPoint = measurementPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingFormulaNumber</b>
     * </p>
     *
     * @param pricingFormulaNumber
     *            Formula ID
     */
    public void setPricingFormulaNumber( @Nullable final String pricingFormulaNumber )
    {
        rememberChangedField("PricingFormulaNumber", this.pricingFormulaNumber);
        this.pricingFormulaNumber = pricingFormulaNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgCndnRecdValidity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionReleaseStatus", getConditionReleaseStatus());
        values.put("DepartureCountry", getDepartureCountry());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("BillableControl", getBillableControl());
        values.put("Industry", getIndustry());
        values.put("CityCode", getCityCode());
        values.put("ConditionContract", getConditionContract());
        values.put("County", getCounty());
        values.put("EngagementProject", getEngagementProject());
        values.put("ConfigurationNumber", getConfigurationNumber());
        values.put("BR_NFDocumentType", getBR_NFDocumentType());
        values.put("BRSpcfcFreeDefinedField1", getBRSpcfcFreeDefinedField1());
        values.put("BRSpcfcFreeDefinedField2", getBRSpcfcFreeDefinedField2());
        values.put("BRSpcfcFreeDefinedField3", getBRSpcfcFreeDefinedField3());
        values.put("InternationalArticleNumber", getInternationalArticleNumber());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("Equipment", getEquipment());
        values.put("CustomerHierarchy", getCustomerHierarchy());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("AccountTaxType", getAccountTaxType());
        values.put("TxRlvnceClassfctnForArgentina", getTxRlvnceClassfctnForArgentina());
        values.put("BR_TaxCode", getBR_TaxCode());
        values.put("LocalSalesTaxApplicabilityCode", getLocalSalesTaxApplicabilityCode());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerPriceGroup", getCustomerPriceGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("BPForSoldToParty", getBPForSoldToParty());
        values.put("Customer", getCustomer());
        values.put("BPForCustomer", getBPForCustomer());
        values.put("PayerParty", getPayerParty());
        values.put("BPForPayerParty", getBPForPayerParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BPForShipToParty", getBPForShipToParty());
        values.put("Supplier", getSupplier());
        values.put("BPForSupplier", getBPForSupplier());
        values.put("DestinationCountry", getDestinationCountry());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Material", getMaterial());
        values.put("ReturnsRefundExtent", getReturnsRefundExtent());
        values.put("AdditionalMaterialGroup1", getAdditionalMaterialGroup1());
        values.put("AdditionalMaterialGroup2", getAdditionalMaterialGroup2());
        values.put("AdditionalMaterialGroup3", getAdditionalMaterialGroup3());
        values.put("AdditionalMaterialGroup4", getAdditionalMaterialGroup4());
        values.put("AdditionalMaterialGroup5", getAdditionalMaterialGroup5());
        values.put("Personnel", getPersonnel());
        values.put("PriceListType", getPriceListType());
        values.put("PostalCode", getPostalCode());
        values.put("Region", getRegion());
        values.put("EngagementProjectServiceOrg", getEngagementProjectServiceOrg());
        values.put("RequirementSegment", getRequirementSegment());
        values.put("StockSegment", getStockSegment());
        values.put("Division", getDivision());
        values.put("CommodityCode", getCommodityCode());
        values.put("ConsumptionTaxCtrlCode", getConsumptionTaxCtrlCode());
        values.put("BRSpcfcTaxBasePercentageCode", getBRSpcfcTaxBasePercentageCode());
        values.put("BRSpcfcTxGrpDynTaxExceptions", getBRSpcfcTxGrpDynTaxExceptions());
        values.put("CustomerTaxClassification1", getCustomerTaxClassification1());
        values.put("CustomerTaxClassification2", getCustomerTaxClassification2());
        values.put("CustomerTaxClassification3", getCustomerTaxClassification3());
        values.put("CustomerTaxClassification4", getCustomerTaxClassification4());
        values.put("CustomerTaxClassification5", getCustomerTaxClassification5());
        values.put("CustomerTaxClassification6", getCustomerTaxClassification6());
        values.put("CustomerTaxClassification7", getCustomerTaxClassification7());
        values.put("CustomerTaxClassification8", getCustomerTaxClassification8());
        values.put("CustomerTaxClassification9", getCustomerTaxClassification9());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("TradingContract", getTradingContract());
        values.put("TradingContractItem", getTradingContractItem());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("BRSpcfcTaxDepartureRegion", getBRSpcfcTaxDepartureRegion());
        values.put("BRSpcfcTaxDestinationRegion", getBRSpcfcTaxDestinationRegion());
        values.put("MainItemMaterialPricingGroup", getMainItemMaterialPricingGroup());
        values.put("MainItemPricingRefMaterial", getMainItemPricingRefMaterial());
        values.put("VariantCondition", getVariantCondition());
        values.put("ValueAddedServiceChargeCode", getValueAddedServiceChargeCode());
        values.put("SDDocument", getSDDocument());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrderSalesOrganization", getSalesOrderSalesOrganization());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("WorkPackage", getWorkPackage());
        values.put("Plant", getPlant());
        values.put("PlantRegion", getPlantRegion());
        values.put("WorkItem", getWorkItem());
        values.put("ConditionProcessingStatus", getConditionProcessingStatus());
        values.put("PricingDate", getPricingDate());
        values.put("ConditionIsExclusive", getConditionIsExclusive());
        values.put("ConditionScaleBasisValue", getConditionScaleBasisValue());
        values.put("TaxCode", getTaxCode());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("SalesSDDocumentCategory", getSalesSDDocumentCategory());
        values.put("ReturnReason", getReturnReason());
        values.put("ProdUnivHierarchyNode", getProdUnivHierarchyNode());
        values.put("ProductHierarchyNode", getProductHierarchyNode());
        values.put("CustomerConditionGroup", getCustomerConditionGroup());
        values.put("ShippingType", getShippingType());
        values.put("SubscriptionContractDuration", getSubscriptionContractDuration());
        values.put("SubscrpnContrDurationUnit", getSubscrpnContrDurationUnit());
        values.put("SubscriptionContractLockReason", getSubscriptionContractLockReason());
        values.put("CrsCtlgMappgPriceVersionNumber", getCrsCtlgMappgPriceVersionNumber());
        values.put("OrderType", getOrderType());
        values.put("SalesDocumentType", getSalesDocumentType());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("VolumeRebateGroup", getVolumeRebateGroup());
        values.put("ValuationType", getValuationType());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("Batch", getBatch());
        values.put("PurgDocSupplyingPlant", getPurgDocSupplyingPlant());
        values.put("MatUsageIndicator", getMatUsageIndicator());
        values.put("ShippingCondition", getShippingCondition());
        values.put("PlantCounty", getPlantCounty());
        values.put("PlantCity", getPlantCity());
        values.put("MaterialExternalGroup", getMaterialExternalGroup());
        values.put("CustomerHierarchyRootNode", getCustomerHierarchyRootNode());
        values.put("CustomerHierarchyNodeID", getCustomerHierarchyNodeID());
        values.put("CustomerHierarchyNodeType", getCustomerHierarchyNodeType());
        values.put("AdditionalCustomerGroup1", getAdditionalCustomerGroup1());
        values.put("AdditionalCustomerGroup2", getAdditionalCustomerGroup2());
        values.put("AdditionalCustomerGroup3", getAdditionalCustomerGroup3());
        values.put("AdditionalCustomerGroup4", getAdditionalCustomerGroup4());
        values.put("AdditionalCustomerGroup5", getAdditionalCustomerGroup5());
        values.put("SDDocumentItem", getSDDocumentItem());
        values.put("CndnBillingDocumentCategory", getCndnBillingDocumentCategory());
        values.put("Country", getCountry());
        values.put("PRAContract", getPRAContract());
        values.put("Well", getWell());
        values.put("WellCompletion", getWellCompletion());
        values.put("MeasurementPoint", getMeasurementPoint());
        values.put("PricingFormulaNumber", getPricingFormulaNumber());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionReleaseStatus") ) {
                final Object value = values.remove("ConditionReleaseStatus");
                if( (value == null) || (!value.equals(getConditionReleaseStatus())) ) {
                    setConditionReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("DepartureCountry") ) {
                final Object value = values.remove("DepartureCountry");
                if( (value == null) || (!value.equals(getDepartureCountry())) ) {
                    setDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("Industry") ) {
                final Object value = values.remove("Industry");
                if( (value == null) || (!value.equals(getIndustry())) ) {
                    setIndustry(((String) value));
                }
            }
            if( values.containsKey("CityCode") ) {
                final Object value = values.remove("CityCode");
                if( (value == null) || (!value.equals(getCityCode())) ) {
                    setCityCode(((String) value));
                }
            }
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((String) value));
                }
            }
            if( values.containsKey("County") ) {
                final Object value = values.remove("County");
                if( (value == null) || (!value.equals(getCounty())) ) {
                    setCounty(((String) value));
                }
            }
            if( values.containsKey("EngagementProject") ) {
                final Object value = values.remove("EngagementProject");
                if( (value == null) || (!value.equals(getEngagementProject())) ) {
                    setEngagementProject(((String) value));
                }
            }
            if( values.containsKey("ConfigurationNumber") ) {
                final Object value = values.remove("ConfigurationNumber");
                if( (value == null) || (!value.equals(getConfigurationNumber())) ) {
                    setConfigurationNumber(((String) value));
                }
            }
            if( values.containsKey("BR_NFDocumentType") ) {
                final Object value = values.remove("BR_NFDocumentType");
                if( (value == null) || (!value.equals(getBR_NFDocumentType())) ) {
                    setBR_NFDocumentType(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcFreeDefinedField1") ) {
                final Object value = values.remove("BRSpcfcFreeDefinedField1");
                if( (value == null) || (!value.equals(getBRSpcfcFreeDefinedField1())) ) {
                    setBRSpcfcFreeDefinedField1(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcFreeDefinedField2") ) {
                final Object value = values.remove("BRSpcfcFreeDefinedField2");
                if( (value == null) || (!value.equals(getBRSpcfcFreeDefinedField2())) ) {
                    setBRSpcfcFreeDefinedField2(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcFreeDefinedField3") ) {
                final Object value = values.remove("BRSpcfcFreeDefinedField3");
                if( (value == null) || (!value.equals(getBRSpcfcFreeDefinedField3())) ) {
                    setBRSpcfcFreeDefinedField3(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumber") ) {
                final Object value = values.remove("InternationalArticleNumber");
                if( (value == null) || (!value.equals(getInternationalArticleNumber())) ) {
                    setInternationalArticleNumber(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("CustomerHierarchy") ) {
                final Object value = values.remove("CustomerHierarchy");
                if( (value == null) || (!value.equals(getCustomerHierarchy())) ) {
                    setCustomerHierarchy(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("AccountTaxType") ) {
                final Object value = values.remove("AccountTaxType");
                if( (value == null) || (!value.equals(getAccountTaxType())) ) {
                    setAccountTaxType(((String) value));
                }
            }
            if( values.containsKey("TxRlvnceClassfctnForArgentina") ) {
                final Object value = values.remove("TxRlvnceClassfctnForArgentina");
                if( (value == null) || (!value.equals(getTxRlvnceClassfctnForArgentina())) ) {
                    setTxRlvnceClassfctnForArgentina(((String) value));
                }
            }
            if( values.containsKey("BR_TaxCode") ) {
                final Object value = values.remove("BR_TaxCode");
                if( (value == null) || (!value.equals(getBR_TaxCode())) ) {
                    setBR_TaxCode(((String) value));
                }
            }
            if( values.containsKey("LocalSalesTaxApplicabilityCode") ) {
                final Object value = values.remove("LocalSalesTaxApplicabilityCode");
                if( (value == null) || (!value.equals(getLocalSalesTaxApplicabilityCode())) ) {
                    setLocalSalesTaxApplicabilityCode(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerPriceGroup") ) {
                final Object value = values.remove("CustomerPriceGroup");
                if( (value == null) || (!value.equals(getCustomerPriceGroup())) ) {
                    setCustomerPriceGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("BPForSoldToParty") ) {
                final Object value = values.remove("BPForSoldToParty");
                if( (value == null) || (!value.equals(getBPForSoldToParty())) ) {
                    setBPForSoldToParty(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("BPForCustomer") ) {
                final Object value = values.remove("BPForCustomer");
                if( (value == null) || (!value.equals(getBPForCustomer())) ) {
                    setBPForCustomer(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("BPForPayerParty") ) {
                final Object value = values.remove("BPForPayerParty");
                if( (value == null) || (!value.equals(getBPForPayerParty())) ) {
                    setBPForPayerParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BPForShipToParty") ) {
                final Object value = values.remove("BPForShipToParty");
                if( (value == null) || (!value.equals(getBPForShipToParty())) ) {
                    setBPForShipToParty(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("BPForSupplier") ) {
                final Object value = values.remove("BPForSupplier");
                if( (value == null) || (!value.equals(getBPForSupplier())) ) {
                    setBPForSupplier(((String) value));
                }
            }
            if( values.containsKey("DestinationCountry") ) {
                final Object value = values.remove("DestinationCountry");
                if( (value == null) || (!value.equals(getDestinationCountry())) ) {
                    setDestinationCountry(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ReturnsRefundExtent") ) {
                final Object value = values.remove("ReturnsRefundExtent");
                if( (value == null) || (!value.equals(getReturnsRefundExtent())) ) {
                    setReturnsRefundExtent(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup1") ) {
                final Object value = values.remove("AdditionalMaterialGroup1");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup1())) ) {
                    setAdditionalMaterialGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup2") ) {
                final Object value = values.remove("AdditionalMaterialGroup2");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup2())) ) {
                    setAdditionalMaterialGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup3") ) {
                final Object value = values.remove("AdditionalMaterialGroup3");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup3())) ) {
                    setAdditionalMaterialGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup4") ) {
                final Object value = values.remove("AdditionalMaterialGroup4");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup4())) ) {
                    setAdditionalMaterialGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup5") ) {
                final Object value = values.remove("AdditionalMaterialGroup5");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup5())) ) {
                    setAdditionalMaterialGroup5(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("PriceListType") ) {
                final Object value = values.remove("PriceListType");
                if( (value == null) || (!value.equals(getPriceListType())) ) {
                    setPriceListType(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("EngagementProjectServiceOrg") ) {
                final Object value = values.remove("EngagementProjectServiceOrg");
                if( (value == null) || (!value.equals(getEngagementProjectServiceOrg())) ) {
                    setEngagementProjectServiceOrg(((String) value));
                }
            }
            if( values.containsKey("RequirementSegment") ) {
                final Object value = values.remove("RequirementSegment");
                if( (value == null) || (!value.equals(getRequirementSegment())) ) {
                    setRequirementSegment(((String) value));
                }
            }
            if( values.containsKey("StockSegment") ) {
                final Object value = values.remove("StockSegment");
                if( (value == null) || (!value.equals(getStockSegment())) ) {
                    setStockSegment(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("CommodityCode") ) {
                final Object value = values.remove("CommodityCode");
                if( (value == null) || (!value.equals(getCommodityCode())) ) {
                    setCommodityCode(((String) value));
                }
            }
            if( values.containsKey("ConsumptionTaxCtrlCode") ) {
                final Object value = values.remove("ConsumptionTaxCtrlCode");
                if( (value == null) || (!value.equals(getConsumptionTaxCtrlCode())) ) {
                    setConsumptionTaxCtrlCode(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcTaxBasePercentageCode") ) {
                final Object value = values.remove("BRSpcfcTaxBasePercentageCode");
                if( (value == null) || (!value.equals(getBRSpcfcTaxBasePercentageCode())) ) {
                    setBRSpcfcTaxBasePercentageCode(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcTxGrpDynTaxExceptions") ) {
                final Object value = values.remove("BRSpcfcTxGrpDynTaxExceptions");
                if( (value == null) || (!value.equals(getBRSpcfcTxGrpDynTaxExceptions())) ) {
                    setBRSpcfcTxGrpDynTaxExceptions(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification1") ) {
                final Object value = values.remove("CustomerTaxClassification1");
                if( (value == null) || (!value.equals(getCustomerTaxClassification1())) ) {
                    setCustomerTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification2") ) {
                final Object value = values.remove("CustomerTaxClassification2");
                if( (value == null) || (!value.equals(getCustomerTaxClassification2())) ) {
                    setCustomerTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification3") ) {
                final Object value = values.remove("CustomerTaxClassification3");
                if( (value == null) || (!value.equals(getCustomerTaxClassification3())) ) {
                    setCustomerTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification4") ) {
                final Object value = values.remove("CustomerTaxClassification4");
                if( (value == null) || (!value.equals(getCustomerTaxClassification4())) ) {
                    setCustomerTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification5") ) {
                final Object value = values.remove("CustomerTaxClassification5");
                if( (value == null) || (!value.equals(getCustomerTaxClassification5())) ) {
                    setCustomerTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification6") ) {
                final Object value = values.remove("CustomerTaxClassification6");
                if( (value == null) || (!value.equals(getCustomerTaxClassification6())) ) {
                    setCustomerTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification7") ) {
                final Object value = values.remove("CustomerTaxClassification7");
                if( (value == null) || (!value.equals(getCustomerTaxClassification7())) ) {
                    setCustomerTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification8") ) {
                final Object value = values.remove("CustomerTaxClassification8");
                if( (value == null) || (!value.equals(getCustomerTaxClassification8())) ) {
                    setCustomerTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification9") ) {
                final Object value = values.remove("CustomerTaxClassification9");
                if( (value == null) || (!value.equals(getCustomerTaxClassification9())) ) {
                    setCustomerTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("TradingContract") ) {
                final Object value = values.remove("TradingContract");
                if( (value == null) || (!value.equals(getTradingContract())) ) {
                    setTradingContract(((String) value));
                }
            }
            if( values.containsKey("TradingContractItem") ) {
                final Object value = values.remove("TradingContractItem");
                if( (value == null) || (!value.equals(getTradingContractItem())) ) {
                    setTradingContractItem(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcTaxDepartureRegion") ) {
                final Object value = values.remove("BRSpcfcTaxDepartureRegion");
                if( (value == null) || (!value.equals(getBRSpcfcTaxDepartureRegion())) ) {
                    setBRSpcfcTaxDepartureRegion(((String) value));
                }
            }
            if( values.containsKey("BRSpcfcTaxDestinationRegion") ) {
                final Object value = values.remove("BRSpcfcTaxDestinationRegion");
                if( (value == null) || (!value.equals(getBRSpcfcTaxDestinationRegion())) ) {
                    setBRSpcfcTaxDestinationRegion(((String) value));
                }
            }
            if( values.containsKey("MainItemMaterialPricingGroup") ) {
                final Object value = values.remove("MainItemMaterialPricingGroup");
                if( (value == null) || (!value.equals(getMainItemMaterialPricingGroup())) ) {
                    setMainItemMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("MainItemPricingRefMaterial") ) {
                final Object value = values.remove("MainItemPricingRefMaterial");
                if( (value == null) || (!value.equals(getMainItemPricingRefMaterial())) ) {
                    setMainItemPricingRefMaterial(((String) value));
                }
            }
            if( values.containsKey("VariantCondition") ) {
                final Object value = values.remove("VariantCondition");
                if( (value == null) || (!value.equals(getVariantCondition())) ) {
                    setVariantCondition(((String) value));
                }
            }
            if( values.containsKey("ValueAddedServiceChargeCode") ) {
                final Object value = values.remove("ValueAddedServiceChargeCode");
                if( (value == null) || (!value.equals(getValueAddedServiceChargeCode())) ) {
                    setValueAddedServiceChargeCode(((String) value));
                }
            }
            if( values.containsKey("SDDocument") ) {
                final Object value = values.remove("SDDocument");
                if( (value == null) || (!value.equals(getSDDocument())) ) {
                    setSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrderSalesOrganization") ) {
                final Object value = values.remove("SalesOrderSalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrderSalesOrganization())) ) {
                    setSalesOrderSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantRegion") ) {
                final Object value = values.remove("PlantRegion");
                if( (value == null) || (!value.equals(getPlantRegion())) ) {
                    setPlantRegion(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("ConditionProcessingStatus") ) {
                final Object value = values.remove("ConditionProcessingStatus");
                if( (value == null) || (!value.equals(getConditionProcessingStatus())) ) {
                    setConditionProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionIsExclusive") ) {
                final Object value = values.remove("ConditionIsExclusive");
                if( (value == null) || (!value.equals(getConditionIsExclusive())) ) {
                    setConditionIsExclusive(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisValue") ) {
                final Object value = values.remove("ConditionScaleBasisValue");
                if( (value == null) || (!value.equals(getConditionScaleBasisValue())) ) {
                    setConditionScaleBasisValue(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("SalesSDDocumentCategory") ) {
                final Object value = values.remove("SalesSDDocumentCategory");
                if( (value == null) || (!value.equals(getSalesSDDocumentCategory())) ) {
                    setSalesSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ReturnReason") ) {
                final Object value = values.remove("ReturnReason");
                if( (value == null) || (!value.equals(getReturnReason())) ) {
                    setReturnReason(((String) value));
                }
            }
            if( values.containsKey("ProdUnivHierarchyNode") ) {
                final Object value = values.remove("ProdUnivHierarchyNode");
                if( (value == null) || (!value.equals(getProdUnivHierarchyNode())) ) {
                    setProdUnivHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("ProductHierarchyNode") ) {
                final Object value = values.remove("ProductHierarchyNode");
                if( (value == null) || (!value.equals(getProductHierarchyNode())) ) {
                    setProductHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("CustomerConditionGroup") ) {
                final Object value = values.remove("CustomerConditionGroup");
                if( (value == null) || (!value.equals(getCustomerConditionGroup())) ) {
                    setCustomerConditionGroup(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("SubscriptionContractDuration") ) {
                final Object value = values.remove("SubscriptionContractDuration");
                if( (value == null) || (!value.equals(getSubscriptionContractDuration())) ) {
                    setSubscriptionContractDuration(((String) value));
                }
            }
            if( values.containsKey("SubscrpnContrDurationUnit") ) {
                final Object value = values.remove("SubscrpnContrDurationUnit");
                if( (value == null) || (!value.equals(getSubscrpnContrDurationUnit())) ) {
                    setSubscrpnContrDurationUnit(((String) value));
                }
            }
            if( values.containsKey("SubscriptionContractLockReason") ) {
                final Object value = values.remove("SubscriptionContractLockReason");
                if( (value == null) || (!value.equals(getSubscriptionContractLockReason())) ) {
                    setSubscriptionContractLockReason(((String) value));
                }
            }
            if( values.containsKey("CrsCtlgMappgPriceVersionNumber") ) {
                final Object value = values.remove("CrsCtlgMappgPriceVersionNumber");
                if( (value == null) || (!value.equals(getCrsCtlgMappgPriceVersionNumber())) ) {
                    setCrsCtlgMappgPriceVersionNumber(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentType") ) {
                final Object value = values.remove("SalesDocumentType");
                if( (value == null) || (!value.equals(getSalesDocumentType())) ) {
                    setSalesDocumentType(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("VolumeRebateGroup") ) {
                final Object value = values.remove("VolumeRebateGroup");
                if( (value == null) || (!value.equals(getVolumeRebateGroup())) ) {
                    setVolumeRebateGroup(((String) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("PurgDocSupplyingPlant") ) {
                final Object value = values.remove("PurgDocSupplyingPlant");
                if( (value == null) || (!value.equals(getPurgDocSupplyingPlant())) ) {
                    setPurgDocSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("MatUsageIndicator") ) {
                final Object value = values.remove("MatUsageIndicator");
                if( (value == null) || (!value.equals(getMatUsageIndicator())) ) {
                    setMatUsageIndicator(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("PlantCounty") ) {
                final Object value = values.remove("PlantCounty");
                if( (value == null) || (!value.equals(getPlantCounty())) ) {
                    setPlantCounty(((String) value));
                }
            }
            if( values.containsKey("PlantCity") ) {
                final Object value = values.remove("PlantCity");
                if( (value == null) || (!value.equals(getPlantCity())) ) {
                    setPlantCity(((String) value));
                }
            }
            if( values.containsKey("MaterialExternalGroup") ) {
                final Object value = values.remove("MaterialExternalGroup");
                if( (value == null) || (!value.equals(getMaterialExternalGroup())) ) {
                    setMaterialExternalGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerHierarchyRootNode") ) {
                final Object value = values.remove("CustomerHierarchyRootNode");
                if( (value == null) || (!value.equals(getCustomerHierarchyRootNode())) ) {
                    setCustomerHierarchyRootNode(((String) value));
                }
            }
            if( values.containsKey("CustomerHierarchyNodeID") ) {
                final Object value = values.remove("CustomerHierarchyNodeID");
                if( (value == null) || (!value.equals(getCustomerHierarchyNodeID())) ) {
                    setCustomerHierarchyNodeID(((String) value));
                }
            }
            if( values.containsKey("CustomerHierarchyNodeType") ) {
                final Object value = values.remove("CustomerHierarchyNodeType");
                if( (value == null) || (!value.equals(getCustomerHierarchyNodeType())) ) {
                    setCustomerHierarchyNodeType(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup1") ) {
                final Object value = values.remove("AdditionalCustomerGroup1");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup1())) ) {
                    setAdditionalCustomerGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup2") ) {
                final Object value = values.remove("AdditionalCustomerGroup2");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup2())) ) {
                    setAdditionalCustomerGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup3") ) {
                final Object value = values.remove("AdditionalCustomerGroup3");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup3())) ) {
                    setAdditionalCustomerGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup4") ) {
                final Object value = values.remove("AdditionalCustomerGroup4");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup4())) ) {
                    setAdditionalCustomerGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup5") ) {
                final Object value = values.remove("AdditionalCustomerGroup5");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup5())) ) {
                    setAdditionalCustomerGroup5(((String) value));
                }
            }
            if( values.containsKey("SDDocumentItem") ) {
                final Object value = values.remove("SDDocumentItem");
                if( (value == null) || (!value.equals(getSDDocumentItem())) ) {
                    setSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("CndnBillingDocumentCategory") ) {
                final Object value = values.remove("CndnBillingDocumentCategory");
                if( (value == null) || (!value.equals(getCndnBillingDocumentCategory())) ) {
                    setCndnBillingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("PRAContract") ) {
                final Object value = values.remove("PRAContract");
                if( (value == null) || (!value.equals(getPRAContract())) ) {
                    setPRAContract(((String) value));
                }
            }
            if( values.containsKey("Well") ) {
                final Object value = values.remove("Well");
                if( (value == null) || (!value.equals(getWell())) ) {
                    setWell(((String) value));
                }
            }
            if( values.containsKey("WellCompletion") ) {
                final Object value = values.remove("WellCompletion");
                if( (value == null) || (!value.equals(getWellCompletion())) ) {
                    setWellCompletion(((String) value));
                }
            }
            if( values.containsKey("MeasurementPoint") ) {
                final Object value = values.remove("MeasurementPoint");
                if( (value == null) || (!value.equals(getMeasurementPoint())) ) {
                    setMeasurementPoint(((String) value));
                }
            }
            if( values.containsKey("PricingFormulaNumber") ) {
                final Object value = values.remove("PricingFormulaNumber");
                if( (value == null) || (!value.equals(getPricingFormulaNumber())) ) {
                    setPricingFormulaNumber(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsPrcgCndnRecdSuplmnt") ) {
                final Object value = (values).remove("to_SlsPrcgCndnRecdSuplmnt");
                if( value instanceof Iterable ) {
                    if( toSlsPrcgCndnRecdSuplmnt == null ) {
                        toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
                    } else {
                        toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList(toSlsPrcgCndnRecdSuplmnt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgCndnRecdSuplmnt entity;
                        if( toSlsPrcgCndnRecdSuplmnt.size() > i ) {
                            entity = toSlsPrcgCndnRecdSuplmnt.get(i);
                        } else {
                            entity = new SlsPrcgCndnRecdSuplmnt();
                            toSlsPrcgCndnRecdSuplmnt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SlsPrcgConditionRecord") ) {
                final Object value = (values).remove("to_SlsPrcgConditionRecord");
                if( value instanceof Map ) {
                    if( toSlsPrcgConditionRecord == null ) {
                        toSlsPrcgConditionRecord = new SlsPrcgConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSlsPrcgConditionRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsPrcgCndnRecdValidityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgCndnRecdValidityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgCndnRecdValidityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgCndnRecdValidityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsPrcgCndnRecdSuplmnt != null ) {
            (values).put("to_SlsPrcgCndnRecdSuplmnt", toSlsPrcgCndnRecdSuplmnt);
        }
        if( toSlsPrcgConditionRecord != null ) {
            (values).put("to_SlsPrcgConditionRecord", toSlsPrcgConditionRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPrcgCndnRecdSuplmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdSuplmnt> fetchSlsPrcgCndnRecdSuplmnt()
    {
        return fetchFieldAsList("to_SlsPrcgCndnRecdSuplmnt", SlsPrcgCndnRecdSuplmnt.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdSuplmnt> getSlsPrcgCndnRecdSuplmntOrFetch()
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = fetchSlsPrcgCndnRecdSuplmnt();
        }
        return toSlsPrcgCndnRecdSuplmnt;
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgCndnRecdValidity</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> is already loaded, the result
     *         will contain the <b>SlsPrcgCndnRecdSuplmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgCndnRecdSuplmnt>> getSlsPrcgCndnRecdSuplmntIfPresent()
    {
        return Option.of(toSlsPrcgCndnRecdSuplmnt);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities for the loaded navigation property
     * <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     */
    public void setSlsPrcgCndnRecdSuplmnt( @Nonnull final List<SlsPrcgCndnRecdSuplmnt> value )
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdSuplmnt.clear();
        toSlsPrcgCndnRecdSuplmnt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     */
    public void addSlsPrcgCndnRecdSuplmnt( SlsPrcgCndnRecdSuplmnt... entity )
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdSuplmnt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsPrcgConditionRecord</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SlsPrcgConditionRecord</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord fetchSlsPrcgConditionRecord()
    {
        return fetchFieldAsSingle("to_SlsPrcgConditionRecord", SlsPrcgConditionRecord.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecord</b> of a queried <b>SlsPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgConditionRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord getSlsPrcgConditionRecordOrFetch()
    {
        if( toSlsPrcgConditionRecord == null ) {
            toSlsPrcgConditionRecord = fetchSlsPrcgConditionRecord();
        }
        return toSlsPrcgConditionRecord;
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgCndnRecdValidity</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgConditionRecord</b> is already loaded, the result
     *         will contain the <b>SlsPrcgConditionRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SlsPrcgConditionRecord> getSlsPrcgConditionRecordIfPresent()
    {
        return Option.of(toSlsPrcgConditionRecord);
    }

    /**
     * Overwrites the associated <b>SlsPrcgConditionRecord</b> entity for the loaded navigation property
     * <b>to_SlsPrcgConditionRecord</b>.
     *
     * @param value
     *            New <b>SlsPrcgConditionRecord</b> entity.
     */
    public void setSlsPrcgConditionRecord( final SlsPrcgConditionRecord value )
    {
        toSlsPrcgConditionRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgCndnRecdValidity instances.
     *
     */
    public final static class SlsPrcgCndnRecdValidityBuilder
    {

        private List<SlsPrcgCndnRecdSuplmnt> toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        private SlsPrcgConditionRecord toSlsPrcgConditionRecord;

        private SlsPrcgCndnRecdValidity.SlsPrcgCndnRecdValidityBuilder toSlsPrcgCndnRecdSuplmnt(
            final List<SlsPrcgCndnRecdSuplmnt> value )
        {
            toSlsPrcgCndnRecdSuplmnt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgCndnRecdValidity</b> to multiple
         * <b>SlsPrcgCndnRecdSuplmnt</b>.
         *
         * @param value
         *            The SlsPrcgCndnRecdSuplmnts to build this SlsPrcgCndnRecdValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgCndnRecdValidity.SlsPrcgCndnRecdValidityBuilder slsPrcgCndnRecdSuplmnt(
            SlsPrcgCndnRecdSuplmnt... value )
        {
            return toSlsPrcgCndnRecdSuplmnt(Lists.newArrayList(value));
        }

        private SlsPrcgCndnRecdValidity.SlsPrcgCndnRecdValidityBuilder toSlsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            toSlsPrcgConditionRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgCndnRecdValidity</b> to single
         * <b>SlsPrcgConditionRecord</b>.
         *
         * @param value
         *            The SlsPrcgConditionRecord to build this SlsPrcgCndnRecdValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgCndnRecdValidity.SlsPrcgCndnRecdValidityBuilder slsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            return toSlsPrcgConditionRecord(value);
        }

    }

}
