/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgCndnRecordScaleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgCndnRecordScaleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable.SlsPrcgCndnRecordScaleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Scales
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgCndnRecordScaleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgCndnRecordScale extends VdmEntity<SlsPrcgCndnRecordScale>
{

    /**
     * Selector for all available fields of SlsPrcgCndnRecordScale.
     *
     */
    public final static SlsPrcgCndnRecordScaleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_RECORD =
        new SlsPrcgCndnRecordScaleField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_SEQUENTIAL_NUMBER =
        new SlsPrcgCndnRecordScaleField<String>("ConditionSequentialNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @return Current number of the line scale
     */
    @Key
    @SerializedName( "ConditionScaleLine" )
    @JsonProperty( "ConditionScaleLine" )
    @Nullable
    @ODataField( odataName = "ConditionScaleLine" )
    private String conditionScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleLine</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_SCALE_LINE =
        new SlsPrcgCndnRecordScaleField<String>("ConditionScaleLine");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new SlsPrcgCndnRecordScaleField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new SlsPrcgCndnRecordScaleField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new SlsPrcgCndnRecordScaleField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new SlsPrcgCndnRecordScaleField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<BigDecimal> CONDITION_RATE_VALUE =
        new SlsPrcgCndnRecordScaleField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_RATE_VALUE_UNIT =
        new SlsPrcgCndnRecordScaleField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<BigDecimal> CONDITION_RATE_RATIO =
        new SlsPrcgCndnRecordScaleField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ConditionRateRatioUnit" )
    @JsonProperty( "ConditionRateRatioUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatioUnit" )
    private String conditionRateRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatioUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_RATE_RATIO_UNIT =
        new SlsPrcgCndnRecordScaleField<String>("ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateAmount" )
    @JsonProperty( "ConditionRateAmount" )
    @Nullable
    @ODataField( odataName = "ConditionRateAmount" )
    private BigDecimal conditionRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<BigDecimal> CONDITION_RATE_AMOUNT =
        new SlsPrcgCndnRecordScaleField<BigDecimal>("ConditionRateAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> CONDITION_CURRENCY =
        new SlsPrcgCndnRecordScaleField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleField<String> E_TAG = new SlsPrcgCndnRecordScaleField<String>("ETag");
    /**
     * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgCndnRecordScale</b> to single
     * <b>SlsPrcgCndnRecdSuplmnt</b>.
     *
     */
    @SerializedName( "to_SlsPrcgCndnRecdSuplmnt" )
    @JsonProperty( "to_SlsPrcgCndnRecdSuplmnt" )
    @ODataField( odataName = "to_SlsPrcgCndnRecdSuplmnt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SlsPrcgCndnRecdSuplmnt toSlsPrcgCndnRecdSuplmnt;
    /**
     * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgCndnRecordScale</b> to single
     * <b>SlsPrcgConditionRecord</b>.
     *
     */
    @SerializedName( "to_SlsPrcgConditionRecord" )
    @JsonProperty( "to_SlsPrcgConditionRecord" )
    @ODataField( odataName = "to_SlsPrcgConditionRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SlsPrcgConditionRecord toSlsPrcgConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgCndnRecdSuplmnt</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleOneToOneLink<SlsPrcgCndnRecdSuplmnt> TO_SLS_PRCG_CNDN_RECD_SUPLMNT =
        new SlsPrcgCndnRecordScaleOneToOneLink<SlsPrcgCndnRecdSuplmnt>("to_SlsPrcgCndnRecdSuplmnt");
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgConditionRecord</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgCndnRecordScaleOneToOneLink<SlsPrcgConditionRecord> TO_SLS_PRCG_CONDITION_RECORD =
        new SlsPrcgCndnRecordScaleOneToOneLink<SlsPrcgConditionRecord>("to_SlsPrcgConditionRecord");

    @Nonnull
    @Override
    public Class<SlsPrcgCndnRecordScale> getType()
    {
        return SlsPrcgCndnRecordScale.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @param conditionScaleLine
     *            Current number of the line scale
     */
    public void setConditionScaleLine( @Nullable final String conditionScaleLine )
    {
        rememberChangedField("ConditionScaleLine", this.conditionScaleLine);
        this.conditionScaleLine = conditionScaleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @param conditionRateRatioUnit
     *            Unit of Measure
     */
    public void setConditionRateRatioUnit( @Nullable final String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @param conditionRateAmount
     *            Condition Amount or Percentage
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgCndnRecordScale";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        result.put("ConditionScaleLine", getConditionScaleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionScaleLine", getConditionScaleLine());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleLine") ) {
                final Object value = values.remove("ConditionScaleLine");
                if( (value == null) || (!value.equals(getConditionScaleLine())) ) {
                    setConditionScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsPrcgCndnRecdSuplmnt") ) {
                final Object value = (values).remove("to_SlsPrcgCndnRecdSuplmnt");
                if( value instanceof Map ) {
                    if( toSlsPrcgCndnRecdSuplmnt == null ) {
                        toSlsPrcgCndnRecdSuplmnt = new SlsPrcgCndnRecdSuplmnt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSlsPrcgCndnRecdSuplmnt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SlsPrcgConditionRecord") ) {
                final Object value = (values).remove("to_SlsPrcgConditionRecord");
                if( value instanceof Map ) {
                    if( toSlsPrcgConditionRecord == null ) {
                        toSlsPrcgConditionRecord = new SlsPrcgConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSlsPrcgConditionRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsPrcgCndnRecordScaleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgCndnRecordScaleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgCndnRecordScaleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgCndnRecordScaleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsPrcgCndnRecdSuplmnt != null ) {
            (values).put("to_SlsPrcgCndnRecdSuplmnt", toSlsPrcgCndnRecdSuplmnt);
        }
        if( toSlsPrcgConditionRecord != null ) {
            (values).put("to_SlsPrcgConditionRecord", toSlsPrcgConditionRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPrcgCndnRecdSuplmnt</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SlsPrcgCndnRecdSuplmnt</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgCndnRecdSuplmnt fetchSlsPrcgCndnRecdSuplmnt()
    {
        return fetchFieldAsSingle("to_SlsPrcgCndnRecdSuplmnt", SlsPrcgCndnRecdSuplmnt.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgCndnRecordScale</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgCndnRecdSuplmnt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgCndnRecdSuplmnt getSlsPrcgCndnRecdSuplmntOrFetch()
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = fetchSlsPrcgCndnRecdSuplmnt();
        }
        return toSlsPrcgCndnRecdSuplmnt;
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgCndnRecordScale</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> is already loaded, the result
     *         will contain the <b>SlsPrcgCndnRecdSuplmnt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SlsPrcgCndnRecdSuplmnt> getSlsPrcgCndnRecdSuplmntIfPresent()
    {
        return Option.of(toSlsPrcgCndnRecdSuplmnt);
    }

    /**
     * Overwrites the associated <b>SlsPrcgCndnRecdSuplmnt</b> entity for the loaded navigation property
     * <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     *
     * @param value
     *            New <b>SlsPrcgCndnRecdSuplmnt</b> entity.
     */
    public void setSlsPrcgCndnRecdSuplmnt( final SlsPrcgCndnRecdSuplmnt value )
    {
        toSlsPrcgCndnRecdSuplmnt = value;
    }

    /**
     * Fetches the <b>SlsPrcgConditionRecord</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SlsPrcgConditionRecord</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord fetchSlsPrcgConditionRecord()
    {
        return fetchFieldAsSingle("to_SlsPrcgConditionRecord", SlsPrcgConditionRecord.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecord</b> of a queried <b>SlsPrcgCndnRecordScale</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgConditionRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord getSlsPrcgConditionRecordOrFetch()
    {
        if( toSlsPrcgConditionRecord == null ) {
            toSlsPrcgConditionRecord = fetchSlsPrcgConditionRecord();
        }
        return toSlsPrcgConditionRecord;
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgCndnRecordScale</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgConditionRecord</b> is already loaded, the result
     *         will contain the <b>SlsPrcgConditionRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SlsPrcgConditionRecord> getSlsPrcgConditionRecordIfPresent()
    {
        return Option.of(toSlsPrcgConditionRecord);
    }

    /**
     * Overwrites the associated <b>SlsPrcgConditionRecord</b> entity for the loaded navigation property
     * <b>to_SlsPrcgConditionRecord</b>.
     *
     * @param value
     *            New <b>SlsPrcgConditionRecord</b> entity.
     */
    public void setSlsPrcgConditionRecord( final SlsPrcgConditionRecord value )
    {
        toSlsPrcgConditionRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgCndnRecordScale instances.
     *
     */
    public final static class SlsPrcgCndnRecordScaleBuilder
    {

        private SlsPrcgCndnRecdSuplmnt toSlsPrcgCndnRecdSuplmnt;
        private SlsPrcgConditionRecord toSlsPrcgConditionRecord;

        private SlsPrcgCndnRecordScale.SlsPrcgCndnRecordScaleBuilder toSlsPrcgCndnRecdSuplmnt(
            final SlsPrcgCndnRecdSuplmnt value )
        {
            toSlsPrcgCndnRecdSuplmnt = value;
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgCndnRecordScale</b> to single
         * <b>SlsPrcgCndnRecdSuplmnt</b>.
         *
         * @param value
         *            The SlsPrcgCndnRecdSuplmnt to build this SlsPrcgCndnRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgCndnRecordScale.SlsPrcgCndnRecordScaleBuilder slsPrcgCndnRecdSuplmnt(
            final SlsPrcgCndnRecdSuplmnt value )
        {
            return toSlsPrcgCndnRecdSuplmnt(value);
        }

        private SlsPrcgCndnRecordScale.SlsPrcgCndnRecordScaleBuilder toSlsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            toSlsPrcgConditionRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgCndnRecordScale</b> to single
         * <b>SlsPrcgConditionRecord</b>.
         *
         * @param value
         *            The SlsPrcgConditionRecord to build this SlsPrcgCndnRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgCndnRecordScale.SlsPrcgCndnRecordScaleBuilder slsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            return toSlsPrcgConditionRecord(value);
        }

    }

}
