/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgConditionRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgConditionRecordLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable.SlsPrcgConditionRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgConditionRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgConditionRecord extends VdmEntity<SlsPrcgConditionRecord>
{

    /**
     * Selector for all available fields of SlsPrcgConditionRecord.
     *
     */
    public final static SlsPrcgConditionRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_RECORD =
        new SlsPrcgConditionRecordField<String>("ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_SEQUENTIAL_NUMBER =
        new SlsPrcgConditionRecordField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     *
     * @return Condition Table
     */
    @SerializedName( "ConditionTable" )
    @JsonProperty( "ConditionTable" )
    @Nullable
    @ODataField( odataName = "ConditionTable" )
    private String conditionTable;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTable</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_TABLE =
        new SlsPrcgConditionRecordField<String>("ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_APPLICATION =
        new SlsPrcgConditionRecordField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_TYPE =
        new SlsPrcgConditionRecordField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new SlsPrcgConditionRecordField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new SlsPrcgConditionRecordField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CREATED_BY_USER =
        new SlsPrcgConditionRecordField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<LocalDateTime> CREATION_DATE =
        new SlsPrcgConditionRecordField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @return Number of texts
     */
    @SerializedName( "ConditionTextID" )
    @JsonProperty( "ConditionTextID" )
    @Nullable
    @ODataField( odataName = "ConditionTextID" )
    private String conditionTextID;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTextID</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_TEXT_ID =
        new SlsPrcgConditionRecordField<String>("ConditionTextID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> PRICING_SCALE_TYPE =
        new SlsPrcgConditionRecordField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Base Type
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> PRICING_SCALE_BASIS =
        new SlsPrcgConditionRecordField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new SlsPrcgConditionRecordField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new SlsPrcgConditionRecordField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_CALCULATION_TYPE =
        new SlsPrcgConditionRecordField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition amount or percentage where no scale exists
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_RATE_VALUE =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_RATE_VALUE_UNIT =
        new SlsPrcgConditionRecordField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_RATE_RATIO =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ConditionRateRatioUnit" )
    @JsonProperty( "ConditionRateRatioUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatioUnit" )
    private String conditionRateRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatioUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_RATE_RATIO_UNIT =
        new SlsPrcgConditionRecordField<String>("ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateAmount" )
    @JsonProperty( "ConditionRateAmount" )
    @Nullable
    @ODataField( odataName = "ConditionRateAmount" )
    private BigDecimal conditionRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_RATE_AMOUNT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionRateAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_CURRENCY =
        new SlsPrcgConditionRecordField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_QUANTITY =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_QUANTITY_UNIT =
        new SlsPrcgConditionRecordField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyNmrtr" )
    @JsonProperty( "ConditionToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyNmrtr" )
    private BigDecimal conditionToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_TO_BASE_QTY_NMRTR =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyDnmntr" )
    @JsonProperty( "ConditionToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyDnmntr" )
    private BigDecimal conditionToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_TO_BASE_QTY_DNMNTR =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> BASE_UNIT =
        new SlsPrcgConditionRecordField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @return Lower limit of the condition rate/amount
     */
    @SerializedName( "ConditionLowerLimit" )
    @JsonProperty( "ConditionLowerLimit" )
    @Nullable
    @ODataField( odataName = "ConditionLowerLimit" )
    private BigDecimal conditionLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionLowerLimit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_LOWER_LIMIT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionLowerLimit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimitAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionLowerLimitAmount" )
    @JsonProperty( "ConditionLowerLimitAmount" )
    @Nullable
    @ODataField( odataName = "ConditionLowerLimitAmount" )
    private BigDecimal conditionLowerLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionLowerLimitAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_LOWER_LIMIT_AMOUNT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionLowerLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimitRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionLowerLimitRatio" )
    @JsonProperty( "ConditionLowerLimitRatio" )
    @Nullable
    @ODataField( odataName = "ConditionLowerLimitRatio" )
    private BigDecimal conditionLowerLimitRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionLowerLimitRatio</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_LOWER_LIMIT_RATIO =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionLowerLimitRatio");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @return Upper limit for the condition rate
     */
    @SerializedName( "ConditionUpperLimit" )
    @JsonProperty( "ConditionUpperLimit" )
    @Nullable
    @ODataField( odataName = "ConditionUpperLimit" )
    private BigDecimal conditionUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUpperLimit</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_UPPER_LIMIT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionUpperLimit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimitAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionUpperLimitAmount" )
    @JsonProperty( "ConditionUpperLimitAmount" )
    @Nullable
    @ODataField( odataName = "ConditionUpperLimitAmount" )
    private BigDecimal conditionUpperLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUpperLimitAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_UPPER_LIMIT_AMOUNT =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionUpperLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimitRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionUpperLimitRatio" )
    @JsonProperty( "ConditionUpperLimitRatio" )
    @Nullable
    @ODataField( odataName = "ConditionUpperLimitRatio" )
    private BigDecimal conditionUpperLimitRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUpperLimitRatio</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> CONDITION_UPPER_LIMIT_RATIO =
        new SlsPrcgConditionRecordField<BigDecimal>("ConditionUpperLimitRatio");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @return Condition Currency (for Cumulation Fields)
     */
    @SerializedName( "ConditionAlternativeCurrency" )
    @JsonProperty( "ConditionAlternativeCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionAlternativeCurrency" )
    private String conditionAlternativeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAlternativeCurrency</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_ALTERNATIVE_CURRENCY =
        new SlsPrcgConditionRecordField<String>("ConditionAlternativeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @return Condition exclusion indicator
     */
    @SerializedName( "ConditionExclusion" )
    @JsonProperty( "ConditionExclusion" )
    @Nullable
    @ODataField( odataName = "ConditionExclusion" )
    private String conditionExclusion;
    /**
     * Use with available fluent helpers to apply the <b>ConditionExclusion</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_EXCLUSION =
        new SlsPrcgConditionRecordField<String>("ConditionExclusion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<Boolean> CONDITION_IS_DELETED =
        new SlsPrcgConditionRecordField<Boolean>("ConditionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> ADDITIONAL_VALUE_DAYS =
        new SlsPrcgConditionRecordField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<LocalDateTime> FIXED_VALUE_DATE =
        new SlsPrcgConditionRecordField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> PAYMENT_TERMS =
        new SlsPrcgConditionRecordField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @return Maximum number of sales orders per condition record
     */
    @SerializedName( "CndnMaxNumberOfSalesOrders" )
    @JsonProperty( "CndnMaxNumberOfSalesOrders" )
    @Nullable
    @ODataField( odataName = "CndnMaxNumberOfSalesOrders" )
    private String cndnMaxNumberOfSalesOrders;
    /**
     * Use with available fluent helpers to apply the <b>CndnMaxNumberOfSalesOrders</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CNDN_MAX_NUMBER_OF_SALES_ORDERS =
        new SlsPrcgConditionRecordField<String>("CndnMaxNumberOfSalesOrders");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @return Minimum condition base value
     */
    @SerializedName( "MinimumConditionBasisValue" )
    @JsonProperty( "MinimumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MinimumConditionBasisValue" )
    private BigDecimal minimumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MinimumConditionBasisValue</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> MINIMUM_CONDITION_BASIS_VALUE =
        new SlsPrcgConditionRecordField<BigDecimal>("MinimumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @return Maximum condition base value
     */
    @SerializedName( "MaximumConditionBasisValue" )
    @JsonProperty( "MaximumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MaximumConditionBasisValue" )
    private BigDecimal maximumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionBasisValue</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> MAXIMUM_CONDITION_BASIS_VALUE =
        new SlsPrcgConditionRecordField<BigDecimal>("MaximumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @return Maximum condition value
     */
    @SerializedName( "MaximumConditionAmount" )
    @JsonProperty( "MaximumConditionAmount" )
    @Nullable
    @ODataField( odataName = "MaximumConditionAmount" )
    private BigDecimal maximumConditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionAmount</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<BigDecimal> MAXIMUM_CONDITION_AMOUNT =
        new SlsPrcgConditionRecordField<BigDecimal>("MaximumConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncrementalScale</b>
     * </p>
     *
     * @return Number of incremental scale
     */
    @SerializedName( "IncrementalScale" )
    @JsonProperty( "IncrementalScale" )
    @Nullable
    @ODataField( odataName = "IncrementalScale" )
    private String incrementalScale;
    /**
     * Use with available fluent helpers to apply the <b>IncrementalScale</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> INCREMENTAL_SCALE =
        new SlsPrcgConditionRecordField<String>("IncrementalScale");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @return Scale number for pricing
     */
    @SerializedName( "PricingScaleLine" )
    @JsonProperty( "PricingScaleLine" )
    @Nullable
    @ODataField( odataName = "PricingScaleLine" )
    private String pricingScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleLine</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> PRICING_SCALE_LINE =
        new SlsPrcgConditionRecordField<String>("PricingScaleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ConditionReleaseStatus" )
    @JsonProperty( "ConditionReleaseStatus" )
    @Nullable
    @ODataField( odataName = "ConditionReleaseStatus" )
    private String conditionReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionReleaseStatus</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_RELEASE_STATUS =
        new SlsPrcgConditionRecordField<String>("ConditionReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesPriceApprovalRequest</b>
     * </p>
     *
     * @return Approval Request for Price Conditions
     */
    @SerializedName( "SalesPriceApprovalRequest" )
    @JsonProperty( "SalesPriceApprovalRequest" )
    @Nullable
    @ODataField( odataName = "SalesPriceApprovalRequest" )
    private String salesPriceApprovalRequest;
    /**
     * Use with available fluent helpers to apply the <b>SalesPriceApprovalRequest</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> SALES_PRICE_APPROVAL_REQUEST =
        new SlsPrcgConditionRecordField<String>("SalesPriceApprovalRequest");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionChangeReason</b>
     * </p>
     *
     * @return Reason for Changing Condition Record
     */
    @SerializedName( "ConditionChangeReason" )
    @JsonProperty( "ConditionChangeReason" )
    @Nullable
    @ODataField( odataName = "ConditionChangeReason" )
    private String conditionChangeReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionChangeReason</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_CHANGE_REASON =
        new SlsPrcgConditionRecordField<String>("ConditionChangeReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrevApprovedConditionRecord</b>
     * </p>
     *
     * @return Previously Approved Condition Record
     */
    @SerializedName( "PrevApprovedConditionRecord" )
    @JsonProperty( "PrevApprovedConditionRecord" )
    @Nullable
    @ODataField( odataName = "PrevApprovedConditionRecord" )
    private String prevApprovedConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>PrevApprovedConditionRecord</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> PREV_APPROVED_CONDITION_RECORD =
        new SlsPrcgConditionRecordField<String>("PrevApprovedConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "ConditionTaxCode" )
    @JsonProperty( "ConditionTaxCode" )
    @Nullable
    @ODataField( odataName = "ConditionTaxCode" )
    private String conditionTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTaxCode</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_TAX_CODE =
        new SlsPrcgConditionRecordField<String>("ConditionTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionWithholdingTaxCode</b>
     * </p>
     *
     * @return Withholding tax code
     */
    @SerializedName( "ConditionWithholdingTaxCode" )
    @JsonProperty( "ConditionWithholdingTaxCode" )
    @Nullable
    @ODataField( odataName = "ConditionWithholdingTaxCode" )
    private String conditionWithholdingTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>ConditionWithholdingTaxCode</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> CONDITION_WITHHOLDING_TAX_CODE =
        new SlsPrcgConditionRecordField<String>("ConditionWithholdingTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>TaxExemptionLicense</b>
     * </p>
     *
     * @return Tax Exemption License Number
     */
    @SerializedName( "TaxExemptionLicense" )
    @JsonProperty( "TaxExemptionLicense" )
    @Nullable
    @ODataField( odataName = "TaxExemptionLicense" )
    private String taxExemptionLicense;
    /**
     * Use with available fluent helpers to apply the <b>TaxExemptionLicense</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> TAX_EXEMPTION_LICENSE =
        new SlsPrcgConditionRecordField<String>("TaxExemptionLicense");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LicenseGrantDate</b>
     * </p>
     *
     * @return Date License Granted
     */
    @SerializedName( "LicenseGrantDate" )
    @JsonProperty( "LicenseGrantDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LicenseGrantDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime licenseGrantDate;
    /**
     * Use with available fluent helpers to apply the <b>LicenseGrantDate</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<LocalDateTime> LICENSE_GRANT_DATE =
        new SlsPrcgConditionRecordField<LocalDateTime>("LicenseGrantDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordField<String> E_TAG = new SlsPrcgConditionRecordField<String>("ETag");
    /**
     * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgConditionRecord</b> to multiple
     * <b>SlsPrcgCndnRecdSuplmnt</b>.
     *
     */
    @SerializedName( "to_SlsPrcgCndnRecdSuplmnt" )
    @JsonProperty( "to_SlsPrcgCndnRecdSuplmnt" )
    @ODataField( odataName = "to_SlsPrcgCndnRecdSuplmnt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgCndnRecdSuplmnt> toSlsPrcgCndnRecdSuplmnt;
    /**
     * Navigation property <b>to_SlsPrcgCndnRecdValidity</b> for <b>SlsPrcgConditionRecord</b> to multiple
     * <b>SlsPrcgCndnRecdValidity</b>.
     *
     */
    @SerializedName( "to_SlsPrcgCndnRecdValidity" )
    @JsonProperty( "to_SlsPrcgCndnRecdValidity" )
    @ODataField( odataName = "to_SlsPrcgCndnRecdValidity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgCndnRecdValidity> toSlsPrcgCndnRecdValidity;
    /**
     * Navigation property <b>to_SlsPrcgCndnRecordScale</b> for <b>SlsPrcgConditionRecord</b> to multiple
     * <b>SlsPrcgCndnRecordScale</b>.
     *
     */
    @SerializedName( "to_SlsPrcgCndnRecordScale" )
    @JsonProperty( "to_SlsPrcgCndnRecordScale" )
    @ODataField( odataName = "to_SlsPrcgCndnRecordScale" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgCndnRecordScale> toSlsPrcgCndnRecordScale;
    /**
     * Navigation property <b>to_SlsPrcgConditionRecordText</b> for <b>SlsPrcgConditionRecord</b> to multiple
     * <b>SlsPrcgConditionRecordText</b>.
     *
     */
    @SerializedName( "to_SlsPrcgConditionRecordText" )
    @JsonProperty( "to_SlsPrcgConditionRecordText" )
    @ODataField( odataName = "to_SlsPrcgConditionRecordText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgConditionRecordText> toSlsPrcgConditionRecordText;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgCndnRecdSuplmnt</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgConditionRecordLink<SlsPrcgCndnRecdSuplmnt> TO_SLS_PRCG_CNDN_RECD_SUPLMNT =
        new SlsPrcgConditionRecordLink<SlsPrcgCndnRecdSuplmnt>("to_SlsPrcgCndnRecdSuplmnt");
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgCndnRecdValidity</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgConditionRecordLink<SlsPrcgCndnRecdValidity> TO_SLS_PRCG_CNDN_RECD_VALIDITY =
        new SlsPrcgConditionRecordLink<SlsPrcgCndnRecdValidity>("to_SlsPrcgCndnRecdValidity");
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgCndnRecordScale</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgConditionRecordLink<SlsPrcgCndnRecordScale> TO_SLS_PRCG_CNDN_RECORD_SCALE =
        new SlsPrcgConditionRecordLink<SlsPrcgCndnRecordScale>("to_SlsPrcgCndnRecordScale");
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgConditionRecordText</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgConditionRecordLink<SlsPrcgConditionRecordText> TO_SLS_PRCG_CONDITION_RECORD_TEXT =
        new SlsPrcgConditionRecordLink<SlsPrcgConditionRecordText>("to_SlsPrcgConditionRecordText");

    @Nonnull
    @Override
    public Class<SlsPrcgConditionRecord> getType()
    {
        return SlsPrcgConditionRecord.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     *
     * @param conditionTable
     *            Condition Table
     */
    public void setConditionTable( @Nullable final String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Valid To Date
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Valid-From Date
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @param conditionTextID
     *            Number of texts
     */
    public void setConditionTextID( @Nullable final String conditionTextID )
    {
        rememberChangedField("ConditionTextID", this.conditionTextID);
        this.conditionTextID = conditionTextID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Base Type
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition amount or percentage where no scale exists
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @param conditionRateRatioUnit
     *            Unit of Measure
     */
    public void setConditionRateRatioUnit( @Nullable final String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @param conditionRateAmount
     *            Condition Amount or Percentage
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @param conditionToBaseQtyNmrtr
     *            Numerator for converting condition units to base units
     */
    public void setConditionToBaseQtyNmrtr( @Nullable final BigDecimal conditionToBaseQtyNmrtr )
    {
        rememberChangedField("ConditionToBaseQtyNmrtr", this.conditionToBaseQtyNmrtr);
        this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @param conditionToBaseQtyDnmntr
     *            Denominator for converting condition units to base units
     */
    public void setConditionToBaseQtyDnmntr( @Nullable final BigDecimal conditionToBaseQtyDnmntr )
    {
        rememberChangedField("ConditionToBaseQtyDnmntr", this.conditionToBaseQtyDnmntr);
        this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @param conditionLowerLimit
     *            Lower limit of the condition rate/amount
     */
    public void setConditionLowerLimit( @Nullable final BigDecimal conditionLowerLimit )
    {
        rememberChangedField("ConditionLowerLimit", this.conditionLowerLimit);
        this.conditionLowerLimit = conditionLowerLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimitAmount</b>
     * </p>
     *
     * @param conditionLowerLimitAmount
     *            Condition Amount or Percentage
     */
    public void setConditionLowerLimitAmount( @Nullable final BigDecimal conditionLowerLimitAmount )
    {
        rememberChangedField("ConditionLowerLimitAmount", this.conditionLowerLimitAmount);
        this.conditionLowerLimitAmount = conditionLowerLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimitRatio</b>
     * </p>
     *
     * @param conditionLowerLimitRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionLowerLimitRatio( @Nullable final BigDecimal conditionLowerLimitRatio )
    {
        rememberChangedField("ConditionLowerLimitRatio", this.conditionLowerLimitRatio);
        this.conditionLowerLimitRatio = conditionLowerLimitRatio;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @param conditionUpperLimit
     *            Upper limit for the condition rate
     */
    public void setConditionUpperLimit( @Nullable final BigDecimal conditionUpperLimit )
    {
        rememberChangedField("ConditionUpperLimit", this.conditionUpperLimit);
        this.conditionUpperLimit = conditionUpperLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimitAmount</b>
     * </p>
     *
     * @param conditionUpperLimitAmount
     *            Condition Amount or Percentage
     */
    public void setConditionUpperLimitAmount( @Nullable final BigDecimal conditionUpperLimitAmount )
    {
        rememberChangedField("ConditionUpperLimitAmount", this.conditionUpperLimitAmount);
        this.conditionUpperLimitAmount = conditionUpperLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimitRatio</b>
     * </p>
     *
     * @param conditionUpperLimitRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionUpperLimitRatio( @Nullable final BigDecimal conditionUpperLimitRatio )
    {
        rememberChangedField("ConditionUpperLimitRatio", this.conditionUpperLimitRatio);
        this.conditionUpperLimitRatio = conditionUpperLimitRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @param conditionAlternativeCurrency
     *            Condition Currency (for Cumulation Fields)
     */
    public void setConditionAlternativeCurrency( @Nullable final String conditionAlternativeCurrency )
    {
        rememberChangedField("ConditionAlternativeCurrency", this.conditionAlternativeCurrency);
        this.conditionAlternativeCurrency = conditionAlternativeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @param conditionExclusion
     *            Condition exclusion indicator
     */
    public void setConditionExclusion( @Nullable final String conditionExclusion )
    {
        rememberChangedField("ConditionExclusion", this.conditionExclusion);
        this.conditionExclusion = conditionExclusion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @param cndnMaxNumberOfSalesOrders
     *            Maximum number of sales orders per condition record
     */
    public void setCndnMaxNumberOfSalesOrders( @Nullable final String cndnMaxNumberOfSalesOrders )
    {
        rememberChangedField("CndnMaxNumberOfSalesOrders", this.cndnMaxNumberOfSalesOrders);
        this.cndnMaxNumberOfSalesOrders = cndnMaxNumberOfSalesOrders;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @param minimumConditionBasisValue
     *            Minimum condition base value
     */
    public void setMinimumConditionBasisValue( @Nullable final BigDecimal minimumConditionBasisValue )
    {
        rememberChangedField("MinimumConditionBasisValue", this.minimumConditionBasisValue);
        this.minimumConditionBasisValue = minimumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @param maximumConditionBasisValue
     *            Maximum condition base value
     */
    public void setMaximumConditionBasisValue( @Nullable final BigDecimal maximumConditionBasisValue )
    {
        rememberChangedField("MaximumConditionBasisValue", this.maximumConditionBasisValue);
        this.maximumConditionBasisValue = maximumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @param maximumConditionAmount
     *            Maximum condition value
     */
    public void setMaximumConditionAmount( @Nullable final BigDecimal maximumConditionAmount )
    {
        rememberChangedField("MaximumConditionAmount", this.maximumConditionAmount);
        this.maximumConditionAmount = maximumConditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncrementalScale</b>
     * </p>
     *
     * @param incrementalScale
     *            Number of incremental scale
     */
    public void setIncrementalScale( @Nullable final String incrementalScale )
    {
        rememberChangedField("IncrementalScale", this.incrementalScale);
        this.incrementalScale = incrementalScale;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @param pricingScaleLine
     *            Scale number for pricing
     */
    public void setPricingScaleLine( @Nullable final String pricingScaleLine )
    {
        rememberChangedField("PricingScaleLine", this.pricingScaleLine);
        this.pricingScaleLine = pricingScaleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @param conditionReleaseStatus
     *            Release Status
     */
    public void setConditionReleaseStatus( @Nullable final String conditionReleaseStatus )
    {
        rememberChangedField("ConditionReleaseStatus", this.conditionReleaseStatus);
        this.conditionReleaseStatus = conditionReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesPriceApprovalRequest</b>
     * </p>
     *
     * @param salesPriceApprovalRequest
     *            Approval Request for Price Conditions
     */
    public void setSalesPriceApprovalRequest( @Nullable final String salesPriceApprovalRequest )
    {
        rememberChangedField("SalesPriceApprovalRequest", this.salesPriceApprovalRequest);
        this.salesPriceApprovalRequest = salesPriceApprovalRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionChangeReason</b>
     * </p>
     *
     * @param conditionChangeReason
     *            Reason for Changing Condition Record
     */
    public void setConditionChangeReason( @Nullable final String conditionChangeReason )
    {
        rememberChangedField("ConditionChangeReason", this.conditionChangeReason);
        this.conditionChangeReason = conditionChangeReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrevApprovedConditionRecord</b>
     * </p>
     *
     * @param prevApprovedConditionRecord
     *            Previously Approved Condition Record
     */
    public void setPrevApprovedConditionRecord( @Nullable final String prevApprovedConditionRecord )
    {
        rememberChangedField("PrevApprovedConditionRecord", this.prevApprovedConditionRecord);
        this.prevApprovedConditionRecord = prevApprovedConditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTaxCode</b>
     * </p>
     *
     * @param conditionTaxCode
     *            Tax on Sales/Purchases Code
     */
    public void setConditionTaxCode( @Nullable final String conditionTaxCode )
    {
        rememberChangedField("ConditionTaxCode", this.conditionTaxCode);
        this.conditionTaxCode = conditionTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionWithholdingTaxCode</b>
     * </p>
     *
     * @param conditionWithholdingTaxCode
     *            Withholding tax code
     */
    public void setConditionWithholdingTaxCode( @Nullable final String conditionWithholdingTaxCode )
    {
        rememberChangedField("ConditionWithholdingTaxCode", this.conditionWithholdingTaxCode);
        this.conditionWithholdingTaxCode = conditionWithholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>TaxExemptionLicense</b>
     * </p>
     *
     * @param taxExemptionLicense
     *            Tax Exemption License Number
     */
    public void setTaxExemptionLicense( @Nullable final String taxExemptionLicense )
    {
        rememberChangedField("TaxExemptionLicense", this.taxExemptionLicense);
        this.taxExemptionLicense = taxExemptionLicense;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LicenseGrantDate</b>
     * </p>
     *
     * @param licenseGrantDate
     *            Date License Granted
     */
    public void setLicenseGrantDate( @Nullable final LocalDateTime licenseGrantDate )
    {
        rememberChangedField("LicenseGrantDate", this.licenseGrantDate);
        this.licenseGrantDate = licenseGrantDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgConditionRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("ConditionTextID", getConditionTextID());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionToBaseQtyNmrtr", getConditionToBaseQtyNmrtr());
        values.put("ConditionToBaseQtyDnmntr", getConditionToBaseQtyDnmntr());
        values.put("BaseUnit", getBaseUnit());
        values.put("ConditionLowerLimit", getConditionLowerLimit());
        values.put("ConditionLowerLimitAmount", getConditionLowerLimitAmount());
        values.put("ConditionLowerLimitRatio", getConditionLowerLimitRatio());
        values.put("ConditionUpperLimit", getConditionUpperLimit());
        values.put("ConditionUpperLimitAmount", getConditionUpperLimitAmount());
        values.put("ConditionUpperLimitRatio", getConditionUpperLimitRatio());
        values.put("ConditionAlternativeCurrency", getConditionAlternativeCurrency());
        values.put("ConditionExclusion", getConditionExclusion());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CndnMaxNumberOfSalesOrders", getCndnMaxNumberOfSalesOrders());
        values.put("MinimumConditionBasisValue", getMinimumConditionBasisValue());
        values.put("MaximumConditionBasisValue", getMaximumConditionBasisValue());
        values.put("MaximumConditionAmount", getMaximumConditionAmount());
        values.put("IncrementalScale", getIncrementalScale());
        values.put("PricingScaleLine", getPricingScaleLine());
        values.put("ConditionReleaseStatus", getConditionReleaseStatus());
        values.put("SalesPriceApprovalRequest", getSalesPriceApprovalRequest());
        values.put("ConditionChangeReason", getConditionChangeReason());
        values.put("PrevApprovedConditionRecord", getPrevApprovedConditionRecord());
        values.put("ConditionTaxCode", getConditionTaxCode());
        values.put("ConditionWithholdingTaxCode", getConditionWithholdingTaxCode());
        values.put("TaxExemptionLicense", getTaxExemptionLicense());
        values.put("LicenseGrantDate", getLicenseGrantDate());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionTextID") ) {
                final Object value = values.remove("ConditionTextID");
                if( (value == null) || (!value.equals(getConditionTextID())) ) {
                    setConditionTextID(((String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyNmrtr") ) {
                final Object value = values.remove("ConditionToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyNmrtr())) ) {
                    setConditionToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyDnmntr") ) {
                final Object value = values.remove("ConditionToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyDnmntr())) ) {
                    setConditionToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionLowerLimit") ) {
                final Object value = values.remove("ConditionLowerLimit");
                if( (value == null) || (!value.equals(getConditionLowerLimit())) ) {
                    setConditionLowerLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionLowerLimitAmount") ) {
                final Object value = values.remove("ConditionLowerLimitAmount");
                if( (value == null) || (!value.equals(getConditionLowerLimitAmount())) ) {
                    setConditionLowerLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionLowerLimitRatio") ) {
                final Object value = values.remove("ConditionLowerLimitRatio");
                if( (value == null) || (!value.equals(getConditionLowerLimitRatio())) ) {
                    setConditionLowerLimitRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionUpperLimit") ) {
                final Object value = values.remove("ConditionUpperLimit");
                if( (value == null) || (!value.equals(getConditionUpperLimit())) ) {
                    setConditionUpperLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionUpperLimitAmount") ) {
                final Object value = values.remove("ConditionUpperLimitAmount");
                if( (value == null) || (!value.equals(getConditionUpperLimitAmount())) ) {
                    setConditionUpperLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionUpperLimitRatio") ) {
                final Object value = values.remove("ConditionUpperLimitRatio");
                if( (value == null) || (!value.equals(getConditionUpperLimitRatio())) ) {
                    setConditionUpperLimitRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAlternativeCurrency") ) {
                final Object value = values.remove("ConditionAlternativeCurrency");
                if( (value == null) || (!value.equals(getConditionAlternativeCurrency())) ) {
                    setConditionAlternativeCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionExclusion") ) {
                final Object value = values.remove("ConditionExclusion");
                if( (value == null) || (!value.equals(getConditionExclusion())) ) {
                    setConditionExclusion(((String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CndnMaxNumberOfSalesOrders") ) {
                final Object value = values.remove("CndnMaxNumberOfSalesOrders");
                if( (value == null) || (!value.equals(getCndnMaxNumberOfSalesOrders())) ) {
                    setCndnMaxNumberOfSalesOrders(((String) value));
                }
            }
            if( values.containsKey("MinimumConditionBasisValue") ) {
                final Object value = values.remove("MinimumConditionBasisValue");
                if( (value == null) || (!value.equals(getMinimumConditionBasisValue())) ) {
                    setMinimumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionBasisValue") ) {
                final Object value = values.remove("MaximumConditionBasisValue");
                if( (value == null) || (!value.equals(getMaximumConditionBasisValue())) ) {
                    setMaximumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionAmount") ) {
                final Object value = values.remove("MaximumConditionAmount");
                if( (value == null) || (!value.equals(getMaximumConditionAmount())) ) {
                    setMaximumConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("IncrementalScale") ) {
                final Object value = values.remove("IncrementalScale");
                if( (value == null) || (!value.equals(getIncrementalScale())) ) {
                    setIncrementalScale(((String) value));
                }
            }
            if( values.containsKey("PricingScaleLine") ) {
                final Object value = values.remove("PricingScaleLine");
                if( (value == null) || (!value.equals(getPricingScaleLine())) ) {
                    setPricingScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionReleaseStatus") ) {
                final Object value = values.remove("ConditionReleaseStatus");
                if( (value == null) || (!value.equals(getConditionReleaseStatus())) ) {
                    setConditionReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("SalesPriceApprovalRequest") ) {
                final Object value = values.remove("SalesPriceApprovalRequest");
                if( (value == null) || (!value.equals(getSalesPriceApprovalRequest())) ) {
                    setSalesPriceApprovalRequest(((String) value));
                }
            }
            if( values.containsKey("ConditionChangeReason") ) {
                final Object value = values.remove("ConditionChangeReason");
                if( (value == null) || (!value.equals(getConditionChangeReason())) ) {
                    setConditionChangeReason(((String) value));
                }
            }
            if( values.containsKey("PrevApprovedConditionRecord") ) {
                final Object value = values.remove("PrevApprovedConditionRecord");
                if( (value == null) || (!value.equals(getPrevApprovedConditionRecord())) ) {
                    setPrevApprovedConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionTaxCode") ) {
                final Object value = values.remove("ConditionTaxCode");
                if( (value == null) || (!value.equals(getConditionTaxCode())) ) {
                    setConditionTaxCode(((String) value));
                }
            }
            if( values.containsKey("ConditionWithholdingTaxCode") ) {
                final Object value = values.remove("ConditionWithholdingTaxCode");
                if( (value == null) || (!value.equals(getConditionWithholdingTaxCode())) ) {
                    setConditionWithholdingTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxExemptionLicense") ) {
                final Object value = values.remove("TaxExemptionLicense");
                if( (value == null) || (!value.equals(getTaxExemptionLicense())) ) {
                    setTaxExemptionLicense(((String) value));
                }
            }
            if( values.containsKey("LicenseGrantDate") ) {
                final Object value = values.remove("LicenseGrantDate");
                if( (value == null) || (!value.equals(getLicenseGrantDate())) ) {
                    setLicenseGrantDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsPrcgCndnRecdSuplmnt") ) {
                final Object value = (values).remove("to_SlsPrcgCndnRecdSuplmnt");
                if( value instanceof Iterable ) {
                    if( toSlsPrcgCndnRecdSuplmnt == null ) {
                        toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
                    } else {
                        toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList(toSlsPrcgCndnRecdSuplmnt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgCndnRecdSuplmnt entity;
                        if( toSlsPrcgCndnRecdSuplmnt.size() > i ) {
                            entity = toSlsPrcgCndnRecdSuplmnt.get(i);
                        } else {
                            entity = new SlsPrcgCndnRecdSuplmnt();
                            toSlsPrcgCndnRecdSuplmnt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SlsPrcgCndnRecdValidity") ) {
                final Object value = (values).remove("to_SlsPrcgCndnRecdValidity");
                if( value instanceof Iterable ) {
                    if( toSlsPrcgCndnRecdValidity == null ) {
                        toSlsPrcgCndnRecdValidity = Lists.newArrayList();
                    } else {
                        toSlsPrcgCndnRecdValidity = Lists.newArrayList(toSlsPrcgCndnRecdValidity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgCndnRecdValidity entity;
                        if( toSlsPrcgCndnRecdValidity.size() > i ) {
                            entity = toSlsPrcgCndnRecdValidity.get(i);
                        } else {
                            entity = new SlsPrcgCndnRecdValidity();
                            toSlsPrcgCndnRecdValidity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SlsPrcgCndnRecordScale") ) {
                final Object value = (values).remove("to_SlsPrcgCndnRecordScale");
                if( value instanceof Iterable ) {
                    if( toSlsPrcgCndnRecordScale == null ) {
                        toSlsPrcgCndnRecordScale = Lists.newArrayList();
                    } else {
                        toSlsPrcgCndnRecordScale = Lists.newArrayList(toSlsPrcgCndnRecordScale);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgCndnRecordScale entity;
                        if( toSlsPrcgCndnRecordScale.size() > i ) {
                            entity = toSlsPrcgCndnRecordScale.get(i);
                        } else {
                            entity = new SlsPrcgCndnRecordScale();
                            toSlsPrcgCndnRecordScale.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SlsPrcgConditionRecordText") ) {
                final Object value = (values).remove("to_SlsPrcgConditionRecordText");
                if( value instanceof Iterable ) {
                    if( toSlsPrcgConditionRecordText == null ) {
                        toSlsPrcgConditionRecordText = Lists.newArrayList();
                    } else {
                        toSlsPrcgConditionRecordText = Lists.newArrayList(toSlsPrcgConditionRecordText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgConditionRecordText entity;
                        if( toSlsPrcgConditionRecordText.size() > i ) {
                            entity = toSlsPrcgConditionRecordText.get(i);
                        } else {
                            entity = new SlsPrcgConditionRecordText();
                            toSlsPrcgConditionRecordText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsPrcgConditionRecordField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgConditionRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgConditionRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgConditionRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsPrcgCndnRecdSuplmnt != null ) {
            (values).put("to_SlsPrcgCndnRecdSuplmnt", toSlsPrcgCndnRecdSuplmnt);
        }
        if( toSlsPrcgCndnRecdValidity != null ) {
            (values).put("to_SlsPrcgCndnRecdValidity", toSlsPrcgCndnRecdValidity);
        }
        if( toSlsPrcgCndnRecordScale != null ) {
            (values).put("to_SlsPrcgCndnRecordScale", toSlsPrcgCndnRecordScale);
        }
        if( toSlsPrcgConditionRecordText != null ) {
            (values).put("to_SlsPrcgConditionRecordText", toSlsPrcgConditionRecordText);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPrcgCndnRecdSuplmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdSuplmnt> fetchSlsPrcgCndnRecdSuplmnt()
    {
        return fetchFieldAsList("to_SlsPrcgCndnRecdSuplmnt", SlsPrcgCndnRecdSuplmnt.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdSuplmnt> getSlsPrcgCndnRecdSuplmntOrFetch()
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = fetchSlsPrcgCndnRecdSuplmnt();
        }
        return toSlsPrcgCndnRecdSuplmnt;
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> is already loaded, the result
     *         will contain the <b>SlsPrcgCndnRecdSuplmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgCndnRecdSuplmnt>> getSlsPrcgCndnRecdSuplmntIfPresent()
    {
        return Option.of(toSlsPrcgCndnRecdSuplmnt);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities for the loaded navigation property
     * <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     */
    public void setSlsPrcgCndnRecdSuplmnt( @Nonnull final List<SlsPrcgCndnRecdSuplmnt> value )
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdSuplmnt.clear();
        toSlsPrcgCndnRecdSuplmnt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgCndnRecdSuplmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPrcgCndnRecdSuplmnt</b> entities.
     */
    public void addSlsPrcgCndnRecdSuplmnt( SlsPrcgCndnRecdSuplmnt... entity )
    {
        if( toSlsPrcgCndnRecdSuplmnt == null ) {
            toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdSuplmnt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsPrcgCndnRecdValidity</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SlsPrcgCndnRecdValidity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPrcgCndnRecdValidity</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdValidity> fetchSlsPrcgCndnRecdValidity()
    {
        return fetchFieldAsList("to_SlsPrcgCndnRecdValidity", SlsPrcgCndnRecdValidity.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdValidity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdValidity</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdValidity</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgCndnRecdValidity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecdValidity> getSlsPrcgCndnRecdValidityOrFetch()
    {
        if( toSlsPrcgCndnRecdValidity == null ) {
            toSlsPrcgCndnRecdValidity = fetchSlsPrcgCndnRecdValidity();
        }
        return toSlsPrcgCndnRecdValidity;
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecdValidity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdValidity</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgCndnRecdValidity</b> is already loaded, the
     *         result will contain the <b>SlsPrcgCndnRecdValidity</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgCndnRecdValidity>> getSlsPrcgCndnRecdValidityIfPresent()
    {
        return Option.of(toSlsPrcgCndnRecdValidity);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgCndnRecdValidity</b> entities for the loaded navigation property
     * <b>to_SlsPrcgCndnRecdValidity</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdValidity</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPrcgCndnRecdValidity</b> entities.
     */
    public void setSlsPrcgCndnRecdValidity( @Nonnull final List<SlsPrcgCndnRecdValidity> value )
    {
        if( toSlsPrcgCndnRecdValidity == null ) {
            toSlsPrcgCndnRecdValidity = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdValidity.clear();
        toSlsPrcgCndnRecdValidity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgCndnRecdValidity</b> entities. This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecdValidity</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecdValidity</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPrcgCndnRecdValidity</b> entities.
     */
    public void addSlsPrcgCndnRecdValidity( SlsPrcgCndnRecdValidity... entity )
    {
        if( toSlsPrcgCndnRecdValidity == null ) {
            toSlsPrcgCndnRecdValidity = Lists.newArrayList();
        }
        toSlsPrcgCndnRecdValidity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsPrcgCndnRecordScale</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgCndnRecordScale</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPrcgCndnRecordScale</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecordScale> fetchSlsPrcgCndnRecordScale()
    {
        return fetchFieldAsList("to_SlsPrcgCndnRecordScale", SlsPrcgCndnRecordScale.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecordScale</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecordScale</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecordScale</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgCndnRecordScale</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgCndnRecordScale> getSlsPrcgCndnRecordScaleOrFetch()
    {
        if( toSlsPrcgCndnRecordScale == null ) {
            toSlsPrcgCndnRecordScale = fetchSlsPrcgCndnRecordScale();
        }
        return toSlsPrcgCndnRecordScale;
    }

    /**
     * Retrieval of associated <b>SlsPrcgCndnRecordScale</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecordScale</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgCndnRecordScale</b> is already loaded, the result
     *         will contain the <b>SlsPrcgCndnRecordScale</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgCndnRecordScale>> getSlsPrcgCndnRecordScaleIfPresent()
    {
        return Option.of(toSlsPrcgCndnRecordScale);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgCndnRecordScale</b> entities for the loaded navigation property
     * <b>to_SlsPrcgCndnRecordScale</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecordScale</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPrcgCndnRecordScale</b> entities.
     */
    public void setSlsPrcgCndnRecordScale( @Nonnull final List<SlsPrcgCndnRecordScale> value )
    {
        if( toSlsPrcgCndnRecordScale == null ) {
            toSlsPrcgCndnRecordScale = Lists.newArrayList();
        }
        toSlsPrcgCndnRecordScale.clear();
        toSlsPrcgCndnRecordScale.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgCndnRecordScale</b> entities. This corresponds to the OData
     * navigation property <b>to_SlsPrcgCndnRecordScale</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgCndnRecordScale</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPrcgCndnRecordScale</b> entities.
     */
    public void addSlsPrcgCndnRecordScale( SlsPrcgCndnRecordScale... entity )
    {
        if( toSlsPrcgCndnRecordScale == null ) {
            toSlsPrcgCndnRecordScale = Lists.newArrayList();
        }
        toSlsPrcgCndnRecordScale.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsPrcgConditionRecordText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SlsPrcgConditionRecordText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPrcgConditionRecordText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgConditionRecordText> fetchSlsPrcgConditionRecordText()
    {
        return fetchFieldAsList("to_SlsPrcgConditionRecordText", SlsPrcgConditionRecordText.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecordText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecordText</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecordText</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgConditionRecordText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPrcgConditionRecordText> getSlsPrcgConditionRecordTextOrFetch()
    {
        if( toSlsPrcgConditionRecordText == null ) {
            toSlsPrcgConditionRecordText = fetchSlsPrcgConditionRecordText();
        }
        return toSlsPrcgConditionRecordText;
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecordText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecordText</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgConditionRecordText</b> is already loaded, the
     *         result will contain the <b>SlsPrcgConditionRecordText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgConditionRecordText>> getSlsPrcgConditionRecordTextIfPresent()
    {
        return Option.of(toSlsPrcgConditionRecordText);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgConditionRecordText</b> entities for the loaded navigation property
     * <b>to_SlsPrcgConditionRecordText</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecordText</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPrcgConditionRecordText</b> entities.
     */
    public void setSlsPrcgConditionRecordText( @Nonnull final List<SlsPrcgConditionRecordText> value )
    {
        if( toSlsPrcgConditionRecordText == null ) {
            toSlsPrcgConditionRecordText = Lists.newArrayList();
        }
        toSlsPrcgConditionRecordText.clear();
        toSlsPrcgConditionRecordText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgConditionRecordText</b> entities. This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecordText</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecordText</b> of a queried <b>SlsPrcgConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPrcgConditionRecordText</b> entities.
     */
    public void addSlsPrcgConditionRecordText( SlsPrcgConditionRecordText... entity )
    {
        if( toSlsPrcgConditionRecordText == null ) {
            toSlsPrcgConditionRecordText = Lists.newArrayList();
        }
        toSlsPrcgConditionRecordText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgConditionRecord instances.
     *
     */
    public final static class SlsPrcgConditionRecordBuilder
    {

        private List<SlsPrcgCndnRecdSuplmnt> toSlsPrcgCndnRecdSuplmnt = Lists.newArrayList();
        private List<SlsPrcgCndnRecdValidity> toSlsPrcgCndnRecdValidity = Lists.newArrayList();
        private List<SlsPrcgCndnRecordScale> toSlsPrcgCndnRecordScale = Lists.newArrayList();
        private List<SlsPrcgConditionRecordText> toSlsPrcgConditionRecordText = Lists.newArrayList();

        private SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder toSlsPrcgCndnRecdSuplmnt(
            final List<SlsPrcgCndnRecdSuplmnt> value )
        {
            toSlsPrcgCndnRecdSuplmnt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgCndnRecdSuplmnt</b> for <b>SlsPrcgConditionRecord</b> to multiple
         * <b>SlsPrcgCndnRecdSuplmnt</b>.
         *
         * @param value
         *            The SlsPrcgCndnRecdSuplmnts to build this SlsPrcgConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder slsPrcgCndnRecdSuplmnt(
            SlsPrcgCndnRecdSuplmnt... value )
        {
            return toSlsPrcgCndnRecdSuplmnt(Lists.newArrayList(value));
        }

        private SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder toSlsPrcgCndnRecdValidity(
            final List<SlsPrcgCndnRecdValidity> value )
        {
            toSlsPrcgCndnRecdValidity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgCndnRecdValidity</b> for <b>SlsPrcgConditionRecord</b> to multiple
         * <b>SlsPrcgCndnRecdValidity</b>.
         *
         * @param value
         *            The SlsPrcgCndnRecdValiditys to build this SlsPrcgConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder slsPrcgCndnRecdValidity(
            SlsPrcgCndnRecdValidity... value )
        {
            return toSlsPrcgCndnRecdValidity(Lists.newArrayList(value));
        }

        private SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder toSlsPrcgCndnRecordScale(
            final List<SlsPrcgCndnRecordScale> value )
        {
            toSlsPrcgCndnRecordScale.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgCndnRecordScale</b> for <b>SlsPrcgConditionRecord</b> to multiple
         * <b>SlsPrcgCndnRecordScale</b>.
         *
         * @param value
         *            The SlsPrcgCndnRecordScales to build this SlsPrcgConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder slsPrcgCndnRecordScale(
            SlsPrcgCndnRecordScale... value )
        {
            return toSlsPrcgCndnRecordScale(Lists.newArrayList(value));
        }

        private SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder toSlsPrcgConditionRecordText(
            final List<SlsPrcgConditionRecordText> value )
        {
            toSlsPrcgConditionRecordText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgConditionRecordText</b> for <b>SlsPrcgConditionRecord</b> to multiple
         * <b>SlsPrcgConditionRecordText</b>.
         *
         * @param value
         *            The SlsPrcgConditionRecordTexts to build this SlsPrcgConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionRecord.SlsPrcgConditionRecordBuilder slsPrcgConditionRecordText(
            SlsPrcgConditionRecordText... value )
        {
            return toSlsPrcgConditionRecordText(Lists.newArrayList(value));
        }

    }

}
