/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgConditionRecordTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgConditionRecordTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable.SlsPrcgConditionRecordTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Record Descriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgConditionRecordTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgConditionRecordText extends VdmEntity<SlsPrcgConditionRecordText>
{

    /**
     * Selector for all available fields of SlsPrcgConditionRecordText.
     *
     */
    public final static SlsPrcgConditionRecordTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordTextField<String> CONDITION_RECORD =
        new SlsPrcgConditionRecordTextField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordTextField<String> CONDITION_SEQUENTIAL_NUMBER =
        new SlsPrcgConditionRecordTextField<String>("ConditionSequentialNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordTextField<String> LANGUAGE =
        new SlsPrcgConditionRecordTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConditionText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ConditionText" )
    @JsonProperty( "ConditionText" )
    @Nullable
    @ODataField( odataName = "ConditionText" )
    private String conditionText;
    /**
     * Use with available fluent helpers to apply the <b>ConditionText</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordTextField<String> CONDITION_TEXT =
        new SlsPrcgConditionRecordTextField<String>("ConditionText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionRecordTextField<String> E_TAG =
        new SlsPrcgConditionRecordTextField<String>("ETag");
    /**
     * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgConditionRecordText</b> to single
     * <b>SlsPrcgConditionRecord</b>.
     *
     */
    @SerializedName( "to_SlsPrcgConditionRecord" )
    @JsonProperty( "to_SlsPrcgConditionRecord" )
    @ODataField( odataName = "to_SlsPrcgConditionRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SlsPrcgConditionRecord toSlsPrcgConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPrcgConditionRecord</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgConditionRecordTextOneToOneLink<SlsPrcgConditionRecord> TO_SLS_PRCG_CONDITION_RECORD =
        new SlsPrcgConditionRecordTextOneToOneLink<SlsPrcgConditionRecord>("to_SlsPrcgConditionRecord");

    @Nonnull
    @Override
    public Class<SlsPrcgConditionRecordText> getType()
    {
        return SlsPrcgConditionRecordText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConditionText</b>
     * </p>
     *
     * @param conditionText
     *            Description
     */
    public void setConditionText( @Nullable final String conditionText )
    {
        rememberChangedField("ConditionText", this.conditionText);
        this.conditionText = conditionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgConditionRecordText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("Language", getLanguage());
        values.put("ConditionText", getConditionText());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConditionText") ) {
                final Object value = values.remove("ConditionText");
                if( (value == null) || (!value.equals(getConditionText())) ) {
                    setConditionText(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsPrcgConditionRecord") ) {
                final Object value = (values).remove("to_SlsPrcgConditionRecord");
                if( value instanceof Map ) {
                    if( toSlsPrcgConditionRecord == null ) {
                        toSlsPrcgConditionRecord = new SlsPrcgConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSlsPrcgConditionRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SlsPrcgConditionRecordTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgConditionRecordTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgConditionRecordTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgConditionRecordTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsPrcgConditionRecord != null ) {
            (values).put("to_SlsPrcgConditionRecord", toSlsPrcgConditionRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPrcgConditionRecord</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SlsPrcgConditionRecord</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord fetchSlsPrcgConditionRecord()
    {
        return fetchFieldAsSingle("to_SlsPrcgConditionRecord", SlsPrcgConditionRecord.class);
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property <b>to_SlsPrcgConditionRecord</b> of a queried <b>SlsPrcgConditionRecordText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPrcgConditionRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPrcgConditionRecord getSlsPrcgConditionRecordOrFetch()
    {
        if( toSlsPrcgConditionRecord == null ) {
            toSlsPrcgConditionRecord = fetchSlsPrcgConditionRecord();
        }
        return toSlsPrcgConditionRecord;
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPrcgConditionRecord</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionRecordText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPrcgConditionRecord</b> is already loaded, the result
     *         will contain the <b>SlsPrcgConditionRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SlsPrcgConditionRecord> getSlsPrcgConditionRecordIfPresent()
    {
        return Option.of(toSlsPrcgConditionRecord);
    }

    /**
     * Overwrites the associated <b>SlsPrcgConditionRecord</b> entity for the loaded navigation property
     * <b>to_SlsPrcgConditionRecord</b>.
     *
     * @param value
     *            New <b>SlsPrcgConditionRecord</b> entity.
     */
    public void setSlsPrcgConditionRecord( final SlsPrcgConditionRecord value )
    {
        toSlsPrcgConditionRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgConditionRecordText instances.
     *
     */
    public final static class SlsPrcgConditionRecordTextBuilder
    {

        private SlsPrcgConditionRecord toSlsPrcgConditionRecord;

        private SlsPrcgConditionRecordText.SlsPrcgConditionRecordTextBuilder toSlsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            toSlsPrcgConditionRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_SlsPrcgConditionRecord</b> for <b>SlsPrcgConditionRecordText</b> to single
         * <b>SlsPrcgConditionRecord</b>.
         *
         * @param value
         *            The SlsPrcgConditionRecord to build this SlsPrcgConditionRecordText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionRecordText.SlsPrcgConditionRecordTextBuilder slsPrcgConditionRecord(
            final SlsPrcgConditionRecord value )
        {
            return toSlsPrcgConditionRecord(value);
        }

    }

}
