/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesPricingConditionRecordServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService
 * SalesPricingConditionRecordService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultSalesPricingConditionRecordServiceBatch
    extends
    BatchFluentHelperBasic<SalesPricingConditionRecordServiceBatch, SalesPricingConditionRecordServiceBatchChangeSet>
    implements
    SalesPricingConditionRecordServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesPricingConditionRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesPricingConditionRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesPricingConditionRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesPricingConditionRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesPricingConditionRecordServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesPricingConditionRecordServiceBatchChangeSet(this, service);
    }

}
