/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText;

/**
 * Implementation of the {@link SalesPricingConditionRecordServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService
 * SalesPricingConditionRecordService}.
 *
 */
public class DefaultSalesPricingConditionRecordServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesPricingConditionRecordServiceBatch, SalesPricingConditionRecordServiceBatchChangeSet>
    implements
    SalesPricingConditionRecordServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesPricingConditionRecordServiceBatchChangeSet(
        @Nonnull final DefaultSalesPricingConditionRecordServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesPricingConditionRecordServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return addRequestCreate(service::createSlsPrcgCndnRecdSuplmnt, slsPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return addRequestUpdate(service::updateSlsPrcgCndnRecdSuplmnt, slsPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet deleteSlsPrcgCndnRecdSuplmnt(
        @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt )
    {
        return addRequestDelete(service::deleteSlsPrcgCndnRecdSuplmnt, slsPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgCndnRecdValidity(
        @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity )
    {
        return addRequestCreate(service::createSlsPrcgCndnRecdValidity, slsPrcgCndnRecdValidity);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgCndnRecdValidity(
        @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity )
    {
        return addRequestUpdate(service::updateSlsPrcgCndnRecdValidity, slsPrcgCndnRecdValidity);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return addRequestCreate(service::createSlsPrcgCndnRecordScale, slsPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return addRequestUpdate(service::updateSlsPrcgCndnRecordScale, slsPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet deleteSlsPrcgCndnRecordScale(
        @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale )
    {
        return addRequestDelete(service::deleteSlsPrcgCndnRecordScale, slsPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return addRequestCreate(service::createSlsPrcgCndnSupplementText, slsPrcgCndnSupplementText);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return addRequestUpdate(service::updateSlsPrcgCndnSupplementText, slsPrcgCndnSupplementText);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet deleteSlsPrcgCndnSupplementText(
        @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText )
    {
        return addRequestDelete(service::deleteSlsPrcgCndnSupplementText, slsPrcgCndnSupplementText);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return addRequestCreate(service::createSlsPrcgConditionRecord, slsPrcgConditionRecord);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return addRequestUpdate(service::updateSlsPrcgConditionRecord, slsPrcgConditionRecord);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet deleteSlsPrcgConditionRecord(
        @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord )
    {
        return addRequestDelete(service::deleteSlsPrcgConditionRecord, slsPrcgConditionRecord);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet createSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return addRequestCreate(service::createSlsPrcgConditionRecordText, slsPrcgConditionRecordText);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet updateSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return addRequestUpdate(service::updateSlsPrcgConditionRecordText, slsPrcgConditionRecordText);
    }

    @Nonnull
    @Override
    public SalesPricingConditionRecordServiceBatchChangeSet deleteSlsPrcgConditionRecordText(
        @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText )
    {
        return addRequestDelete(service::deleteSlsPrcgConditionRecordText, slsPrcgConditionRecordText);
    }

}
