/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesPricingConditionRecordService
 * SalesPricingConditionRecordService}.
 *
 */
public interface SalesPricingConditionRecordServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesPricingConditionRecordServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesPricingConditionRecordServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     * SlsPrcgCndnRecdSuplmnt} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     *            SlsPrcgCndnRecdSuplmnt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgCndnRecdSuplmnt( @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     * SlsPrcgCndnRecdSuplmnt} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     *            SlsPrcgCndnRecdSuplmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgCndnRecdSuplmnt( @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     * SlsPrcgCndnRecdSuplmnt} entity in the S/4HANA system.
     *
     * @param slsPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdSuplmnt
     *            SlsPrcgCndnRecdSuplmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        deleteSlsPrcgCndnRecdSuplmnt( @Nonnull final SlsPrcgCndnRecdSuplmnt slsPrcgCndnRecdSuplmnt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity
     * SlsPrcgCndnRecdValidity} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecdValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity
     *            SlsPrcgCndnRecdValidity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgCndnRecdValidity( @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity
     * SlsPrcgCndnRecdValidity} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecdValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecdValidity
     *            SlsPrcgCndnRecdValidity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgCndnRecdValidity( @Nonnull final SlsPrcgCndnRecdValidity slsPrcgCndnRecdValidity );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     * SlsPrcgCndnRecordScale} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     *            SlsPrcgCndnRecordScale} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgCndnRecordScale( @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     * SlsPrcgCndnRecordScale} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     *            SlsPrcgCndnRecordScale} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgCndnRecordScale( @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     * SlsPrcgCndnRecordScale} entity in the S/4HANA system.
     *
     * @param slsPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
     *            SlsPrcgCndnRecordScale} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        deleteSlsPrcgCndnRecordScale( @Nonnull final SlsPrcgCndnRecordScale slsPrcgCndnRecordScale );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     * SlsPrcgCndnSupplementText} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnSupplementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     *            SlsPrcgCndnSupplementText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgCndnSupplementText( @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     * SlsPrcgCndnSupplementText} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgCndnSupplementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     *            SlsPrcgCndnSupplementText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgCndnSupplementText( @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     * SlsPrcgCndnSupplementText} entity in the S/4HANA system.
     *
     * @param slsPrcgCndnSupplementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
     *            SlsPrcgCndnSupplementText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        deleteSlsPrcgCndnSupplementText( @Nonnull final SlsPrcgCndnSupplementText slsPrcgCndnSupplementText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     * SlsPrcgConditionRecord} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     *            SlsPrcgConditionRecord} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgConditionRecord( @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     * SlsPrcgConditionRecord} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     *            SlsPrcgConditionRecord} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgConditionRecord( @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     * SlsPrcgConditionRecord} entity in the S/4HANA system.
     *
     * @param slsPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
     *            SlsPrcgConditionRecord} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        deleteSlsPrcgConditionRecord( @Nonnull final SlsPrcgConditionRecord slsPrcgConditionRecord );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     * SlsPrcgConditionRecordText} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgConditionRecordText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     *            SlsPrcgConditionRecordText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        createSlsPrcgConditionRecordText( @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     * SlsPrcgConditionRecordText} entity and save it to the S/4HANA system.
     *
     * @param slsPrcgConditionRecordText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     *            SlsPrcgConditionRecordText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        updateSlsPrcgConditionRecordText( @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     * SlsPrcgConditionRecordText} entity in the S/4HANA system.
     *
     * @param slsPrcgConditionRecordText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecordText
     *            SlsPrcgConditionRecordText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesPricingConditionRecordServiceBatchChangeSet
        deleteSlsPrcgConditionRecordText( @Nonnull final SlsPrcgConditionRecordText slsPrcgConditionRecordText );

}
