/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale
 * SlsPrcgCndnRecordScale}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgCndnRecordScaleField
 * SlsPrcgCndnRecordScaleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgCndnRecordScaleLink
 * SlsPrcgCndnRecordScaleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SCALE_LINE
 * CONDITION_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RATE_RATIO
 * CONDITION_RATE_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RATE_RATIO_UNIT
 * CONDITION_RATE_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_RATE_AMOUNT
 * CONDITION_RATE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#E_TAG
 * E_TAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#TO_SLS_PRCG_CNDN_RECD_SUPLMNT
 * TO_SLS_PRCG_CNDN_RECD_SUPLMNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnRecordScale#TO_SLS_PRCG_CONDITION_RECORD
 * TO_SLS_PRCG_CONDITION_RECORD}</li>
 * </ul>
 *
 */
public interface SlsPrcgCndnRecordScaleSelectable extends EntitySelectable<SlsPrcgCndnRecordScale>
{

}
