/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText
 * SlsPrcgCndnSupplementText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgCndnSupplementTextField
 * SlsPrcgCndnSupplementTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgCndnSupplementTextLink
 * SlsPrcgCndnSupplementTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#CONDITION_TEXT
 * CONDITION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#E_TAG
 * E_TAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgCndnSupplementText#TO_SLS_PRCG_CNDN_RECD_SUPLMNT
 * TO_SLS_PRCG_CNDN_RECD_SUPLMNT}</li>
 * </ul>
 *
 */
public interface SlsPrcgCndnSupplementTextSelectable extends EntitySelectable<SlsPrcgCndnSupplementText>
{

}
