/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord
 * SlsPrcgConditionRecord}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.field.SlsPrcgConditionRecordField
 * SlsPrcgConditionRecordField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.link.SlsPrcgConditionRecordLink
 * SlsPrcgConditionRecordLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TABLE
 * CONDITION_TABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_VALIDITY_END_DATE
 * CONDITION_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_VALIDITY_START_DATE
 * CONDITION_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TEXT_ID
 * CONDITION_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RATE_RATIO
 * CONDITION_RATE_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RATE_RATIO_UNIT
 * CONDITION_RATE_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RATE_AMOUNT
 * CONDITION_RATE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TO_BASE_QTY_NMRTR
 * CONDITION_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TO_BASE_QTY_DNMNTR
 * CONDITION_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_LOWER_LIMIT
 * CONDITION_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_LOWER_LIMIT_AMOUNT
 * CONDITION_LOWER_LIMIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_LOWER_LIMIT_RATIO
 * CONDITION_LOWER_LIMIT_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_UPPER_LIMIT
 * CONDITION_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_UPPER_LIMIT_AMOUNT
 * CONDITION_UPPER_LIMIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_UPPER_LIMIT_RATIO
 * CONDITION_UPPER_LIMIT_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_ALTERNATIVE_CURRENCY
 * CONDITION_ALTERNATIVE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_EXCLUSION
 * CONDITION_EXCLUSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_IS_DELETED
 * CONDITION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#ADDITIONAL_VALUE_DAYS
 * ADDITIONAL_VALUE_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#FIXED_VALUE_DATE
 * FIXED_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CNDN_MAX_NUMBER_OF_SALES_ORDERS
 * CNDN_MAX_NUMBER_OF_SALES_ORDERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#MINIMUM_CONDITION_BASIS_VALUE
 * MINIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#MAXIMUM_CONDITION_BASIS_VALUE
 * MAXIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#MAXIMUM_CONDITION_AMOUNT
 * MAXIMUM_CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#INCREMENTAL_SCALE
 * INCREMENTAL_SCALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#PRICING_SCALE_LINE
 * PRICING_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_RELEASE_STATUS
 * CONDITION_RELEASE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#SALES_PRICE_APPROVAL_REQUEST
 * SALES_PRICE_APPROVAL_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_CHANGE_REASON
 * CONDITION_CHANGE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#PREV_APPROVED_CONDITION_RECORD
 * PREV_APPROVED_CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_TAX_CODE
 * CONDITION_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#CONDITION_WITHHOLDING_TAX_CODE
 * CONDITION_WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#TAX_EXEMPTION_LICENSE
 * TAX_EXEMPTION_LICENSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#LICENSE_GRANT_DATE
 * LICENSE_GRANT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#E_TAG
 * E_TAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#TO_SLS_PRCG_CNDN_RECD_SUPLMNT
 * TO_SLS_PRCG_CNDN_RECD_SUPLMNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#TO_SLS_PRCG_CNDN_RECD_VALIDITY
 * TO_SLS_PRCG_CNDN_RECD_VALIDITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#TO_SLS_PRCG_CNDN_RECORD_SCALE
 * TO_SLS_PRCG_CNDN_RECORD_SCALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salespricingconditionrecord.SlsPrcgConditionRecord#TO_SLS_PRCG_CONDITION_RECORD_TEXT
 * TO_SLS_PRCG_CONDITION_RECORD_TEXT}</li>
 * </ul>
 *
 */
public interface SlsPrcgConditionRecordSelectable extends EntitySelectable<SlsPrcgConditionRecord>
{

}
