/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SalesQuotationItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SalesQuotationItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable.SalesQuotationItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesQuotationItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesQuotationItemPartner extends VdmEntity<SalesQuotationItemPartner>
{

    /**
     * Selector for all available fields of SalesQuotationItemPartner.
     *
     */
    public final static SalesQuotationItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @Key
    @SerializedName( "SalesQuotation" )
    @JsonProperty( "SalesQuotation" )
    @Nullable
    @ODataField( odataName = "SalesQuotation" )
    private String salesQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SalesQuotation</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> SALES_QUOTATION =
        new SalesQuotationItemPartnerField<String>("SalesQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotationItem</b>
     * </p>
     *
     * @return Item number of the SD document
     */
    @Key
    @SerializedName( "SalesQuotationItem" )
    @JsonProperty( "SalesQuotationItem" )
    @Nullable
    @ODataField( odataName = "SalesQuotationItem" )
    private String salesQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesQuotationItem</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> SALES_QUOTATION_ITEM =
        new SalesQuotationItemPartnerField<String>("SalesQuotationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> PARTNER_FUNCTION =
        new SalesQuotationItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> CUSTOMER =
        new SalesQuotationItemPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> SUPPLIER =
        new SalesQuotationItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> PERSONNEL =
        new SalesQuotationItemPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static SalesQuotationItemPartnerField<String> CONTACT_PERSON =
        new SalesQuotationItemPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_SalesQuotation</b> for <b>SalesQuotationItemPartner</b> to single
     * <b>SalesQuotation</b>.
     *
     */
    @SerializedName( "to_SalesQuotation" )
    @JsonProperty( "to_SalesQuotation" )
    @ODataField( odataName = "to_SalesQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesQuotation toSalesQuotation;
    /**
     * Navigation property <b>to_SalesQuotationItem</b> for <b>SalesQuotationItemPartner</b> to single
     * <b>SalesQuotationItem</b>.
     *
     */
    @SerializedName( "to_SalesQuotationItem" )
    @JsonProperty( "to_SalesQuotationItem" )
    @ODataField( odataName = "to_SalesQuotationItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesQuotationItem toSalesQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesQuotation</b> navigation property to query operations.
     *
     */
    public final static SalesQuotationItemPartnerOneToOneLink<SalesQuotation> TO_SALES_QUOTATION =
        new SalesQuotationItemPartnerOneToOneLink<SalesQuotation>("to_SalesQuotation");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesQuotationItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesQuotationItemPartnerOneToOneLink<SalesQuotationItem> TO_SALES_QUOTATION_ITEM =
        new SalesQuotationItemPartnerOneToOneLink<SalesQuotationItem>("to_SalesQuotationItem");

    @Nonnull
    @Override
    public Class<SalesQuotationItemPartner> getType()
    {
        return SalesQuotationItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @param salesQuotation
     *            Sales and Distribution Document Number
     */
    public void setSalesQuotation( @Nullable final String salesQuotation )
    {
        rememberChangedField("SalesQuotation", this.salesQuotation);
        this.salesQuotation = salesQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotationItem</b>
     * </p>
     *
     * @param salesQuotationItem
     *            Item number of the SD document
     */
    public void setSalesQuotationItem( @Nullable final String salesQuotationItem )
    {
        rememberChangedField("SalesQuotationItem", this.salesQuotationItem);
        this.salesQuotationItem = salesQuotationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesQuotationItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesQuotation", getSalesQuotation());
        result.put("SalesQuotationItem", getSalesQuotationItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesQuotation", getSalesQuotation());
        values.put("SalesQuotationItem", getSalesQuotationItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesQuotation") ) {
                final Object value = values.remove("SalesQuotation");
                if( (value == null) || (!value.equals(getSalesQuotation())) ) {
                    setSalesQuotation(((String) value));
                }
            }
            if( values.containsKey("SalesQuotationItem") ) {
                final Object value = values.remove("SalesQuotationItem");
                if( (value == null) || (!value.equals(getSalesQuotationItem())) ) {
                    setSalesQuotationItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesQuotation") ) {
                final Object value = (values).remove("to_SalesQuotation");
                if( value instanceof Map ) {
                    if( toSalesQuotation == null ) {
                        toSalesQuotation = new SalesQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesQuotation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesQuotationItem") ) {
                final Object value = (values).remove("to_SalesQuotationItem");
                if( value instanceof Map ) {
                    if( toSalesQuotationItem == null ) {
                        toSalesQuotationItem = new SalesQuotationItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesQuotationItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesQuotationItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesQuotationItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesQuotationItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesQuotationItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesQuotation != null ) {
            (values).put("to_SalesQuotation", toSalesQuotation);
        }
        if( toSalesQuotationItem != null ) {
            (values).put("to_SalesQuotationItem", toSalesQuotationItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesQuotation</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation fetchSalesQuotation()
    {
        return fetchFieldAsSingle("to_SalesQuotation", SalesQuotation.class);
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property <b>to_SalesQuotation</b> of a queried <b>SalesQuotationItemPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation getSalesQuotationOrFetch()
    {
        if( toSalesQuotation == null ) {
            toSalesQuotation = fetchSalesQuotation();
        }
        return toSalesQuotation;
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>SalesQuotationItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesQuotation</b> is already loaded, the result will
     *         contain the <b>SalesQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesQuotation> getSalesQuotationIfPresent()
    {
        return Option.of(toSalesQuotation);
    }

    /**
     * Overwrites the associated <b>SalesQuotation</b> entity for the loaded navigation property
     * <b>to_SalesQuotation</b>.
     *
     * @param value
     *            New <b>SalesQuotation</b> entity.
     */
    public void setSalesQuotation( final SalesQuotation value )
    {
        toSalesQuotation = value;
    }

    /**
     * Fetches the <b>SalesQuotationItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesQuotationItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesQuotationItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotationItem fetchSalesQuotationItem()
    {
        return fetchFieldAsSingle("to_SalesQuotationItem", SalesQuotationItem.class);
    }

    /**
     * Retrieval of associated <b>SalesQuotationItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_SalesQuotationItem</b> of a queried <b>SalesQuotationItemPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesQuotationItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotationItem getSalesQuotationItemOrFetch()
    {
        if( toSalesQuotationItem == null ) {
            toSalesQuotationItem = fetchSalesQuotationItem();
        }
        return toSalesQuotationItem;
    }

    /**
     * Retrieval of associated <b>SalesQuotationItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotationItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesQuotationItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesQuotationItem</b> is already loaded, the result
     *         will contain the <b>SalesQuotationItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesQuotationItem> getSalesQuotationItemIfPresent()
    {
        return Option.of(toSalesQuotationItem);
    }

    /**
     * Overwrites the associated <b>SalesQuotationItem</b> entity for the loaded navigation property
     * <b>to_SalesQuotationItem</b>.
     *
     * @param value
     *            New <b>SalesQuotationItem</b> entity.
     */
    public void setSalesQuotationItem( final SalesQuotationItem value )
    {
        toSalesQuotationItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesQuotationItemPartner instances.
     *
     */
    public final static class SalesQuotationItemPartnerBuilder
    {

        private SalesQuotation toSalesQuotation;
        private String salesQuotation = null;
        private SalesQuotationItem toSalesQuotationItem;
        private String salesQuotationItem = null;

        private SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder toSalesQuotation(
            final SalesQuotation value )
        {
            toSalesQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesQuotation</b> for <b>SalesQuotationItemPartner</b> to single
         * <b>SalesQuotation</b>.
         *
         * @param value
         *            The SalesQuotation to build this SalesQuotationItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder salesQuotation( final SalesQuotation value )
        {
            return toSalesQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesQuotation</b>
         * </p>
         *
         * @param value
         *            The salesQuotation to build this SalesQuotationItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder salesQuotation( final String value )
        {
            salesQuotation = value;
            return this;
        }

        private SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder toSalesQuotationItem(
            final SalesQuotationItem value )
        {
            toSalesQuotationItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesQuotationItem</b> for <b>SalesQuotationItemPartner</b> to single
         * <b>SalesQuotationItem</b>.
         *
         * @param value
         *            The SalesQuotationItem to build this SalesQuotationItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder salesQuotationItem(
            final SalesQuotationItem value )
        {
            return toSalesQuotationItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesQuotationItem</b>
         * </p>
         *
         * @param value
         *            The salesQuotationItem to build this SalesQuotationItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationItemPartner.SalesQuotationItemPartnerBuilder salesQuotationItem( final String value )
        {
            salesQuotationItem = value;
            return this;
        }

    }

}
