/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable.SalesQuotationPrcgElmntSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
 * SalesQuotationPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SalesQuotationPrcgElmntByKeyFluentHelper
    extends
    FluentHelperByKey<SalesQuotationPrcgElmntByKeyFluentHelper, SalesQuotationPrcgElmnt, SalesQuotationPrcgElmntSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
     * SalesQuotationPrcgElmnt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesQuotationPrcgElmnt}
     * @param salesQuotation
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesQuotationPrcgElmnt}
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public SalesQuotationPrcgElmntByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesQuotation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesQuotation", salesQuotation);
        this.key.put("PricingProcedureStep", pricingProcedureStep);
        this.key.put("PricingProcedureCounter", pricingProcedureCounter);
    }

    @Override
    @Nonnull
    protected Class<SalesQuotationPrcgElmnt> getEntityClass()
    {
        return SalesQuotationPrcgElmnt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
