/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SalesQuotationRelatedObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SalesQuotationRelatedObjectOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable.SalesQuotationRelatedObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Related Object
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesQuotationRelatedObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesQuotationRelatedObject extends VdmEntity<SalesQuotationRelatedObject>
{

    /**
     * Selector for all available fields of SalesQuotationRelatedObject.
     *
     */
    public final static SalesQuotationRelatedObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @return Sales Quotation
     */
    @Key
    @SerializedName( "SalesQuotation" )
    @JsonProperty( "SalesQuotation" )
    @Nullable
    @ODataField( odataName = "SalesQuotation" )
    private String salesQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SalesQuotation</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SALES_QUOTATION =
        new SalesQuotationRelatedObjectField<String>("SalesQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSequenceNmbr</b>
     * </p>
     *
     * @return Sequence Number of the Related Object of an SD Document
     */
    @Key
    @SerializedName( "SDDocRelatedObjectSequenceNmbr" )
    @JsonProperty( "SDDocRelatedObjectSequenceNmbr" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectSequenceNmbr" )
    private String sDDocRelatedObjectSequenceNmbr;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectSequenceNmbr</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR =
        new SalesQuotationRelatedObjectField<String>("SDDocRelatedObjectSequenceNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRelatedObjectType</b>
     * </p>
     *
     * @return Type of the Related Object of an SD Document
     */
    @SerializedName( "SDDocumentRelatedObjectType" )
    @JsonProperty( "SDDocumentRelatedObjectType" )
    @Nullable
    @ODataField( odataName = "SDDocumentRelatedObjectType" )
    private String sDDocumentRelatedObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentRelatedObjectType</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SD_DOCUMENT_RELATED_OBJECT_TYPE =
        new SalesQuotationRelatedObjectField<String>("SDDocumentRelatedObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSystem</b>
     * </p>
     *
     * @return System of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectSystem" )
    @JsonProperty( "SDDocRelatedObjectSystem" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectSystem" )
    private String sDDocRelatedObjectSystem;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectSystem</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SD_DOC_RELATED_OBJECT_SYSTEM =
        new SalesQuotationRelatedObjectField<String>("SDDocRelatedObjectSystem");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference1</b>
     * </p>
     *
     * @return Reference of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectReference1" )
    @JsonProperty( "SDDocRelatedObjectReference1" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectReference1" )
    private String sDDocRelatedObjectReference1;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectReference1</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SD_DOC_RELATED_OBJECT_REFERENCE1 =
        new SalesQuotationRelatedObjectField<String>("SDDocRelatedObjectReference1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference2</b>
     * </p>
     *
     * @return Reference of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectReference2" )
    @JsonProperty( "SDDocRelatedObjectReference2" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectReference2" )
    private String sDDocRelatedObjectReference2;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectReference2</b> field to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectField<String> SD_DOC_RELATED_OBJECT_REFERENCE2 =
        new SalesQuotationRelatedObjectField<String>("SDDocRelatedObjectReference2");
    /**
     * Navigation property <b>to_SalesQuotation</b> for <b>SalesQuotationRelatedObject</b> to single
     * <b>SalesQuotation</b>.
     *
     */
    @SerializedName( "to_SalesQuotation" )
    @JsonProperty( "to_SalesQuotation" )
    @ODataField( odataName = "to_SalesQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesQuotation toSalesQuotation;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesQuotation</b> navigation property to query operations.
     *
     */
    public final static SalesQuotationRelatedObjectOneToOneLink<SalesQuotation> TO_SALES_QUOTATION =
        new SalesQuotationRelatedObjectOneToOneLink<SalesQuotation>("to_SalesQuotation");

    @Nonnull
    @Override
    public Class<SalesQuotationRelatedObject> getType()
    {
        return SalesQuotationRelatedObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @param salesQuotation
     *            Sales Quotation
     */
    public void setSalesQuotation( @Nullable final String salesQuotation )
    {
        rememberChangedField("SalesQuotation", this.salesQuotation);
        this.salesQuotation = salesQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSequenceNmbr</b>
     * </p>
     *
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectSequenceNmbr( @Nullable final String sDDocRelatedObjectSequenceNmbr )
    {
        rememberChangedField("SDDocRelatedObjectSequenceNmbr", this.sDDocRelatedObjectSequenceNmbr);
        this.sDDocRelatedObjectSequenceNmbr = sDDocRelatedObjectSequenceNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRelatedObjectType</b>
     * </p>
     *
     * @param sDDocumentRelatedObjectType
     *            Type of the Related Object of an SD Document
     */
    public void setSDDocumentRelatedObjectType( @Nullable final String sDDocumentRelatedObjectType )
    {
        rememberChangedField("SDDocumentRelatedObjectType", this.sDDocumentRelatedObjectType);
        this.sDDocumentRelatedObjectType = sDDocumentRelatedObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSystem</b>
     * </p>
     *
     * @param sDDocRelatedObjectSystem
     *            System of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectSystem( @Nullable final String sDDocRelatedObjectSystem )
    {
        rememberChangedField("SDDocRelatedObjectSystem", this.sDDocRelatedObjectSystem);
        this.sDDocRelatedObjectSystem = sDDocRelatedObjectSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference1</b>
     * </p>
     *
     * @param sDDocRelatedObjectReference1
     *            Reference of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectReference1( @Nullable final String sDDocRelatedObjectReference1 )
    {
        rememberChangedField("SDDocRelatedObjectReference1", this.sDDocRelatedObjectReference1);
        this.sDDocRelatedObjectReference1 = sDDocRelatedObjectReference1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference2</b>
     * </p>
     *
     * @param sDDocRelatedObjectReference2
     *            Reference of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectReference2( @Nullable final String sDDocRelatedObjectReference2 )
    {
        rememberChangedField("SDDocRelatedObjectReference2", this.sDDocRelatedObjectReference2);
        this.sDDocRelatedObjectReference2 = sDDocRelatedObjectReference2;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesQuotationRelatedObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesQuotation", getSalesQuotation());
        result.put("SDDocRelatedObjectSequenceNmbr", getSDDocRelatedObjectSequenceNmbr());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesQuotation", getSalesQuotation());
        values.put("SDDocRelatedObjectSequenceNmbr", getSDDocRelatedObjectSequenceNmbr());
        values.put("SDDocumentRelatedObjectType", getSDDocumentRelatedObjectType());
        values.put("SDDocRelatedObjectSystem", getSDDocRelatedObjectSystem());
        values.put("SDDocRelatedObjectReference1", getSDDocRelatedObjectReference1());
        values.put("SDDocRelatedObjectReference2", getSDDocRelatedObjectReference2());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesQuotation") ) {
                final Object value = values.remove("SalesQuotation");
                if( (value == null) || (!value.equals(getSalesQuotation())) ) {
                    setSalesQuotation(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectSequenceNmbr") ) {
                final Object value = values.remove("SDDocRelatedObjectSequenceNmbr");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectSequenceNmbr())) ) {
                    setSDDocRelatedObjectSequenceNmbr(((String) value));
                }
            }
            if( values.containsKey("SDDocumentRelatedObjectType") ) {
                final Object value = values.remove("SDDocumentRelatedObjectType");
                if( (value == null) || (!value.equals(getSDDocumentRelatedObjectType())) ) {
                    setSDDocumentRelatedObjectType(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectSystem") ) {
                final Object value = values.remove("SDDocRelatedObjectSystem");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectSystem())) ) {
                    setSDDocRelatedObjectSystem(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectReference1") ) {
                final Object value = values.remove("SDDocRelatedObjectReference1");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectReference1())) ) {
                    setSDDocRelatedObjectReference1(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectReference2") ) {
                final Object value = values.remove("SDDocRelatedObjectReference2");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectReference2())) ) {
                    setSDDocRelatedObjectReference2(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesQuotation") ) {
                final Object value = (values).remove("to_SalesQuotation");
                if( value instanceof Map ) {
                    if( toSalesQuotation == null ) {
                        toSalesQuotation = new SalesQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesQuotation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesQuotationRelatedObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SalesQuotationRelatedObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesQuotationRelatedObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesQuotationRelatedObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesQuotation != null ) {
            (values).put("to_SalesQuotation", toSalesQuotation);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesQuotation</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation fetchSalesQuotation()
    {
        return fetchFieldAsSingle("to_SalesQuotation", SalesQuotation.class);
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property <b>to_SalesQuotation</b> of a queried <b>SalesQuotationRelatedObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation getSalesQuotationOrFetch()
    {
        if( toSalesQuotation == null ) {
            toSalesQuotation = fetchSalesQuotation();
        }
        return toSalesQuotation;
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>SalesQuotationRelatedObject</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesQuotation</b> is already loaded, the result will
     *         contain the <b>SalesQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesQuotation> getSalesQuotationIfPresent()
    {
        return Option.of(toSalesQuotation);
    }

    /**
     * Overwrites the associated <b>SalesQuotation</b> entity for the loaded navigation property
     * <b>to_SalesQuotation</b>.
     *
     * @param value
     *            New <b>SalesQuotation</b> entity.
     */
    public void setSalesQuotation( final SalesQuotation value )
    {
        toSalesQuotation = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesQuotationRelatedObject instances.
     *
     */
    public final static class SalesQuotationRelatedObjectBuilder
    {

        private SalesQuotation toSalesQuotation;
        private String salesQuotation = null;

        private SalesQuotationRelatedObject.SalesQuotationRelatedObjectBuilder toSalesQuotation(
            final SalesQuotation value )
        {
            toSalesQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesQuotation</b> for <b>SalesQuotationRelatedObject</b> to single
         * <b>SalesQuotation</b>.
         *
         * @param value
         *            The SalesQuotation to build this SalesQuotationRelatedObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationRelatedObject.SalesQuotationRelatedObjectBuilder salesQuotation(
            final SalesQuotation value )
        {
            return toSalesQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesQuotation</b>
         * </p>
         *
         * @param value
         *            The salesQuotation to build this SalesQuotationRelatedObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesQuotationRelatedObject.SalesQuotationRelatedObjectBuilder salesQuotation( final String value )
        {
            salesQuotation = value;
            return this;
        }

    }

}
