/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SlsQtanPrecdgProcFlowField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SlsQtanPrecdgProcFlowOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable.SlsQtanPrecdgProcFlowSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Preceding Process Flow
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsQtanPrecdgProcFlowType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsQtanPrecdgProcFlow extends VdmEntity<SlsQtanPrecdgProcFlow>
{

    /**
     * Selector for all available fields of SlsQtanPrecdgProcFlow.
     *
     */
    public final static SlsQtanPrecdgProcFlowSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @return Subsequent Sales and Distribution Document
     */
    @Key
    @SerializedName( "SalesQuotation" )
    @JsonProperty( "SalesQuotation" )
    @Nullable
    @ODataField( odataName = "SalesQuotation" )
    private String salesQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SalesQuotation</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> SALES_QUOTATION =
        new SlsQtanPrecdgProcFlowField<String>("SalesQuotation");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocRelationshipUUID</b>
     * </p>
     *
     * @return SD Unique Document Relationship Identification
     */
    @Key
    @SerializedName( "DocRelationshipUUID" )
    @JsonProperty( "DocRelationshipUUID" )
    @Nullable
    @ODataField( odataName = "DocRelationshipUUID" )
    private UUID docRelationshipUUID;
    /**
     * Use with available fluent helpers to apply the <b>DocRelationshipUUID</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<UUID> DOC_RELATIONSHIP_UUID =
        new SlsQtanPrecdgProcFlowField<UUID>("DocRelationshipUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @return Preceding sales and distribution document
     */
    @SerializedName( "PrecedingDocument" )
    @JsonProperty( "PrecedingDocument" )
    @Nullable
    @ODataField( odataName = "PrecedingDocument" )
    private String precedingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocument</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> PRECEDING_DOCUMENT =
        new SlsQtanPrecdgProcFlowField<String>("PrecedingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "PrecedingDocumentCategory" )
    @JsonProperty( "PrecedingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PrecedingDocumentCategory" )
    private String precedingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocumentCategory</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> PRECEDING_DOCUMENT_CATEGORY =
        new SlsQtanPrecdgProcFlowField<String>("PrecedingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @return Level of the document flow record
     */
    @SerializedName( "ProcessFlowLevel" )
    @JsonProperty( "ProcessFlowLevel" )
    @Nullable
    @ODataField( odataName = "ProcessFlowLevel" )
    private String processFlowLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProcessFlowLevel</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> PROCESS_FLOW_LEVEL =
        new SlsQtanPrecdgProcFlowField<String>("ProcessFlowLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     *
     * @return General SD status
     */
    @SerializedName( "StatusCode" )
    @JsonProperty( "StatusCode" )
    @Nullable
    @ODataField( odataName = "StatusCode" )
    private String statusCode;
    /**
     * Use with available fluent helpers to apply the <b>StatusCode</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> STATUS_CODE =
        new SlsQtanPrecdgProcFlowField<String>("StatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentStatusDesc</b>
     * </p>
     *
     * @return Status Description
     */
    @SerializedName( "SDDocumentStatusDesc" )
    @JsonProperty( "SDDocumentStatusDesc" )
    @Nullable
    @ODataField( odataName = "SDDocumentStatusDesc" )
    private String sDDocumentStatusDesc;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentStatusDesc</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<String> SD_DOCUMENT_STATUS_DESC =
        new SlsQtanPrecdgProcFlowField<String>("SDDocumentStatusDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<LocalDateTime> CREATION_DATE =
        new SlsQtanPrecdgProcFlowField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<LocalTime> CREATION_TIME =
        new SlsQtanPrecdgProcFlowField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowField<LocalDateTime> LAST_CHANGE_DATE =
        new SlsQtanPrecdgProcFlowField<LocalDateTime>("LastChangeDate");
    /**
     * Navigation property <b>to_SalesQuotation</b> for <b>SlsQtanPrecdgProcFlow</b> to single <b>SalesQuotation</b>.
     *
     */
    @SerializedName( "to_SalesQuotation" )
    @JsonProperty( "to_SalesQuotation" )
    @ODataField( odataName = "to_SalesQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesQuotation toSalesQuotation;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesQuotation</b> navigation property to query operations.
     *
     */
    public final static SlsQtanPrecdgProcFlowOneToOneLink<SalesQuotation> TO_SALES_QUOTATION =
        new SlsQtanPrecdgProcFlowOneToOneLink<SalesQuotation>("to_SalesQuotation");

    @Nonnull
    @Override
    public Class<SlsQtanPrecdgProcFlow> getType()
    {
        return SlsQtanPrecdgProcFlow.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesQuotation</b>
     * </p>
     *
     * @param salesQuotation
     *            Subsequent Sales and Distribution Document
     */
    public void setSalesQuotation( @Nullable final String salesQuotation )
    {
        rememberChangedField("SalesQuotation", this.salesQuotation);
        this.salesQuotation = salesQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocRelationshipUUID</b>
     * </p>
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     */
    public void setDocRelationshipUUID( @Nullable final UUID docRelationshipUUID )
    {
        rememberChangedField("DocRelationshipUUID", this.docRelationshipUUID);
        this.docRelationshipUUID = docRelationshipUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @param precedingDocument
     *            Preceding sales and distribution document
     */
    public void setPrecedingDocument( @Nullable final String precedingDocument )
    {
        rememberChangedField("PrecedingDocument", this.precedingDocument);
        this.precedingDocument = precedingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @param precedingDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setPrecedingDocumentCategory( @Nullable final String precedingDocumentCategory )
    {
        rememberChangedField("PrecedingDocumentCategory", this.precedingDocumentCategory);
        this.precedingDocumentCategory = precedingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @param processFlowLevel
     *            Level of the document flow record
     */
    public void setProcessFlowLevel( @Nullable final String processFlowLevel )
    {
        rememberChangedField("ProcessFlowLevel", this.processFlowLevel);
        this.processFlowLevel = processFlowLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     *
     * @param statusCode
     *            General SD status
     */
    public void setStatusCode( @Nullable final String statusCode )
    {
        rememberChangedField("StatusCode", this.statusCode);
        this.statusCode = statusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentStatusDesc</b>
     * </p>
     *
     * @param sDDocumentStatusDesc
     *            Status Description
     */
    public void setSDDocumentStatusDesc( @Nullable final String sDDocumentStatusDesc )
    {
        rememberChangedField("SDDocumentStatusDesc", this.sDDocumentStatusDesc);
        this.sDDocumentStatusDesc = sDDocumentStatusDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsQtanPrecdgProcFlow";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesQuotation", getSalesQuotation());
        result.put("DocRelationshipUUID", getDocRelationshipUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesQuotation", getSalesQuotation());
        values.put("DocRelationshipUUID", getDocRelationshipUUID());
        values.put("PrecedingDocument", getPrecedingDocument());
        values.put("PrecedingDocumentCategory", getPrecedingDocumentCategory());
        values.put("ProcessFlowLevel", getProcessFlowLevel());
        values.put("StatusCode", getStatusCode());
        values.put("SDDocumentStatusDesc", getSDDocumentStatusDesc());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesQuotation") ) {
                final Object value = values.remove("SalesQuotation");
                if( (value == null) || (!value.equals(getSalesQuotation())) ) {
                    setSalesQuotation(((String) value));
                }
            }
            if( values.containsKey("DocRelationshipUUID") ) {
                final Object value = values.remove("DocRelationshipUUID");
                if( (value == null) || (!value.equals(getDocRelationshipUUID())) ) {
                    setDocRelationshipUUID(((UUID) value));
                }
            }
            if( values.containsKey("PrecedingDocument") ) {
                final Object value = values.remove("PrecedingDocument");
                if( (value == null) || (!value.equals(getPrecedingDocument())) ) {
                    setPrecedingDocument(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocumentCategory") ) {
                final Object value = values.remove("PrecedingDocumentCategory");
                if( (value == null) || (!value.equals(getPrecedingDocumentCategory())) ) {
                    setPrecedingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ProcessFlowLevel") ) {
                final Object value = values.remove("ProcessFlowLevel");
                if( (value == null) || (!value.equals(getProcessFlowLevel())) ) {
                    setProcessFlowLevel(((String) value));
                }
            }
            if( values.containsKey("StatusCode") ) {
                final Object value = values.remove("StatusCode");
                if( (value == null) || (!value.equals(getStatusCode())) ) {
                    setStatusCode(((String) value));
                }
            }
            if( values.containsKey("SDDocumentStatusDesc") ) {
                final Object value = values.remove("SDDocumentStatusDesc");
                if( (value == null) || (!value.equals(getSDDocumentStatusDesc())) ) {
                    setSDDocumentStatusDesc(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesQuotation") ) {
                final Object value = (values).remove("to_SalesQuotation");
                if( value instanceof Map ) {
                    if( toSalesQuotation == null ) {
                        toSalesQuotation = new SalesQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesQuotation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsQtanPrecdgProcFlowField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsQtanPrecdgProcFlowField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsQtanPrecdgProcFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsQtanPrecdgProcFlowField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesQuotation != null ) {
            (values).put("to_SalesQuotation", toSalesQuotation);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesQuotation</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation fetchSalesQuotation()
    {
        return fetchFieldAsSingle("to_SalesQuotation", SalesQuotation.class);
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property <b>to_SalesQuotation</b> of a queried <b>SlsQtanPrecdgProcFlow</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesQuotation getSalesQuotationOrFetch()
    {
        if( toSalesQuotation == null ) {
            toSalesQuotation = fetchSalesQuotation();
        }
        return toSalesQuotation;
    }

    /**
     * Retrieval of associated <b>SalesQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>SlsQtanPrecdgProcFlow</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesQuotation</b> is already loaded, the result will
     *         contain the <b>SalesQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesQuotation> getSalesQuotationIfPresent()
    {
        return Option.of(toSalesQuotation);
    }

    /**
     * Overwrites the associated <b>SalesQuotation</b> entity for the loaded navigation property
     * <b>to_SalesQuotation</b>.
     *
     * @param value
     *            New <b>SalesQuotation</b> entity.
     */
    public void setSalesQuotation( final SalesQuotation value )
    {
        toSalesQuotation = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsQtanPrecdgProcFlow instances.
     *
     */
    public final static class SlsQtanPrecdgProcFlowBuilder
    {

        private SalesQuotation toSalesQuotation;
        private String salesQuotation = null;

        private SlsQtanPrecdgProcFlow.SlsQtanPrecdgProcFlowBuilder toSalesQuotation( final SalesQuotation value )
        {
            toSalesQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesQuotation</b> for <b>SlsQtanPrecdgProcFlow</b> to single
         * <b>SalesQuotation</b>.
         *
         * @param value
         *            The SalesQuotation to build this SlsQtanPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsQtanPrecdgProcFlow.SlsQtanPrecdgProcFlowBuilder salesQuotation( final SalesQuotation value )
        {
            return toSalesQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesQuotation</b>
         * </p>
         *
         * @param value
         *            The salesQuotation to build this SlsQtanPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsQtanPrecdgProcFlow.SlsQtanPrecdgProcFlowBuilder salesQuotation( final String value )
        {
            salesQuotation = value;
            return this;
        }

    }

}
