/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject;

/**
 * Implementation of the {@link SalesQuotationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService SalesQuotationService}.
 *
 */
public class DefaultSalesQuotationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesQuotationServiceBatch, SalesQuotationServiceBatchChangeSet>
    implements
    SalesQuotationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesQuotationServiceBatchChangeSet(
        @Nonnull final DefaultSalesQuotationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesQuotationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet createSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return addRequestCreate(service::createSalesQuotation, salesQuotation);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return addRequestUpdate(service::updateSalesQuotation, salesQuotation);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotation( @Nonnull final SalesQuotation salesQuotation )
    {
        return addRequestDelete(service::deleteSalesQuotation, salesQuotation);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet createSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return addRequestCreate(service::createSalesQuotationItem, salesQuotationItem);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return addRequestUpdate(service::updateSalesQuotationItem, salesQuotationItem);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationItem(
        @Nonnull final SalesQuotationItem salesQuotationItem )
    {
        return addRequestDelete(service::deleteSalesQuotationItem, salesQuotationItem);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationItemPartner(
        @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner )
    {
        return addRequestUpdate(service::updateSalesQuotationItemPartner, salesQuotationItemPartner);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationItemPartner(
        @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner )
    {
        return addRequestDelete(service::deleteSalesQuotationItemPartner, salesQuotationItemPartner);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationItemPrcgElmnt(
        @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt )
    {
        return addRequestUpdate(service::updateSalesQuotationItemPrcgElmnt, salesQuotationItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationItemPrcgElmnt(
        @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt )
    {
        return addRequestDelete(service::deleteSalesQuotationItemPrcgElmnt, salesQuotationItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationItemText(
        @Nonnull final SalesQuotationItemText salesQuotationItemText )
    {
        return addRequestUpdate(service::updateSalesQuotationItemText, salesQuotationItemText);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationItemText(
        @Nonnull final SalesQuotationItemText salesQuotationItemText )
    {
        return addRequestDelete(service::deleteSalesQuotationItemText, salesQuotationItemText);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationPartner(
        @Nonnull final SalesQuotationPartner salesQuotationPartner )
    {
        return addRequestUpdate(service::updateSalesQuotationPartner, salesQuotationPartner);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationPartner(
        @Nonnull final SalesQuotationPartner salesQuotationPartner )
    {
        return addRequestDelete(service::deleteSalesQuotationPartner, salesQuotationPartner);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationPrcgElmnt(
        @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt )
    {
        return addRequestUpdate(service::updateSalesQuotationPrcgElmnt, salesQuotationPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationPrcgElmnt(
        @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt )
    {
        return addRequestDelete(service::deleteSalesQuotationPrcgElmnt, salesQuotationPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet createSalesQuotationRelatedObject(
        @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject )
    {
        return addRequestCreate(service::createSalesQuotationRelatedObject, salesQuotationRelatedObject);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationRelatedObject(
        @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject )
    {
        return addRequestDelete(service::deleteSalesQuotationRelatedObject, salesQuotationRelatedObject);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet updateSalesQuotationText(
        @Nonnull final SalesQuotationText salesQuotationText )
    {
        return addRequestUpdate(service::updateSalesQuotationText, salesQuotationText);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSalesQuotationText(
        @Nonnull final SalesQuotationText salesQuotationText )
    {
        return addRequestDelete(service::deleteSalesQuotationText, salesQuotationText);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet createSlsQtanItemRelatedObject(
        @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject )
    {
        return addRequestCreate(service::createSlsQtanItemRelatedObject, slsQtanItemRelatedObject);
    }

    @Nonnull
    @Override
    public SalesQuotationServiceBatchChangeSet deleteSlsQtanItemRelatedObject(
        @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject )
    {
        return addRequestDelete(service::deleteSlsQtanItemRelatedObject, slsQtanItemRelatedObject);
    }

}
