/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesQuotationService SalesQuotationService}.
 *
 */
public interface SalesQuotationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesQuotationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesQuotationServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     * SalesQuotation} entity and save it to the S/4HANA system.
     *
     * @param salesQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     *            SalesQuotation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet createSalesQuotation( @Nonnull final SalesQuotation salesQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     * SalesQuotation} entity and save it to the S/4HANA system.
     *
     * @param salesQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     *            SalesQuotation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet updateSalesQuotation( @Nonnull final SalesQuotation salesQuotation );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     * SalesQuotation} entity in the S/4HANA system.
     *
     * @param salesQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotation
     *            SalesQuotation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet deleteSalesQuotation( @Nonnull final SalesQuotation salesQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     * SalesQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     *            SalesQuotationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        createSalesQuotationItem( @Nonnull final SalesQuotationItem salesQuotationItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     * SalesQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     *            SalesQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationItem( @Nonnull final SalesQuotationItem salesQuotationItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     * SalesQuotationItem} entity in the S/4HANA system.
     *
     * @param salesQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItem
     *            SalesQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationItem( @Nonnull final SalesQuotationItem salesQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner
     * SalesQuotationItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner
     *            SalesQuotationItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationItemPartner( @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner
     * SalesQuotationItemPartner} entity in the S/4HANA system.
     *
     * @param salesQuotationItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPartner
     *            SalesQuotationItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationItemPartner( @Nonnull final SalesQuotationItemPartner salesQuotationItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt
     * SalesQuotationItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt
     *            SalesQuotationItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationItemPrcgElmnt( @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt
     * SalesQuotationItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesQuotationItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemPrcgElmnt
     *            SalesQuotationItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationItemPrcgElmnt( @Nonnull final SalesQuotationItemPrcgElmnt salesQuotationItemPrcgElmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText
     * SalesQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText
     *            SalesQuotationItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationItemText( @Nonnull final SalesQuotationItemText salesQuotationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText
     * SalesQuotationItemText} entity in the S/4HANA system.
     *
     * @param salesQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText
     *            SalesQuotationItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationItemText( @Nonnull final SalesQuotationItemText salesQuotationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner
     * SalesQuotationPartner} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner
     *            SalesQuotationPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationPartner( @Nonnull final SalesQuotationPartner salesQuotationPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner
     * SalesQuotationPartner} entity in the S/4HANA system.
     *
     * @param salesQuotationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPartner
     *            SalesQuotationPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationPartner( @Nonnull final SalesQuotationPartner salesQuotationPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
     * SalesQuotationPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
     *            SalesQuotationPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationPrcgElmnt( @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
     * SalesQuotationPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesQuotationPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
     *            SalesQuotationPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationPrcgElmnt( @Nonnull final SalesQuotationPrcgElmnt salesQuotationPrcgElmnt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject
     * SalesQuotationRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject
     *            SalesQuotationRelatedObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        createSalesQuotationRelatedObject( @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject
     * SalesQuotationRelatedObject} entity in the S/4HANA system.
     *
     * @param salesQuotationRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationRelatedObject
     *            SalesQuotationRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationRelatedObject( @Nonnull final SalesQuotationRelatedObject salesQuotationRelatedObject );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText
     * SalesQuotationText} entity and save it to the S/4HANA system.
     *
     * @param salesQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText
     *            SalesQuotationText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        updateSalesQuotationText( @Nonnull final SalesQuotationText salesQuotationText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText
     * SalesQuotationText} entity in the S/4HANA system.
     *
     * @param salesQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationText
     *            SalesQuotationText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSalesQuotationText( @Nonnull final SalesQuotationText salesQuotationText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject
     * SlsQtanItemRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param slsQtanItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject
     *            SlsQtanItemRelatedObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        createSlsQtanItemRelatedObject( @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject
     * SlsQtanItemRelatedObject} entity in the S/4HANA system.
     *
     * @param slsQtanItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject
     *            SlsQtanItemRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesQuotationServiceBatchChangeSet
        deleteSlsQtanItemRelatedObject( @Nonnull final SlsQtanItemRelatedObject slsQtanItemRelatedObject );

}
