/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText
 * SalesQuotationItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SalesQuotationItemTextField
 * SalesQuotationItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SalesQuotationItemTextLink
 * SalesQuotationItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#SALES_QUOTATION
 * SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#SALES_QUOTATION_ITEM
 * SALES_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#TO_SALES_QUOTATION
 * TO_SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationItemText#TO_SALES_QUOTATION_ITEM
 * TO_SALES_QUOTATION_ITEM}</li>
 * </ul>
 *
 */
public interface SalesQuotationItemTextSelectable extends EntitySelectable<SalesQuotationItemText>
{

}
