/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt
 * SalesQuotationPrcgElmnt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SalesQuotationPrcgElmntField
 * SalesQuotationPrcgElmntField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SalesQuotationPrcgElmntLink
 * SalesQuotationPrcgElmntLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#SALES_QUOTATION
 * SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICING_DATE_TIME
 * PRICING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICE_CONDITION_DETERMINATION_DTE
 * PRICE_CONDITION_DETERMINATION_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_BASE_VALUE
 * CONDITION_BASE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_QUANTITY_SAP_UNIT
 * CONDITION_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_QUANTITY_ISO_UNIT
 * CONDITION_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_CATEGORY
 * CONDITION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_IS_FOR_STATISTICS
 * CONDITION_IS_FOR_STATISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_ORIGIN
 * CONDITION_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#IS_GROUP_CONDITION
 * IS_GROUP_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CNDN_ROUNDING_OFF_DIFF_AMOUNT
 * CNDN_ROUNDING_OFF_DIFF_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_AMOUNT
 * CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_CONTROL
 * CONDITION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_CLASS
 * CONDITION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRCG_PROCEDURE_COUNTER_FOR_HEADER
 * PRCG_PROCEDURE_COUNTER_FOR_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#FACTOR_FOR_CONDITION_BASIS_VALUE
 * FACTOR_FOR_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#STRUCTURE_CONDITION
 * STRUCTURE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE
 * PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_SCALE_BASIS_VALUE
 * CONDITION_SCALE_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_SCALE_BASIS_UNIT
 * CONDITION_SCALE_BASIS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_SCALE_BASIS_CURRENCY
 * CONDITION_SCALE_BASIS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CNDN_IS_RELEVANT_FOR_INTCO_BILLING
 * CNDN_IS_RELEVANT_FOR_INTCO_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_IS_MANUALLY_CHANGED
 * CONDITION_IS_MANUALLY_CHANGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#CONDITION_IS_FOR_CONFIGURATION
 * CONDITION_IS_FOR_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#VARIANT_CONDITION
 * VARIANT_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SalesQuotationPrcgElmnt#TO_SALES_QUOTATION
 * TO_SALES_QUOTATION}</li>
 * </ul>
 *
 */
public interface SalesQuotationPrcgElmntSelectable extends EntitySelectable<SalesQuotationPrcgElmnt>
{

}
