/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject
 * SlsQtanItemRelatedObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SlsQtanItemRelatedObjectField
 * SlsQtanItemRelatedObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SlsQtanItemRelatedObjectLink
 * SlsQtanItemRelatedObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SALES_QUOTATION
 * SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SALES_QUOTATION_ITEM
 * SALES_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR
 * SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SD_DOCUMENT_RELATED_OBJECT_TYPE
 * SD_DOCUMENT_RELATED_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SD_DOC_RELATED_OBJECT_SYSTEM
 * SD_DOC_RELATED_OBJECT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SD_DOC_RELATED_OBJECT_REFERENCE1
 * SD_DOC_RELATED_OBJECT_REFERENCE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#SD_DOC_RELATED_OBJECT_REFERENCE2
 * SD_DOC_RELATED_OBJECT_REFERENCE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#TO_SALES_QUOTATION
 * TO_SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItemRelatedObject#TO_SALES_QUOTATION_ITEM
 * TO_SALES_QUOTATION_ITEM}</li>
 * </ul>
 *
 */
public interface SlsQtanItemRelatedObjectSelectable extends EntitySelectable<SlsQtanItemRelatedObject>
{

}
