/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow
 * SlsQtanItmPrecdgProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SlsQtanItmPrecdgProcFlowField
 * SlsQtanItmPrecdgProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SlsQtanItmPrecdgProcFlowLink
 * SlsQtanItmPrecdgProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#SALES_QUOTATION
 * SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#SALES_QUOTATION_ITEM
 * SALES_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#DOC_RELATIONSHIP_UUID
 * DOC_RELATIONSHIP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#PRECEDING_DOCUMENT
 * PRECEDING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#PRECEDING_DOCUMENT_ITEM
 * PRECEDING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#PRECEDING_DOCUMENT_CATEGORY
 * PRECEDING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#STATUS_CODE
 * STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#SD_DOCUMENT_STATUS_DESC
 * SD_DOCUMENT_STATUS_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#TO_SALES_QUOTATION
 * TO_SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmPrecdgProcFlow#TO_SALES_QUOTATION_ITEM
 * TO_SALES_QUOTATION_ITEM}</li>
 * </ul>
 *
 */
public interface SlsQtanItmPrecdgProcFlowSelectable extends EntitySelectable<SlsQtanItmPrecdgProcFlow>
{

}
