/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow
 * SlsQtanItmSubsqntProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.field.SlsQtanItmSubsqntProcFlowField
 * SlsQtanItmSubsqntProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.link.SlsQtanItmSubsqntProcFlowLink
 * SlsQtanItmSubsqntProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SALES_QUOTATION
 * SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SALES_QUOTATION_ITEM
 * SALES_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#DOC_RELATIONSHIP_UUID
 * DOC_RELATIONSHIP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#STATUS_CODE
 * STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#SD_DOCUMENT_STATUS_DESC
 * SD_DOCUMENT_STATUS_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#TO_SALES_QUOTATION
 * TO_SALES_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesquotation.SlsQtanItmSubsqntProcFlow#TO_SALES_QUOTATION_ITEM
 * TO_SALES_QUOTATION_ITEM}</li>
 * </ul>
 *
 */
public interface SlsQtanItmSubsqntProcFlowSelectable extends EntitySelectable<SlsQtanItmSubsqntProcFlow>
{

}
