/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtDelivSchedField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtDelivSchedLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtDelivSchedOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtDelivSchedSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Delivery Schedule
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesSchedgAgrmtDelivSchedType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesSchedgAgrmtDelivSched extends VdmEntity<SalesSchedgAgrmtDelivSched>
{

    /**
     * Selector for all available fields of SalesSchedgAgrmtDelivSched.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "SalesSchedulingAgreement" )
    @JsonProperty( "SalesSchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreement" )
    private String salesSchedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreement</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> SALES_SCHEDULING_AGREEMENT =
        new SalesSchedgAgrmtDelivSchedField<String>("SalesSchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "SalesSchedulingAgreementItem" )
    @JsonProperty( "SalesSchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreementItem" )
    private String salesSchedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> SALES_SCHEDULING_AGREEMENT_ITEM =
        new SalesSchedgAgrmtDelivSchedField<String>("SalesSchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IntDeliveryScheduleNumber</b>
     * </p>
     *
     * @return Internal delivery schedule number
     */
    @Key
    @SerializedName( "IntDeliveryScheduleNumber" )
    @JsonProperty( "IntDeliveryScheduleNumber" )
    @Nullable
    @ODataField( odataName = "IntDeliveryScheduleNumber" )
    private String intDeliveryScheduleNumber;
    /**
     * Use with available fluent helpers to apply the <b>IntDeliveryScheduleNumber</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> INT_DELIVERY_SCHEDULE_NUMBER =
        new SalesSchedgAgrmtDelivSchedField<String>("IntDeliveryScheduleNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementReleaseType</b>
     * </p>
     *
     * @return Release type
     */
    @Key
    @SerializedName( "SchedulingAgreementReleaseType" )
    @JsonProperty( "SchedulingAgreementReleaseType" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementReleaseType" )
    private String schedulingAgreementReleaseType;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementReleaseType</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> SCHEDULING_AGREEMENT_RELEASE_TYPE =
        new SalesSchedgAgrmtDelivSchedField<String>("SchedulingAgreementReleaseType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleStartDate</b>
     * </p>
     *
     * @return Valid-from date of delivery schedule
     */
    @SerializedName( "DeliveryScheduleStartDate" )
    @JsonProperty( "DeliveryScheduleStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryScheduleStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryScheduleStartDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryScheduleStartDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> DELIVERY_SCHEDULE_START_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("DeliveryScheduleStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleEndDate</b>
     * </p>
     *
     * @return Valid-to date of delivery schedule
     */
    @SerializedName( "DeliveryScheduleEndDate" )
    @JsonProperty( "DeliveryScheduleEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryScheduleEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryScheduleEndDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryScheduleEndDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> DELIVERY_SCHEDULE_END_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("DeliveryScheduleEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustomerDeliveryScheduleNumber</b>
     * </p>
     *
     * @return Delivery Schedule
     */
    @SerializedName( "CustomerDeliveryScheduleNumber" )
    @JsonProperty( "CustomerDeliveryScheduleNumber" )
    @Nullable
    @ODataField( odataName = "CustomerDeliveryScheduleNumber" )
    private String customerDeliveryScheduleNumber;
    /**
     * Use with available fluent helpers to apply the <b>CustomerDeliveryScheduleNumber</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> CUSTOMER_DELIVERY_SCHEDULE_NUMBER =
        new SalesSchedgAgrmtDelivSchedField<String>("CustomerDeliveryScheduleNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleDate</b>
     * </p>
     *
     * @return Delivery Schedule Date
     */
    @SerializedName( "DeliveryScheduleDate" )
    @JsonProperty( "DeliveryScheduleDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryScheduleDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryScheduleDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryScheduleDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> DELIVERY_SCHEDULE_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("DeliveryScheduleDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDateKey</b>
     * </p>
     *
     * @return Date Key for Schedule Line Date
     */
    @SerializedName( "ScheduleLineDateKey" )
    @JsonProperty( "ScheduleLineDateKey" )
    @Nullable
    @ODataField( odataName = "ScheduleLineDateKey" )
    private String scheduleLineDateKey;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDateKey</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> SCHEDULE_LINE_DATE_KEY =
        new SalesSchedgAgrmtDelivSchedField<String>("ScheduleLineDateKey");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryDocPostingDate</b>
     * </p>
     *
     * @return Last Delivery Date
     */
    @SerializedName( "LastDeliveryDocPostingDate" )
    @JsonProperty( "LastDeliveryDocPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastDeliveryDocPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastDeliveryDocPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>LastDeliveryDocPostingDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> LAST_DELIVERY_DOC_POSTING_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("LastDeliveryDocPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryDocument</b>
     * </p>
     *
     * @return Last Delivery Confirmed by The Customer
     */
    @SerializedName( "LastDeliveryDocument" )
    @JsonProperty( "LastDeliveryDocument" )
    @Nullable
    @ODataField( odataName = "LastDeliveryDocument" )
    private String lastDeliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>LastDeliveryDocument</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> LAST_DELIVERY_DOCUMENT =
        new SalesSchedgAgrmtDelivSchedField<String>("LastDeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastIntDeliveryScheduleNumber</b>
     * </p>
     *
     * @return Last internal release order number
     */
    @SerializedName( "LastIntDeliveryScheduleNumber" )
    @JsonProperty( "LastIntDeliveryScheduleNumber" )
    @Nullable
    @ODataField( odataName = "LastIntDeliveryScheduleNumber" )
    private String lastIntDeliveryScheduleNumber;
    /**
     * Use with available fluent helpers to apply the <b>LastIntDeliveryScheduleNumber</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> LAST_INT_DELIVERY_SCHEDULE_NUMBER =
        new SalesSchedgAgrmtDelivSchedField<String>("LastIntDeliveryScheduleNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> CREATION_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalTime> CREATION_TIME =
        new SalesSchedgAgrmtDelivSchedField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> CREATED_BY_USER =
        new SalesSchedgAgrmtDelivSchedField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JITHorizonEndDate</b>
     * </p>
     *
     * @return JIT Horizon
     */
    @SerializedName( "JITHorizonEndDate" )
    @JsonProperty( "JITHorizonEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JITHorizonEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jITHorizonEndDate;
    /**
     * Use with available fluent helpers to apply the <b>JITHorizonEndDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> JIT_HORIZON_END_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("JITHorizonEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerFiscalYear</b>
     * </p>
     *
     * @return Customer Fiscal Year
     */
    @SerializedName( "CustomerFiscalYear" )
    @JsonProperty( "CustomerFiscalYear" )
    @Nullable
    @ODataField( odataName = "CustomerFiscalYear" )
    private String customerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>CustomerFiscalYear</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> CUSTOMER_FISCAL_YEAR =
        new SalesSchedgAgrmtDelivSchedField<String>("CustomerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RequirementsStatusKey</b>
     * </p>
     *
     * @return Requirements status key
     */
    @SerializedName( "RequirementsStatusKey" )
    @JsonProperty( "RequirementsStatusKey" )
    @Nullable
    @ODataField( odataName = "RequirementsStatusKey" )
    private String requirementsStatusKey;
    /**
     * Use with available fluent helpers to apply the <b>RequirementsStatusKey</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> REQUIREMENTS_STATUS_KEY =
        new SalesSchedgAgrmtDelivSchedField<String>("RequirementsStatusKey");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleCreationDate</b>
     * </p>
     *
     * @return Delivery schedule date of creation
     */
    @SerializedName( "DeliveryScheduleCreationDate" )
    @JsonProperty( "DeliveryScheduleCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryScheduleCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryScheduleCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryScheduleCreationDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> DELIVERY_SCHEDULE_CREATION_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("DeliveryScheduleCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib01</b>
     * </p>
     *
     * @return Additional data field 1 for delivery schedules
     */
    @SerializedName( "DelivSchedFreeDefinedAttrib01" )
    @JsonProperty( "DelivSchedFreeDefinedAttrib01" )
    @Nullable
    @ODataField( odataName = "DelivSchedFreeDefinedAttrib01" )
    private String delivSchedFreeDefinedAttrib01;
    /**
     * Use with available fluent helpers to apply the <b>DelivSchedFreeDefinedAttrib01</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> DELIV_SCHED_FREE_DEFINED_ATTRIB01 =
        new SalesSchedgAgrmtDelivSchedField<String>("DelivSchedFreeDefinedAttrib01");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib02</b>
     * </p>
     *
     * @return Additional data field 2 for delivery schedules
     */
    @SerializedName( "DelivSchedFreeDefinedAttrib02" )
    @JsonProperty( "DelivSchedFreeDefinedAttrib02" )
    @Nullable
    @ODataField( odataName = "DelivSchedFreeDefinedAttrib02" )
    private String delivSchedFreeDefinedAttrib02;
    /**
     * Use with available fluent helpers to apply the <b>DelivSchedFreeDefinedAttrib02</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> DELIV_SCHED_FREE_DEFINED_ATTRIB02 =
        new SalesSchedgAgrmtDelivSchedField<String>("DelivSchedFreeDefinedAttrib02");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib03</b>
     * </p>
     *
     * @return Additional data field 3 for delivery schedules
     */
    @SerializedName( "DelivSchedFreeDefinedAttrib03" )
    @JsonProperty( "DelivSchedFreeDefinedAttrib03" )
    @Nullable
    @ODataField( odataName = "DelivSchedFreeDefinedAttrib03" )
    private String delivSchedFreeDefinedAttrib03;
    /**
     * Use with available fluent helpers to apply the <b>DelivSchedFreeDefinedAttrib03</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> DELIV_SCHED_FREE_DEFINED_ATTRIB03 =
        new SalesSchedgAgrmtDelivSchedField<String>("DelivSchedFreeDefinedAttrib03");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib04</b>
     * </p>
     *
     * @return Additional data field 4 for delivery schedules
     */
    @SerializedName( "DelivSchedFreeDefinedAttrib04" )
    @JsonProperty( "DelivSchedFreeDefinedAttrib04" )
    @Nullable
    @ODataField( odataName = "DelivSchedFreeDefinedAttrib04" )
    private String delivSchedFreeDefinedAttrib04;
    /**
     * Use with available fluent helpers to apply the <b>DelivSchedFreeDefinedAttrib04</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> DELIV_SCHED_FREE_DEFINED_ATTRIB04 =
        new SalesSchedgAgrmtDelivSchedField<String>("DelivSchedFreeDefinedAttrib04");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib05</b>
     * </p>
     *
     * @return Additional data field 5 for delivery schedules
     */
    @SerializedName( "DelivSchedFreeDefinedAttrib05" )
    @JsonProperty( "DelivSchedFreeDefinedAttrib05" )
    @Nullable
    @ODataField( odataName = "DelivSchedFreeDefinedAttrib05" )
    private String delivSchedFreeDefinedAttrib05;
    /**
     * Use with available fluent helpers to apply the <b>DelivSchedFreeDefinedAttrib05</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> DELIV_SCHED_FREE_DEFINED_ATTRIB05 =
        new SalesSchedgAgrmtDelivSchedField<String>("DelivSchedFreeDefinedAttrib05");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadPeriodStartDate</b>
     * </p>
     *
     * @return Start of production go-ahead
     */
    @SerializedName( "ProdnGoAheadPeriodStartDate" )
    @JsonProperty( "ProdnGoAheadPeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProdnGoAheadPeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime prodnGoAheadPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProdnGoAheadPeriodStartDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> PRODN_GO_AHEAD_PERIOD_START_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("ProdnGoAheadPeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionGoAheadPeriodEndDate</b>
     * </p>
     *
     * @return End of production go-ahead
     */
    @SerializedName( "ProductionGoAheadPeriodEndDate" )
    @JsonProperty( "ProductionGoAheadPeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductionGoAheadPeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productionGoAheadPeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductionGoAheadPeriodEndDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> PRODUCTION_GO_AHEAD_PERIOD_END_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("ProductionGoAheadPeriodEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoAheadPeriodStartDate</b>
     * </p>
     *
     * @return Start of material go-ahead
     */
    @SerializedName( "MaterialGoAheadPeriodStartDate" )
    @JsonProperty( "MaterialGoAheadPeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialGoAheadPeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialGoAheadPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGoAheadPeriodStartDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> MATERIAL_GO_AHEAD_PERIOD_START_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("MaterialGoAheadPeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoAheadPeriodEndDate</b>
     * </p>
     *
     * @return End of material go-ahead
     */
    @SerializedName( "MaterialGoAheadPeriodEndDate" )
    @JsonProperty( "MaterialGoAheadPeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaterialGoAheadPeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime materialGoAheadPeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGoAheadPeriodEndDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> MATERIAL_GO_AHEAD_PERIOD_END_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("MaterialGoAheadPeriodEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPointOfConsumption</b>
     * </p>
     *
     * @return Customer point of consumption
     */
    @SerializedName( "CustomerPointOfConsumption" )
    @JsonProperty( "CustomerPointOfConsumption" )
    @Nullable
    @ODataField( odataName = "CustomerPointOfConsumption" )
    private String customerPointOfConsumption;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPointOfConsumption</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> CUSTOMER_POINT_OF_CONSUMPTION =
        new SalesSchedgAgrmtDelivSchedField<String>("CustomerPointOfConsumption");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HighPriorityStockKey</b>
     * </p>
     *
     * @return Key for high priority stock
     */
    @SerializedName( "HighPriorityStockKey" )
    @JsonProperty( "HighPriorityStockKey" )
    @Nullable
    @ODataField( odataName = "HighPriorityStockKey" )
    private String highPriorityStockKey;
    /**
     * Use with available fluent helpers to apply the <b>HighPriorityStockKey</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> HIGH_PRIORITY_STOCK_KEY =
        new SalesSchedgAgrmtDelivSchedField<String>("HighPriorityStockKey");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CumltvQtyFsclYearRsetDate</b>
     * </p>
     *
     * @return Date on which cumulative received quantity set to zero
     */
    @SerializedName( "CumltvQtyFsclYearRsetDate" )
    @JsonProperty( "CumltvQtyFsclYearRsetDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CumltvQtyFsclYearRsetDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime cumltvQtyFsclYearRsetDate;
    /**
     * Use with available fluent helpers to apply the <b>CumltvQtyFsclYearRsetDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> CUMLTV_QTY_FSCL_YEAR_RSET_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("CumltvQtyFsclYearRsetDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatlGoAheadValidityPeriod</b>
     * </p>
     *
     * @return Material go-ahead - validity period
     */
    @SerializedName( "MatlGoAheadValidityPeriod" )
    @JsonProperty( "MatlGoAheadValidityPeriod" )
    @Nullable
    @ODataField( odataName = "MatlGoAheadValidityPeriod" )
    private String matlGoAheadValidityPeriod;
    /**
     * Use with available fluent helpers to apply the <b>MatlGoAheadValidityPeriod</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> MATL_GO_AHEAD_VALIDITY_PERIOD =
        new SalesSchedgAgrmtDelivSchedField<String>("MatlGoAheadValidityPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlGoAheadValidityPeriodUnit</b>
     * </p>
     *
     * @return Material go-ahead - unit validity period
     */
    @SerializedName( "MatlGoAheadValidityPeriodUnit" )
    @JsonProperty( "MatlGoAheadValidityPeriodUnit" )
    @Nullable
    @ODataField( odataName = "MatlGoAheadValidityPeriodUnit" )
    private String matlGoAheadValidityPeriodUnit;
    /**
     * Use with available fluent helpers to apply the <b>MatlGoAheadValidityPeriodUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> MATL_GO_AHEAD_VALIDITY_PERIOD_UNIT =
        new SalesSchedgAgrmtDelivSchedField<String>("MatlGoAheadValidityPeriodUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadValidityPeriod</b>
     * </p>
     *
     * @return Production go-ahead - validity period
     */
    @SerializedName( "ProdnGoAheadValidityPeriod" )
    @JsonProperty( "ProdnGoAheadValidityPeriod" )
    @Nullable
    @ODataField( odataName = "ProdnGoAheadValidityPeriod" )
    private String prodnGoAheadValidityPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ProdnGoAheadValidityPeriod</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> PRODN_GO_AHEAD_VALIDITY_PERIOD =
        new SalesSchedgAgrmtDelivSchedField<String>("ProdnGoAheadValidityPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadValidityPeriodUnit</b>
     * </p>
     *
     * @return Production go-ahead - Unit validity period
     */
    @SerializedName( "ProdnGoAheadValidityPeriodUnit" )
    @JsonProperty( "ProdnGoAheadValidityPeriodUnit" )
    @Nullable
    @ODataField( odataName = "ProdnGoAheadValidityPeriodUnit" )
    private String prodnGoAheadValidityPeriodUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnGoAheadValidityPeriodUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> PRODN_GO_AHEAD_VALIDITY_PERIOD_UNIT =
        new SalesSchedgAgrmtDelivSchedField<String>("ProdnGoAheadValidityPeriodUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustRcvdCumltvQtyByFsclYrChg</b>
     * </p>
     *
     * @return Cumulative quantity reached on date zero setting made
     */
    @SerializedName( "CustRcvdCumltvQtyByFsclYrChg" )
    @JsonProperty( "CustRcvdCumltvQtyByFsclYrChg" )
    @Nullable
    @ODataField( odataName = "CustRcvdCumltvQtyByFsclYrChg" )
    private BigDecimal custRcvdCumltvQtyByFsclYrChg;
    /**
     * Use with available fluent helpers to apply the <b>CustRcvdCumltvQtyByFsclYrChg</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> CUST_RCVD_CUMLTV_QTY_BY_FSCL_YR_CHG =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("CustRcvdCumltvQtyByFsclYrChg");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LastReceiptQuantity</b>
     * </p>
     *
     * @return Last delivery quantity received by the customer
     */
    @SerializedName( "LastReceiptQuantity" )
    @JsonProperty( "LastReceiptQuantity" )
    @Nullable
    @ODataField( odataName = "LastReceiptQuantity" )
    private BigDecimal lastReceiptQuantity;
    /**
     * Use with available fluent helpers to apply the <b>LastReceiptQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> LAST_RECEIPT_QUANTITY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("LastReceiptQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeReceiptQuantity</b>
     * </p>
     *
     * @return Cumulative Quantity Received by Customer
     */
    @SerializedName( "CumulativeReceiptQuantity" )
    @JsonProperty( "CumulativeReceiptQuantity" )
    @Nullable
    @ODataField( odataName = "CumulativeReceiptQuantity" )
    private BigDecimal cumulativeReceiptQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CumulativeReceiptQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> CUMULATIVE_RECEIPT_QUANTITY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("CumulativeReceiptQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HghstDelivGoAheadCumltvQty</b>
     * </p>
     *
     * @return Highest delivery go-ahead cumulative quantity
     */
    @SerializedName( "HghstDelivGoAheadCumltvQty" )
    @JsonProperty( "HghstDelivGoAheadCumltvQty" )
    @Nullable
    @ODataField( odataName = "HghstDelivGoAheadCumltvQty" )
    private BigDecimal hghstDelivGoAheadCumltvQty;
    /**
     * Use with available fluent helpers to apply the <b>HghstDelivGoAheadCumltvQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> HGHST_DELIV_GO_AHEAD_CUMLTV_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("HghstDelivGoAheadCumltvQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlMatlGoAheadCumltvQty</b>
     * </p>
     *
     * @return Actual cumulative material go-ahead quantity
     */
    @SerializedName( "ActlMatlGoAheadCumltvQty" )
    @JsonProperty( "ActlMatlGoAheadCumltvQty" )
    @Nullable
    @ODataField( odataName = "ActlMatlGoAheadCumltvQty" )
    private BigDecimal actlMatlGoAheadCumltvQty;
    /**
     * Use with available fluent helpers to apply the <b>ActlMatlGoAheadCumltvQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> ACTL_MATL_GO_AHEAD_CUMLTV_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("ActlMatlGoAheadCumltvQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlProdnGoAheadCumltvQty</b>
     * </p>
     *
     * @return Actual cumulative production go-ahead quantity
     */
    @SerializedName( "ActlProdnGoAheadCumltvQty" )
    @JsonProperty( "ActlProdnGoAheadCumltvQty" )
    @Nullable
    @ODataField( odataName = "ActlProdnGoAheadCumltvQty" )
    private BigDecimal actlProdnGoAheadCumltvQty;
    /**
     * Use with available fluent helpers to apply the <b>ActlProdnGoAheadCumltvQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> ACTL_PRODN_GO_AHEAD_CUMLTV_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("ActlProdnGoAheadCumltvQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlDelivGoAheadCumltvQty</b>
     * </p>
     *
     * @return Actual cumulative delivery go-ahead quantity
     */
    @SerializedName( "ActlDelivGoAheadCumltvQty" )
    @JsonProperty( "ActlDelivGoAheadCumltvQty" )
    @Nullable
    @ODataField( odataName = "ActlDelivGoAheadCumltvQty" )
    private BigDecimal actlDelivGoAheadCumltvQty;
    /**
     * Use with available fluent helpers to apply the <b>ActlDelivGoAheadCumltvQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> ACTL_DELIV_GO_AHEAD_CUMLTV_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("ActlDelivGoAheadCumltvQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HghstMatlGoAheadCumltvQty</b>
     * </p>
     *
     * @return Highest cumulative material go-ahead quantity
     */
    @SerializedName( "HghstMatlGoAheadCumltvQty" )
    @JsonProperty( "HghstMatlGoAheadCumltvQty" )
    @Nullable
    @ODataField( odataName = "HghstMatlGoAheadCumltvQty" )
    private BigDecimal hghstMatlGoAheadCumltvQty;
    /**
     * Use with available fluent helpers to apply the <b>HghstMatlGoAheadCumltvQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> HGHST_MATL_GO_AHEAD_CUMLTV_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("HghstMatlGoAheadCumltvQty");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryNoteSentByExtAgt</b>
     * </p>
     *
     * @return Last dlv. note sent by ext. service agent to the customer
     */
    @SerializedName( "LastDeliveryNoteSentByExtAgt" )
    @JsonProperty( "LastDeliveryNoteSentByExtAgt" )
    @Nullable
    @ODataField( odataName = "LastDeliveryNoteSentByExtAgt" )
    private String lastDeliveryNoteSentByExtAgt;
    /**
     * Use with available fluent helpers to apply the <b>LastDeliveryNoteSentByExtAgt</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> LAST_DELIVERY_NOTE_SENT_BY_EXT_AGT =
        new SalesSchedgAgrmtDelivSchedField<String>("LastDeliveryNoteSentByExtAgt");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryNoteSentDate</b>
     * </p>
     *
     * @return Date of last delivery sent by external agent to customer
     */
    @SerializedName( "LastDeliveryNoteSentDate" )
    @JsonProperty( "LastDeliveryNoteSentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastDeliveryNoteSentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastDeliveryNoteSentDate;
    /**
     * Use with available fluent helpers to apply the <b>LastDeliveryNoteSentDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> LAST_DELIVERY_NOTE_SENT_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("LastDeliveryNoteSentDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryCumltvIssdQty</b>
     * </p>
     *
     * @return Cumulative issued quantity for the last delivery
     */
    @SerializedName( "LastDeliveryCumltvIssdQty" )
    @JsonProperty( "LastDeliveryCumltvIssdQty" )
    @Nullable
    @ODataField( odataName = "LastDeliveryCumltvIssdQty" )
    private BigDecimal lastDeliveryCumltvIssdQty;
    /**
     * Use with available fluent helpers to apply the <b>LastDeliveryCumltvIssdQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> LAST_DELIVERY_CUMLTV_ISSD_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("LastDeliveryCumltvIssdQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalAgentCumltvIssdQty</b>
     * </p>
     *
     * @return Cumulative quantity issued by external agent
     */
    @SerializedName( "ExternalAgentCumltvIssdQty" )
    @JsonProperty( "ExternalAgentCumltvIssdQty" )
    @Nullable
    @ODataField( odataName = "ExternalAgentCumltvIssdQty" )
    private BigDecimal externalAgentCumltvIssdQty;
    /**
     * Use with available fluent helpers to apply the <b>ExternalAgentCumltvIssdQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> EXTERNAL_AGENT_CUMLTV_ISSD_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("ExternalAgentCumltvIssdQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeIssuedQuantity</b>
     * </p>
     *
     * @return Cumulative issued quantity
     */
    @SerializedName( "CumulativeIssuedQuantity" )
    @JsonProperty( "CumulativeIssuedQuantity" )
    @Nullable
    @ODataField( odataName = "CumulativeIssuedQuantity" )
    private BigDecimal cumulativeIssuedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CumulativeIssuedQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> CUMULATIVE_ISSUED_QUANTITY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("CumulativeIssuedQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeDeliveredQuantity</b>
     * </p>
     *
     * @return Cumulative qty for delivery/MAIS in base unit of measure
     */
    @SerializedName( "CumulativeDeliveredQuantity" )
    @JsonProperty( "CumulativeDeliveredQuantity" )
    @Nullable
    @ODataField( odataName = "CumulativeDeliveredQuantity" )
    private BigDecimal cumulativeDeliveredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CumulativeDeliveredQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> CUMULATIVE_DELIVERED_QUANTITY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("CumulativeDeliveredQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeInTransitQuantity</b>
     * </p>
     *
     * @return Difference between customer and current cumulative qties
     */
    @SerializedName( "CumulativeInTransitQuantity" )
    @JsonProperty( "CumulativeInTransitQuantity" )
    @Nullable
    @ODataField( odataName = "CumulativeInTransitQuantity" )
    private BigDecimal cumulativeInTransitQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CumulativeInTransitQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> CUMULATIVE_IN_TRANSIT_QUANTITY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("CumulativeInTransitQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtInTrnstQty</b>
     * </p>
     *
     * @return Quantity in transit on the basis of the specified delivery
     */
    @SerializedName( "SalesSchedgAgrmtInTrnstQty" )
    @JsonProperty( "SalesSchedgAgrmtInTrnstQty" )
    @Nullable
    @ODataField( odataName = "SalesSchedgAgrmtInTrnstQty" )
    private BigDecimal salesSchedgAgrmtInTrnstQty;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedgAgrmtInTrnstQty</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<BigDecimal> SALES_SCHEDG_AGRMT_IN_TRNST_QTY =
        new SalesSchedgAgrmtDelivSchedField<BigDecimal>("SalesSchedgAgrmtInTrnstQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<String> ORDER_QUANTITY_UNIT =
        new SalesSchedgAgrmtDelivSchedField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedField<LocalDateTime> LAST_CHANGE_DATE =
        new SalesSchedgAgrmtDelivSchedField<LocalDateTime>("LastChangeDate");
    /**
     * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtDelivSched</b> to single
     * <b>SalesSchedgAgrmt</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmt" )
    @JsonProperty( "to_SalesSchedgAgrmt" )
    @ODataField( odataName = "to_SalesSchedgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmt toSalesSchedgAgrmt;
    /**
     * Navigation property <b>to_SalesSchedgAgrmtSchedLine</b> for <b>SalesSchedgAgrmtDelivSched</b> to multiple
     * <b>SalesSchedgAgrmtSchedLine</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtSchedLine" )
    @JsonProperty( "to_SalesSchedgAgrmtSchedLine" )
    @ODataField( odataName = "to_SalesSchedgAgrmtSchedLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesSchedgAgrmtSchedLine> toSalesSchedgAgrmtSchedLine;
    /**
     * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtDelivSched</b> to single
     * <b>SalesSchedgAgrmtItem</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtItem" )
    @JsonProperty( "to_SalesSchedgAgrmtItem" )
    @ODataField( odataName = "to_SalesSchedgAgrmtItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmt</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedOneToOneLink<SalesSchedgAgrmt> TO_SALES_SCHEDG_AGRMT =
        new SalesSchedgAgrmtDelivSchedOneToOneLink<SalesSchedgAgrmt>("to_SalesSchedgAgrmt");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtSchedLine</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedLink<SalesSchedgAgrmtSchedLine> TO_SALES_SCHEDG_AGRMT_SCHED_LINE =
        new SalesSchedgAgrmtDelivSchedLink<SalesSchedgAgrmtSchedLine>("to_SalesSchedgAgrmtSchedLine");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtDelivSchedOneToOneLink<SalesSchedgAgrmtItem> TO_SALES_SCHEDG_AGRMT_ITEM =
        new SalesSchedgAgrmtDelivSchedOneToOneLink<SalesSchedgAgrmtItem>("to_SalesSchedgAgrmtItem");

    @Nonnull
    @Override
    public Class<SalesSchedgAgrmtDelivSched> getType()
    {
        return SalesSchedgAgrmtDelivSched.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @param salesSchedulingAgreement
     *            Sales Document
     */
    public void setSalesSchedulingAgreement( @Nullable final String salesSchedulingAgreement )
    {
        rememberChangedField("SalesSchedulingAgreement", this.salesSchedulingAgreement);
        this.salesSchedulingAgreement = salesSchedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @param salesSchedulingAgreementItem
     *            Sales Document Item
     */
    public void setSalesSchedulingAgreementItem( @Nullable final String salesSchedulingAgreementItem )
    {
        rememberChangedField("SalesSchedulingAgreementItem", this.salesSchedulingAgreementItem);
        this.salesSchedulingAgreementItem = salesSchedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IntDeliveryScheduleNumber</b>
     * </p>
     *
     * @param intDeliveryScheduleNumber
     *            Internal delivery schedule number
     */
    public void setIntDeliveryScheduleNumber( @Nullable final String intDeliveryScheduleNumber )
    {
        rememberChangedField("IntDeliveryScheduleNumber", this.intDeliveryScheduleNumber);
        this.intDeliveryScheduleNumber = intDeliveryScheduleNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementReleaseType</b>
     * </p>
     *
     * @param schedulingAgreementReleaseType
     *            Release type
     */
    public void setSchedulingAgreementReleaseType( @Nullable final String schedulingAgreementReleaseType )
    {
        rememberChangedField("SchedulingAgreementReleaseType", this.schedulingAgreementReleaseType);
        this.schedulingAgreementReleaseType = schedulingAgreementReleaseType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleStartDate</b>
     * </p>
     *
     * @param deliveryScheduleStartDate
     *            Valid-from date of delivery schedule
     */
    public void setDeliveryScheduleStartDate( @Nullable final LocalDateTime deliveryScheduleStartDate )
    {
        rememberChangedField("DeliveryScheduleStartDate", this.deliveryScheduleStartDate);
        this.deliveryScheduleStartDate = deliveryScheduleStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleEndDate</b>
     * </p>
     *
     * @param deliveryScheduleEndDate
     *            Valid-to date of delivery schedule
     */
    public void setDeliveryScheduleEndDate( @Nullable final LocalDateTime deliveryScheduleEndDate )
    {
        rememberChangedField("DeliveryScheduleEndDate", this.deliveryScheduleEndDate);
        this.deliveryScheduleEndDate = deliveryScheduleEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustomerDeliveryScheduleNumber</b>
     * </p>
     *
     * @param customerDeliveryScheduleNumber
     *            Delivery Schedule
     */
    public void setCustomerDeliveryScheduleNumber( @Nullable final String customerDeliveryScheduleNumber )
    {
        rememberChangedField("CustomerDeliveryScheduleNumber", this.customerDeliveryScheduleNumber);
        this.customerDeliveryScheduleNumber = customerDeliveryScheduleNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleDate</b>
     * </p>
     *
     * @param deliveryScheduleDate
     *            Delivery Schedule Date
     */
    public void setDeliveryScheduleDate( @Nullable final LocalDateTime deliveryScheduleDate )
    {
        rememberChangedField("DeliveryScheduleDate", this.deliveryScheduleDate);
        this.deliveryScheduleDate = deliveryScheduleDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDateKey</b>
     * </p>
     *
     * @param scheduleLineDateKey
     *            Date Key for Schedule Line Date
     */
    public void setScheduleLineDateKey( @Nullable final String scheduleLineDateKey )
    {
        rememberChangedField("ScheduleLineDateKey", this.scheduleLineDateKey);
        this.scheduleLineDateKey = scheduleLineDateKey;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryDocPostingDate</b>
     * </p>
     *
     * @param lastDeliveryDocPostingDate
     *            Last Delivery Date
     */
    public void setLastDeliveryDocPostingDate( @Nullable final LocalDateTime lastDeliveryDocPostingDate )
    {
        rememberChangedField("LastDeliveryDocPostingDate", this.lastDeliveryDocPostingDate);
        this.lastDeliveryDocPostingDate = lastDeliveryDocPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryDocument</b>
     * </p>
     *
     * @param lastDeliveryDocument
     *            Last Delivery Confirmed by The Customer
     */
    public void setLastDeliveryDocument( @Nullable final String lastDeliveryDocument )
    {
        rememberChangedField("LastDeliveryDocument", this.lastDeliveryDocument);
        this.lastDeliveryDocument = lastDeliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastIntDeliveryScheduleNumber</b>
     * </p>
     *
     * @param lastIntDeliveryScheduleNumber
     *            Last internal release order number
     */
    public void setLastIntDeliveryScheduleNumber( @Nullable final String lastIntDeliveryScheduleNumber )
    {
        rememberChangedField("LastIntDeliveryScheduleNumber", this.lastIntDeliveryScheduleNumber);
        this.lastIntDeliveryScheduleNumber = lastIntDeliveryScheduleNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JITHorizonEndDate</b>
     * </p>
     *
     * @param jITHorizonEndDate
     *            JIT Horizon
     */
    public void setJITHorizonEndDate( @Nullable final LocalDateTime jITHorizonEndDate )
    {
        rememberChangedField("JITHorizonEndDate", this.jITHorizonEndDate);
        this.jITHorizonEndDate = jITHorizonEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerFiscalYear</b>
     * </p>
     *
     * @param customerFiscalYear
     *            Customer Fiscal Year
     */
    public void setCustomerFiscalYear( @Nullable final String customerFiscalYear )
    {
        rememberChangedField("CustomerFiscalYear", this.customerFiscalYear);
        this.customerFiscalYear = customerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RequirementsStatusKey</b>
     * </p>
     *
     * @param requirementsStatusKey
     *            Requirements status key
     */
    public void setRequirementsStatusKey( @Nullable final String requirementsStatusKey )
    {
        rememberChangedField("RequirementsStatusKey", this.requirementsStatusKey);
        this.requirementsStatusKey = requirementsStatusKey;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryScheduleCreationDate</b>
     * </p>
     *
     * @param deliveryScheduleCreationDate
     *            Delivery schedule date of creation
     */
    public void setDeliveryScheduleCreationDate( @Nullable final LocalDateTime deliveryScheduleCreationDate )
    {
        rememberChangedField("DeliveryScheduleCreationDate", this.deliveryScheduleCreationDate);
        this.deliveryScheduleCreationDate = deliveryScheduleCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib01</b>
     * </p>
     *
     * @param delivSchedFreeDefinedAttrib01
     *            Additional data field 1 for delivery schedules
     */
    public void setDelivSchedFreeDefinedAttrib01( @Nullable final String delivSchedFreeDefinedAttrib01 )
    {
        rememberChangedField("DelivSchedFreeDefinedAttrib01", this.delivSchedFreeDefinedAttrib01);
        this.delivSchedFreeDefinedAttrib01 = delivSchedFreeDefinedAttrib01;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib02</b>
     * </p>
     *
     * @param delivSchedFreeDefinedAttrib02
     *            Additional data field 2 for delivery schedules
     */
    public void setDelivSchedFreeDefinedAttrib02( @Nullable final String delivSchedFreeDefinedAttrib02 )
    {
        rememberChangedField("DelivSchedFreeDefinedAttrib02", this.delivSchedFreeDefinedAttrib02);
        this.delivSchedFreeDefinedAttrib02 = delivSchedFreeDefinedAttrib02;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib03</b>
     * </p>
     *
     * @param delivSchedFreeDefinedAttrib03
     *            Additional data field 3 for delivery schedules
     */
    public void setDelivSchedFreeDefinedAttrib03( @Nullable final String delivSchedFreeDefinedAttrib03 )
    {
        rememberChangedField("DelivSchedFreeDefinedAttrib03", this.delivSchedFreeDefinedAttrib03);
        this.delivSchedFreeDefinedAttrib03 = delivSchedFreeDefinedAttrib03;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib04</b>
     * </p>
     *
     * @param delivSchedFreeDefinedAttrib04
     *            Additional data field 4 for delivery schedules
     */
    public void setDelivSchedFreeDefinedAttrib04( @Nullable final String delivSchedFreeDefinedAttrib04 )
    {
        rememberChangedField("DelivSchedFreeDefinedAttrib04", this.delivSchedFreeDefinedAttrib04);
        this.delivSchedFreeDefinedAttrib04 = delivSchedFreeDefinedAttrib04;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DelivSchedFreeDefinedAttrib05</b>
     * </p>
     *
     * @param delivSchedFreeDefinedAttrib05
     *            Additional data field 5 for delivery schedules
     */
    public void setDelivSchedFreeDefinedAttrib05( @Nullable final String delivSchedFreeDefinedAttrib05 )
    {
        rememberChangedField("DelivSchedFreeDefinedAttrib05", this.delivSchedFreeDefinedAttrib05);
        this.delivSchedFreeDefinedAttrib05 = delivSchedFreeDefinedAttrib05;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadPeriodStartDate</b>
     * </p>
     *
     * @param prodnGoAheadPeriodStartDate
     *            Start of production go-ahead
     */
    public void setProdnGoAheadPeriodStartDate( @Nullable final LocalDateTime prodnGoAheadPeriodStartDate )
    {
        rememberChangedField("ProdnGoAheadPeriodStartDate", this.prodnGoAheadPeriodStartDate);
        this.prodnGoAheadPeriodStartDate = prodnGoAheadPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionGoAheadPeriodEndDate</b>
     * </p>
     *
     * @param productionGoAheadPeriodEndDate
     *            End of production go-ahead
     */
    public void setProductionGoAheadPeriodEndDate( @Nullable final LocalDateTime productionGoAheadPeriodEndDate )
    {
        rememberChangedField("ProductionGoAheadPeriodEndDate", this.productionGoAheadPeriodEndDate);
        this.productionGoAheadPeriodEndDate = productionGoAheadPeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoAheadPeriodStartDate</b>
     * </p>
     *
     * @param materialGoAheadPeriodStartDate
     *            Start of material go-ahead
     */
    public void setMaterialGoAheadPeriodStartDate( @Nullable final LocalDateTime materialGoAheadPeriodStartDate )
    {
        rememberChangedField("MaterialGoAheadPeriodStartDate", this.materialGoAheadPeriodStartDate);
        this.materialGoAheadPeriodStartDate = materialGoAheadPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoAheadPeriodEndDate</b>
     * </p>
     *
     * @param materialGoAheadPeriodEndDate
     *            End of material go-ahead
     */
    public void setMaterialGoAheadPeriodEndDate( @Nullable final LocalDateTime materialGoAheadPeriodEndDate )
    {
        rememberChangedField("MaterialGoAheadPeriodEndDate", this.materialGoAheadPeriodEndDate);
        this.materialGoAheadPeriodEndDate = materialGoAheadPeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPointOfConsumption</b>
     * </p>
     *
     * @param customerPointOfConsumption
     *            Customer point of consumption
     */
    public void setCustomerPointOfConsumption( @Nullable final String customerPointOfConsumption )
    {
        rememberChangedField("CustomerPointOfConsumption", this.customerPointOfConsumption);
        this.customerPointOfConsumption = customerPointOfConsumption;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HighPriorityStockKey</b>
     * </p>
     *
     * @param highPriorityStockKey
     *            Key for high priority stock
     */
    public void setHighPriorityStockKey( @Nullable final String highPriorityStockKey )
    {
        rememberChangedField("HighPriorityStockKey", this.highPriorityStockKey);
        this.highPriorityStockKey = highPriorityStockKey;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CumltvQtyFsclYearRsetDate</b>
     * </p>
     *
     * @param cumltvQtyFsclYearRsetDate
     *            Date on which cumulative received quantity set to zero
     */
    public void setCumltvQtyFsclYearRsetDate( @Nullable final LocalDateTime cumltvQtyFsclYearRsetDate )
    {
        rememberChangedField("CumltvQtyFsclYearRsetDate", this.cumltvQtyFsclYearRsetDate);
        this.cumltvQtyFsclYearRsetDate = cumltvQtyFsclYearRsetDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatlGoAheadValidityPeriod</b>
     * </p>
     *
     * @param matlGoAheadValidityPeriod
     *            Material go-ahead - validity period
     */
    public void setMatlGoAheadValidityPeriod( @Nullable final String matlGoAheadValidityPeriod )
    {
        rememberChangedField("MatlGoAheadValidityPeriod", this.matlGoAheadValidityPeriod);
        this.matlGoAheadValidityPeriod = matlGoAheadValidityPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlGoAheadValidityPeriodUnit</b>
     * </p>
     *
     * @param matlGoAheadValidityPeriodUnit
     *            Material go-ahead - unit validity period
     */
    public void setMatlGoAheadValidityPeriodUnit( @Nullable final String matlGoAheadValidityPeriodUnit )
    {
        rememberChangedField("MatlGoAheadValidityPeriodUnit", this.matlGoAheadValidityPeriodUnit);
        this.matlGoAheadValidityPeriodUnit = matlGoAheadValidityPeriodUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadValidityPeriod</b>
     * </p>
     *
     * @param prodnGoAheadValidityPeriod
     *            Production go-ahead - validity period
     */
    public void setProdnGoAheadValidityPeriod( @Nullable final String prodnGoAheadValidityPeriod )
    {
        rememberChangedField("ProdnGoAheadValidityPeriod", this.prodnGoAheadValidityPeriod);
        this.prodnGoAheadValidityPeriod = prodnGoAheadValidityPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnGoAheadValidityPeriodUnit</b>
     * </p>
     *
     * @param prodnGoAheadValidityPeriodUnit
     *            Production go-ahead - Unit validity period
     */
    public void setProdnGoAheadValidityPeriodUnit( @Nullable final String prodnGoAheadValidityPeriodUnit )
    {
        rememberChangedField("ProdnGoAheadValidityPeriodUnit", this.prodnGoAheadValidityPeriodUnit);
        this.prodnGoAheadValidityPeriodUnit = prodnGoAheadValidityPeriodUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustRcvdCumltvQtyByFsclYrChg</b>
     * </p>
     *
     * @param custRcvdCumltvQtyByFsclYrChg
     *            Cumulative quantity reached on date zero setting made
     */
    public void setCustRcvdCumltvQtyByFsclYrChg( @Nullable final BigDecimal custRcvdCumltvQtyByFsclYrChg )
    {
        rememberChangedField("CustRcvdCumltvQtyByFsclYrChg", this.custRcvdCumltvQtyByFsclYrChg);
        this.custRcvdCumltvQtyByFsclYrChg = custRcvdCumltvQtyByFsclYrChg;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LastReceiptQuantity</b>
     * </p>
     *
     * @param lastReceiptQuantity
     *            Last delivery quantity received by the customer
     */
    public void setLastReceiptQuantity( @Nullable final BigDecimal lastReceiptQuantity )
    {
        rememberChangedField("LastReceiptQuantity", this.lastReceiptQuantity);
        this.lastReceiptQuantity = lastReceiptQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeReceiptQuantity</b>
     * </p>
     *
     * @param cumulativeReceiptQuantity
     *            Cumulative Quantity Received by Customer
     */
    public void setCumulativeReceiptQuantity( @Nullable final BigDecimal cumulativeReceiptQuantity )
    {
        rememberChangedField("CumulativeReceiptQuantity", this.cumulativeReceiptQuantity);
        this.cumulativeReceiptQuantity = cumulativeReceiptQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HghstDelivGoAheadCumltvQty</b>
     * </p>
     *
     * @param hghstDelivGoAheadCumltvQty
     *            Highest delivery go-ahead cumulative quantity
     */
    public void setHghstDelivGoAheadCumltvQty( @Nullable final BigDecimal hghstDelivGoAheadCumltvQty )
    {
        rememberChangedField("HghstDelivGoAheadCumltvQty", this.hghstDelivGoAheadCumltvQty);
        this.hghstDelivGoAheadCumltvQty = hghstDelivGoAheadCumltvQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlMatlGoAheadCumltvQty</b>
     * </p>
     *
     * @param actlMatlGoAheadCumltvQty
     *            Actual cumulative material go-ahead quantity
     */
    public void setActlMatlGoAheadCumltvQty( @Nullable final BigDecimal actlMatlGoAheadCumltvQty )
    {
        rememberChangedField("ActlMatlGoAheadCumltvQty", this.actlMatlGoAheadCumltvQty);
        this.actlMatlGoAheadCumltvQty = actlMatlGoAheadCumltvQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlProdnGoAheadCumltvQty</b>
     * </p>
     *
     * @param actlProdnGoAheadCumltvQty
     *            Actual cumulative production go-ahead quantity
     */
    public void setActlProdnGoAheadCumltvQty( @Nullable final BigDecimal actlProdnGoAheadCumltvQty )
    {
        rememberChangedField("ActlProdnGoAheadCumltvQty", this.actlProdnGoAheadCumltvQty);
        this.actlProdnGoAheadCumltvQty = actlProdnGoAheadCumltvQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActlDelivGoAheadCumltvQty</b>
     * </p>
     *
     * @param actlDelivGoAheadCumltvQty
     *            Actual cumulative delivery go-ahead quantity
     */
    public void setActlDelivGoAheadCumltvQty( @Nullable final BigDecimal actlDelivGoAheadCumltvQty )
    {
        rememberChangedField("ActlDelivGoAheadCumltvQty", this.actlDelivGoAheadCumltvQty);
        this.actlDelivGoAheadCumltvQty = actlDelivGoAheadCumltvQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HghstMatlGoAheadCumltvQty</b>
     * </p>
     *
     * @param hghstMatlGoAheadCumltvQty
     *            Highest cumulative material go-ahead quantity
     */
    public void setHghstMatlGoAheadCumltvQty( @Nullable final BigDecimal hghstMatlGoAheadCumltvQty )
    {
        rememberChangedField("HghstMatlGoAheadCumltvQty", this.hghstMatlGoAheadCumltvQty);
        this.hghstMatlGoAheadCumltvQty = hghstMatlGoAheadCumltvQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryNoteSentByExtAgt</b>
     * </p>
     *
     * @param lastDeliveryNoteSentByExtAgt
     *            Last dlv. note sent by ext. service agent to the customer
     */
    public void setLastDeliveryNoteSentByExtAgt( @Nullable final String lastDeliveryNoteSentByExtAgt )
    {
        rememberChangedField("LastDeliveryNoteSentByExtAgt", this.lastDeliveryNoteSentByExtAgt);
        this.lastDeliveryNoteSentByExtAgt = lastDeliveryNoteSentByExtAgt;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryNoteSentDate</b>
     * </p>
     *
     * @param lastDeliveryNoteSentDate
     *            Date of last delivery sent by external agent to customer
     */
    public void setLastDeliveryNoteSentDate( @Nullable final LocalDateTime lastDeliveryNoteSentDate )
    {
        rememberChangedField("LastDeliveryNoteSentDate", this.lastDeliveryNoteSentDate);
        this.lastDeliveryNoteSentDate = lastDeliveryNoteSentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LastDeliveryCumltvIssdQty</b>
     * </p>
     *
     * @param lastDeliveryCumltvIssdQty
     *            Cumulative issued quantity for the last delivery
     */
    public void setLastDeliveryCumltvIssdQty( @Nullable final BigDecimal lastDeliveryCumltvIssdQty )
    {
        rememberChangedField("LastDeliveryCumltvIssdQty", this.lastDeliveryCumltvIssdQty);
        this.lastDeliveryCumltvIssdQty = lastDeliveryCumltvIssdQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalAgentCumltvIssdQty</b>
     * </p>
     *
     * @param externalAgentCumltvIssdQty
     *            Cumulative quantity issued by external agent
     */
    public void setExternalAgentCumltvIssdQty( @Nullable final BigDecimal externalAgentCumltvIssdQty )
    {
        rememberChangedField("ExternalAgentCumltvIssdQty", this.externalAgentCumltvIssdQty);
        this.externalAgentCumltvIssdQty = externalAgentCumltvIssdQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeIssuedQuantity</b>
     * </p>
     *
     * @param cumulativeIssuedQuantity
     *            Cumulative issued quantity
     */
    public void setCumulativeIssuedQuantity( @Nullable final BigDecimal cumulativeIssuedQuantity )
    {
        rememberChangedField("CumulativeIssuedQuantity", this.cumulativeIssuedQuantity);
        this.cumulativeIssuedQuantity = cumulativeIssuedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeDeliveredQuantity</b>
     * </p>
     *
     * @param cumulativeDeliveredQuantity
     *            Cumulative qty for delivery/MAIS in base unit of measure
     */
    public void setCumulativeDeliveredQuantity( @Nullable final BigDecimal cumulativeDeliveredQuantity )
    {
        rememberChangedField("CumulativeDeliveredQuantity", this.cumulativeDeliveredQuantity);
        this.cumulativeDeliveredQuantity = cumulativeDeliveredQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeInTransitQuantity</b>
     * </p>
     *
     * @param cumulativeInTransitQuantity
     *            Difference between customer and current cumulative qties
     */
    public void setCumulativeInTransitQuantity( @Nullable final BigDecimal cumulativeInTransitQuantity )
    {
        rememberChangedField("CumulativeInTransitQuantity", this.cumulativeInTransitQuantity);
        this.cumulativeInTransitQuantity = cumulativeInTransitQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtInTrnstQty</b>
     * </p>
     *
     * @param salesSchedgAgrmtInTrnstQty
     *            Quantity in transit on the basis of the specified delivery
     */
    public void setSalesSchedgAgrmtInTrnstQty( @Nullable final BigDecimal salesSchedgAgrmtInTrnstQty )
    {
        rememberChangedField("SalesSchedgAgrmtInTrnstQty", this.salesSchedgAgrmtInTrnstQty);
        this.salesSchedgAgrmtInTrnstQty = salesSchedgAgrmtInTrnstQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesSchedgAgrmtDelivSched";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        result.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        result.put("IntDeliveryScheduleNumber", getIntDeliveryScheduleNumber());
        result.put("SchedulingAgreementReleaseType", getSchedulingAgreementReleaseType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        values.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        values.put("IntDeliveryScheduleNumber", getIntDeliveryScheduleNumber());
        values.put("SchedulingAgreementReleaseType", getSchedulingAgreementReleaseType());
        values.put("DeliveryScheduleStartDate", getDeliveryScheduleStartDate());
        values.put("DeliveryScheduleEndDate", getDeliveryScheduleEndDate());
        values.put("CustomerDeliveryScheduleNumber", getCustomerDeliveryScheduleNumber());
        values.put("DeliveryScheduleDate", getDeliveryScheduleDate());
        values.put("ScheduleLineDateKey", getScheduleLineDateKey());
        values.put("LastDeliveryDocPostingDate", getLastDeliveryDocPostingDate());
        values.put("LastDeliveryDocument", getLastDeliveryDocument());
        values.put("LastIntDeliveryScheduleNumber", getLastIntDeliveryScheduleNumber());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("JITHorizonEndDate", getJITHorizonEndDate());
        values.put("CustomerFiscalYear", getCustomerFiscalYear());
        values.put("RequirementsStatusKey", getRequirementsStatusKey());
        values.put("DeliveryScheduleCreationDate", getDeliveryScheduleCreationDate());
        values.put("DelivSchedFreeDefinedAttrib01", getDelivSchedFreeDefinedAttrib01());
        values.put("DelivSchedFreeDefinedAttrib02", getDelivSchedFreeDefinedAttrib02());
        values.put("DelivSchedFreeDefinedAttrib03", getDelivSchedFreeDefinedAttrib03());
        values.put("DelivSchedFreeDefinedAttrib04", getDelivSchedFreeDefinedAttrib04());
        values.put("DelivSchedFreeDefinedAttrib05", getDelivSchedFreeDefinedAttrib05());
        values.put("ProdnGoAheadPeriodStartDate", getProdnGoAheadPeriodStartDate());
        values.put("ProductionGoAheadPeriodEndDate", getProductionGoAheadPeriodEndDate());
        values.put("MaterialGoAheadPeriodStartDate", getMaterialGoAheadPeriodStartDate());
        values.put("MaterialGoAheadPeriodEndDate", getMaterialGoAheadPeriodEndDate());
        values.put("CustomerPointOfConsumption", getCustomerPointOfConsumption());
        values.put("HighPriorityStockKey", getHighPriorityStockKey());
        values.put("CumltvQtyFsclYearRsetDate", getCumltvQtyFsclYearRsetDate());
        values.put("MatlGoAheadValidityPeriod", getMatlGoAheadValidityPeriod());
        values.put("MatlGoAheadValidityPeriodUnit", getMatlGoAheadValidityPeriodUnit());
        values.put("ProdnGoAheadValidityPeriod", getProdnGoAheadValidityPeriod());
        values.put("ProdnGoAheadValidityPeriodUnit", getProdnGoAheadValidityPeriodUnit());
        values.put("CustRcvdCumltvQtyByFsclYrChg", getCustRcvdCumltvQtyByFsclYrChg());
        values.put("LastReceiptQuantity", getLastReceiptQuantity());
        values.put("CumulativeReceiptQuantity", getCumulativeReceiptQuantity());
        values.put("HghstDelivGoAheadCumltvQty", getHghstDelivGoAheadCumltvQty());
        values.put("ActlMatlGoAheadCumltvQty", getActlMatlGoAheadCumltvQty());
        values.put("ActlProdnGoAheadCumltvQty", getActlProdnGoAheadCumltvQty());
        values.put("ActlDelivGoAheadCumltvQty", getActlDelivGoAheadCumltvQty());
        values.put("HghstMatlGoAheadCumltvQty", getHghstMatlGoAheadCumltvQty());
        values.put("LastDeliveryNoteSentByExtAgt", getLastDeliveryNoteSentByExtAgt());
        values.put("LastDeliveryNoteSentDate", getLastDeliveryNoteSentDate());
        values.put("LastDeliveryCumltvIssdQty", getLastDeliveryCumltvIssdQty());
        values.put("ExternalAgentCumltvIssdQty", getExternalAgentCumltvIssdQty());
        values.put("CumulativeIssuedQuantity", getCumulativeIssuedQuantity());
        values.put("CumulativeDeliveredQuantity", getCumulativeDeliveredQuantity());
        values.put("CumulativeInTransitQuantity", getCumulativeInTransitQuantity());
        values.put("SalesSchedgAgrmtInTrnstQty", getSalesSchedgAgrmtInTrnstQty());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("LastChangeDate", getLastChangeDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesSchedulingAgreement") ) {
                final Object value = values.remove("SalesSchedulingAgreement");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreement())) ) {
                    setSalesSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreementItem") ) {
                final Object value = values.remove("SalesSchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreementItem())) ) {
                    setSalesSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("IntDeliveryScheduleNumber") ) {
                final Object value = values.remove("IntDeliveryScheduleNumber");
                if( (value == null) || (!value.equals(getIntDeliveryScheduleNumber())) ) {
                    setIntDeliveryScheduleNumber(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementReleaseType") ) {
                final Object value = values.remove("SchedulingAgreementReleaseType");
                if( (value == null) || (!value.equals(getSchedulingAgreementReleaseType())) ) {
                    setSchedulingAgreementReleaseType(((String) value));
                }
            }
            if( values.containsKey("DeliveryScheduleStartDate") ) {
                final Object value = values.remove("DeliveryScheduleStartDate");
                if( (value == null) || (!value.equals(getDeliveryScheduleStartDate())) ) {
                    setDeliveryScheduleStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryScheduleEndDate") ) {
                final Object value = values.remove("DeliveryScheduleEndDate");
                if( (value == null) || (!value.equals(getDeliveryScheduleEndDate())) ) {
                    setDeliveryScheduleEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerDeliveryScheduleNumber") ) {
                final Object value = values.remove("CustomerDeliveryScheduleNumber");
                if( (value == null) || (!value.equals(getCustomerDeliveryScheduleNumber())) ) {
                    setCustomerDeliveryScheduleNumber(((String) value));
                }
            }
            if( values.containsKey("DeliveryScheduleDate") ) {
                final Object value = values.remove("DeliveryScheduleDate");
                if( (value == null) || (!value.equals(getDeliveryScheduleDate())) ) {
                    setDeliveryScheduleDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduleLineDateKey") ) {
                final Object value = values.remove("ScheduleLineDateKey");
                if( (value == null) || (!value.equals(getScheduleLineDateKey())) ) {
                    setScheduleLineDateKey(((String) value));
                }
            }
            if( values.containsKey("LastDeliveryDocPostingDate") ) {
                final Object value = values.remove("LastDeliveryDocPostingDate");
                if( (value == null) || (!value.equals(getLastDeliveryDocPostingDate())) ) {
                    setLastDeliveryDocPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastDeliveryDocument") ) {
                final Object value = values.remove("LastDeliveryDocument");
                if( (value == null) || (!value.equals(getLastDeliveryDocument())) ) {
                    setLastDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("LastIntDeliveryScheduleNumber") ) {
                final Object value = values.remove("LastIntDeliveryScheduleNumber");
                if( (value == null) || (!value.equals(getLastIntDeliveryScheduleNumber())) ) {
                    setLastIntDeliveryScheduleNumber(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("JITHorizonEndDate") ) {
                final Object value = values.remove("JITHorizonEndDate");
                if( (value == null) || (!value.equals(getJITHorizonEndDate())) ) {
                    setJITHorizonEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerFiscalYear") ) {
                final Object value = values.remove("CustomerFiscalYear");
                if( (value == null) || (!value.equals(getCustomerFiscalYear())) ) {
                    setCustomerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("RequirementsStatusKey") ) {
                final Object value = values.remove("RequirementsStatusKey");
                if( (value == null) || (!value.equals(getRequirementsStatusKey())) ) {
                    setRequirementsStatusKey(((String) value));
                }
            }
            if( values.containsKey("DeliveryScheduleCreationDate") ) {
                final Object value = values.remove("DeliveryScheduleCreationDate");
                if( (value == null) || (!value.equals(getDeliveryScheduleCreationDate())) ) {
                    setDeliveryScheduleCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DelivSchedFreeDefinedAttrib01") ) {
                final Object value = values.remove("DelivSchedFreeDefinedAttrib01");
                if( (value == null) || (!value.equals(getDelivSchedFreeDefinedAttrib01())) ) {
                    setDelivSchedFreeDefinedAttrib01(((String) value));
                }
            }
            if( values.containsKey("DelivSchedFreeDefinedAttrib02") ) {
                final Object value = values.remove("DelivSchedFreeDefinedAttrib02");
                if( (value == null) || (!value.equals(getDelivSchedFreeDefinedAttrib02())) ) {
                    setDelivSchedFreeDefinedAttrib02(((String) value));
                }
            }
            if( values.containsKey("DelivSchedFreeDefinedAttrib03") ) {
                final Object value = values.remove("DelivSchedFreeDefinedAttrib03");
                if( (value == null) || (!value.equals(getDelivSchedFreeDefinedAttrib03())) ) {
                    setDelivSchedFreeDefinedAttrib03(((String) value));
                }
            }
            if( values.containsKey("DelivSchedFreeDefinedAttrib04") ) {
                final Object value = values.remove("DelivSchedFreeDefinedAttrib04");
                if( (value == null) || (!value.equals(getDelivSchedFreeDefinedAttrib04())) ) {
                    setDelivSchedFreeDefinedAttrib04(((String) value));
                }
            }
            if( values.containsKey("DelivSchedFreeDefinedAttrib05") ) {
                final Object value = values.remove("DelivSchedFreeDefinedAttrib05");
                if( (value == null) || (!value.equals(getDelivSchedFreeDefinedAttrib05())) ) {
                    setDelivSchedFreeDefinedAttrib05(((String) value));
                }
            }
            if( values.containsKey("ProdnGoAheadPeriodStartDate") ) {
                final Object value = values.remove("ProdnGoAheadPeriodStartDate");
                if( (value == null) || (!value.equals(getProdnGoAheadPeriodStartDate())) ) {
                    setProdnGoAheadPeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductionGoAheadPeriodEndDate") ) {
                final Object value = values.remove("ProductionGoAheadPeriodEndDate");
                if( (value == null) || (!value.equals(getProductionGoAheadPeriodEndDate())) ) {
                    setProductionGoAheadPeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialGoAheadPeriodStartDate") ) {
                final Object value = values.remove("MaterialGoAheadPeriodStartDate");
                if( (value == null) || (!value.equals(getMaterialGoAheadPeriodStartDate())) ) {
                    setMaterialGoAheadPeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialGoAheadPeriodEndDate") ) {
                final Object value = values.remove("MaterialGoAheadPeriodEndDate");
                if( (value == null) || (!value.equals(getMaterialGoAheadPeriodEndDate())) ) {
                    setMaterialGoAheadPeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerPointOfConsumption") ) {
                final Object value = values.remove("CustomerPointOfConsumption");
                if( (value == null) || (!value.equals(getCustomerPointOfConsumption())) ) {
                    setCustomerPointOfConsumption(((String) value));
                }
            }
            if( values.containsKey("HighPriorityStockKey") ) {
                final Object value = values.remove("HighPriorityStockKey");
                if( (value == null) || (!value.equals(getHighPriorityStockKey())) ) {
                    setHighPriorityStockKey(((String) value));
                }
            }
            if( values.containsKey("CumltvQtyFsclYearRsetDate") ) {
                final Object value = values.remove("CumltvQtyFsclYearRsetDate");
                if( (value == null) || (!value.equals(getCumltvQtyFsclYearRsetDate())) ) {
                    setCumltvQtyFsclYearRsetDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MatlGoAheadValidityPeriod") ) {
                final Object value = values.remove("MatlGoAheadValidityPeriod");
                if( (value == null) || (!value.equals(getMatlGoAheadValidityPeriod())) ) {
                    setMatlGoAheadValidityPeriod(((String) value));
                }
            }
            if( values.containsKey("MatlGoAheadValidityPeriodUnit") ) {
                final Object value = values.remove("MatlGoAheadValidityPeriodUnit");
                if( (value == null) || (!value.equals(getMatlGoAheadValidityPeriodUnit())) ) {
                    setMatlGoAheadValidityPeriodUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnGoAheadValidityPeriod") ) {
                final Object value = values.remove("ProdnGoAheadValidityPeriod");
                if( (value == null) || (!value.equals(getProdnGoAheadValidityPeriod())) ) {
                    setProdnGoAheadValidityPeriod(((String) value));
                }
            }
            if( values.containsKey("ProdnGoAheadValidityPeriodUnit") ) {
                final Object value = values.remove("ProdnGoAheadValidityPeriodUnit");
                if( (value == null) || (!value.equals(getProdnGoAheadValidityPeriodUnit())) ) {
                    setProdnGoAheadValidityPeriodUnit(((String) value));
                }
            }
            if( values.containsKey("CustRcvdCumltvQtyByFsclYrChg") ) {
                final Object value = values.remove("CustRcvdCumltvQtyByFsclYrChg");
                if( (value == null) || (!value.equals(getCustRcvdCumltvQtyByFsclYrChg())) ) {
                    setCustRcvdCumltvQtyByFsclYrChg(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastReceiptQuantity") ) {
                final Object value = values.remove("LastReceiptQuantity");
                if( (value == null) || (!value.equals(getLastReceiptQuantity())) ) {
                    setLastReceiptQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CumulativeReceiptQuantity") ) {
                final Object value = values.remove("CumulativeReceiptQuantity");
                if( (value == null) || (!value.equals(getCumulativeReceiptQuantity())) ) {
                    setCumulativeReceiptQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HghstDelivGoAheadCumltvQty") ) {
                final Object value = values.remove("HghstDelivGoAheadCumltvQty");
                if( (value == null) || (!value.equals(getHghstDelivGoAheadCumltvQty())) ) {
                    setHghstDelivGoAheadCumltvQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActlMatlGoAheadCumltvQty") ) {
                final Object value = values.remove("ActlMatlGoAheadCumltvQty");
                if( (value == null) || (!value.equals(getActlMatlGoAheadCumltvQty())) ) {
                    setActlMatlGoAheadCumltvQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActlProdnGoAheadCumltvQty") ) {
                final Object value = values.remove("ActlProdnGoAheadCumltvQty");
                if( (value == null) || (!value.equals(getActlProdnGoAheadCumltvQty())) ) {
                    setActlProdnGoAheadCumltvQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActlDelivGoAheadCumltvQty") ) {
                final Object value = values.remove("ActlDelivGoAheadCumltvQty");
                if( (value == null) || (!value.equals(getActlDelivGoAheadCumltvQty())) ) {
                    setActlDelivGoAheadCumltvQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("HghstMatlGoAheadCumltvQty") ) {
                final Object value = values.remove("HghstMatlGoAheadCumltvQty");
                if( (value == null) || (!value.equals(getHghstMatlGoAheadCumltvQty())) ) {
                    setHghstMatlGoAheadCumltvQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastDeliveryNoteSentByExtAgt") ) {
                final Object value = values.remove("LastDeliveryNoteSentByExtAgt");
                if( (value == null) || (!value.equals(getLastDeliveryNoteSentByExtAgt())) ) {
                    setLastDeliveryNoteSentByExtAgt(((String) value));
                }
            }
            if( values.containsKey("LastDeliveryNoteSentDate") ) {
                final Object value = values.remove("LastDeliveryNoteSentDate");
                if( (value == null) || (!value.equals(getLastDeliveryNoteSentDate())) ) {
                    setLastDeliveryNoteSentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastDeliveryCumltvIssdQty") ) {
                final Object value = values.remove("LastDeliveryCumltvIssdQty");
                if( (value == null) || (!value.equals(getLastDeliveryCumltvIssdQty())) ) {
                    setLastDeliveryCumltvIssdQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExternalAgentCumltvIssdQty") ) {
                final Object value = values.remove("ExternalAgentCumltvIssdQty");
                if( (value == null) || (!value.equals(getExternalAgentCumltvIssdQty())) ) {
                    setExternalAgentCumltvIssdQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("CumulativeIssuedQuantity") ) {
                final Object value = values.remove("CumulativeIssuedQuantity");
                if( (value == null) || (!value.equals(getCumulativeIssuedQuantity())) ) {
                    setCumulativeIssuedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CumulativeDeliveredQuantity") ) {
                final Object value = values.remove("CumulativeDeliveredQuantity");
                if( (value == null) || (!value.equals(getCumulativeDeliveredQuantity())) ) {
                    setCumulativeDeliveredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CumulativeInTransitQuantity") ) {
                final Object value = values.remove("CumulativeInTransitQuantity");
                if( (value == null) || (!value.equals(getCumulativeInTransitQuantity())) ) {
                    setCumulativeInTransitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesSchedgAgrmtInTrnstQty") ) {
                final Object value = values.remove("SalesSchedgAgrmtInTrnstQty");
                if( (value == null) || (!value.equals(getSalesSchedgAgrmtInTrnstQty())) ) {
                    setSalesSchedgAgrmtInTrnstQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesSchedgAgrmt") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmt");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmt == null ) {
                        toSalesSchedgAgrmt = new SalesSchedgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmtSchedLine") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtSchedLine");
                if( value instanceof Iterable ) {
                    if( toSalesSchedgAgrmtSchedLine == null ) {
                        toSalesSchedgAgrmtSchedLine = Lists.newArrayList();
                    } else {
                        toSalesSchedgAgrmtSchedLine = Lists.newArrayList(toSalesSchedgAgrmtSchedLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesSchedgAgrmtSchedLine entity;
                        if( toSalesSchedgAgrmtSchedLine.size() > i ) {
                            entity = toSalesSchedgAgrmtSchedLine.get(i);
                        } else {
                            entity = new SalesSchedgAgrmtSchedLine();
                            toSalesSchedgAgrmtSchedLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmtItem") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtItem");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmtItem == null ) {
                        toSalesSchedgAgrmtItem = new SalesSchedgAgrmtItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmtItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesSchedgAgrmtDelivSchedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SalesSchedgAgrmtDelivSchedField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesSchedgAgrmtDelivSchedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesSchedgAgrmtDelivSchedField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesSchedgAgrmt != null ) {
            (values).put("to_SalesSchedgAgrmt", toSalesSchedgAgrmt);
        }
        if( toSalesSchedgAgrmtSchedLine != null ) {
            (values).put("to_SalesSchedgAgrmtSchedLine", toSalesSchedgAgrmtSchedLine);
        }
        if( toSalesSchedgAgrmtItem != null ) {
            (values).put("to_SalesSchedgAgrmtItem", toSalesSchedgAgrmtItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmt</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmt</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt fetchSalesSchedgAgrmt()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmt", SalesSchedgAgrmt.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmt</b> of a queried <b>SalesSchedgAgrmtDelivSched</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt getSalesSchedgAgrmtOrFetch()
    {
        if( toSalesSchedgAgrmt == null ) {
            toSalesSchedgAgrmt = fetchSalesSchedgAgrmt();
        }
        return toSalesSchedgAgrmt;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtDelivSched</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmt</b> is already loaded, the result will
     *         contain the <b>SalesSchedgAgrmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmt> getSalesSchedgAgrmtIfPresent()
    {
        return Option.of(toSalesSchedgAgrmt);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmt</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmt</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmt</b> entity.
     */
    public void setSalesSchedgAgrmt( final SalesSchedgAgrmt value )
    {
        toSalesSchedgAgrmt = value;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtSchedLine</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SalesSchedgAgrmtSchedLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesSchedgAgrmtSchedLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtSchedLine> fetchSalesSchedgAgrmtSchedLine()
    {
        return fetchFieldAsList("to_SalesSchedgAgrmtSchedLine", SalesSchedgAgrmtSchedLine.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtSchedLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtSchedLine</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtSchedLine</b> of a queried <b>SalesSchedgAgrmtDelivSched</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtSchedLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtSchedLine> getSalesSchedgAgrmtSchedLineOrFetch()
    {
        if( toSalesSchedgAgrmtSchedLine == null ) {
            toSalesSchedgAgrmtSchedLine = fetchSalesSchedgAgrmtSchedLine();
        }
        return toSalesSchedgAgrmtSchedLine;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtSchedLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtSchedLine</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtDelivSched</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtSchedLine</b> is already loaded, the
     *         result will contain the <b>SalesSchedgAgrmtSchedLine</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesSchedgAgrmtSchedLine>> getSalesSchedgAgrmtSchedLineIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtSchedLine);
    }

    /**
     * Overwrites the list of associated <b>SalesSchedgAgrmtSchedLine</b> entities for the loaded navigation property
     * <b>to_SalesSchedgAgrmtSchedLine</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtSchedLine</b> of a queried <b>SalesSchedgAgrmtDelivSched</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesSchedgAgrmtSchedLine</b> entities.
     */
    public void setSalesSchedgAgrmtSchedLine( @Nonnull final List<SalesSchedgAgrmtSchedLine> value )
    {
        if( toSalesSchedgAgrmtSchedLine == null ) {
            toSalesSchedgAgrmtSchedLine = Lists.newArrayList();
        }
        toSalesSchedgAgrmtSchedLine.clear();
        toSalesSchedgAgrmtSchedLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesSchedgAgrmtSchedLine</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtSchedLine</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtSchedLine</b> of a queried <b>SalesSchedgAgrmtDelivSched</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesSchedgAgrmtSchedLine</b> entities.
     */
    public void addSalesSchedgAgrmtSchedLine( SalesSchedgAgrmtSchedLine... entity )
    {
        if( toSalesSchedgAgrmtSchedLine == null ) {
            toSalesSchedgAgrmtSchedLine = Lists.newArrayList();
        }
        toSalesSchedgAgrmtSchedLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmtItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem fetchSalesSchedgAgrmtItem()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmtItem", SalesSchedgAgrmtItem.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtItem</b> of a queried <b>SalesSchedgAgrmtDelivSched</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem getSalesSchedgAgrmtItemOrFetch()
    {
        if( toSalesSchedgAgrmtItem == null ) {
            toSalesSchedgAgrmtItem = fetchSalesSchedgAgrmtItem();
        }
        return toSalesSchedgAgrmtItem;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtDelivSched</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtItem</b> is already loaded, the result
     *         will contain the <b>SalesSchedgAgrmtItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmtItem> getSalesSchedgAgrmtItemIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtItem);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmtItem</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmtItem</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmtItem</b> entity.
     */
    public void setSalesSchedgAgrmtItem( final SalesSchedgAgrmtItem value )
    {
        toSalesSchedgAgrmtItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesSchedgAgrmtDelivSched instances.
     *
     */
    public final static class SalesSchedgAgrmtDelivSchedBuilder
    {

        private SalesSchedgAgrmt toSalesSchedgAgrmt;
        private List<SalesSchedgAgrmtSchedLine> toSalesSchedgAgrmtSchedLine = Lists.newArrayList();
        private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;

        private SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder toSalesSchedgAgrmt(
            final SalesSchedgAgrmt value )
        {
            toSalesSchedgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtDelivSched</b> to single
         * <b>SalesSchedgAgrmt</b>.
         *
         * @param value
         *            The SalesSchedgAgrmt to build this SalesSchedgAgrmtDelivSched with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder salesSchedgAgrmt(
            final SalesSchedgAgrmt value )
        {
            return toSalesSchedgAgrmt(value);
        }

        private SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder toSalesSchedgAgrmtSchedLine(
            final List<SalesSchedgAgrmtSchedLine> value )
        {
            toSalesSchedgAgrmtSchedLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtSchedLine</b> for <b>SalesSchedgAgrmtDelivSched</b> to multiple
         * <b>SalesSchedgAgrmtSchedLine</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtSchedLines to build this SalesSchedgAgrmtDelivSched with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder salesSchedgAgrmtSchedLine(
            SalesSchedgAgrmtSchedLine... value )
        {
            return toSalesSchedgAgrmtSchedLine(Lists.newArrayList(value));
        }

        private SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder toSalesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            toSalesSchedgAgrmtItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtDelivSched</b> to single
         * <b>SalesSchedgAgrmtItem</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItem to build this SalesSchedgAgrmtDelivSched with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtDelivSched.SalesSchedgAgrmtDelivSchedBuilder salesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            return toSalesSchedgAgrmtItem(value);
        }

    }

}
