/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtDelivSchedSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
 * SalesSchedgAgrmtDelivSched} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesSchedgAgrmtDelivSchedByKeyFluentHelper
    extends
    FluentHelperByKey<SalesSchedgAgrmtDelivSchedByKeyFluentHelper, SalesSchedgAgrmtDelivSched, SalesSchedgAgrmtDelivSchedSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
     * SalesSchedgAgrmtDelivSched} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesSchedgAgrmtDelivSched}
     * @param salesSchedulingAgreement
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesSchedgAgrmtDelivSched}
     * @param schedulingAgreementReleaseType
     *            Release type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param intDeliveryScheduleNumber
     *            Internal delivery schedule number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SalesSchedgAgrmtDelivSchedByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String intDeliveryScheduleNumber,
        final String schedulingAgreementReleaseType )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesSchedulingAgreement", salesSchedulingAgreement);
        this.key.put("SalesSchedulingAgreementItem", salesSchedulingAgreementItem);
        this.key.put("IntDeliveryScheduleNumber", intDeliveryScheduleNumber);
        this.key.put("SchedulingAgreementReleaseType", schedulingAgreementReleaseType);
    }

    @Override
    @Nonnull
    protected Class<SalesSchedgAgrmtDelivSched> getEntityClass()
    {
        return SalesSchedgAgrmtDelivSched.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
