/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Scheduling Agreement Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesSchedgAgrmtItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesSchedgAgrmtItem extends VdmEntity<SalesSchedgAgrmtItem>
{

    /**
     * Selector for all available fields of SalesSchedgAgrmtItem.
     *
     */
    public final static SalesSchedgAgrmtItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @return Sales Scheduling Agreement
     */
    @Key
    @SerializedName( "SalesSchedulingAgreement" )
    @JsonProperty( "SalesSchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreement" )
    private String salesSchedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreement</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SALES_SCHEDULING_AGREEMENT =
        new SalesSchedgAgrmtItemField<String>("SalesSchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @return Sales Scheduling Agreement Item
     */
    @Key
    @SerializedName( "SalesSchedulingAgreementItem" )
    @JsonProperty( "SalesSchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreementItem" )
    private String salesSchedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SALES_SCHEDULING_AGREEMENT_ITEM =
        new SalesSchedgAgrmtItemField<String>("SalesSchedulingAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesSchedgAgrmtItemCategory" )
    @JsonProperty( "SalesSchedgAgrmtItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesSchedgAgrmtItemCategory" )
    private String salesSchedgAgrmtItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedgAgrmtItemCategory</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SALES_SCHEDG_AGRMT_ITEM_CATEGORY =
        new SalesSchedgAgrmtItemField<String>("SalesSchedgAgrmtItemCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<LocalDateTime> LAST_CHANGE_DATE =
        new SalesSchedgAgrmtItemField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> MATERIAL = new SalesSchedgAgrmtItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @return Material Entered
     */
    @SerializedName( "OriginallyRequestedMaterial" )
    @JsonProperty( "OriginallyRequestedMaterial" )
    @Nullable
    @ODataField( odataName = "OriginallyRequestedMaterial" )
    private String originallyRequestedMaterial;
    /**
     * Use with available fluent helpers to apply the <b>OriginallyRequestedMaterial</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ORIGINALLY_REQUESTED_MATERIAL =
        new SalesSchedgAgrmtItemField<String>("OriginallyRequestedMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> MATERIAL_BY_CUSTOMER =
        new SalesSchedgAgrmtItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> MATERIAL_GROUP =
        new SalesSchedgAgrmtItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> MATERIAL_PRICING_GROUP =
        new SalesSchedgAgrmtItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> PRODUCTION_PLANT =
        new SalesSchedgAgrmtItemField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> STORAGE_LOCATION =
        new SalesSchedgAgrmtItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlngDelivSchedInstrn</b>
     * </p>
     *
     * @return Instruction for Planning Delivery Schedule
     */
    @SerializedName( "PlngDelivSchedInstrn" )
    @JsonProperty( "PlngDelivSchedInstrn" )
    @Nullable
    @ODataField( odataName = "PlngDelivSchedInstrn" )
    private String plngDelivSchedInstrn;
    /**
     * Use with available fluent helpers to apply the <b>PlngDelivSchedInstrn</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> PLNG_DELIV_SCHED_INSTRN =
        new SalesSchedgAgrmtItemField<String>("PlngDelivSchedInstrn");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesSchedgAgrmtItemText" )
    @JsonProperty( "SalesSchedgAgrmtItemText" )
    @Nullable
    @ODataField( odataName = "SalesSchedgAgrmtItemText" )
    private String salesSchedgAgrmtItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedgAgrmtItemText</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SALES_SCHEDG_AGRMT_ITEM_TEXT =
        new SalesSchedgAgrmtItemField<String>("SalesSchedgAgrmtItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesSchedgAgrmtItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of the Underlying Purchase Order
     */
    @SerializedName( "UnderlyingPurchaseOrderItem" )
    @JsonProperty( "UnderlyingPurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "UnderlyingPurchaseOrderItem" )
    private String underlyingPurchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>UnderlyingPurchaseOrderItem</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> UNDERLYING_PURCHASE_ORDER_ITEM =
        new SalesSchedgAgrmtItemField<String>("UnderlyingPurchaseOrderItem");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantity</b>
     * </p>
     *
     * @return Cumulative Order Quantity in Sales Unit
     */
    @SerializedName( "OrderQuantity" )
    @JsonProperty( "OrderQuantity" )
    @Nullable
    @ODataField( odataName = "OrderQuantity" )
    private BigDecimal orderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> ORDER_QUANTITY =
        new SalesSchedgAgrmtItemField<BigDecimal>("OrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderToBaseQuantityDnmntr</b>
     * </p>
     *
     * @return Denominator (divisor) for conversion of sales Qty into SKU
     */
    @SerializedName( "OrderToBaseQuantityDnmntr" )
    @JsonProperty( "OrderToBaseQuantityDnmntr" )
    @Nullable
    @ODataField( odataName = "OrderToBaseQuantityDnmntr" )
    private BigDecimal orderToBaseQuantityDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrderToBaseQuantityDnmntr</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> ORDER_TO_BASE_QUANTITY_DNMNTR =
        new SalesSchedgAgrmtItemField<BigDecimal>("OrderToBaseQuantityDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderToBaseQuantityNmrtr</b>
     * </p>
     *
     * @return Numerator (factor) for conversion of sales quantity into SKU
     */
    @SerializedName( "OrderToBaseQuantityNmrtr" )
    @JsonProperty( "OrderToBaseQuantityNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderToBaseQuantityNmrtr" )
    private BigDecimal orderToBaseQuantityNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderToBaseQuantityNmrtr</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> ORDER_TO_BASE_QUANTITY_NMRTR =
        new SalesSchedgAgrmtItemField<BigDecimal>("OrderToBaseQuantityNmrtr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ORDER_QUANTITY_UNIT =
        new SalesSchedgAgrmtItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesSchedgAgrmtItemField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesSchedgAgrmtItemField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @return Target Quantity in Sales Units
     */
    @SerializedName( "TargetQuantity" )
    @JsonProperty( "TargetQuantity" )
    @Nullable
    @ODataField( odataName = "TargetQuantity" )
    private BigDecimal targetQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> TARGET_QUANTITY =
        new SalesSchedgAgrmtItemField<BigDecimal>("TargetQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityUnit</b>
     * </p>
     *
     * @return Target Quantity UoM
     */
    @SerializedName( "TargetQuantityUnit" )
    @JsonProperty( "TargetQuantityUnit" )
    @Nullable
    @ODataField( odataName = "TargetQuantityUnit" )
    private String targetQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> TARGET_QUANTITY_UNIT =
        new SalesSchedgAgrmtItemField<String>("TargetQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesSchedgAgrmtItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> NET_AMOUNT =
        new SalesSchedgAgrmtItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> NET_PRICE_AMOUNT =
        new SalesSchedgAgrmtItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<BigDecimal> NET_PRICE_QUANTITY =
        new SalesSchedgAgrmtItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "NetPriceQuantityUnit" )
    @JsonProperty( "NetPriceQuantityUnit" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantityUnit" )
    private String netPriceQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> NET_PRICE_QUANTITY_UNIT =
        new SalesSchedgAgrmtItemField<String>("NetPriceQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> TRANSACTION_CURRENCY =
        new SalesSchedgAgrmtItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<LocalDateTime> PRICING_DATE =
        new SalesSchedgAgrmtItemField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SHIPPING_POINT =
        new SalesSchedgAgrmtItemField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SHIPPING_TYPE =
        new SalesSchedgAgrmtItemField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> DELIVERY_PRIORITY =
        new SalesSchedgAgrmtItemField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> INCOTERMS_CLASSIFICATION =
        new SalesSchedgAgrmtItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesSchedgAgrmtItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> INCOTERMS_LOCATION1 =
        new SalesSchedgAgrmtItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> INCOTERMS_LOCATION2 =
        new SalesSchedgAgrmtItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesSchedgAgrmtItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ITEM_BILLING_BLOCK_REASON =
        new SalesSchedgAgrmtItemField<String>("ItemBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> SD_PROCESS_STATUS =
        new SalesSchedgAgrmtItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @return Delivery Status (Item)
     */
    @SerializedName( "DeliveryStatus" )
    @JsonProperty( "DeliveryStatus" )
    @Nullable
    @ODataField( odataName = "DeliveryStatus" )
    private String deliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> DELIVERY_STATUS =
        new SalesSchedgAgrmtItemField<String>("DeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGeneralIncompletionStatus</b>
     * </p>
     *
     * @return Incompletion Status (Item)
     */
    @SerializedName( "ItemGeneralIncompletionStatus" )
    @JsonProperty( "ItemGeneralIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemGeneralIncompletionStatus" )
    private String itemGeneralIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemGeneralIncompletionStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ITEM_GENERAL_INCOMPLETION_STATUS =
        new SalesSchedgAgrmtItemField<String>("ItemGeneralIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingIncompletionStatus</b>
     * </p>
     *
     * @return Billing Incompletion Status (Item)
     */
    @SerializedName( "ItemBillingIncompletionStatus" )
    @JsonProperty( "ItemBillingIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemBillingIncompletionStatus" )
    private String itemBillingIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingIncompletionStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ITEM_BILLING_INCOMPLETION_STATUS =
        new SalesSchedgAgrmtItemField<String>("ItemBillingIncompletionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryIncompletionStatus</b>
     * </p>
     *
     * @return Delivery Incompletion Status (Item)
     */
    @SerializedName( "ItemDeliveryIncompletionStatus" )
    @JsonProperty( "ItemDeliveryIncompletionStatus" )
    @Nullable
    @ODataField( odataName = "ItemDeliveryIncompletionStatus" )
    private String itemDeliveryIncompletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemDeliveryIncompletionStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemField<String> ITEM_DELIVERY_INCOMPLETION_STATUS =
        new SalesSchedgAgrmtItemField<String>("ItemDeliveryIncompletionStatus");
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesSchedgAgrmtItem</b> to multiple
     * <b>SalesSchedgAgrmtItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesSchedgAgrmtItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesSchedgAgrmtItem</b> to multiple
     * <b>SalesSchedgAgrmtItmPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesSchedgAgrmtItmPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtItem</b> to single <b>SalesSchedgAgrmt</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmt" )
    @JsonProperty( "to_SalesSchedgAgrmt" )
    @ODataField( odataName = "to_SalesSchedgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmt toSalesSchedgAgrmt;
    /**
     * Navigation property <b>to_SalesSchedgAgrmtDelivSched</b> for <b>SalesSchedgAgrmtItem</b> to multiple
     * <b>SalesSchedgAgrmtDelivSched</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtDelivSched" )
    @JsonProperty( "to_SalesSchedgAgrmtDelivSched" )
    @ODataField( odataName = "to_SalesSchedgAgrmtDelivSched" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesSchedgAgrmtDelivSched> toSalesSchedgAgrmtDelivSched;
    /**
     * Navigation property <b>to_Text</b> for <b>SalesSchedgAgrmtItem</b> to multiple <b>SalesSchedgAgrmtItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesSchedgAgrmtItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItemPartner> TO_PARTNER =
        new SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItmPrcgElmnt> TO_PRICING_ELEMENT =
        new SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItmPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmt</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtItemOneToOneLink<SalesSchedgAgrmt> TO_SALES_SCHEDG_AGRMT =
        new SalesSchedgAgrmtItemOneToOneLink<SalesSchedgAgrmt>("to_SalesSchedgAgrmt");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtDelivSched</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtItemLink<SalesSchedgAgrmtDelivSched> TO_SALES_SCHEDG_AGRMT_DELIV_SCHED =
        new SalesSchedgAgrmtItemLink<SalesSchedgAgrmtDelivSched>("to_SalesSchedgAgrmtDelivSched");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItemText> TO_TEXT =
        new SalesSchedgAgrmtItemLink<SalesSchedgAgrmtItemText>("to_Text");

    @Nonnull
    @Override
    public Class<SalesSchedgAgrmtItem> getType()
    {
        return SalesSchedgAgrmtItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     */
    public void setSalesSchedulingAgreement( @Nullable final String salesSchedulingAgreement )
    {
        rememberChangedField("SalesSchedulingAgreement", this.salesSchedulingAgreement);
        this.salesSchedulingAgreement = salesSchedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     */
    public void setSalesSchedulingAgreementItem( @Nullable final String salesSchedulingAgreementItem )
    {
        rememberChangedField("SalesSchedulingAgreementItem", this.salesSchedulingAgreementItem);
        this.salesSchedulingAgreementItem = salesSchedulingAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtItemCategory</b>
     * </p>
     *
     * @param salesSchedgAgrmtItemCategory
     *            Sales Document Item Category
     */
    public void setSalesSchedgAgrmtItemCategory( @Nullable final String salesSchedgAgrmtItemCategory )
    {
        rememberChangedField("SalesSchedgAgrmtItemCategory", this.salesSchedgAgrmtItemCategory);
        this.salesSchedgAgrmtItemCategory = salesSchedgAgrmtItemCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OriginallyRequestedMaterial</b>
     * </p>
     *
     * @param originallyRequestedMaterial
     *            Material Entered
     */
    public void setOriginallyRequestedMaterial( @Nullable final String originallyRequestedMaterial )
    {
        rememberChangedField("OriginallyRequestedMaterial", this.originallyRequestedMaterial);
        this.originallyRequestedMaterial = originallyRequestedMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Plant (Own or External)
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlngDelivSchedInstrn</b>
     * </p>
     *
     * @param plngDelivSchedInstrn
     *            Instruction for Planning Delivery Schedule
     */
    public void setPlngDelivSchedInstrn( @Nullable final String plngDelivSchedInstrn )
    {
        rememberChangedField("PlngDelivSchedInstrn", this.plngDelivSchedInstrn);
        this.plngDelivSchedInstrn = plngDelivSchedInstrn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedgAgrmtItemText</b>
     * </p>
     *
     * @param salesSchedgAgrmtItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesSchedgAgrmtItemText( @Nullable final String salesSchedgAgrmtItemText )
    {
        rememberChangedField("SalesSchedgAgrmtItemText", this.salesSchedgAgrmtItemText);
        this.salesSchedgAgrmtItemText = salesSchedgAgrmtItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @param underlyingPurchaseOrderItem
     *            Item Number of the Underlying Purchase Order
     */
    public void setUnderlyingPurchaseOrderItem( @Nullable final String underlyingPurchaseOrderItem )
    {
        rememberChangedField("UnderlyingPurchaseOrderItem", this.underlyingPurchaseOrderItem);
        this.underlyingPurchaseOrderItem = underlyingPurchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantity</b>
     * </p>
     *
     * @param orderQuantity
     *            Cumulative Order Quantity in Sales Unit
     */
    public void setOrderQuantity( @Nullable final BigDecimal orderQuantity )
    {
        rememberChangedField("OrderQuantity", this.orderQuantity);
        this.orderQuantity = orderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderToBaseQuantityDnmntr</b>
     * </p>
     *
     * @param orderToBaseQuantityDnmntr
     *            Denominator (divisor) for conversion of sales Qty into SKU
     */
    public void setOrderToBaseQuantityDnmntr( @Nullable final BigDecimal orderToBaseQuantityDnmntr )
    {
        rememberChangedField("OrderToBaseQuantityDnmntr", this.orderToBaseQuantityDnmntr);
        this.orderToBaseQuantityDnmntr = orderToBaseQuantityDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderToBaseQuantityNmrtr</b>
     * </p>
     *
     * @param orderToBaseQuantityNmrtr
     *            Numerator (factor) for conversion of sales quantity into SKU
     */
    public void setOrderToBaseQuantityNmrtr( @Nullable final BigDecimal orderToBaseQuantityNmrtr )
    {
        rememberChangedField("OrderToBaseQuantityNmrtr", this.orderToBaseQuantityNmrtr);
        this.orderToBaseQuantityNmrtr = orderToBaseQuantityNmrtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @param targetQuantity
     *            Target Quantity in Sales Units
     */
    public void setTargetQuantity( @Nullable final BigDecimal targetQuantity )
    {
        rememberChangedField("TargetQuantity", this.targetQuantity);
        this.targetQuantity = targetQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityUnit</b>
     * </p>
     *
     * @param targetQuantityUnit
     *            Target Quantity UoM
     */
    public void setTargetQuantityUnit( @Nullable final String targetQuantityUnit )
    {
        rememberChangedField("TargetQuantityUnit", this.targetQuantityUnit);
        this.targetQuantityUnit = targetQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Condition Pricing Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     *
     * @param netPriceQuantityUnit
     *            Condition Unit
     */
    public void setNetPriceQuantityUnit( @Nullable final String netPriceQuantityUnit )
    {
        rememberChangedField("NetPriceQuantityUnit", this.netPriceQuantityUnit);
        this.netPriceQuantityUnit = netPriceQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @param deliveryStatus
     *            Delivery Status (Item)
     */
    public void setDeliveryStatus( @Nullable final String deliveryStatus )
    {
        rememberChangedField("DeliveryStatus", this.deliveryStatus);
        this.deliveryStatus = deliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemGeneralIncompletionStatus</b>
     * </p>
     *
     * @param itemGeneralIncompletionStatus
     *            Incompletion Status (Item)
     */
    public void setItemGeneralIncompletionStatus( @Nullable final String itemGeneralIncompletionStatus )
    {
        rememberChangedField("ItemGeneralIncompletionStatus", this.itemGeneralIncompletionStatus);
        this.itemGeneralIncompletionStatus = itemGeneralIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingIncompletionStatus</b>
     * </p>
     *
     * @param itemBillingIncompletionStatus
     *            Billing Incompletion Status (Item)
     */
    public void setItemBillingIncompletionStatus( @Nullable final String itemBillingIncompletionStatus )
    {
        rememberChangedField("ItemBillingIncompletionStatus", this.itemBillingIncompletionStatus);
        this.itemBillingIncompletionStatus = itemBillingIncompletionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryIncompletionStatus</b>
     * </p>
     *
     * @param itemDeliveryIncompletionStatus
     *            Delivery Incompletion Status (Item)
     */
    public void setItemDeliveryIncompletionStatus( @Nullable final String itemDeliveryIncompletionStatus )
    {
        rememberChangedField("ItemDeliveryIncompletionStatus", this.itemDeliveryIncompletionStatus);
        this.itemDeliveryIncompletionStatus = itemDeliveryIncompletionStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesSchedgAgrmtItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        result.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        values.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        values.put("SalesSchedgAgrmtItemCategory", getSalesSchedgAgrmtItemCategory());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("Material", getMaterial());
        values.put("OriginallyRequestedMaterial", getOriginallyRequestedMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("ProductionPlant", getProductionPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("PlngDelivSchedInstrn", getPlngDelivSchedInstrn());
        values.put("SalesSchedgAgrmtItemText", getSalesSchedgAgrmtItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("UnderlyingPurchaseOrderItem", getUnderlyingPurchaseOrderItem());
        values.put("OrderQuantity", getOrderQuantity());
        values.put("OrderToBaseQuantityDnmntr", getOrderToBaseQuantityDnmntr());
        values.put("OrderToBaseQuantityNmrtr", getOrderToBaseQuantityNmrtr());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("TargetQuantity", getTargetQuantity());
        values.put("TargetQuantityUnit", getTargetQuantityUnit());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("NetAmount", getNetAmount());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("NetPriceQuantityUnit", getNetPriceQuantityUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("PricingDate", getPricingDate());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("DeliveryStatus", getDeliveryStatus());
        values.put("ItemGeneralIncompletionStatus", getItemGeneralIncompletionStatus());
        values.put("ItemBillingIncompletionStatus", getItemBillingIncompletionStatus());
        values.put("ItemDeliveryIncompletionStatus", getItemDeliveryIncompletionStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesSchedulingAgreement") ) {
                final Object value = values.remove("SalesSchedulingAgreement");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreement())) ) {
                    setSalesSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreementItem") ) {
                final Object value = values.remove("SalesSchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreementItem())) ) {
                    setSalesSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("SalesSchedgAgrmtItemCategory") ) {
                final Object value = values.remove("SalesSchedgAgrmtItemCategory");
                if( (value == null) || (!value.equals(getSalesSchedgAgrmtItemCategory())) ) {
                    setSalesSchedgAgrmtItemCategory(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OriginallyRequestedMaterial") ) {
                final Object value = values.remove("OriginallyRequestedMaterial");
                if( (value == null) || (!value.equals(getOriginallyRequestedMaterial())) ) {
                    setOriginallyRequestedMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("PlngDelivSchedInstrn") ) {
                final Object value = values.remove("PlngDelivSchedInstrn");
                if( (value == null) || (!value.equals(getPlngDelivSchedInstrn())) ) {
                    setPlngDelivSchedInstrn(((String) value));
                }
            }
            if( values.containsKey("SalesSchedgAgrmtItemText") ) {
                final Object value = values.remove("SalesSchedgAgrmtItemText");
                if( (value == null) || (!value.equals(getSalesSchedgAgrmtItemText())) ) {
                    setSalesSchedgAgrmtItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("UnderlyingPurchaseOrderItem") ) {
                final Object value = values.remove("UnderlyingPurchaseOrderItem");
                if( (value == null) || (!value.equals(getUnderlyingPurchaseOrderItem())) ) {
                    setUnderlyingPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("OrderQuantity") ) {
                final Object value = values.remove("OrderQuantity");
                if( (value == null) || (!value.equals(getOrderQuantity())) ) {
                    setOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderToBaseQuantityDnmntr") ) {
                final Object value = values.remove("OrderToBaseQuantityDnmntr");
                if( (value == null) || (!value.equals(getOrderToBaseQuantityDnmntr())) ) {
                    setOrderToBaseQuantityDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderToBaseQuantityNmrtr") ) {
                final Object value = values.remove("OrderToBaseQuantityNmrtr");
                if( (value == null) || (!value.equals(getOrderToBaseQuantityNmrtr())) ) {
                    setOrderToBaseQuantityNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("TargetQuantity") ) {
                final Object value = values.remove("TargetQuantity");
                if( (value == null) || (!value.equals(getTargetQuantity())) ) {
                    setTargetQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("TargetQuantityUnit") ) {
                final Object value = values.remove("TargetQuantityUnit");
                if( (value == null) || (!value.equals(getTargetQuantityUnit())) ) {
                    setTargetQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantityUnit") ) {
                final Object value = values.remove("NetPriceQuantityUnit");
                if( (value == null) || (!value.equals(getNetPriceQuantityUnit())) ) {
                    setNetPriceQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("DeliveryStatus") ) {
                final Object value = values.remove("DeliveryStatus");
                if( (value == null) || (!value.equals(getDeliveryStatus())) ) {
                    setDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("ItemGeneralIncompletionStatus") ) {
                final Object value = values.remove("ItemGeneralIncompletionStatus");
                if( (value == null) || (!value.equals(getItemGeneralIncompletionStatus())) ) {
                    setItemGeneralIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemBillingIncompletionStatus") ) {
                final Object value = values.remove("ItemBillingIncompletionStatus");
                if( (value == null) || (!value.equals(getItemBillingIncompletionStatus())) ) {
                    setItemBillingIncompletionStatus(((String) value));
                }
            }
            if( values.containsKey("ItemDeliveryIncompletionStatus") ) {
                final Object value = values.remove("ItemDeliveryIncompletionStatus");
                if( (value == null) || (!value.equals(getItemDeliveryIncompletionStatus())) ) {
                    setItemDeliveryIncompletionStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesSchedgAgrmtItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesSchedgAgrmtItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesSchedgAgrmtItmPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesSchedgAgrmtItmPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmt") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmt");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmt == null ) {
                        toSalesSchedgAgrmt = new SalesSchedgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmtDelivSched") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtDelivSched");
                if( value instanceof Iterable ) {
                    if( toSalesSchedgAgrmtDelivSched == null ) {
                        toSalesSchedgAgrmtDelivSched = Lists.newArrayList();
                    } else {
                        toSalesSchedgAgrmtDelivSched = Lists.newArrayList(toSalesSchedgAgrmtDelivSched);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesSchedgAgrmtDelivSched entity;
                        if( toSalesSchedgAgrmtDelivSched.size() > i ) {
                            entity = toSalesSchedgAgrmtDelivSched.get(i);
                        } else {
                            entity = new SalesSchedgAgrmtDelivSched();
                            toSalesSchedgAgrmtDelivSched.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesSchedgAgrmtItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SalesSchedgAgrmtItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesSchedgAgrmtItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesSchedgAgrmtItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesSchedgAgrmtItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesSchedgAgrmtItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toSalesSchedgAgrmt != null ) {
            (values).put("to_SalesSchedgAgrmt", toSalesSchedgAgrmt);
        }
        if( toSalesSchedgAgrmtDelivSched != null ) {
            (values).put("to_SalesSchedgAgrmtDelivSched", toSalesSchedgAgrmtDelivSched);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItemPartner</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesSchedgAgrmtItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesSchedgAgrmtItemPartner.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesSchedgAgrmtItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesSchedgAgrmtItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesSchedgAgrmtItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesSchedgAgrmtItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesSchedgAgrmtItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesSchedgAgrmtItemPartner</b> entities. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesSchedgAgrmtItemPartner</b> entities.
     */
    public void addPartner( SalesSchedgAgrmtItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItmPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesSchedgAgrmtItmPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItmPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesSchedgAgrmtItmPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesSchedgAgrmtItmPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesSchedgAgrmtItmPrcgElmnt</b> entities.
     */
    public void addPricingElement( SalesSchedgAgrmtItmPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesSchedgAgrmt</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmt</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt fetchSalesSchedgAgrmt()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmt", SalesSchedgAgrmt.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmt</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt getSalesSchedgAgrmtOrFetch()
    {
        if( toSalesSchedgAgrmt == null ) {
            toSalesSchedgAgrmt = fetchSalesSchedgAgrmt();
        }
        return toSalesSchedgAgrmt;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmt</b> is already loaded, the result will
     *         contain the <b>SalesSchedgAgrmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmt> getSalesSchedgAgrmtIfPresent()
    {
        return Option.of(toSalesSchedgAgrmt);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmt</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmt</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmt</b> entity.
     */
    public void setSalesSchedgAgrmt( final SalesSchedgAgrmt value )
    {
        toSalesSchedgAgrmt = value;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtDelivSched</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesSchedgAgrmtDelivSched</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtDelivSched> fetchSalesSchedgAgrmtDelivSched()
    {
        return fetchFieldAsList("to_SalesSchedgAgrmtDelivSched", SalesSchedgAgrmtDelivSched.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtDelivSched</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtDelivSched</b> of a queried <b>SalesSchedgAgrmtItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtDelivSched</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtDelivSched> getSalesSchedgAgrmtDelivSchedOrFetch()
    {
        if( toSalesSchedgAgrmtDelivSched == null ) {
            toSalesSchedgAgrmtDelivSched = fetchSalesSchedgAgrmtDelivSched();
        }
        return toSalesSchedgAgrmtDelivSched;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtDelivSched</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtDelivSched</b> is already loaded, the
     *         result will contain the <b>SalesSchedgAgrmtDelivSched</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesSchedgAgrmtDelivSched>> getSalesSchedgAgrmtDelivSchedIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtDelivSched);
    }

    /**
     * Overwrites the list of associated <b>SalesSchedgAgrmtDelivSched</b> entities for the loaded navigation property
     * <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtDelivSched</b> of a queried <b>SalesSchedgAgrmtItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesSchedgAgrmtDelivSched</b> entities.
     */
    public void setSalesSchedgAgrmtDelivSched( @Nonnull final List<SalesSchedgAgrmtDelivSched> value )
    {
        if( toSalesSchedgAgrmtDelivSched == null ) {
            toSalesSchedgAgrmtDelivSched = Lists.newArrayList();
        }
        toSalesSchedgAgrmtDelivSched.clear();
        toSalesSchedgAgrmtDelivSched.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesSchedgAgrmtDelivSched</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtDelivSched</b> of a queried <b>SalesSchedgAgrmtItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesSchedgAgrmtDelivSched</b> entities.
     */
    public void addSalesSchedgAgrmtDelivSched( SalesSchedgAgrmtDelivSched... entity )
    {
        if( toSalesSchedgAgrmtDelivSched == null ) {
            toSalesSchedgAgrmtDelivSched = Lists.newArrayList();
        }
        toSalesSchedgAgrmtDelivSched.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesSchedgAgrmtItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", SalesSchedgAgrmtItemText.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesSchedgAgrmtItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SalesSchedgAgrmtItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesSchedgAgrmtItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SalesSchedgAgrmtItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesSchedgAgrmtItemText</b> entities.
     */
    public void setText( @Nonnull final List<SalesSchedgAgrmtItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesSchedgAgrmtItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesSchedgAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesSchedgAgrmtItemText</b> entities.
     */
    public void addText( SalesSchedgAgrmtItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesSchedgAgrmtItem instances.
     *
     */
    public final static class SalesSchedgAgrmtItemBuilder
    {

        private List<SalesSchedgAgrmtItemPartner> toPartner = Lists.newArrayList();
        private List<SalesSchedgAgrmtItmPrcgElmnt> toPricingElement = Lists.newArrayList();
        private SalesSchedgAgrmt toSalesSchedgAgrmt;
        private List<SalesSchedgAgrmtDelivSched> toSalesSchedgAgrmtDelivSched = Lists.newArrayList();
        private List<SalesSchedgAgrmtItemText> toText = Lists.newArrayList();

        private SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder toPartner(
            final List<SalesSchedgAgrmtItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesSchedgAgrmtItem</b> to multiple
         * <b>SalesSchedgAgrmtItemPartner</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItemPartners to build this SalesSchedgAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder partner( SalesSchedgAgrmtItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder toPricingElement(
            final List<SalesSchedgAgrmtItmPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesSchedgAgrmtItem</b> to multiple
         * <b>SalesSchedgAgrmtItmPrcgElmnt</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItmPrcgElmnts to build this SalesSchedgAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder pricingElement( SalesSchedgAgrmtItmPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder toSalesSchedgAgrmt( final SalesSchedgAgrmt value )
        {
            toSalesSchedgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtItem</b> to single
         * <b>SalesSchedgAgrmt</b>.
         *
         * @param value
         *            The SalesSchedgAgrmt to build this SalesSchedgAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder salesSchedgAgrmt( final SalesSchedgAgrmt value )
        {
            return toSalesSchedgAgrmt(value);
        }

        private SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder toSalesSchedgAgrmtDelivSched(
            final List<SalesSchedgAgrmtDelivSched> value )
        {
            toSalesSchedgAgrmtDelivSched.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtDelivSched</b> for <b>SalesSchedgAgrmtItem</b> to multiple
         * <b>SalesSchedgAgrmtDelivSched</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtDelivScheds to build this SalesSchedgAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder salesSchedgAgrmtDelivSched(
            SalesSchedgAgrmtDelivSched... value )
        {
            return toSalesSchedgAgrmtDelivSched(Lists.newArrayList(value));
        }

        private SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder toText( final List<SalesSchedgAgrmtItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SalesSchedgAgrmtItem</b> to multiple
         * <b>SalesSchedgAgrmtItemText</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItemTexts to build this SalesSchedgAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItem.SalesSchedgAgrmtItemBuilder text( SalesSchedgAgrmtItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
