/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtItemPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
 * SalesSchedgAgrmtItemPartner} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesSchedgAgrmtItemPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<SalesSchedgAgrmtItemPartnerByKeyFluentHelper, SalesSchedgAgrmtItemPartner, SalesSchedgAgrmtItemPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesSchedgAgrmtItemPartner}
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesSchedgAgrmtItemPartner}
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SalesSchedgAgrmtItemPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String partnerFunction )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesSchedulingAgreement", salesSchedulingAgreement);
        this.key.put("SalesSchedulingAgreementItem", salesSchedulingAgreementItem);
        this.key.put("PartnerFunction", partnerFunction);
    }

    @Override
    @Nonnull
    protected Class<SalesSchedgAgrmtItemPartner> getEntityClass()
    {
        return SalesSchedgAgrmtItemPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
