/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtItemTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesSchedgAgrmtItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesSchedgAgrmtItemText extends VdmEntity<SalesSchedgAgrmtItemText>
{

    /**
     * Selector for all available fields of SalesSchedgAgrmtItemText.
     *
     */
    public final static SalesSchedgAgrmtItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @return Sales Scheduling Agreement
     */
    @Key
    @SerializedName( "SalesSchedulingAgreement" )
    @JsonProperty( "SalesSchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreement" )
    private String salesSchedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreement</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextField<String> SALES_SCHEDULING_AGREEMENT =
        new SalesSchedgAgrmtItemTextField<String>("SalesSchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @return Sales Scheduling Agreement Item
     */
    @Key
    @SerializedName( "SalesSchedulingAgreementItem" )
    @JsonProperty( "SalesSchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreementItem" )
    private String salesSchedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextField<String> SALES_SCHEDULING_AGREEMENT_ITEM =
        new SalesSchedgAgrmtItemTextField<String>("SalesSchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextField<String> LANGUAGE =
        new SalesSchedgAgrmtItemTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextField<String> LONG_TEXT_ID =
        new SalesSchedgAgrmtItemTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextField<String> LONG_TEXT =
        new SalesSchedgAgrmtItemTextField<String>("LongText");
    /**
     * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtItemText</b> to single
     * <b>SalesSchedgAgrmt</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmt" )
    @JsonProperty( "to_SalesSchedgAgrmt" )
    @ODataField( odataName = "to_SalesSchedgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmt toSalesSchedgAgrmt;
    /**
     * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtItemText</b> to single
     * <b>SalesSchedgAgrmtItem</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtItem" )
    @JsonProperty( "to_SalesSchedgAgrmtItem" )
    @ODataField( odataName = "to_SalesSchedgAgrmtItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmt</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextOneToOneLink<SalesSchedgAgrmt> TO_SALES_SCHEDG_AGRMT =
        new SalesSchedgAgrmtItemTextOneToOneLink<SalesSchedgAgrmt>("to_SalesSchedgAgrmt");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtItemTextOneToOneLink<SalesSchedgAgrmtItem> TO_SALES_SCHEDG_AGRMT_ITEM =
        new SalesSchedgAgrmtItemTextOneToOneLink<SalesSchedgAgrmtItem>("to_SalesSchedgAgrmtItem");

    @Nonnull
    @Override
    public Class<SalesSchedgAgrmtItemText> getType()
    {
        return SalesSchedgAgrmtItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     */
    public void setSalesSchedulingAgreement( @Nullable final String salesSchedulingAgreement )
    {
        rememberChangedField("SalesSchedulingAgreement", this.salesSchedulingAgreement);
        this.salesSchedulingAgreement = salesSchedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     */
    public void setSalesSchedulingAgreementItem( @Nullable final String salesSchedulingAgreementItem )
    {
        rememberChangedField("SalesSchedulingAgreementItem", this.salesSchedulingAgreementItem);
        this.salesSchedulingAgreementItem = salesSchedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesSchedgAgrmtItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        result.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        values.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesSchedulingAgreement") ) {
                final Object value = values.remove("SalesSchedulingAgreement");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreement())) ) {
                    setSalesSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreementItem") ) {
                final Object value = values.remove("SalesSchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreementItem())) ) {
                    setSalesSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesSchedgAgrmt") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmt");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmt == null ) {
                        toSalesSchedgAgrmt = new SalesSchedgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmtItem") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtItem");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmtItem == null ) {
                        toSalesSchedgAgrmtItem = new SalesSchedgAgrmtItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmtItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesSchedgAgrmtItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesSchedgAgrmtItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesSchedgAgrmtItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesSchedgAgrmtItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesSchedgAgrmt != null ) {
            (values).put("to_SalesSchedgAgrmt", toSalesSchedgAgrmt);
        }
        if( toSalesSchedgAgrmtItem != null ) {
            (values).put("to_SalesSchedgAgrmtItem", toSalesSchedgAgrmtItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmt</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmt</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt fetchSalesSchedgAgrmt()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmt", SalesSchedgAgrmt.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmt</b> of a queried <b>SalesSchedgAgrmtItemText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt getSalesSchedgAgrmtOrFetch()
    {
        if( toSalesSchedgAgrmt == null ) {
            toSalesSchedgAgrmt = fetchSalesSchedgAgrmt();
        }
        return toSalesSchedgAgrmt;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItemText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmt</b> is already loaded, the result will
     *         contain the <b>SalesSchedgAgrmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmt> getSalesSchedgAgrmtIfPresent()
    {
        return Option.of(toSalesSchedgAgrmt);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmt</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmt</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmt</b> entity.
     */
    public void setSalesSchedgAgrmt( final SalesSchedgAgrmt value )
    {
        toSalesSchedgAgrmt = value;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmtItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem fetchSalesSchedgAgrmtItem()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmtItem", SalesSchedgAgrmtItem.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtItem</b> of a queried <b>SalesSchedgAgrmtItemText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem getSalesSchedgAgrmtItemOrFetch()
    {
        if( toSalesSchedgAgrmtItem == null ) {
            toSalesSchedgAgrmtItem = fetchSalesSchedgAgrmtItem();
        }
        return toSalesSchedgAgrmtItem;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtItemText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtItem</b> is already loaded, the result
     *         will contain the <b>SalesSchedgAgrmtItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmtItem> getSalesSchedgAgrmtItemIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtItem);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmtItem</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmtItem</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmtItem</b> entity.
     */
    public void setSalesSchedgAgrmtItem( final SalesSchedgAgrmtItem value )
    {
        toSalesSchedgAgrmtItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesSchedgAgrmtItemText instances.
     *
     */
    public final static class SalesSchedgAgrmtItemTextBuilder
    {

        private SalesSchedgAgrmt toSalesSchedgAgrmt;
        private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;

        private SalesSchedgAgrmtItemText.SalesSchedgAgrmtItemTextBuilder toSalesSchedgAgrmt(
            final SalesSchedgAgrmt value )
        {
            toSalesSchedgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtItemText</b> to single
         * <b>SalesSchedgAgrmt</b>.
         *
         * @param value
         *            The SalesSchedgAgrmt to build this SalesSchedgAgrmtItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItemText.SalesSchedgAgrmtItemTextBuilder salesSchedgAgrmt( final SalesSchedgAgrmt value )
        {
            return toSalesSchedgAgrmt(value);
        }

        private SalesSchedgAgrmtItemText.SalesSchedgAgrmtItemTextBuilder toSalesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            toSalesSchedgAgrmtItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtItemText</b> to single
         * <b>SalesSchedgAgrmtItem</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItem to build this SalesSchedgAgrmtItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtItemText.SalesSchedgAgrmtItemTextBuilder salesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            return toSalesSchedgAgrmtItem(value);
        }

    }

}
