/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtSchedLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtSchedLineOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtSchedLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Schedule Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesSchedgAgrmtSchedLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesSchedgAgrmtSchedLine extends VdmEntity<SalesSchedgAgrmtSchedLine>
{

    /**
     * Selector for all available fields of SalesSchedgAgrmtSchedLine.
     *
     */
    public final static SalesSchedgAgrmtSchedLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @return Sales Scheduling Agreement
     */
    @Key
    @SerializedName( "SalesSchedulingAgreement" )
    @JsonProperty( "SalesSchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreement" )
    private String salesSchedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreement</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SALES_SCHEDULING_AGREEMENT =
        new SalesSchedgAgrmtSchedLineField<String>("SalesSchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @return Sales Scheduling Agreement Item
     */
    @Key
    @SerializedName( "SalesSchedulingAgreementItem" )
    @JsonProperty( "SalesSchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SalesSchedulingAgreementItem" )
    private String salesSchedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesSchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SALES_SCHEDULING_AGREEMENT_ITEM =
        new SalesSchedgAgrmtSchedLineField<String>("SalesSchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SCHEDULE_LINE =
        new SalesSchedgAgrmtSchedLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementReleaseType</b>
     * </p>
     *
     * @return Release type
     */
    @SerializedName( "SchedulingAgreementReleaseType" )
    @JsonProperty( "SchedulingAgreementReleaseType" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementReleaseType" )
    private String schedulingAgreementReleaseType;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementReleaseType</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SCHEDULING_AGREEMENT_RELEASE_TYPE =
        new SalesSchedgAgrmtSchedLineField<String>("SchedulingAgreementReleaseType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineCategory</b>
     * </p>
     *
     * @return Schedule Line Category
     */
    @SerializedName( "ScheduleLineCategory" )
    @JsonProperty( "ScheduleLineCategory" )
    @Nullable
    @ODataField( odataName = "ScheduleLineCategory" )
    private String scheduleLineCategory;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineCategory</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SCHEDULE_LINE_CATEGORY =
        new SalesSchedgAgrmtSchedLineField<String>("ScheduleLineCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> ORDER_QUANTITY_UNIT =
        new SalesSchedgAgrmtSchedLineField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesSchedgAgrmtSchedLineField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesSchedgAgrmtSchedLineField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDelivDateCategory</b>
     * </p>
     *
     * @return Delivery Date Type (Day, Week, Month, Interval)
     */
    @SerializedName( "SalesDelivDateCategory" )
    @JsonProperty( "SalesDelivDateCategory" )
    @Nullable
    @ODataField( odataName = "SalesDelivDateCategory" )
    private String salesDelivDateCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesDelivDateCategory</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> SALES_DELIV_DATE_CATEGORY =
        new SalesSchedgAgrmtSchedLineField<String>("SalesDelivDateCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesSchedgAgrmtSchedLineField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryTime</b>
     * </p>
     *
     * @return Arrival time
     */
    @SerializedName( "RequestedDeliveryTime" )
    @JsonProperty( "RequestedDeliveryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requestedDeliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalTime> REQUESTED_DELIVERY_TIME =
        new SalesSchedgAgrmtSchedLineField<LocalTime>("RequestedDeliveryTime");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Order Quantity in Sales Units
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new SalesSchedgAgrmtSchedLineField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Corrected quantity in sales unit
     */
    @SerializedName( "CorrectedQtyInOrderQtyUnit" )
    @JsonProperty( "CorrectedQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "CorrectedQtyInOrderQtyUnit" )
    private BigDecimal correctedQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CorrectedQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<BigDecimal> CORRECTED_QTY_IN_ORDER_QTY_UNIT =
        new SalesSchedgAgrmtSchedLineField<BigDecimal>("CorrectedQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOpenQuantity</b>
     * </p>
     *
     * @return Open quantity to be delivered (in sales unit)
     */
    @SerializedName( "ScheduleLineOpenQuantity" )
    @JsonProperty( "ScheduleLineOpenQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOpenQuantity" )
    private BigDecimal scheduleLineOpenQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOpenQuantity</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<BigDecimal> SCHEDULE_LINE_OPEN_QUANTITY =
        new SalesSchedgAgrmtSchedLineField<BigDecimal>("ScheduleLineOpenQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @return Confirmed Quantity
     */
    @SerializedName( "ConfdOrderQtyByMatlAvailCheck" )
    @JsonProperty( "ConfdOrderQtyByMatlAvailCheck" )
    @Nullable
    @ODataField( odataName = "ConfdOrderQtyByMatlAvailCheck" )
    private BigDecimal confdOrderQtyByMatlAvailCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConfdOrderQtyByMatlAvailCheck</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<BigDecimal> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK =
        new SalesSchedgAgrmtSchedLineField<BigDecimal>("ConfdOrderQtyByMatlAvailCheck");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityDate</b>
     * </p>
     *
     * @return Material Staging/Availability Date
     */
    @SerializedName( "ProductAvailabilityDate" )
    @JsonProperty( "ProductAvailabilityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductAvailabilityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productAvailabilityDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductAvailabilityDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalDateTime> PRODUCT_AVAILABILITY_DATE =
        new SalesSchedgAgrmtSchedLineField<LocalDateTime>("ProductAvailabilityDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityTime</b>
     * </p>
     *
     * @return Material Staging Time (Local, Relating to a Plant)
     */
    @SerializedName( "ProductAvailabilityTime" )
    @JsonProperty( "ProductAvailabilityTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ProductAvailabilityTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime productAvailabilityTime;
    /**
     * Use with available fluent helpers to apply the <b>ProductAvailabilityTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalTime> PRODUCT_AVAILABILITY_TIME =
        new SalesSchedgAgrmtSchedLineField<LocalTime>("ProductAvailabilityTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @return Schedule Line Blocked for Delivery
     */
    @SerializedName( "DelivBlockReasonForSchedLine" )
    @JsonProperty( "DelivBlockReasonForSchedLine" )
    @Nullable
    @ODataField( odataName = "DelivBlockReasonForSchedLine" )
    private String delivBlockReasonForSchedLine;
    /**
     * Use with available fluent helpers to apply the <b>DelivBlockReasonForSchedLine</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> DELIV_BLOCK_REASON_FOR_SCHED_LINE =
        new SalesSchedgAgrmtSchedLineField<String>("DelivBlockReasonForSchedLine");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningDate</b>
     * </p>
     *
     * @return Transportation Planning Date
     */
    @SerializedName( "TransportationPlanningDate" )
    @JsonProperty( "TransportationPlanningDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TransportationPlanningDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime transportationPlanningDate;
    /**
     * Use with available fluent helpers to apply the <b>TransportationPlanningDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalDateTime> TRANSPORTATION_PLANNING_DATE =
        new SalesSchedgAgrmtSchedLineField<LocalDateTime>("TransportationPlanningDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningTime</b>
     * </p>
     *
     * @return Transp. Planning Time (Local, Relating to a Shipping Point)
     */
    @SerializedName( "TransportationPlanningTime" )
    @JsonProperty( "TransportationPlanningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TransportationPlanningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime transportationPlanningTime;
    /**
     * Use with available fluent helpers to apply the <b>TransportationPlanningTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalTime> TRANSPORTATION_PLANNING_TIME =
        new SalesSchedgAgrmtSchedLineField<LocalTime>("TransportationPlanningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueDate</b>
     * </p>
     *
     * @return Goods Issue Date
     */
    @SerializedName( "GoodsIssueDate" )
    @JsonProperty( "GoodsIssueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "GoodsIssueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime goodsIssueDate;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalDateTime> GOODS_ISSUE_DATE =
        new SalesSchedgAgrmtSchedLineField<LocalDateTime>("GoodsIssueDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingDate</b>
     * </p>
     *
     * @return Loading Date
     */
    @SerializedName( "LoadingDate" )
    @JsonProperty( "LoadingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LoadingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime loadingDate;
    /**
     * Use with available fluent helpers to apply the <b>LoadingDate</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalDateTime> LOADING_DATE =
        new SalesSchedgAgrmtSchedLineField<LocalDateTime>("LoadingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueTime</b>
     * </p>
     *
     * @return Time of Goods Issue (Local, Relating to a Plant)
     */
    @SerializedName( "GoodsIssueTime" )
    @JsonProperty( "GoodsIssueTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "GoodsIssueTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime goodsIssueTime;
    /**
     * Use with available fluent helpers to apply the <b>GoodsIssueTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalTime> GOODS_ISSUE_TIME =
        new SalesSchedgAgrmtSchedLineField<LocalTime>("GoodsIssueTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingTime</b>
     * </p>
     *
     * @return Loading Time (Local Time Relating to a Shipping Point)
     */
    @SerializedName( "LoadingTime" )
    @JsonProperty( "LoadingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LoadingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime loadingTime;
    /**
     * Use with available fluent helpers to apply the <b>LoadingTime</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<LocalTime> LOADING_TIME =
        new SalesSchedgAgrmtSchedLineField<LocalTime>("LoadingTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> GOODS_MOVEMENT_TYPE =
        new SalesSchedgAgrmtSchedLineField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustEngineeringChgStatus</b>
     * </p>
     *
     * @return Customer Engineering Change Status
     */
    @SerializedName( "CustEngineeringChgStatus" )
    @JsonProperty( "CustEngineeringChgStatus" )
    @Nullable
    @ODataField( odataName = "CustEngineeringChgStatus" )
    private String custEngineeringChgStatus;
    /**
     * Use with available fluent helpers to apply the <b>CustEngineeringChgStatus</b> field to query operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineField<String> CUST_ENGINEERING_CHG_STATUS =
        new SalesSchedgAgrmtSchedLineField<String>("CustEngineeringChgStatus");
    /**
     * Navigation property <b>to_SalesSchedgAgrmtDelivSched</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
     * <b>SalesSchedgAgrmtDelivSched</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtDelivSched" )
    @JsonProperty( "to_SalesSchedgAgrmtDelivSched" )
    @ODataField( odataName = "to_SalesSchedgAgrmtDelivSched" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmtDelivSched toSalesSchedgAgrmtDelivSched;
    /**
     * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
     * <b>SalesSchedgAgrmt</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmt" )
    @JsonProperty( "to_SalesSchedgAgrmt" )
    @ODataField( odataName = "to_SalesSchedgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmt toSalesSchedgAgrmt;
    /**
     * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
     * <b>SalesSchedgAgrmtItem</b>.
     *
     */
    @SerializedName( "to_SalesSchedgAgrmtItem" )
    @JsonProperty( "to_SalesSchedgAgrmtItem" )
    @ODataField( odataName = "to_SalesSchedgAgrmtItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtDelivSched</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmtDelivSched> TO_SALES_SCHEDG_AGRMT_DELIV_SCHED =
        new SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmtDelivSched>("to_SalesSchedgAgrmtDelivSched");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmt</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmt> TO_SALES_SCHEDG_AGRMT =
        new SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmt>("to_SalesSchedgAgrmt");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesSchedgAgrmtItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmtItem> TO_SALES_SCHEDG_AGRMT_ITEM =
        new SalesSchedgAgrmtSchedLineOneToOneLink<SalesSchedgAgrmtItem>("to_SalesSchedgAgrmtItem");

    @Nonnull
    @Override
    public Class<SalesSchedgAgrmtSchedLine> getType()
    {
        return SalesSchedgAgrmtSchedLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     * </p>
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     */
    public void setSalesSchedulingAgreement( @Nullable final String salesSchedulingAgreement )
    {
        rememberChangedField("SalesSchedulingAgreement", this.salesSchedulingAgreement);
        this.salesSchedulingAgreement = salesSchedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     * </p>
     *
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     */
    public void setSalesSchedulingAgreementItem( @Nullable final String salesSchedulingAgreementItem )
    {
        rememberChangedField("SalesSchedulingAgreementItem", this.salesSchedulingAgreementItem);
        this.salesSchedulingAgreementItem = salesSchedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementReleaseType</b>
     * </p>
     *
     * @param schedulingAgreementReleaseType
     *            Release type
     */
    public void setSchedulingAgreementReleaseType( @Nullable final String schedulingAgreementReleaseType )
    {
        rememberChangedField("SchedulingAgreementReleaseType", this.schedulingAgreementReleaseType);
        this.schedulingAgreementReleaseType = schedulingAgreementReleaseType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineCategory</b>
     * </p>
     *
     * @param scheduleLineCategory
     *            Schedule Line Category
     */
    public void setScheduleLineCategory( @Nullable final String scheduleLineCategory )
    {
        rememberChangedField("ScheduleLineCategory", this.scheduleLineCategory);
        this.scheduleLineCategory = scheduleLineCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDelivDateCategory</b>
     * </p>
     *
     * @param salesDelivDateCategory
     *            Delivery Date Type (Day, Week, Month, Interval)
     */
    public void setSalesDelivDateCategory( @Nullable final String salesDelivDateCategory )
    {
        rememberChangedField("SalesDelivDateCategory", this.salesDelivDateCategory);
        this.salesDelivDateCategory = salesDelivDateCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryTime</b>
     * </p>
     *
     * @param requestedDeliveryTime
     *            Arrival time
     */
    public void setRequestedDeliveryTime( @Nullable final LocalTime requestedDeliveryTime )
    {
        rememberChangedField("RequestedDeliveryTime", this.requestedDeliveryTime);
        this.requestedDeliveryTime = requestedDeliveryTime;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Order Quantity in Sales Units
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param correctedQtyInOrderQtyUnit
     *            Corrected quantity in sales unit
     */
    public void setCorrectedQtyInOrderQtyUnit( @Nullable final BigDecimal correctedQtyInOrderQtyUnit )
    {
        rememberChangedField("CorrectedQtyInOrderQtyUnit", this.correctedQtyInOrderQtyUnit);
        this.correctedQtyInOrderQtyUnit = correctedQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOpenQuantity</b>
     * </p>
     *
     * @param scheduleLineOpenQuantity
     *            Open quantity to be delivered (in sales unit)
     */
    public void setScheduleLineOpenQuantity( @Nullable final BigDecimal scheduleLineOpenQuantity )
    {
        rememberChangedField("ScheduleLineOpenQuantity", this.scheduleLineOpenQuantity);
        this.scheduleLineOpenQuantity = scheduleLineOpenQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @param confdOrderQtyByMatlAvailCheck
     *            Confirmed Quantity
     */
    public void setConfdOrderQtyByMatlAvailCheck( @Nullable final BigDecimal confdOrderQtyByMatlAvailCheck )
    {
        rememberChangedField("ConfdOrderQtyByMatlAvailCheck", this.confdOrderQtyByMatlAvailCheck);
        this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityDate</b>
     * </p>
     *
     * @param productAvailabilityDate
     *            Material Staging/Availability Date
     */
    public void setProductAvailabilityDate( @Nullable final LocalDateTime productAvailabilityDate )
    {
        rememberChangedField("ProductAvailabilityDate", this.productAvailabilityDate);
        this.productAvailabilityDate = productAvailabilityDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductAvailabilityTime</b>
     * </p>
     *
     * @param productAvailabilityTime
     *            Material Staging Time (Local, Relating to a Plant)
     */
    public void setProductAvailabilityTime( @Nullable final LocalTime productAvailabilityTime )
    {
        rememberChangedField("ProductAvailabilityTime", this.productAvailabilityTime);
        this.productAvailabilityTime = productAvailabilityTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @param delivBlockReasonForSchedLine
     *            Schedule Line Blocked for Delivery
     */
    public void setDelivBlockReasonForSchedLine( @Nullable final String delivBlockReasonForSchedLine )
    {
        rememberChangedField("DelivBlockReasonForSchedLine", this.delivBlockReasonForSchedLine);
        this.delivBlockReasonForSchedLine = delivBlockReasonForSchedLine;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningDate</b>
     * </p>
     *
     * @param transportationPlanningDate
     *            Transportation Planning Date
     */
    public void setTransportationPlanningDate( @Nullable final LocalDateTime transportationPlanningDate )
    {
        rememberChangedField("TransportationPlanningDate", this.transportationPlanningDate);
        this.transportationPlanningDate = transportationPlanningDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TransportationPlanningTime</b>
     * </p>
     *
     * @param transportationPlanningTime
     *            Transp. Planning Time (Local, Relating to a Shipping Point)
     */
    public void setTransportationPlanningTime( @Nullable final LocalTime transportationPlanningTime )
    {
        rememberChangedField("TransportationPlanningTime", this.transportationPlanningTime);
        this.transportationPlanningTime = transportationPlanningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueDate</b>
     * </p>
     *
     * @param goodsIssueDate
     *            Goods Issue Date
     */
    public void setGoodsIssueDate( @Nullable final LocalDateTime goodsIssueDate )
    {
        rememberChangedField("GoodsIssueDate", this.goodsIssueDate);
        this.goodsIssueDate = goodsIssueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingDate</b>
     * </p>
     *
     * @param loadingDate
     *            Loading Date
     */
    public void setLoadingDate( @Nullable final LocalDateTime loadingDate )
    {
        rememberChangedField("LoadingDate", this.loadingDate);
        this.loadingDate = loadingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsIssueTime</b>
     * </p>
     *
     * @param goodsIssueTime
     *            Time of Goods Issue (Local, Relating to a Plant)
     */
    public void setGoodsIssueTime( @Nullable final LocalTime goodsIssueTime )
    {
        rememberChangedField("GoodsIssueTime", this.goodsIssueTime);
        this.goodsIssueTime = goodsIssueTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LoadingTime</b>
     * </p>
     *
     * @param loadingTime
     *            Loading Time (Local Time Relating to a Shipping Point)
     */
    public void setLoadingTime( @Nullable final LocalTime loadingTime )
    {
        rememberChangedField("LoadingTime", this.loadingTime);
        this.loadingTime = loadingTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>CustEngineeringChgStatus</b>
     * </p>
     *
     * @param custEngineeringChgStatus
     *            Customer Engineering Change Status
     */
    public void setCustEngineeringChgStatus( @Nullable final String custEngineeringChgStatus )
    {
        rememberChangedField("CustEngineeringChgStatus", this.custEngineeringChgStatus);
        this.custEngineeringChgStatus = custEngineeringChgStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesSchedgAgrmtSchedLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        result.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesSchedulingAgreement", getSalesSchedulingAgreement());
        values.put("SalesSchedulingAgreementItem", getSalesSchedulingAgreementItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("SchedulingAgreementReleaseType", getSchedulingAgreementReleaseType());
        values.put("ScheduleLineCategory", getScheduleLineCategory());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("SalesDelivDateCategory", getSalesDelivDateCategory());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("RequestedDeliveryTime", getRequestedDeliveryTime());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("CorrectedQtyInOrderQtyUnit", getCorrectedQtyInOrderQtyUnit());
        values.put("ScheduleLineOpenQuantity", getScheduleLineOpenQuantity());
        values.put("ConfdOrderQtyByMatlAvailCheck", getConfdOrderQtyByMatlAvailCheck());
        values.put("ProductAvailabilityDate", getProductAvailabilityDate());
        values.put("ProductAvailabilityTime", getProductAvailabilityTime());
        values.put("DelivBlockReasonForSchedLine", getDelivBlockReasonForSchedLine());
        values.put("TransportationPlanningDate", getTransportationPlanningDate());
        values.put("TransportationPlanningTime", getTransportationPlanningTime());
        values.put("GoodsIssueDate", getGoodsIssueDate());
        values.put("LoadingDate", getLoadingDate());
        values.put("GoodsIssueTime", getGoodsIssueTime());
        values.put("LoadingTime", getLoadingTime());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("CustEngineeringChgStatus", getCustEngineeringChgStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesSchedulingAgreement") ) {
                final Object value = values.remove("SalesSchedulingAgreement");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreement())) ) {
                    setSalesSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SalesSchedulingAgreementItem") ) {
                final Object value = values.remove("SalesSchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSalesSchedulingAgreementItem())) ) {
                    setSalesSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementReleaseType") ) {
                final Object value = values.remove("SchedulingAgreementReleaseType");
                if( (value == null) || (!value.equals(getSchedulingAgreementReleaseType())) ) {
                    setSchedulingAgreementReleaseType(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineCategory") ) {
                final Object value = values.remove("ScheduleLineCategory");
                if( (value == null) || (!value.equals(getScheduleLineCategory())) ) {
                    setScheduleLineCategory(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("SalesDelivDateCategory") ) {
                final Object value = values.remove("SalesDelivDateCategory");
                if( (value == null) || (!value.equals(getSalesDelivDateCategory())) ) {
                    setSalesDelivDateCategory(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequestedDeliveryTime") ) {
                final Object value = values.remove("RequestedDeliveryTime");
                if( (value == null) || (!value.equals(getRequestedDeliveryTime())) ) {
                    setRequestedDeliveryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CorrectedQtyInOrderQtyUnit") ) {
                final Object value = values.remove("CorrectedQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getCorrectedQtyInOrderQtyUnit())) ) {
                    setCorrectedQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ScheduleLineOpenQuantity") ) {
                final Object value = values.remove("ScheduleLineOpenQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOpenQuantity())) ) {
                    setScheduleLineOpenQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfdOrderQtyByMatlAvailCheck") ) {
                final Object value = values.remove("ConfdOrderQtyByMatlAvailCheck");
                if( (value == null) || (!value.equals(getConfdOrderQtyByMatlAvailCheck())) ) {
                    setConfdOrderQtyByMatlAvailCheck(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductAvailabilityDate") ) {
                final Object value = values.remove("ProductAvailabilityDate");
                if( (value == null) || (!value.equals(getProductAvailabilityDate())) ) {
                    setProductAvailabilityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductAvailabilityTime") ) {
                final Object value = values.remove("ProductAvailabilityTime");
                if( (value == null) || (!value.equals(getProductAvailabilityTime())) ) {
                    setProductAvailabilityTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DelivBlockReasonForSchedLine") ) {
                final Object value = values.remove("DelivBlockReasonForSchedLine");
                if( (value == null) || (!value.equals(getDelivBlockReasonForSchedLine())) ) {
                    setDelivBlockReasonForSchedLine(((String) value));
                }
            }
            if( values.containsKey("TransportationPlanningDate") ) {
                final Object value = values.remove("TransportationPlanningDate");
                if( (value == null) || (!value.equals(getTransportationPlanningDate())) ) {
                    setTransportationPlanningDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TransportationPlanningTime") ) {
                final Object value = values.remove("TransportationPlanningTime");
                if( (value == null) || (!value.equals(getTransportationPlanningTime())) ) {
                    setTransportationPlanningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("GoodsIssueDate") ) {
                final Object value = values.remove("GoodsIssueDate");
                if( (value == null) || (!value.equals(getGoodsIssueDate())) ) {
                    setGoodsIssueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LoadingDate") ) {
                final Object value = values.remove("LoadingDate");
                if( (value == null) || (!value.equals(getLoadingDate())) ) {
                    setLoadingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsIssueTime") ) {
                final Object value = values.remove("GoodsIssueTime");
                if( (value == null) || (!value.equals(getGoodsIssueTime())) ) {
                    setGoodsIssueTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LoadingTime") ) {
                final Object value = values.remove("LoadingTime");
                if( (value == null) || (!value.equals(getLoadingTime())) ) {
                    setLoadingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("CustEngineeringChgStatus") ) {
                final Object value = values.remove("CustEngineeringChgStatus");
                if( (value == null) || (!value.equals(getCustEngineeringChgStatus())) ) {
                    setCustEngineeringChgStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesSchedgAgrmtDelivSched") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtDelivSched");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmtDelivSched == null ) {
                        toSalesSchedgAgrmtDelivSched = new SalesSchedgAgrmtDelivSched();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmtDelivSched.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmt") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmt");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmt == null ) {
                        toSalesSchedgAgrmt = new SalesSchedgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesSchedgAgrmtItem") ) {
                final Object value = (values).remove("to_SalesSchedgAgrmtItem");
                if( value instanceof Map ) {
                    if( toSalesSchedgAgrmtItem == null ) {
                        toSalesSchedgAgrmtItem = new SalesSchedgAgrmtItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesSchedgAgrmtItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesSchedgAgrmtSchedLineField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesSchedgAgrmtSchedLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesSchedgAgrmtSchedLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesSchedgAgrmtSchedLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesSchedgAgrmtDelivSched != null ) {
            (values).put("to_SalesSchedgAgrmtDelivSched", toSalesSchedgAgrmtDelivSched);
        }
        if( toSalesSchedgAgrmt != null ) {
            (values).put("to_SalesSchedgAgrmt", toSalesSchedgAgrmt);
        }
        if( toSalesSchedgAgrmtItem != null ) {
            (values).put("to_SalesSchedgAgrmtItem", toSalesSchedgAgrmtItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtDelivSched</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmtDelivSched</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtDelivSched fetchSalesSchedgAgrmtDelivSched()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmtDelivSched", SalesSchedgAgrmtDelivSched.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtDelivSched</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtDelivSched</b> of a queried <b>SalesSchedgAgrmtSchedLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtDelivSched</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtDelivSched getSalesSchedgAgrmtDelivSchedOrFetch()
    {
        if( toSalesSchedgAgrmtDelivSched == null ) {
            toSalesSchedgAgrmtDelivSched = fetchSalesSchedgAgrmtDelivSched();
        }
        return toSalesSchedgAgrmtDelivSched;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtDelivSched</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesSchedgAgrmtDelivSched</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtSchedLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtDelivSched</b> is already loaded, the
     *         result will contain the <b>SalesSchedgAgrmtDelivSched</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmtDelivSched> getSalesSchedgAgrmtDelivSchedIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtDelivSched);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmtDelivSched</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmtDelivSched</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmtDelivSched</b> entity.
     */
    public void setSalesSchedgAgrmtDelivSched( final SalesSchedgAgrmtDelivSched value )
    {
        toSalesSchedgAgrmtDelivSched = value;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmt</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmt</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt fetchSalesSchedgAgrmt()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmt", SalesSchedgAgrmt.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmt</b> of a queried <b>SalesSchedgAgrmtSchedLine</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmt getSalesSchedgAgrmtOrFetch()
    {
        if( toSalesSchedgAgrmt == null ) {
            toSalesSchedgAgrmt = fetchSalesSchedgAgrmt();
        }
        return toSalesSchedgAgrmt;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtSchedLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmt</b> is already loaded, the result will
     *         contain the <b>SalesSchedgAgrmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmt> getSalesSchedgAgrmtIfPresent()
    {
        return Option.of(toSalesSchedgAgrmt);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmt</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmt</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmt</b> entity.
     */
    public void setSalesSchedgAgrmt( final SalesSchedgAgrmt value )
    {
        toSalesSchedgAgrmt = value;
    }

    /**
     * Fetches the <b>SalesSchedgAgrmtItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesSchedgAgrmtItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem fetchSalesSchedgAgrmtItem()
    {
        return fetchFieldAsSingle("to_SalesSchedgAgrmtItem", SalesSchedgAgrmtItem.class);
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property <b>to_SalesSchedgAgrmtItem</b> of a queried <b>SalesSchedgAgrmtSchedLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesSchedgAgrmtItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesSchedgAgrmtItem getSalesSchedgAgrmtItemOrFetch()
    {
        if( toSalesSchedgAgrmtItem == null ) {
            toSalesSchedgAgrmtItem = fetchSalesSchedgAgrmtItem();
        }
        return toSalesSchedgAgrmtItem;
    }

    /**
     * Retrieval of associated <b>SalesSchedgAgrmtItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesSchedgAgrmtItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesSchedgAgrmtSchedLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesSchedgAgrmtItem</b> is already loaded, the result
     *         will contain the <b>SalesSchedgAgrmtItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesSchedgAgrmtItem> getSalesSchedgAgrmtItemIfPresent()
    {
        return Option.of(toSalesSchedgAgrmtItem);
    }

    /**
     * Overwrites the associated <b>SalesSchedgAgrmtItem</b> entity for the loaded navigation property
     * <b>to_SalesSchedgAgrmtItem</b>.
     *
     * @param value
     *            New <b>SalesSchedgAgrmtItem</b> entity.
     */
    public void setSalesSchedgAgrmtItem( final SalesSchedgAgrmtItem value )
    {
        toSalesSchedgAgrmtItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesSchedgAgrmtSchedLine instances.
     *
     */
    public final static class SalesSchedgAgrmtSchedLineBuilder
    {

        private SalesSchedgAgrmtDelivSched toSalesSchedgAgrmtDelivSched;
        private SalesSchedgAgrmt toSalesSchedgAgrmt;
        private SalesSchedgAgrmtItem toSalesSchedgAgrmtItem;

        private SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder toSalesSchedgAgrmtDelivSched(
            final SalesSchedgAgrmtDelivSched value )
        {
            toSalesSchedgAgrmtDelivSched = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtDelivSched</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
         * <b>SalesSchedgAgrmtDelivSched</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtDelivSched to build this SalesSchedgAgrmtSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder salesSchedgAgrmtDelivSched(
            final SalesSchedgAgrmtDelivSched value )
        {
            return toSalesSchedgAgrmtDelivSched(value);
        }

        private SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder toSalesSchedgAgrmt(
            final SalesSchedgAgrmt value )
        {
            toSalesSchedgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmt</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
         * <b>SalesSchedgAgrmt</b>.
         *
         * @param value
         *            The SalesSchedgAgrmt to build this SalesSchedgAgrmtSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder salesSchedgAgrmt(
            final SalesSchedgAgrmt value )
        {
            return toSalesSchedgAgrmt(value);
        }

        private SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder toSalesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            toSalesSchedgAgrmtItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesSchedgAgrmtItem</b> for <b>SalesSchedgAgrmtSchedLine</b> to single
         * <b>SalesSchedgAgrmtItem</b>.
         *
         * @param value
         *            The SalesSchedgAgrmtItem to build this SalesSchedgAgrmtSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesSchedgAgrmtSchedLine.SalesSchedgAgrmtSchedLineBuilder salesSchedgAgrmtItem(
            final SalesSchedgAgrmtItem value )
        {
            return toSalesSchedgAgrmtItem(value);
        }

    }

}
