/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable.SalesSchedgAgrmtSchedLineSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
 * SalesSchedgAgrmtSchedLine} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesSchedgAgrmtSchedLineByKeyFluentHelper
    extends
    FluentHelperByKey<SalesSchedgAgrmtSchedLineByKeyFluentHelper, SalesSchedgAgrmtSchedLine, SalesSchedgAgrmtSchedLineSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
     * SalesSchedgAgrmtSchedLine} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesSchedgAgrmtSchedLine}
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesSchedgAgrmtSchedLine}
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SalesSchedgAgrmtSchedLineByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String scheduleLine )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesSchedulingAgreement", salesSchedulingAgreement);
        this.key.put("SalesSchedulingAgreementItem", salesSchedulingAgreementItem);
        this.key.put("ScheduleLine", scheduleLine);
    }

    @Override
    @Nonnull
    protected Class<SalesSchedgAgrmtSchedLine> getEntityClass()
    {
        return SalesSchedgAgrmtSchedLine.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
