/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesSchedulingAgreementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService
 * SalesSchedulingAgreementService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesSchedulingAgreementServiceBatch
    extends
    BatchFluentHelperBasic<SalesSchedulingAgreementServiceBatch, SalesSchedulingAgreementServiceBatchChangeSet>
    implements
    SalesSchedulingAgreementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesSchedulingAgreementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesSchedulingAgreementServiceBatchChangeSet(this, service);
    }

}
