/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText;

/**
 * Implementation of the {@link SalesSchedulingAgreementServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService
 * SalesSchedulingAgreementService}.
 *
 */
public class DefaultSalesSchedulingAgreementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesSchedulingAgreementServiceBatch, SalesSchedulingAgreementServiceBatchChangeSet>
    implements
    SalesSchedulingAgreementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesSchedulingAgreementServiceBatchChangeSet(
        @Nonnull final DefaultSalesSchedulingAgreementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesSchedulingAgreementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet createSalesSchedgAgrmt(
        @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return addRequestCreate(service::createSalesSchedgAgrmt, salesSchedgAgrmt);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmt(
        @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmt, salesSchedgAgrmt);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmt(
        @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmt, salesSchedgAgrmt);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet createSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return addRequestCreate(service::createSalesSchedgAgrmtItem, salesSchedgAgrmtItem);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtItem, salesSchedgAgrmtItem);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtItem(
        @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtItem, salesSchedgAgrmtItem);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtItemPartner(
        @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtItemPartner, salesSchedgAgrmtItemPartner);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtItemPartner(
        @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtItemPartner, salesSchedgAgrmtItemPartner);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtItemText(
        @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtItemText, salesSchedgAgrmtItemText);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtItemText(
        @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtItemText, salesSchedgAgrmtItemText);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtItmPrcgElmnt(
        @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtItmPrcgElmnt, salesSchedgAgrmtItmPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtItmPrcgElmnt(
        @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtItmPrcgElmnt, salesSchedgAgrmtItmPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtPartner(
        @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtPartner, salesSchedgAgrmtPartner);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtPartner(
        @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtPartner, salesSchedgAgrmtPartner);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtPrcgElement(
        @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtPrcgElement, salesSchedgAgrmtPrcgElement);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtPrcgElement(
        @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtPrcgElement, salesSchedgAgrmtPrcgElement);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet updateSalesSchedgAgrmtText(
        @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText )
    {
        return addRequestUpdate(service::updateSalesSchedgAgrmtText, salesSchedgAgrmtText);
    }

    @Nonnull
    @Override
    public SalesSchedulingAgreementServiceBatchChangeSet deleteSalesSchedgAgrmtText(
        @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText )
    {
        return addRequestDelete(service::deleteSalesSchedgAgrmtText, salesSchedgAgrmtText);
    }

}
