/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesSchedulingAgreementService
 * SalesSchedulingAgreementService}.
 *
 */
public interface SalesSchedulingAgreementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesSchedulingAgreementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesSchedulingAgreementServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        createSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        createSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *            SalesSchedgAgrmtItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtItemPartner( @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *            SalesSchedgAgrmtItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtItemPartner( @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *            SalesSchedgAgrmtItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtItemText( @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *            SalesSchedgAgrmtItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtItemText( @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItmPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *            SalesSchedgAgrmtItmPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtItmPrcgElmnt( @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItmPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *            SalesSchedgAgrmtItmPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtItmPrcgElmnt( @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *            SalesSchedgAgrmtPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtPartner( @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *            SalesSchedgAgrmtPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtPartner( @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtPrcgElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *            SalesSchedgAgrmtPrcgElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtPrcgElement( @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtPrcgElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *            SalesSchedgAgrmtPrcgElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtPrcgElement( @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *            SalesSchedgAgrmtText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        updateSalesSchedgAgrmtText( @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *            SalesSchedgAgrmtText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesSchedulingAgreementServiceBatchChangeSet
        deleteSalesSchedgAgrmtText( @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText );

}
