/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
 * SalesSchedgAgrmtDelivSched}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtDelivSchedField
 * SalesSchedgAgrmtDelivSchedField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtDelivSchedLink
 * SalesSchedgAgrmtDelivSchedLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#SALES_SCHEDULING_AGREEMENT
 * SALES_SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#SALES_SCHEDULING_AGREEMENT_ITEM
 * SALES_SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#INT_DELIVERY_SCHEDULE_NUMBER
 * INT_DELIVERY_SCHEDULE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#SCHEDULING_AGREEMENT_RELEASE_TYPE
 * SCHEDULING_AGREEMENT_RELEASE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIVERY_SCHEDULE_START_DATE
 * DELIVERY_SCHEDULE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIVERY_SCHEDULE_END_DATE
 * DELIVERY_SCHEDULE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUSTOMER_DELIVERY_SCHEDULE_NUMBER
 * CUSTOMER_DELIVERY_SCHEDULE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIVERY_SCHEDULE_DATE
 * DELIVERY_SCHEDULE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#SCHEDULE_LINE_DATE_KEY
 * SCHEDULE_LINE_DATE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_DELIVERY_DOC_POSTING_DATE
 * LAST_DELIVERY_DOC_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_DELIVERY_DOCUMENT
 * LAST_DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_INT_DELIVERY_SCHEDULE_NUMBER
 * LAST_INT_DELIVERY_SCHEDULE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#JIT_HORIZON_END_DATE
 * JIT_HORIZON_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUSTOMER_FISCAL_YEAR
 * CUSTOMER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#REQUIREMENTS_STATUS_KEY
 * REQUIREMENTS_STATUS_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIVERY_SCHEDULE_CREATION_DATE
 * DELIVERY_SCHEDULE_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIV_SCHED_FREE_DEFINED_ATTRIB01
 * DELIV_SCHED_FREE_DEFINED_ATTRIB01}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIV_SCHED_FREE_DEFINED_ATTRIB02
 * DELIV_SCHED_FREE_DEFINED_ATTRIB02}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIV_SCHED_FREE_DEFINED_ATTRIB03
 * DELIV_SCHED_FREE_DEFINED_ATTRIB03}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIV_SCHED_FREE_DEFINED_ATTRIB04
 * DELIV_SCHED_FREE_DEFINED_ATTRIB04}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#DELIV_SCHED_FREE_DEFINED_ATTRIB05
 * DELIV_SCHED_FREE_DEFINED_ATTRIB05}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#PRODN_GO_AHEAD_PERIOD_START_DATE
 * PRODN_GO_AHEAD_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#PRODUCTION_GO_AHEAD_PERIOD_END_DATE
 * PRODUCTION_GO_AHEAD_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#MATERIAL_GO_AHEAD_PERIOD_START_DATE
 * MATERIAL_GO_AHEAD_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#MATERIAL_GO_AHEAD_PERIOD_END_DATE
 * MATERIAL_GO_AHEAD_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUSTOMER_POINT_OF_CONSUMPTION
 * CUSTOMER_POINT_OF_CONSUMPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#HIGH_PRIORITY_STOCK_KEY
 * HIGH_PRIORITY_STOCK_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUMLTV_QTY_FSCL_YEAR_RSET_DATE
 * CUMLTV_QTY_FSCL_YEAR_RSET_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#MATL_GO_AHEAD_VALIDITY_PERIOD
 * MATL_GO_AHEAD_VALIDITY_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#MATL_GO_AHEAD_VALIDITY_PERIOD_UNIT
 * MATL_GO_AHEAD_VALIDITY_PERIOD_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#PRODN_GO_AHEAD_VALIDITY_PERIOD
 * PRODN_GO_AHEAD_VALIDITY_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#PRODN_GO_AHEAD_VALIDITY_PERIOD_UNIT
 * PRODN_GO_AHEAD_VALIDITY_PERIOD_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUST_RCVD_CUMLTV_QTY_BY_FSCL_YR_CHG
 * CUST_RCVD_CUMLTV_QTY_BY_FSCL_YR_CHG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_RECEIPT_QUANTITY
 * LAST_RECEIPT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUMULATIVE_RECEIPT_QUANTITY
 * CUMULATIVE_RECEIPT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#HGHST_DELIV_GO_AHEAD_CUMLTV_QTY
 * HGHST_DELIV_GO_AHEAD_CUMLTV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#ACTL_MATL_GO_AHEAD_CUMLTV_QTY
 * ACTL_MATL_GO_AHEAD_CUMLTV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#ACTL_PRODN_GO_AHEAD_CUMLTV_QTY
 * ACTL_PRODN_GO_AHEAD_CUMLTV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#ACTL_DELIV_GO_AHEAD_CUMLTV_QTY
 * ACTL_DELIV_GO_AHEAD_CUMLTV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#HGHST_MATL_GO_AHEAD_CUMLTV_QTY
 * HGHST_MATL_GO_AHEAD_CUMLTV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_DELIVERY_NOTE_SENT_BY_EXT_AGT
 * LAST_DELIVERY_NOTE_SENT_BY_EXT_AGT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_DELIVERY_NOTE_SENT_DATE
 * LAST_DELIVERY_NOTE_SENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_DELIVERY_CUMLTV_ISSD_QTY
 * LAST_DELIVERY_CUMLTV_ISSD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#EXTERNAL_AGENT_CUMLTV_ISSD_QTY
 * EXTERNAL_AGENT_CUMLTV_ISSD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUMULATIVE_ISSUED_QUANTITY
 * CUMULATIVE_ISSUED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUMULATIVE_DELIVERED_QUANTITY
 * CUMULATIVE_DELIVERED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#CUMULATIVE_IN_TRANSIT_QUANTITY
 * CUMULATIVE_IN_TRANSIT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#SALES_SCHEDG_AGRMT_IN_TRNST_QTY
 * SALES_SCHEDG_AGRMT_IN_TRNST_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#TO_SALES_SCHEDG_AGRMT
 * TO_SALES_SCHEDG_AGRMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#TO_SALES_SCHEDG_AGRMT_SCHED_LINE
 * TO_SALES_SCHEDG_AGRMT_SCHED_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched#TO_SALES_SCHEDG_AGRMT_ITEM
 * TO_SALES_SCHEDG_AGRMT_ITEM}</li>
 * </ul>
 *
 */
public interface SalesSchedgAgrmtDelivSchedSelectable extends EntitySelectable<SalesSchedgAgrmtDelivSched>
{

}
