/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
 * SalesSchedgAgrmtItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtItemPartnerField
 * SalesSchedgAgrmtItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtItemPartnerLink
 * SalesSchedgAgrmtItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#SALES_SCHEDULING_AGREEMENT
 * SALES_SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#SALES_SCHEDULING_AGREEMENT_ITEM
 * SALES_SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#TO_SALES_SCHEDG_AGRMT
 * TO_SALES_SCHEDG_AGRMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner#TO_SALES_SCHEDG_AGRMT_ITEM
 * TO_SALES_SCHEDG_AGRMT_ITEM}</li>
 * </ul>
 *
 */
public interface SalesSchedgAgrmtItemPartnerSelectable extends EntitySelectable<SalesSchedgAgrmtItemPartner>
{

}
