/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
 * SalesSchedgAgrmtPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtPartnerField
 * SalesSchedgAgrmtPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtPartnerLink
 * SalesSchedgAgrmtPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#SALES_SCHEDULING_AGREEMENT
 * SALES_SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner#TO_SALES_SCHEDG_AGRMT
 * TO_SALES_SCHEDG_AGRMT}</li>
 * </ul>
 *
 */
public interface SalesSchedgAgrmtPartnerSelectable extends EntitySelectable<SalesSchedgAgrmtPartner>
{

}
