/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
 * SalesSchedgAgrmtSchedLine}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.field.SalesSchedgAgrmtSchedLineField
 * SalesSchedgAgrmtSchedLineField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.link.SalesSchedgAgrmtSchedLineLink
 * SalesSchedgAgrmtSchedLineLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SALES_SCHEDULING_AGREEMENT
 * SALES_SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SALES_SCHEDULING_AGREEMENT_ITEM
 * SALES_SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SCHEDULING_AGREEMENT_RELEASE_TYPE
 * SCHEDULING_AGREEMENT_RELEASE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SCHEDULE_LINE_CATEGORY
 * SCHEDULE_LINE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#ORDER_QUANTITY_SAP_UNIT
 * ORDER_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#ORDER_QUANTITY_ISO_UNIT
 * ORDER_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SALES_DELIV_DATE_CATEGORY
 * SALES_DELIV_DATE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#REQUESTED_DELIVERY_TIME
 * REQUESTED_DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SCHEDULE_LINE_ORDER_QUANTITY
 * SCHEDULE_LINE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#CORRECTED_QTY_IN_ORDER_QTY_UNIT
 * CORRECTED_QTY_IN_ORDER_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#SCHEDULE_LINE_OPEN_QUANTITY
 * SCHEDULE_LINE_OPEN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK
 * CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#PRODUCT_AVAILABILITY_DATE
 * PRODUCT_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#PRODUCT_AVAILABILITY_TIME
 * PRODUCT_AVAILABILITY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#DELIV_BLOCK_REASON_FOR_SCHED_LINE
 * DELIV_BLOCK_REASON_FOR_SCHED_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#TRANSPORTATION_PLANNING_DATE
 * TRANSPORTATION_PLANNING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#TRANSPORTATION_PLANNING_TIME
 * TRANSPORTATION_PLANNING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#GOODS_ISSUE_DATE
 * GOODS_ISSUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#LOADING_DATE
 * LOADING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#GOODS_ISSUE_TIME
 * GOODS_ISSUE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#LOADING_TIME
 * LOADING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#CUST_ENGINEERING_CHG_STATUS
 * CUST_ENGINEERING_CHG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#TO_SALES_SCHEDG_AGRMT_DELIV_SCHED
 * TO_SALES_SCHEDG_AGRMT_DELIV_SCHED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#TO_SALES_SCHEDG_AGRMT
 * TO_SALES_SCHEDG_AGRMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine#TO_SALES_SCHEDG_AGRMT_ITEM
 * TO_SALES_SCHEDG_AGRMT_ITEM}</li>
 * </ul>
 *
 */
public interface SalesSchedgAgrmtSchedLineSelectable extends EntitySelectable<SalesSchedgAgrmtSchedLine>
{

}
