/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>ActionResponse</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ActionResponse extends VdmComplex<ActionResponse>
{

    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property from the Odata EDM: <b>Response</b>
     * </p>
     *
     * @param response
     *
     * @return Response
     */
    @SerializedName( "Response" )
    @JsonProperty( "Response" )
    @Nullable
    @ODataField( odataName = "Response" )
    private String response;

    @Nonnull
    @Override
    public Class<ActionResponse> getType()
    {
        return ActionResponse.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Response", getResponse());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Response") ) {
                final Object value = values.remove("Response");
                if( (value == null) || (!value.equals(getResponse())) ) {
                    setResponse(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property from the Odata EDM: <b>Response</b>
     * </p>
     *
     * @param response
     *            Response
     */
    public void setResponse( @Nullable final String response )
    {
        rememberChangedField("Response", this.response);
        this.response = response;
    }

}
