/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.net.URI;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>HeaderRelease</b> OData function import.
 *
 */
public class HeaderReleaseFluentHelper
    extends
    SingleValuedFluentHelperFunction<HeaderReleaseFluentHelper, ActionResponse, ActionResponse>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>HeaderRelease</b> OData function import with the provided
     * parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper
     * object.
     *
     * @param schedgAgreementWithJitProfile
     *            Scheduling Agreement Jit Release Strategy Profile
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementWithJitProfile</b>
     *            </p>
     * @param schedgAgreementCreateWoutSline
     *            Create without Schedule Line
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateWoutSline</b>
     *            </p>
     * @param schedgAgreementCreateFrcOnly
     *            Forecast Only
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateFrcOnly</b>
     *            </p>
     * @param schedgAgreementdeactJitTolChck
     *            Deactivate Jit Tolerance Check
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementdeactJitTolChck</b>
     *            </p>
     * @param schedgAgreementStandardRelDate
     *            Schediling Agreement Release Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementStandardRelDate</b>
     *            </p>
     * @param schedgAgreementMoveCreateDate
     *            Move Release Creation Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementMoveCreateDate</b>
     *            </p>
     * @param schedgAgreementSelectionScope
     *            Scope of Selection
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementSelectionScope</b>
     *            </p>
     * @param schedgAgreementCreateFrcAndJit
     *            Forecast And Jit Schedule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateFrcAndJit</b>
     *            </p>
     * @param schedgAgreementOffFrcDynStop
     *            Deactivate Forecast Dynamic Stopping
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementOffFrcDynStop</b>
     *            </p>
     * @param schedulingAgreement
     *            Scheduling Agreement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreement</b>
     *            </p>
     * @param schedgAgreementOffJitDynStop
     *            Deactivate Jit Dynamic Stopping
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementOffJitDynStop</b>
     *            </p>
     * @param schedgAgreementWithFrcProfile
     *            Scheduling Agreement Forecast Release Strategy Profile
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementWithFrcProfile</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param schedgAgreementDeactFrcTolChck
     *            Deactivate Forecast Tolearance Check
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementDeactFrcTolChck</b>
     *            </p>
     * @param schedgAgreementCreateJitOnly
     *            Jit Only
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateJitOnly</b>
     *            </p>
     */
    public HeaderReleaseFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String schedulingAgreement,
        @Nonnull final Boolean schedgAgreementWithJitProfile,
        @Nonnull final Boolean schedgAgreementWithFrcProfile,
        @Nonnull final Boolean schedgAgreementCreateFrcAndJit,
        @Nonnull final Boolean schedgAgreementCreateFrcOnly,
        @Nonnull final Boolean schedgAgreementCreateJitOnly,
        @Nonnull final Boolean schedgAgreementCreateWoutSline,
        @Nonnull final Boolean schedgAgreementDeactFrcTolChck,
        @Nonnull final Boolean schedgAgreementdeactJitTolChck,
        @Nonnull final String schedgAgreementMoveCreateDate,
        @Nonnull final Boolean schedgAgreementOffFrcDynStop,
        @Nonnull final Boolean schedgAgreementOffJitDynStop,
        @Nonnull final String schedgAgreementSelectionScope,
        @Nonnull final String schedgAgreementStandardRelDate )
    {
        super(servicePath);
        values.put("SchedulingAgreement", schedulingAgreement);
        values.put("SchedgAgreementWithJitProfile", schedgAgreementWithJitProfile);
        values.put("SchedgAgreementWithFrcProfile", schedgAgreementWithFrcProfile);
        values.put("SchedgAgreementCreateFrcAndJit", schedgAgreementCreateFrcAndJit);
        values.put("SchedgAgreementCreateFrcOnly", schedgAgreementCreateFrcOnly);
        values.put("SchedgAgreementCreateJitOnly", schedgAgreementCreateJitOnly);
        values.put("SchedgAgreementCreateWoutSline", schedgAgreementCreateWoutSline);
        values.put("SchedgAgreementDeactFrcTolChck", schedgAgreementDeactFrcTolChck);
        values.put("SchedgAgreementdeactJitTolChck", schedgAgreementdeactJitTolChck);
        values.put("SchedgAgreementMoveCreateDate", schedgAgreementMoveCreateDate);
        values.put("SchedgAgreementOffFrcDynStop", schedgAgreementOffFrcDynStop);
        values.put("SchedgAgreementOffJitDynStop", schedgAgreementOffJitDynStop);
        values.put("SchedgAgreementSelectionScope", schedgAgreementSelectionScope);
        values.put("SchedgAgreementStandardRelDate", schedgAgreementStandardRelDate);
    }

    @Override
    @Nonnull
    protected Class<ActionResponse> getEntityClass()
    {
        return ActionResponse.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "HeaderRelease";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public ActionResponse executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
