/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtAcCntSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt SchAgrmtAcCnt} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SchAgrmtAcCntByKeyFluentHelper
    extends
    FluentHelperByKey<SchAgrmtAcCntByKeyFluentHelper, SchAgrmtAcCnt, SchAgrmtAcCntSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt SchAgrmtAcCnt}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SchAgrmtAcCnt}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SchAgrmtAcCnt}
     * @param accountAssignmentNumber
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public SchAgrmtAcCntByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String accountAssignmentNumber,
        final String schedulingAgreementItem,
        final String schedulingAgreement )
    {
        super(servicePath, entityCollection);
        this.key.put("AccountAssignmentNumber", accountAssignmentNumber);
        this.key.put("SchedulingAgreementItem", schedulingAgreementItem);
        this.key.put("SchedulingAgreement", schedulingAgreement);
    }

    @Override
    @Nonnull
    protected Class<SchAgrmtAcCnt> getEntityClass()
    {
        return SchAgrmtAcCnt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
