/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Scheduling Agreement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchAgrmtHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchAgrmtHeader extends VdmEntity<SchAgrmtHeader>
{

    /**
     * Selector for all available fields of SchAgrmtHeader.
     *
     */
    public final static SchAgrmtHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SCHEDULING_AGREEMENT =
        new SchAgrmtHeaderField<String>("SchedulingAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> COMPANY_CODE = new SchAgrmtHeaderField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_DOCUMENT_CATEGORY =
        new SchAgrmtHeaderField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentType</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_DOCUMENT_TYPE =
        new SchAgrmtHeaderField<String>("PurchasingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User of person who created a purchasing document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> CREATED_BY_USER = new SchAgrmtHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Purchasing Document
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<LocalDateTime> CREATION_DATE =
        new SchAgrmtHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> LANGUAGE = new SchAgrmtHeaderField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_ORGANIZATION =
        new SchAgrmtHeaderField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_GROUP =
        new SchAgrmtHeaderField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> DOCUMENT_CURRENCY =
        new SchAgrmtHeaderField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_CLASSIFICATION =
        new SchAgrmtHeaderField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_TRANSFER_LOCATION =
        new SchAgrmtHeaderField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PAYMENT_TERMS = new SchAgrmtHeaderField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new SchAgrmtHeaderField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new SchAgrmtHeaderField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new SchAgrmtHeaderField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new SchAgrmtHeaderField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> NET_PAYMENT_DAYS =
        new SchAgrmtHeaderField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetAmount</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "TargetAmount" )
    @JsonProperty( "TargetAmount" )
    @Nullable
    @ODataField( odataName = "TargetAmount" )
    private BigDecimal targetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TargetAmount</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<BigDecimal> TARGET_AMOUNT =
        new SchAgrmtHeaderField<BigDecimal>("TargetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return The exchangeRate contained in this entity.
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> EXCHANGE_RATE = new SchAgrmtHeaderField<String>("ExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @return Indicator for Fixed Exchange Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateIsFixed</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<Boolean> EXCHANGE_RATE_IS_FIXED =
        new SchAgrmtHeaderField<Boolean>("ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_LOCATION1 =
        new SchAgrmtHeaderField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_LOCATION2 =
        new SchAgrmtHeaderField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_VERSION =
        new SchAgrmtHeaderField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 1
     */
    @SerializedName( "IncotermsLocation1Identifier" )
    @JsonProperty( "IncotermsLocation1Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1Identifier" )
    private String incotermsLocation1Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1Identifier</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_LOCATION1_IDENTIFIER =
        new SchAgrmtHeaderField<String>("IncotermsLocation1Identifier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @return Incoterm Location 1 - Place of Destination
     */
    @SerializedName( "IncotermsSupChnLoc1AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc1AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc1AddlUUID" )
    private UUID incotermsSupChnLoc1AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc1AddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<UUID> INCOTERMS_SUP_CHN_LOC1_ADDL_UUID =
        new SchAgrmtHeaderField<UUID>("IncotermsSupChnLoc1AddlUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 2
     */
    @SerializedName( "IncotermsLocation2Identifier" )
    @JsonProperty( "IncotermsLocation2Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2Identifier" )
    private String incotermsLocation2Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2Identifier</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INCOTERMS_LOCATION2_IDENTIFIER =
        new SchAgrmtHeaderField<String>("IncotermsLocation2Identifier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @return Incoterm Location 2 - Place of Delivery
     */
    @SerializedName( "IncotermsSupChnLoc2AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc2AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc2AddlUUID" )
    private UUID incotermsSupChnLoc2AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc2AddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<UUID> INCOTERMS_SUP_CHN_LOC2_ADDL_UUID =
        new SchAgrmtHeaderField<UUID>("IncotermsSupChnLoc2AddlUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @return Incoterm - Deviating Place of Destination
     */
    @SerializedName( "IncotermsSupChnDvtgLocAddlUUID" )
    @JsonProperty( "IncotermsSupChnDvtgLocAddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnDvtgLocAddlUUID" )
    private UUID incotermsSupChnDvtgLocAddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnDvtgLocAddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<UUID> INCOTERMS_SUP_CHN_DVTG_LOC_ADDL_UUID =
        new SchAgrmtHeaderField<UUID>("IncotermsSupChnDvtgLocAddlUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @return Purchasing Document Date
     */
    @SerializedName( "PurchasingDocumentOrderDate" )
    @JsonProperty( "PurchasingDocumentOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchasingDocumentOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchasingDocumentOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentOrderDate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<LocalDateTime> PURCHASING_DOCUMENT_ORDER_DATE =
        new SchAgrmtHeaderField<LocalDateTime>("PurchasingDocumentOrderDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleAgreementHasReleaseDoc</b>
     * </p>
     *
     * @return Indicator for scheduling agreement release documentation
     */
    @SerializedName( "ScheduleAgreementHasReleaseDoc" )
    @JsonProperty( "ScheduleAgreementHasReleaseDoc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ScheduleAgreementHasReleaseDoc" )
    private Boolean scheduleAgreementHasReleaseDoc;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleAgreementHasReleaseDoc</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<Boolean> SCHEDULE_AGREEMENT_HAS_RELEASE_DOC =
        new SchAgrmtHeaderField<Boolean>("ScheduleAgreementHasReleaseDoc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLIER = new SchAgrmtHeaderField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierAddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "SupplierAddressID" )
    @JsonProperty( "SupplierAddressID" )
    @Nullable
    @ODataField( odataName = "SupplierAddressID" )
    private String supplierAddressID;
    /**
     * Use with available fluent helpers to apply the <b>SupplierAddressID</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLIER_ADDRESS_ID =
        new SchAgrmtHeaderField<String>("SupplierAddressID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<LocalDateTime> VALIDITY_START_DATE =
        new SchAgrmtHeaderField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<LocalDateTime> VALIDITY_END_DATE =
        new SchAgrmtHeaderField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrigin</b>
     * </p>
     *
     * @return Status of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentOrigin" )
    @JsonProperty( "PurchasingDocumentOrigin" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentOrigin" )
    private String purchasingDocumentOrigin;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentOrigin</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_DOCUMENT_ORIGIN =
        new SchAgrmtHeaderField<String>("PurchasingDocumentOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new SchAgrmtHeaderField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @return Quotation Submission Date
     */
    @SerializedName( "QuotationSubmissionDate" )
    @JsonProperty( "QuotationSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationSubmissionDate</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<LocalDateTime> QUOTATION_SUBMISSION_DATE =
        new SchAgrmtHeaderField<LocalDateTime>("QuotationSubmissionDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotationExternalID" )
    @JsonProperty( "SupplierQuotationExternalID" )
    @Nullable
    @ODataField( odataName = "SupplierQuotationExternalID" )
    private String supplierQuotationExternalID;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotationExternalID</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLIER_QUOTATION_EXTERNAL_ID =
        new SchAgrmtHeaderField<String>("SupplierQuotationExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @return Responsible Salesperson at Supplier's Office
     */
    @SerializedName( "SupplierRespSalesPersonName" )
    @JsonProperty( "SupplierRespSalesPersonName" )
    @Nullable
    @ODataField( odataName = "SupplierRespSalesPersonName" )
    private String supplierRespSalesPersonName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRespSalesPersonName</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLIER_RESP_SALES_PERSON_NAME =
        new SchAgrmtHeaderField<String>("SupplierRespSalesPersonName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @return Supplier's Phone Number
     */
    @SerializedName( "SupplierPhoneNumber" )
    @JsonProperty( "SupplierPhoneNumber" )
    @Nullable
    @ODataField( odataName = "SupplierPhoneNumber" )
    private String supplierPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPhoneNumber</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLIER_PHONE_NUMBER =
        new SchAgrmtHeaderField<String>("SupplierPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @return Different Invoicing Party
     */
    @SerializedName( "InvoicingParty" )
    @JsonProperty( "InvoicingParty" )
    @Nullable
    @ODataField( odataName = "InvoicingParty" )
    private String invoicingParty;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingParty</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> INVOICING_PARTY = new SchAgrmtHeaderField<String>("InvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @return Goods Supplier
     */
    @SerializedName( "SupplyingSupplier" )
    @JsonProperty( "SupplyingSupplier" )
    @Nullable
    @ODataField( odataName = "SupplyingSupplier" )
    private String supplyingSupplier;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingSupplier</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SUPPLYING_SUPPLIER =
        new SchAgrmtHeaderField<String>("SupplyingSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CompanyVATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "CompanyVATRegistration" )
    @JsonProperty( "CompanyVATRegistration" )
    @Nullable
    @ODataField( odataName = "CompanyVATRegistration" )
    private String companyVATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>CompanyVATRegistration</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> COMPANY_VAT_REGISTRATION =
        new SchAgrmtHeaderField<String>("CompanyVATRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @return Country/Region of Sales Tax ID Number
     */
    @SerializedName( "VATRegistrationCountry" )
    @JsonProperty( "VATRegistrationCountry" )
    @Nullable
    @ODataField( odataName = "VATRegistrationCountry" )
    private String vATRegistrationCountry;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistrationCountry</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> VAT_REGISTRATION_COUNTRY =
        new SchAgrmtHeaderField<String>("VATRegistrationCountry");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementStatus</b>
     * </p>
     *
     * @return The schedulingAgreementStatus contained in this entity.
     */
    @SerializedName( "SchedulingAgreementStatus" )
    @JsonProperty( "SchedulingAgreementStatus" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementStatus" )
    private String schedulingAgreementStatus;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementStatus</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> SCHEDULING_AGREEMENT_STATUS =
        new SchAgrmtHeaderField<String>("SchedulingAgreementStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdCmplncSuplrSts</b>
     * </p>
     *
     * @return Product Compliance Supplier Check Status (All Items)
     */
    @SerializedName( "PurgAggrgdProdCmplncSuplrSts" )
    @JsonProperty( "PurgAggrgdProdCmplncSuplrSts" )
    @Nullable
    @ODataField( odataName = "PurgAggrgdProdCmplncSuplrSts" )
    private String purgAggrgdProdCmplncSuplrSts;
    /**
     * Use with available fluent helpers to apply the <b>PurgAggrgdProdCmplncSuplrSts</b> field to query operations.
     *
     */
    public final static SchAgrmtHeaderField<String> PURG_AGGRGD_PROD_CMPLNC_SUPLR_STS =
        new SchAgrmtHeaderField<String>("PurgAggrgdProdCmplncSuplrSts");
    /**
     * Navigation property <b>to_SchAgrmtPartner</b> for <b>SchAgrmtHeader</b> to multiple <b>SchAgrmtPartner</b>.
     *
     */
    @SerializedName( "to_SchAgrmtPartner" )
    @JsonProperty( "to_SchAgrmtPartner" )
    @ODataField( odataName = "to_SchAgrmtPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchAgrmtPartner> toSchAgrmtPartner;
    /**
     * Navigation property <b>to_SchedgAgrmtHdrNotes</b> for <b>SchAgrmtHeader</b> to multiple
     * <b>SchedgAgrmtHdrNotes</b>.
     *
     */
    @SerializedName( "to_SchedgAgrmtHdrNotes" )
    @JsonProperty( "to_SchedgAgrmtHdrNotes" )
    @ODataField( odataName = "to_SchedgAgrmtHdrNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchedgAgrmtHdrNotes> toSchedgAgrmtHdrNotes;
    /**
     * Navigation property <b>to_SchedgAgrmtItm</b> for <b>SchAgrmtHeader</b> to multiple <b>SchAgrmtItem</b>.
     *
     */
    @SerializedName( "to_SchedgAgrmtItm" )
    @JsonProperty( "to_SchedgAgrmtItm" )
    @ODataField( odataName = "to_SchedgAgrmtItm" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchAgrmtItem> toSchedgAgrmtItm;
    /**
     * Use with available fluent helpers to apply the <b>to_SchAgrmtPartner</b> navigation property to query operations.
     *
     */
    public final static SchAgrmtHeaderLink<SchAgrmtPartner> TO_SCH_AGRMT_PARTNER =
        new SchAgrmtHeaderLink<SchAgrmtPartner>("to_SchAgrmtPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_SchedgAgrmtHdrNotes</b> navigation property to query
     * operations.
     *
     */
    public final static SchAgrmtHeaderLink<SchedgAgrmtHdrNotes> TO_SCHEDG_AGRMT_HDR_NOTES =
        new SchAgrmtHeaderLink<SchedgAgrmtHdrNotes>("to_SchedgAgrmtHdrNotes");
    /**
     * Use with available fluent helpers to apply the <b>to_SchedgAgrmtItm</b> navigation property to query operations.
     *
     */
    public final static SchAgrmtHeaderLink<SchAgrmtItem> TO_SCHEDG_AGRMT_ITM =
        new SchAgrmtHeaderLink<SchAgrmtItem>("to_SchedgAgrmtItm");

    @Nonnull
    @Override
    public Class<SchAgrmtHeader> getType()
    {
        return SchAgrmtHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            Purchasing Document Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User of person who created a purchasing document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Purchasing Document
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetAmount</b>
     * </p>
     *
     * @param targetAmount
     *            Target Value for Header Area per Distribution
     */
    public void setTargetAmount( @Nullable final BigDecimal targetAmount )
    {
        rememberChangedField("TargetAmount", this.targetAmount);
        this.targetAmount = targetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            The exchangeRate to set.
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @param incotermsLocation1Identifier
     *            Identifier for Incoterm Location 1
     */
    public void setIncotermsLocation1Identifier( @Nullable final String incotermsLocation1Identifier )
    {
        rememberChangedField("IncotermsLocation1Identifier", this.incotermsLocation1Identifier);
        this.incotermsLocation1Identifier = incotermsLocation1Identifier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc1AddlUUID
     *            Incoterm Location 1 - Place of Destination
     */
    public void setIncotermsSupChnLoc1AddlUUID( @Nullable final UUID incotermsSupChnLoc1AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc1AddlUUID", this.incotermsSupChnLoc1AddlUUID);
        this.incotermsSupChnLoc1AddlUUID = incotermsSupChnLoc1AddlUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @param incotermsLocation2Identifier
     *            Identifier for Incoterm Location 2
     */
    public void setIncotermsLocation2Identifier( @Nullable final String incotermsLocation2Identifier )
    {
        rememberChangedField("IncotermsLocation2Identifier", this.incotermsLocation2Identifier);
        this.incotermsLocation2Identifier = incotermsLocation2Identifier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc2AddlUUID
     *            Incoterm Location 2 - Place of Delivery
     */
    public void setIncotermsSupChnLoc2AddlUUID( @Nullable final UUID incotermsSupChnLoc2AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc2AddlUUID", this.incotermsSupChnLoc2AddlUUID);
        this.incotermsSupChnLoc2AddlUUID = incotermsSupChnLoc2AddlUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnDvtgLocAddlUUID
     *            Incoterm - Deviating Place of Destination
     */
    public void setIncotermsSupChnDvtgLocAddlUUID( @Nullable final UUID incotermsSupChnDvtgLocAddlUUID )
    {
        rememberChangedField("IncotermsSupChnDvtgLocAddlUUID", this.incotermsSupChnDvtgLocAddlUUID);
        this.incotermsSupChnDvtgLocAddlUUID = incotermsSupChnDvtgLocAddlUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @param purchasingDocumentOrderDate
     *            Purchasing Document Date
     */
    public void setPurchasingDocumentOrderDate( @Nullable final LocalDateTime purchasingDocumentOrderDate )
    {
        rememberChangedField("PurchasingDocumentOrderDate", this.purchasingDocumentOrderDate);
        this.purchasingDocumentOrderDate = purchasingDocumentOrderDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleAgreementHasReleaseDoc</b>
     * </p>
     *
     * @param scheduleAgreementHasReleaseDoc
     *            Indicator for scheduling agreement release documentation
     */
    public void setScheduleAgreementHasReleaseDoc( @Nullable final Boolean scheduleAgreementHasReleaseDoc )
    {
        rememberChangedField("ScheduleAgreementHasReleaseDoc", this.scheduleAgreementHasReleaseDoc);
        this.scheduleAgreementHasReleaseDoc = scheduleAgreementHasReleaseDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierAddressID</b>
     * </p>
     *
     * @param supplierAddressID
     *            Address Number
     */
    public void setSupplierAddressID( @Nullable final String supplierAddressID )
    {
        rememberChangedField("SupplierAddressID", this.supplierAddressID);
        this.supplierAddressID = supplierAddressID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start of Validity Period
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End of Validity Period
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrigin</b>
     * </p>
     *
     * @param purchasingDocumentOrigin
     *            Status of Purchasing Document
     */
    public void setPurchasingDocumentOrigin( @Nullable final String purchasingDocumentOrigin )
    {
        rememberChangedField("PurchasingDocumentOrigin", this.purchasingDocumentOrigin);
        this.purchasingDocumentOrigin = purchasingDocumentOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *            Quotation Submission Date
     */
    public void setQuotationSubmissionDate( @Nullable final LocalDateTime quotationSubmissionDate )
    {
        rememberChangedField("QuotationSubmissionDate", this.quotationSubmissionDate);
        this.quotationSubmissionDate = quotationSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @param supplierQuotationExternalID
     *            Quotation Number
     */
    public void setSupplierQuotationExternalID( @Nullable final String supplierQuotationExternalID )
    {
        rememberChangedField("SupplierQuotationExternalID", this.supplierQuotationExternalID);
        this.supplierQuotationExternalID = supplierQuotationExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @param supplierRespSalesPersonName
     *            Responsible Salesperson at Supplier's Office
     */
    public void setSupplierRespSalesPersonName( @Nullable final String supplierRespSalesPersonName )
    {
        rememberChangedField("SupplierRespSalesPersonName", this.supplierRespSalesPersonName);
        this.supplierRespSalesPersonName = supplierRespSalesPersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @param supplierPhoneNumber
     *            Supplier's Phone Number
     */
    public void setSupplierPhoneNumber( @Nullable final String supplierPhoneNumber )
    {
        rememberChangedField("SupplierPhoneNumber", this.supplierPhoneNumber);
        this.supplierPhoneNumber = supplierPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @param supplyingSupplier
     *            Goods Supplier
     */
    public void setSupplyingSupplier( @Nullable final String supplyingSupplier )
    {
        rememberChangedField("SupplyingSupplier", this.supplyingSupplier);
        this.supplyingSupplier = supplyingSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CompanyVATRegistration</b>
     * </p>
     *
     * @param companyVATRegistration
     *            VAT Registration Number
     */
    public void setCompanyVATRegistration( @Nullable final String companyVATRegistration )
    {
        rememberChangedField("CompanyVATRegistration", this.companyVATRegistration);
        this.companyVATRegistration = companyVATRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @param vATRegistrationCountry
     *            Country/Region of Sales Tax ID Number
     */
    public void setVATRegistrationCountry( @Nullable final String vATRegistrationCountry )
    {
        rememberChangedField("VATRegistrationCountry", this.vATRegistrationCountry);
        this.vATRegistrationCountry = vATRegistrationCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementStatus</b>
     * </p>
     *
     * @param schedulingAgreementStatus
     *            The schedulingAgreementStatus to set.
     */
    public void setSchedulingAgreementStatus( @Nullable final String schedulingAgreementStatus )
    {
        rememberChangedField("SchedulingAgreementStatus", this.schedulingAgreementStatus);
        this.schedulingAgreementStatus = schedulingAgreementStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdCmplncSuplrSts</b>
     * </p>
     *
     * @param purgAggrgdProdCmplncSuplrSts
     *            Product Compliance Supplier Check Status (All Items)
     */
    public void setPurgAggrgdProdCmplncSuplrSts( @Nullable final String purgAggrgdProdCmplncSuplrSts )
    {
        rememberChangedField("PurgAggrgdProdCmplncSuplrSts", this.purgAggrgdProdCmplncSuplrSts);
        this.purgAggrgdProdCmplncSuplrSts = purgAggrgdProdCmplncSuplrSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchAgrmtHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("Language", getLanguage());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("TargetAmount", getTargetAmount());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1Identifier", getIncotermsLocation1Identifier());
        values.put("IncotermsSupChnLoc1AddlUUID", getIncotermsSupChnLoc1AddlUUID());
        values.put("IncotermsLocation2Identifier", getIncotermsLocation2Identifier());
        values.put("IncotermsSupChnLoc2AddlUUID", getIncotermsSupChnLoc2AddlUUID());
        values.put("IncotermsSupChnDvtgLocAddlUUID", getIncotermsSupChnDvtgLocAddlUUID());
        values.put("PurchasingDocumentOrderDate", getPurchasingDocumentOrderDate());
        values.put("ScheduleAgreementHasReleaseDoc", getScheduleAgreementHasReleaseDoc());
        values.put("Supplier", getSupplier());
        values.put("SupplierAddressID", getSupplierAddressID());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("PurchasingDocumentOrigin", getPurchasingDocumentOrigin());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("QuotationSubmissionDate", getQuotationSubmissionDate());
        values.put("SupplierQuotationExternalID", getSupplierQuotationExternalID());
        values.put("SupplierRespSalesPersonName", getSupplierRespSalesPersonName());
        values.put("SupplierPhoneNumber", getSupplierPhoneNumber());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("SupplyingSupplier", getSupplyingSupplier());
        values.put("CompanyVATRegistration", getCompanyVATRegistration());
        values.put("VATRegistrationCountry", getVATRegistrationCountry());
        values.put("SchedulingAgreementStatus", getSchedulingAgreementStatus());
        values.put("PurgAggrgdProdCmplncSuplrSts", getPurgAggrgdProdCmplncSuplrSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("TargetAmount") ) {
                final Object value = values.remove("TargetAmount");
                if( (value == null) || (!value.equals(getTargetAmount())) ) {
                    setTargetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1Identifier") ) {
                final Object value = values.remove("IncotermsLocation1Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation1Identifier())) ) {
                    setIncotermsLocation1Identifier(((String) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc1AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc1AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc1AddlUUID())) ) {
                    setIncotermsSupChnLoc1AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsLocation2Identifier") ) {
                final Object value = values.remove("IncotermsLocation2Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation2Identifier())) ) {
                    setIncotermsLocation2Identifier(((String) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc2AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc2AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc2AddlUUID())) ) {
                    setIncotermsSupChnLoc2AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsSupChnDvtgLocAddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnDvtgLocAddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnDvtgLocAddlUUID())) ) {
                    setIncotermsSupChnDvtgLocAddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchasingDocumentOrderDate") ) {
                final Object value = values.remove("PurchasingDocumentOrderDate");
                if( (value == null) || (!value.equals(getPurchasingDocumentOrderDate())) ) {
                    setPurchasingDocumentOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduleAgreementHasReleaseDoc") ) {
                final Object value = values.remove("ScheduleAgreementHasReleaseDoc");
                if( (value == null) || (!value.equals(getScheduleAgreementHasReleaseDoc())) ) {
                    setScheduleAgreementHasReleaseDoc(((Boolean) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierAddressID") ) {
                final Object value = values.remove("SupplierAddressID");
                if( (value == null) || (!value.equals(getSupplierAddressID())) ) {
                    setSupplierAddressID(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchasingDocumentOrigin") ) {
                final Object value = values.remove("PurchasingDocumentOrigin");
                if( (value == null) || (!value.equals(getPurchasingDocumentOrigin())) ) {
                    setPurchasingDocumentOrigin(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("QuotationSubmissionDate") ) {
                final Object value = values.remove("QuotationSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationSubmissionDate())) ) {
                    setQuotationSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierQuotationExternalID") ) {
                final Object value = values.remove("SupplierQuotationExternalID");
                if( (value == null) || (!value.equals(getSupplierQuotationExternalID())) ) {
                    setSupplierQuotationExternalID(((String) value));
                }
            }
            if( values.containsKey("SupplierRespSalesPersonName") ) {
                final Object value = values.remove("SupplierRespSalesPersonName");
                if( (value == null) || (!value.equals(getSupplierRespSalesPersonName())) ) {
                    setSupplierRespSalesPersonName(((String) value));
                }
            }
            if( values.containsKey("SupplierPhoneNumber") ) {
                final Object value = values.remove("SupplierPhoneNumber");
                if( (value == null) || (!value.equals(getSupplierPhoneNumber())) ) {
                    setSupplierPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((String) value));
                }
            }
            if( values.containsKey("SupplyingSupplier") ) {
                final Object value = values.remove("SupplyingSupplier");
                if( (value == null) || (!value.equals(getSupplyingSupplier())) ) {
                    setSupplyingSupplier(((String) value));
                }
            }
            if( values.containsKey("CompanyVATRegistration") ) {
                final Object value = values.remove("CompanyVATRegistration");
                if( (value == null) || (!value.equals(getCompanyVATRegistration())) ) {
                    setCompanyVATRegistration(((String) value));
                }
            }
            if( values.containsKey("VATRegistrationCountry") ) {
                final Object value = values.remove("VATRegistrationCountry");
                if( (value == null) || (!value.equals(getVATRegistrationCountry())) ) {
                    setVATRegistrationCountry(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementStatus") ) {
                final Object value = values.remove("SchedulingAgreementStatus");
                if( (value == null) || (!value.equals(getSchedulingAgreementStatus())) ) {
                    setSchedulingAgreementStatus(((String) value));
                }
            }
            if( values.containsKey("PurgAggrgdProdCmplncSuplrSts") ) {
                final Object value = values.remove("PurgAggrgdProdCmplncSuplrSts");
                if( (value == null) || (!value.equals(getPurgAggrgdProdCmplncSuplrSts())) ) {
                    setPurgAggrgdProdCmplncSuplrSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SchAgrmtPartner") ) {
                final Object value = (values).remove("to_SchAgrmtPartner");
                if( value instanceof Iterable ) {
                    if( toSchAgrmtPartner == null ) {
                        toSchAgrmtPartner = Lists.newArrayList();
                    } else {
                        toSchAgrmtPartner = Lists.newArrayList(toSchAgrmtPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchAgrmtPartner entity;
                        if( toSchAgrmtPartner.size() > i ) {
                            entity = toSchAgrmtPartner.get(i);
                        } else {
                            entity = new SchAgrmtPartner();
                            toSchAgrmtPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SchedgAgrmtHdrNotes") ) {
                final Object value = (values).remove("to_SchedgAgrmtHdrNotes");
                if( value instanceof Iterable ) {
                    if( toSchedgAgrmtHdrNotes == null ) {
                        toSchedgAgrmtHdrNotes = Lists.newArrayList();
                    } else {
                        toSchedgAgrmtHdrNotes = Lists.newArrayList(toSchedgAgrmtHdrNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchedgAgrmtHdrNotes entity;
                        if( toSchedgAgrmtHdrNotes.size() > i ) {
                            entity = toSchedgAgrmtHdrNotes.get(i);
                        } else {
                            entity = new SchedgAgrmtHdrNotes();
                            toSchedgAgrmtHdrNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SchedgAgrmtItm") ) {
                final Object value = (values).remove("to_SchedgAgrmtItm");
                if( value instanceof Iterable ) {
                    if( toSchedgAgrmtItm == null ) {
                        toSchedgAgrmtItm = Lists.newArrayList();
                    } else {
                        toSchedgAgrmtItm = Lists.newArrayList(toSchedgAgrmtItm);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchAgrmtItem entity;
                        if( toSchedgAgrmtItm.size() > i ) {
                            entity = toSchedgAgrmtItm.get(i);
                        } else {
                            entity = new SchAgrmtItem();
                            toSchedgAgrmtItm.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SchAgrmtHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchAgrmtHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchAgrmtHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchAgrmtHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSchAgrmtPartner != null ) {
            (values).put("to_SchAgrmtPartner", toSchAgrmtPartner);
        }
        if( toSchedgAgrmtHdrNotes != null ) {
            (values).put("to_SchedgAgrmtHdrNotes", toSchedgAgrmtHdrNotes);
        }
        if( toSchedgAgrmtItm != null ) {
            (values).put("to_SchedgAgrmtItm", toSchedgAgrmtItm);
        }
        return values;
    }

    /**
     * Fetches the <b>SchAgrmtPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SchAgrmtPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchAgrmtPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtPartner> fetchSchAgrmtPartner()
    {
        return fetchFieldAsList("to_SchAgrmtPartner", SchAgrmtPartner.class);
    }

    /**
     * Retrieval of associated <b>SchAgrmtPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtPartner</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtPartner</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchAgrmtPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtPartner> getSchAgrmtPartnerOrFetch()
    {
        if( toSchAgrmtPartner == null ) {
            toSchAgrmtPartner = fetchSchAgrmtPartner();
        }
        return toSchAgrmtPartner;
    }

    /**
     * Retrieval of associated <b>SchAgrmtPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtPartner</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchAgrmtPartner</b> is already loaded, the result will
     *         contain the <b>SchAgrmtPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchAgrmtPartner>> getSchAgrmtPartnerIfPresent()
    {
        return Option.of(toSchAgrmtPartner);
    }

    /**
     * Overwrites the list of associated <b>SchAgrmtPartner</b> entities for the loaded navigation property
     * <b>to_SchAgrmtPartner</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtPartner</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchAgrmtPartner</b> entities.
     */
    public void setSchAgrmtPartner( @Nonnull final List<SchAgrmtPartner> value )
    {
        if( toSchAgrmtPartner == null ) {
            toSchAgrmtPartner = Lists.newArrayList();
        }
        toSchAgrmtPartner.clear();
        toSchAgrmtPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchAgrmtPartner</b> entities. This corresponds to the OData navigation
     * property <b>to_SchAgrmtPartner</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtPartner</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchAgrmtPartner</b> entities.
     */
    public void addSchAgrmtPartner( SchAgrmtPartner... entity )
    {
        if( toSchAgrmtPartner == null ) {
            toSchAgrmtPartner = Lists.newArrayList();
        }
        toSchAgrmtPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SchedgAgrmtHdrNotes</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SchedgAgrmtHdrNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchedgAgrmtHdrNotes</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtHdrNotes> fetchSchedgAgrmtHdrNotes()
    {
        return fetchFieldAsList("to_SchedgAgrmtHdrNotes", SchedgAgrmtHdrNotes.class);
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtHdrNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtHdrNotes</b> of a queried <b>SchAgrmtHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchedgAgrmtHdrNotes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtHdrNotes> getSchedgAgrmtHdrNotesOrFetch()
    {
        if( toSchedgAgrmtHdrNotes == null ) {
            toSchedgAgrmtHdrNotes = fetchSchedgAgrmtHdrNotes();
        }
        return toSchedgAgrmtHdrNotes;
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtHdrNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtHdrNotes</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchedgAgrmtHdrNotes</b> is already loaded, the result
     *         will contain the <b>SchedgAgrmtHdrNotes</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchedgAgrmtHdrNotes>> getSchedgAgrmtHdrNotesIfPresent()
    {
        return Option.of(toSchedgAgrmtHdrNotes);
    }

    /**
     * Overwrites the list of associated <b>SchedgAgrmtHdrNotes</b> entities for the loaded navigation property
     * <b>to_SchedgAgrmtHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtHdrNotes</b> of a queried <b>SchAgrmtHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchedgAgrmtHdrNotes</b> entities.
     */
    public void setSchedgAgrmtHdrNotes( @Nonnull final List<SchedgAgrmtHdrNotes> value )
    {
        if( toSchedgAgrmtHdrNotes == null ) {
            toSchedgAgrmtHdrNotes = Lists.newArrayList();
        }
        toSchedgAgrmtHdrNotes.clear();
        toSchedgAgrmtHdrNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchedgAgrmtHdrNotes</b> entities. This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtHdrNotes</b> of a queried <b>SchAgrmtHeader</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchedgAgrmtHdrNotes</b> entities.
     */
    public void addSchedgAgrmtHdrNotes( SchedgAgrmtHdrNotes... entity )
    {
        if( toSchedgAgrmtHdrNotes == null ) {
            toSchedgAgrmtHdrNotes = Lists.newArrayList();
        }
        toSchedgAgrmtHdrNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SchAgrmtItem</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtItm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchAgrmtItem</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtItem> fetchSchedgAgrmtItm()
    {
        return fetchFieldAsList("to_SchedgAgrmtItm", SchAgrmtItem.class);
    }

    /**
     * Retrieval of associated <b>SchAgrmtItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchedgAgrmtItm</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItm</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchAgrmtItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtItem> getSchedgAgrmtItmOrFetch()
    {
        if( toSchedgAgrmtItm == null ) {
            toSchedgAgrmtItm = fetchSchedgAgrmtItm();
        }
        return toSchedgAgrmtItm;
    }

    /**
     * Retrieval of associated <b>SchAgrmtItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchedgAgrmtItm</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchedgAgrmtItm</b> is already loaded, the result will
     *         contain the <b>SchAgrmtItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchAgrmtItem>> getSchedgAgrmtItmIfPresent()
    {
        return Option.of(toSchedgAgrmtItm);
    }

    /**
     * Overwrites the list of associated <b>SchAgrmtItem</b> entities for the loaded navigation property
     * <b>to_SchedgAgrmtItm</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItm</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchAgrmtItem</b> entities.
     */
    public void setSchedgAgrmtItm( @Nonnull final List<SchAgrmtItem> value )
    {
        if( toSchedgAgrmtItm == null ) {
            toSchedgAgrmtItm = Lists.newArrayList();
        }
        toSchedgAgrmtItm.clear();
        toSchedgAgrmtItm.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchAgrmtItem</b> entities. This corresponds to the OData navigation
     * property <b>to_SchedgAgrmtItm</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItm</b> of a queried <b>SchAgrmtHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchAgrmtItem</b> entities.
     */
    public void addSchedgAgrmtItm( SchAgrmtItem... entity )
    {
        if( toSchedgAgrmtItm == null ) {
            toSchedgAgrmtItm = Lists.newArrayList();
        }
        toSchedgAgrmtItm.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SchAgrmtHeader instances.
     *
     */
    public final static class SchAgrmtHeaderBuilder
    {

        private List<SchAgrmtPartner> toSchAgrmtPartner = Lists.newArrayList();
        private List<SchedgAgrmtHdrNotes> toSchedgAgrmtHdrNotes = Lists.newArrayList();
        private List<SchAgrmtItem> toSchedgAgrmtItm = Lists.newArrayList();

        private SchAgrmtHeader.SchAgrmtHeaderBuilder toSchAgrmtPartner( final List<SchAgrmtPartner> value )
        {
            toSchAgrmtPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchAgrmtPartner</b> for <b>SchAgrmtHeader</b> to multiple <b>SchAgrmtPartner</b>.
         *
         * @param value
         *            The SchAgrmtPartners to build this SchAgrmtHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtHeader.SchAgrmtHeaderBuilder schAgrmtPartner( SchAgrmtPartner... value )
        {
            return toSchAgrmtPartner(Lists.newArrayList(value));
        }

        private SchAgrmtHeader.SchAgrmtHeaderBuilder toSchedgAgrmtHdrNotes( final List<SchedgAgrmtHdrNotes> value )
        {
            toSchedgAgrmtHdrNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchedgAgrmtHdrNotes</b> for <b>SchAgrmtHeader</b> to multiple
         * <b>SchedgAgrmtHdrNotes</b>.
         *
         * @param value
         *            The SchedgAgrmtHdrNotess to build this SchAgrmtHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtHeader.SchAgrmtHeaderBuilder schedgAgrmtHdrNotes( SchedgAgrmtHdrNotes... value )
        {
            return toSchedgAgrmtHdrNotes(Lists.newArrayList(value));
        }

        private SchAgrmtHeader.SchAgrmtHeaderBuilder toSchedgAgrmtItm( final List<SchAgrmtItem> value )
        {
            toSchedgAgrmtItm.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchedgAgrmtItm</b> for <b>SchAgrmtHeader</b> to multiple <b>SchAgrmtItem</b>.
         *
         * @param value
         *            The SchAgrmtItems to build this SchAgrmtHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtHeader.SchAgrmtHeaderBuilder schedgAgrmtItm( SchAgrmtItem... value )
        {
            return toSchedgAgrmtItm(Lists.newArrayList(value));
        }

    }

}
