/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchAgrmtItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchAgrmtItem extends VdmEntity<SchAgrmtItem>
{

    /**
     * Selector for all available fields of SchAgrmtItem.
     *
     */
    public final static SchAgrmtItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SCHEDULING_AGREEMENT =
        new SchAgrmtItemField<String>("SchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "SchedulingAgreementItem" )
    @JsonProperty( "SchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementItem" )
    private String schedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SCHEDULING_AGREEMENT_ITEM =
        new SchAgrmtItemField<String>("SchedulingAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> COMPANY_CODE = new SchAgrmtItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASING_DOCUMENT_CATEGORY =
        new SchAgrmtItemField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new SchAgrmtItemField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchasingDocumentItemText" )
    @JsonProperty( "PurchasingDocumentItemText" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemText" )
    private String purchasingDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemText</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASING_DOCUMENT_ITEM_TEXT =
        new SchAgrmtItemField<String>("PurchasingDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> MATERIAL = new SchAgrmtItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @return Material number
     */
    @SerializedName( "ManufacturerMaterial" )
    @JsonProperty( "ManufacturerMaterial" )
    @Nullable
    @ODataField( odataName = "ManufacturerMaterial" )
    private String manufacturerMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerMaterial</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> MANUFACTURER_MATERIAL =
        new SchAgrmtItemField<String>("ManufacturerMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new SchAgrmtItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> MATERIAL_GROUP = new SchAgrmtItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PLANT = new SchAgrmtItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ReferenceDeliveryAddressID" )
    @JsonProperty( "ReferenceDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ReferenceDeliveryAddressID" )
    private String referenceDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDeliveryAddressID</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> REFERENCE_DELIVERY_ADDRESS_ID =
        new SchAgrmtItemField<String>("ReferenceDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> CUSTOMER = new SchAgrmtItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_CLASSIFICATION =
        new SchAgrmtItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SchAgrmtItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_LOCATION1 =
        new SchAgrmtItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_LOCATION2 =
        new SchAgrmtItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 1
     */
    @SerializedName( "IncotermsLocation1Identifier" )
    @JsonProperty( "IncotermsLocation1Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1Identifier" )
    private String incotermsLocation1Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1Identifier</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_LOCATION1_IDENTIFIER =
        new SchAgrmtItemField<String>("IncotermsLocation1Identifier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @return Incoterm Location 1 - Place of Destination
     */
    @SerializedName( "IncotermsSupChnLoc1AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc1AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc1AddlUUID" )
    private UUID incotermsSupChnLoc1AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc1AddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<UUID> INCOTERMS_SUP_CHN_LOC1_ADDL_UUID =
        new SchAgrmtItemField<UUID>("IncotermsSupChnLoc1AddlUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 2
     */
    @SerializedName( "IncotermsLocation2Identifier" )
    @JsonProperty( "IncotermsLocation2Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2Identifier" )
    private String incotermsLocation2Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2Identifier</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> INCOTERMS_LOCATION2_IDENTIFIER =
        new SchAgrmtItemField<String>("IncotermsLocation2Identifier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @return Incoterm Location 2 - Place of Delivery
     */
    @SerializedName( "IncotermsSupChnLoc2AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc2AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc2AddlUUID" )
    private UUID incotermsSupChnLoc2AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc2AddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<UUID> INCOTERMS_SUP_CHN_LOC2_ADDL_UUID =
        new SchAgrmtItemField<UUID>("IncotermsSupChnLoc2AddlUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @return Incoterm - Deviating Place of Destination
     */
    @SerializedName( "IncotermsSupChnDvtgLocAddlUUID" )
    @JsonProperty( "IncotermsSupChnDvtgLocAddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnDvtgLocAddlUUID" )
    private UUID incotermsSupChnDvtgLocAddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnDvtgLocAddlUUID</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<UUID> INCOTERMS_SUP_CHN_DVTG_LOC_ADDL_UUID =
        new SchAgrmtItemField<UUID>("IncotermsSupChnDvtgLocAddlUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> ORDER_QUANTITY_UNIT =
        new SchAgrmtItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @return Target Quantity
     */
    @SerializedName( "TargetQuantity" )
    @JsonProperty( "TargetQuantity" )
    @Nullable
    @ODataField( odataName = "TargetQuantity" )
    private BigDecimal targetQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantity</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> TARGET_QUANTITY =
        new SchAgrmtItemField<BigDecimal>("TargetQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASE_REQUISITION =
        new SchAgrmtItemField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASE_REQUISITION_ITEM =
        new SchAgrmtItemField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtAgreedCumQty</b>
     * </p>
     *
     * @return Agreed Cumulative Quantity
     */
    @SerializedName( "SchedAgrmtAgreedCumQty" )
    @JsonProperty( "SchedAgrmtAgreedCumQty" )
    @Nullable
    @ODataField( odataName = "SchedAgrmtAgreedCumQty" )
    private BigDecimal schedAgrmtAgreedCumQty;
    /**
     * Use with available fluent helpers to apply the <b>SchedAgrmtAgreedCumQty</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> SCHED_AGRMT_AGREED_CUM_QTY =
        new SchAgrmtItemField<BigDecimal>("SchedAgrmtAgreedCumQty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtCumQtyReconcileDate</b>
     * </p>
     *
     * @return Reconciliation date for agreed cumulative quantity
     */
    @SerializedName( "SchedAgrmtCumQtyReconcileDate" )
    @JsonProperty( "SchedAgrmtCumQtyReconcileDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedAgrmtCumQtyReconcileDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedAgrmtCumQtyReconcileDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedAgrmtCumQtyReconcileDate</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<LocalDateTime> SCHED_AGRMT_CUM_QTY_RECONCILE_DATE =
        new SchAgrmtItemField<LocalDateTime>("SchedAgrmtCumQtyReconcileDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ItemLastTransmissionDate</b>
     * </p>
     *
     * @return Last Transmission
     */
    @SerializedName( "ItemLastTransmissionDate" )
    @JsonProperty( "ItemLastTransmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ItemLastTransmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime itemLastTransmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>ItemLastTransmissionDate</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<LocalDateTime> ITEM_LAST_TRANSMISSION_DATE =
        new SchAgrmtItemField<LocalDateTime>("ItemLastTransmissionDate");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @return Number of Days for First Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder1" )
    @JsonProperty( "NoDaysReminder1" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder1" )
    private BigDecimal noDaysReminder1;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder1</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> NO_DAYS_REMINDER1 =
        new SchAgrmtItemField<BigDecimal>("NoDaysReminder1");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @return Number of Days for Second Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder2" )
    @JsonProperty( "NoDaysReminder2" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder2" )
    private BigDecimal noDaysReminder2;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder2</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> NO_DAYS_REMINDER2 =
        new SchAgrmtItemField<BigDecimal>("NoDaysReminder2");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @return Number of Days for Third Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder3" )
    @JsonProperty( "NoDaysReminder3" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder3" )
    private BigDecimal noDaysReminder3;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder3</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> NO_DAYS_REMINDER3 =
        new SchAgrmtItemField<BigDecimal>("NoDaysReminder3");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @return Order Acknowledgment Number
     */
    @SerializedName( "PurgDocOrderAcknNumber" )
    @JsonProperty( "PurgDocOrderAcknNumber" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderAcknNumber" )
    private String purgDocOrderAcknNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderAcknNumber</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURG_DOC_ORDER_ACKN_NUMBER =
        new SchAgrmtItemField<String>("PurgDocOrderAcknNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "RequirementTracking" )
    @JsonProperty( "RequirementTracking" )
    @Nullable
    @ODataField( odataName = "RequirementTracking" )
    private String requirementTracking;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTracking</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> REQUIREMENT_TRACKING =
        new SchAgrmtItemField<String>("RequirementTracking");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @return Order Acknowledgment Requirement
     */
    @SerializedName( "IsOrderAcknRqd" )
    @JsonProperty( "IsOrderAcknRqd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOrderAcknRqd" )
    private Boolean isOrderAcknRqd;
    /**
     * Use with available fluent helpers to apply the <b>IsOrderAcknRqd</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> IS_ORDER_ACKN_RQD = new SchAgrmtItemField<Boolean>("IsOrderAcknRqd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocEstimatedPrice</b>
     * </p>
     *
     * @return Indicator: Estimated Price
     */
    @SerializedName( "PurgDocEstimatedPrice" )
    @JsonProperty( "PurgDocEstimatedPrice" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurgDocEstimatedPrice" )
    private Boolean purgDocEstimatedPrice;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocEstimatedPrice</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> PURG_DOC_ESTIMATED_PRICE =
        new SchAgrmtItemField<Boolean>("PurgDocEstimatedPrice");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @return Price Printout
     */
    @SerializedName( "PriceIsToBePrinted" )
    @JsonProperty( "PriceIsToBePrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceIsToBePrinted" )
    private Boolean priceIsToBePrinted;
    /**
     * Use with available fluent helpers to apply the <b>PriceIsToBePrinted</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> PRICE_IS_TO_BE_PRINTED =
        new SchAgrmtItemField<Boolean>("PriceIsToBePrinted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new SchAgrmtItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @return The multipleAcctAssgmtDistribution contained in this entity.
     */
    @SerializedName( "MultipleAcctAssgmtDistribution" )
    @JsonProperty( "MultipleAcctAssgmtDistribution" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistribution" )
    private String multipleAcctAssgmtDistribution;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistribution</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> MULTIPLE_ACCT_ASSGMT_DISTRIBUTION =
        new SchAgrmtItemField<String>("MultipleAcctAssgmtDistribution");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialInvoiceDistribution</b>
     * </p>
     *
     * @return The partialInvoiceDistribution contained in this entity.
     */
    @SerializedName( "PartialInvoiceDistribution" )
    @JsonProperty( "PartialInvoiceDistribution" )
    @Nullable
    @ODataField( odataName = "PartialInvoiceDistribution" )
    private String partialInvoiceDistribution;
    /**
     * Use with available fluent helpers to apply the <b>PartialInvoiceDistribution</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PARTIAL_INVOICE_DISTRIBUTION =
        new SchAgrmtItemField<String>("PartialInvoiceDistribution");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Document (in Document Currency)
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> NET_PRICE_AMOUNT =
        new SchAgrmtItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Price Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> NET_PRICE_QUANTITY =
        new SchAgrmtItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "OrderPriceUnit" )
    @JsonProperty( "OrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnit" )
    private String orderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnit</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> ORDER_PRICE_UNIT = new SchAgrmtItemField<String>("OrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PRODUCT_TYPE = new SchAgrmtItemField<String>("ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @return Material Type
     */
    @SerializedName( "MaterialType" )
    @JsonProperty( "MaterialType" )
    @Nullable
    @ODataField( odataName = "MaterialType" )
    private String materialType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialType</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> MATERIAL_TYPE = new SchAgrmtItemField<String>("MaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> STORAGE_LOCATION = new SchAgrmtItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> DOCUMENT_CURRENCY = new SchAgrmtItemField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @return Indicator: Update Info Record
     */
    @SerializedName( "IsInfoRecordUpdated" )
    @JsonProperty( "IsInfoRecordUpdated" )
    @Nullable
    @ODataField( odataName = "IsInfoRecordUpdated" )
    private String isInfoRecordUpdated;
    /**
     * Use with available fluent helpers to apply the <b>IsInfoRecordUpdated</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> IS_INFO_RECORD_UPDATED =
        new SchAgrmtItemField<String>("IsInfoRecordUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASING_INFO_RECORD =
        new SchAgrmtItemField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @return Denominator for Conv. of Order Price Unit into Order Unit
     */
    @SerializedName( "OrdPriceUnitToOrderUnitDnmntr" )
    @JsonProperty( "OrdPriceUnitToOrderUnitDnmntr" )
    @Nullable
    @ODataField( odataName = "OrdPriceUnitToOrderUnitDnmntr" )
    private BigDecimal ordPriceUnitToOrderUnitDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrdPriceUnitToOrderUnitDnmntr</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR =
        new SchAgrmtItemField<BigDecimal>("OrdPriceUnitToOrderUnitDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Price Unit into Order Unit
     */
    @SerializedName( "OrderPriceUnitToOrderUnitNmrtr" )
    @JsonProperty( "OrderPriceUnitToOrderUnitNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitToOrderUnitNmrtr" )
    private BigDecimal orderPriceUnitToOrderUnitNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitToOrderUnitNmrtr</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR =
        new SchAgrmtItemField<BigDecimal>("OrderPriceUnitToOrderUnitNmrtr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new SchAgrmtItemField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new SchAgrmtItemField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new SchAgrmtItemField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new SchAgrmtItemField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> STOCK_TYPE = new SchAgrmtItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> TAX_CODE = new SchAgrmtItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> TAX_COUNTRY = new SchAgrmtItemField<String>("TaxCountry");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<LocalDateTime> TAX_DETERMINATION_DATE =
        new SchAgrmtItemField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SHIPPING_INSTRUCTION =
        new SchAgrmtItemField<String>("ShippingInstruction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoAtRegistration</b>
     * </p>
     *
     * @return Indicator: Action at Registration
     */
    @SerializedName( "IsInfoAtRegistration" )
    @JsonProperty( "IsInfoAtRegistration" )
    @Nullable
    @ODataField( odataName = "IsInfoAtRegistration" )
    private String isInfoAtRegistration;
    /**
     * Use with available fluent helpers to apply the <b>IsInfoAtRegistration</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> IS_INFO_AT_REGISTRATION =
        new SchAgrmtItemField<String>("IsInfoAtRegistration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @return Goods Receipt Indicator
     */
    @SerializedName( "GoodsReceiptIsExpected" )
    @JsonProperty( "GoodsReceiptIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsExpected" )
    private Boolean goodsReceiptIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsExpected</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> GOODS_RECEIPT_IS_EXPECTED =
        new SchAgrmtItemField<Boolean>("GoodsReceiptIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @return Goods Receipt, Non-Valuated
     */
    @SerializedName( "GoodsReceiptIsNonValuated" )
    @JsonProperty( "GoodsReceiptIsNonValuated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsNonValuated" )
    private Boolean goodsReceiptIsNonValuated;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsNonValuated</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> GOODS_RECEIPT_IS_NON_VALUATED =
        new SchAgrmtItemField<Boolean>("GoodsReceiptIsNonValuated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @return Invoice Receipt Indicator
     */
    @SerializedName( "InvoiceIsExpected" )
    @JsonProperty( "InvoiceIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsExpected" )
    private Boolean invoiceIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsExpected</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> INVOICE_IS_EXPECTED =
        new SchAgrmtItemField<Boolean>("InvoiceIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @return Indicator: GR-Based Invoice Verification
     */
    @SerializedName( "InvoiceIsGoodsReceiptBased" )
    @JsonProperty( "InvoiceIsGoodsReceiptBased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsGoodsReceiptBased" )
    private Boolean invoiceIsGoodsReceiptBased;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsGoodsReceiptBased</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> INVOICE_IS_GOODS_RECEIPT_BASED =
        new SchAgrmtItemField<Boolean>("InvoiceIsGoodsReceiptBased");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @return Evaluated Receipt Settlement (ERS)
     */
    @SerializedName( "EvaldRcptSettlmtIsAllowed" )
    @JsonProperty( "EvaldRcptSettlmtIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EvaldRcptSettlmtIsAllowed" )
    private Boolean evaldRcptSettlmtIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>EvaldRcptSettlmtIsAllowed</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> EVALD_RCPT_SETTLMT_IS_ALLOWED =
        new SchAgrmtItemField<Boolean>("EvaldRcptSettlmtIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @return Minimum Remaining Shelf Life
     */
    @SerializedName( "MinRemainingShelfLife" )
    @JsonProperty( "MinRemainingShelfLife" )
    @Nullable
    @ODataField( odataName = "MinRemainingShelfLife" )
    private BigDecimal minRemainingShelfLife;
    /**
     * Use with available fluent helpers to apply the <b>MinRemainingShelfLife</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> MIN_REMAINING_SHELF_LIFE =
        new SchAgrmtItemField<BigDecimal>("MinRemainingShelfLife");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QualityMgmtCtrlKey</b>
     * </p>
     *
     * @return Control Key for Quality Management in Procurement
     */
    @SerializedName( "QualityMgmtCtrlKey" )
    @JsonProperty( "QualityMgmtCtrlKey" )
    @Nullable
    @ODataField( odataName = "QualityMgmtCtrlKey" )
    private String qualityMgmtCtrlKey;
    /**
     * Use with available fluent helpers to apply the <b>QualityMgmtCtrlKey</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> QUALITY_MGMT_CTRL_KEY =
        new SchAgrmtItemField<String>("QualityMgmtCtrlKey");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityCertificateType</b>
     * </p>
     *
     * @return Certificate Type
     */
    @SerializedName( "QualityCertificateType" )
    @JsonProperty( "QualityCertificateType" )
    @Nullable
    @ODataField( odataName = "QualityCertificateType" )
    private String qualityCertificateType;
    /**
     * Use with available fluent helpers to apply the <b>QualityCertificateType</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> QUALITY_CERTIFICATE_TYPE =
        new SchAgrmtItemField<String>("QualityCertificateType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtCumulativeQtyControl</b>
     * </p>
     *
     * @return CQ Control Type
     */
    @SerializedName( "SchedAgrmtCumulativeQtyControl" )
    @JsonProperty( "SchedAgrmtCumulativeQtyControl" )
    @Nullable
    @ODataField( odataName = "SchedAgrmtCumulativeQtyControl" )
    private String schedAgrmtCumulativeQtyControl;
    /**
     * Use with available fluent helpers to apply the <b>SchedAgrmtCumulativeQtyControl</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SCHED_AGRMT_CUMULATIVE_QTY_CONTROL =
        new SchAgrmtItemField<String>("SchedAgrmtCumulativeQtyControl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeQuantityIsNotSent</b>
     * </p>
     *
     * @return No Transmission of Cumulative Quantities in SA Release
     */
    @SerializedName( "CumulativeQuantityIsNotSent" )
    @JsonProperty( "CumulativeQuantityIsNotSent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CumulativeQuantityIsNotSent" )
    private Boolean cumulativeQuantityIsNotSent;
    /**
     * Use with available fluent helpers to apply the <b>CumulativeQuantityIsNotSent</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> CUMULATIVE_QUANTITY_IS_NOT_SENT =
        new SchAgrmtItemField<Boolean>("CumulativeQuantityIsNotSent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SchedgAgrmtRelCreationProfile</b>
     * </p>
     *
     * @return Release Creation Profile
     */
    @SerializedName( "SchedgAgrmtRelCreationProfile" )
    @JsonProperty( "SchedgAgrmtRelCreationProfile" )
    @Nullable
    @ODataField( odataName = "SchedgAgrmtRelCreationProfile" )
    private String schedgAgrmtRelCreationProfile;
    /**
     * Use with available fluent helpers to apply the <b>SchedgAgrmtRelCreationProfile</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> SCHEDG_AGRMT_REL_CREATION_PROFILE =
        new SchAgrmtItemField<String>("SchedgAgrmtRelCreationProfile");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForJITDelivSchedule</b>
     * </p>
     *
     * @return JIT Delivery Schedules
     */
    @SerializedName( "IsRelevantForJITDelivSchedule" )
    @JsonProperty( "IsRelevantForJITDelivSchedule" )
    @Nullable
    @ODataField( odataName = "IsRelevantForJITDelivSchedule" )
    private String isRelevantForJITDelivSchedule;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForJITDelivSchedule</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> IS_RELEVANT_FOR_JIT_DELIV_SCHEDULE =
        new SchAgrmtItemField<String>("IsRelevantForJITDelivSchedule");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextFcstDelivSchedSendingDate</b>
     * </p>
     *
     * @return Next Forecast Delivery Schedule Transmission
     */
    @SerializedName( "NextFcstDelivSchedSendingDate" )
    @JsonProperty( "NextFcstDelivSchedSendingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NextFcstDelivSchedSendingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime nextFcstDelivSchedSendingDate;
    /**
     * Use with available fluent helpers to apply the <b>NextFcstDelivSchedSendingDate</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<LocalDateTime> NEXT_FCST_DELIV_SCHED_SENDING_DATE =
        new SchAgrmtItemField<LocalDateTime>("NextFcstDelivSchedSendingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextJITDelivSchedSendingDate</b>
     * </p>
     *
     * @return Next JIT Delivery Schedule Transmission
     */
    @SerializedName( "NextJITDelivSchedSendingDate" )
    @JsonProperty( "NextJITDelivSchedSendingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NextJITDelivSchedSendingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime nextJITDelivSchedSendingDate;
    /**
     * Use with available fluent helpers to apply the <b>NextJITDelivSchedSendingDate</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<LocalDateTime> NEXT_JIT_DELIV_SCHED_SENDING_DATE =
        new SchAgrmtItemField<LocalDateTime>("NextJITDelivSchedSendingDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LoadingPointForDelivery</b>
     * </p>
     *
     * @return Loading/Unloading Point
     */
    @SerializedName( "LoadingPointForDelivery" )
    @JsonProperty( "LoadingPointForDelivery" )
    @Nullable
    @ODataField( odataName = "LoadingPointForDelivery" )
    private String loadingPointForDelivery;
    /**
     * Use with available fluent helpers to apply the <b>LoadingPointForDelivery</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> LOADING_POINT_FOR_DELIVERY =
        new SchAgrmtItemField<String>("LoadingPointForDelivery");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineFirmOrderInDays</b>
     * </p>
     *
     * @return Firm Zone (Go-Ahead for Production)
     */
    @SerializedName( "ScheduleLineFirmOrderInDays" )
    @JsonProperty( "ScheduleLineFirmOrderInDays" )
    @Nullable
    @ODataField( odataName = "ScheduleLineFirmOrderInDays" )
    private BigDecimal scheduleLineFirmOrderInDays;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineFirmOrderInDays</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> SCHEDULE_LINE_FIRM_ORDER_IN_DAYS =
        new SchAgrmtItemField<BigDecimal>("ScheduleLineFirmOrderInDays");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineSemiFirmOrderInDays</b>
     * </p>
     *
     * @return Trade-Off Zone (Go-Ahead for Materials Procurement)
     */
    @SerializedName( "SchedLineSemiFirmOrderInDays" )
    @JsonProperty( "SchedLineSemiFirmOrderInDays" )
    @Nullable
    @ODataField( odataName = "SchedLineSemiFirmOrderInDays" )
    private BigDecimal schedLineSemiFirmOrderInDays;
    /**
     * Use with available fluent helpers to apply the <b>SchedLineSemiFirmOrderInDays</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<BigDecimal> SCHED_LINE_SEMI_FIRM_ORDER_IN_DAYS =
        new SchAgrmtItemField<BigDecimal>("SchedLineSemiFirmOrderInDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FirmTradeOffZoneBindMRP</b>
     * </p>
     *
     * @return Firm/Trade-Off Zones Binding with Regard to Mat. Planning
     */
    @SerializedName( "FirmTradeOffZoneBindMRP" )
    @JsonProperty( "FirmTradeOffZoneBindMRP" )
    @Nullable
    @ODataField( odataName = "FirmTradeOffZoneBindMRP" )
    private String firmTradeOffZoneBindMRP;
    /**
     * Use with available fluent helpers to apply the <b>FirmTradeOffZoneBindMRP</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> FIRM_TRADE_OFF_ZONE_BIND_MRP =
        new SchAgrmtItemField<String>("FirmTradeOffZoneBindMRP");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @return Product Compliance Supplier Check Status (Item)
     */
    @SerializedName( "PurgProdCmplncSupplierStatus" )
    @JsonProperty( "PurgProdCmplncSupplierStatus" )
    @Nullable
    @ODataField( odataName = "PurgProdCmplncSupplierStatus" )
    private String purgProdCmplncSupplierStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgProdCmplncSupplierStatus</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<String> PURG_PROD_CMPLNC_SUPPLIER_STATUS =
        new SchAgrmtItemField<String>("PurgProdCmplncSupplierStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsToBeAcceptedAtOrigin</b>
     * </p>
     *
     * @return Acceptance At Origin
     */
    @SerializedName( "IsToBeAcceptedAtOrigin" )
    @JsonProperty( "IsToBeAcceptedAtOrigin" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsToBeAcceptedAtOrigin" )
    private Boolean isToBeAcceptedAtOrigin;
    /**
     * Use with available fluent helpers to apply the <b>IsToBeAcceptedAtOrigin</b> field to query operations.
     *
     */
    public final static SchAgrmtItemField<Boolean> IS_TO_BE_ACCEPTED_AT_ORIGIN =
        new SchAgrmtItemField<Boolean>("IsToBeAcceptedAtOrigin");
    /**
     * Navigation property <b>to_SchAgrmtAcCnt</b> for <b>SchAgrmtItem</b> to multiple <b>SchAgrmtAcCnt</b>.
     *
     */
    @SerializedName( "to_SchAgrmtAcCnt" )
    @JsonProperty( "to_SchAgrmtAcCnt" )
    @ODataField( odataName = "to_SchAgrmtAcCnt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchAgrmtAcCnt> toSchAgrmtAcCnt;
    /**
     * Navigation property <b>to_SchAgrmtSchLine</b> for <b>SchAgrmtItem</b> to multiple <b>SchAgrmtSchLine</b>.
     *
     */
    @SerializedName( "to_SchAgrmtSchLine" )
    @JsonProperty( "to_SchAgrmtSchLine" )
    @ODataField( odataName = "to_SchAgrmtSchLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchAgrmtSchLine> toSchAgrmtSchLine;
    /**
     * Navigation property <b>to_SchedgAgrmtDeliveryAddress</b> for <b>SchAgrmtItem</b> to single
     * <b>SchedgAgrmtDeliveryAddress</b>.
     *
     */
    @SerializedName( "to_SchedgAgrmtDeliveryAddress" )
    @JsonProperty( "to_SchedgAgrmtDeliveryAddress" )
    @ODataField( odataName = "to_SchedgAgrmtDeliveryAddress" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SchedgAgrmtDeliveryAddress toSchedgAgrmtDeliveryAddress;
    /**
     * Navigation property <b>to_SchedgAgrmtItmNotes</b> for <b>SchAgrmtItem</b> to multiple <b>SchedgAgrmtItmNotes</b>.
     *
     */
    @SerializedName( "to_SchedgAgrmtItmNotes" )
    @JsonProperty( "to_SchedgAgrmtItmNotes" )
    @ODataField( odataName = "to_SchedgAgrmtItmNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchedgAgrmtItmNotes> toSchedgAgrmtItmNotes;
    /**
     * Use with available fluent helpers to apply the <b>to_SchAgrmtAcCnt</b> navigation property to query operations.
     *
     */
    public final static SchAgrmtItemLink<SchAgrmtAcCnt> TO_SCH_AGRMT_AC_CNT =
        new SchAgrmtItemLink<SchAgrmtAcCnt>("to_SchAgrmtAcCnt");
    /**
     * Use with available fluent helpers to apply the <b>to_SchAgrmtSchLine</b> navigation property to query operations.
     *
     */
    public final static SchAgrmtItemLink<SchAgrmtSchLine> TO_SCH_AGRMT_SCH_LINE =
        new SchAgrmtItemLink<SchAgrmtSchLine>("to_SchAgrmtSchLine");
    /**
     * Use with available fluent helpers to apply the <b>to_SchedgAgrmtDeliveryAddress</b> navigation property to query
     * operations.
     *
     */
    public final static SchAgrmtItemOneToOneLink<SchedgAgrmtDeliveryAddress> TO_SCHEDG_AGRMT_DELIVERY_ADDRESS =
        new SchAgrmtItemOneToOneLink<SchedgAgrmtDeliveryAddress>("to_SchedgAgrmtDeliveryAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_SchedgAgrmtItmNotes</b> navigation property to query
     * operations.
     *
     */
    public final static SchAgrmtItemLink<SchedgAgrmtItmNotes> TO_SCHEDG_AGRMT_ITM_NOTES =
        new SchAgrmtItemLink<SchedgAgrmtItmNotes>("to_SchedgAgrmtItmNotes");

    @Nonnull
    @Override
    public Class<SchAgrmtItem> getType()
    {
        return SchAgrmtItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     */
    public void setSchedulingAgreementItem( @Nullable final String schedulingAgreementItem )
    {
        rememberChangedField("SchedulingAgreementItem", this.schedulingAgreementItem);
        this.schedulingAgreementItem = schedulingAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @param purchasingDocumentItemText
     *            Short Text
     */
    public void setPurchasingDocumentItemText( @Nullable final String purchasingDocumentItemText )
    {
        rememberChangedField("PurchasingDocumentItemText", this.purchasingDocumentItemText);
        this.purchasingDocumentItemText = purchasingDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @param manufacturerMaterial
     *            Material number
     */
    public void setManufacturerMaterial( @Nullable final String manufacturerMaterial )
    {
        rememberChangedField("ManufacturerMaterial", this.manufacturerMaterial);
        this.manufacturerMaterial = manufacturerMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @param referenceDeliveryAddressID
     *            Number of delivery address
     */
    public void setReferenceDeliveryAddressID( @Nullable final String referenceDeliveryAddressID )
    {
        rememberChangedField("ReferenceDeliveryAddressID", this.referenceDeliveryAddressID);
        this.referenceDeliveryAddressID = referenceDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @param incotermsLocation1Identifier
     *            Identifier for Incoterm Location 1
     */
    public void setIncotermsLocation1Identifier( @Nullable final String incotermsLocation1Identifier )
    {
        rememberChangedField("IncotermsLocation1Identifier", this.incotermsLocation1Identifier);
        this.incotermsLocation1Identifier = incotermsLocation1Identifier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc1AddlUUID
     *            Incoterm Location 1 - Place of Destination
     */
    public void setIncotermsSupChnLoc1AddlUUID( @Nullable final UUID incotermsSupChnLoc1AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc1AddlUUID", this.incotermsSupChnLoc1AddlUUID);
        this.incotermsSupChnLoc1AddlUUID = incotermsSupChnLoc1AddlUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @param incotermsLocation2Identifier
     *            Identifier for Incoterm Location 2
     */
    public void setIncotermsLocation2Identifier( @Nullable final String incotermsLocation2Identifier )
    {
        rememberChangedField("IncotermsLocation2Identifier", this.incotermsLocation2Identifier);
        this.incotermsLocation2Identifier = incotermsLocation2Identifier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc2AddlUUID
     *            Incoterm Location 2 - Place of Delivery
     */
    public void setIncotermsSupChnLoc2AddlUUID( @Nullable final UUID incotermsSupChnLoc2AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc2AddlUUID", this.incotermsSupChnLoc2AddlUUID);
        this.incotermsSupChnLoc2AddlUUID = incotermsSupChnLoc2AddlUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnDvtgLocAddlUUID
     *            Incoterm - Deviating Place of Destination
     */
    public void setIncotermsSupChnDvtgLocAddlUUID( @Nullable final UUID incotermsSupChnDvtgLocAddlUUID )
    {
        rememberChangedField("IncotermsSupChnDvtgLocAddlUUID", this.incotermsSupChnDvtgLocAddlUUID);
        this.incotermsSupChnDvtgLocAddlUUID = incotermsSupChnDvtgLocAddlUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @param targetQuantity
     *            Target Quantity
     */
    public void setTargetQuantity( @Nullable final BigDecimal targetQuantity )
    {
        rememberChangedField("TargetQuantity", this.targetQuantity);
        this.targetQuantity = targetQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtAgreedCumQty</b>
     * </p>
     *
     * @param schedAgrmtAgreedCumQty
     *            Agreed Cumulative Quantity
     */
    public void setSchedAgrmtAgreedCumQty( @Nullable final BigDecimal schedAgrmtAgreedCumQty )
    {
        rememberChangedField("SchedAgrmtAgreedCumQty", this.schedAgrmtAgreedCumQty);
        this.schedAgrmtAgreedCumQty = schedAgrmtAgreedCumQty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtCumQtyReconcileDate</b>
     * </p>
     *
     * @param schedAgrmtCumQtyReconcileDate
     *            Reconciliation date for agreed cumulative quantity
     */
    public void setSchedAgrmtCumQtyReconcileDate( @Nullable final LocalDateTime schedAgrmtCumQtyReconcileDate )
    {
        rememberChangedField("SchedAgrmtCumQtyReconcileDate", this.schedAgrmtCumQtyReconcileDate);
        this.schedAgrmtCumQtyReconcileDate = schedAgrmtCumQtyReconcileDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ItemLastTransmissionDate</b>
     * </p>
     *
     * @param itemLastTransmissionDate
     *            Last Transmission
     */
    public void setItemLastTransmissionDate( @Nullable final LocalDateTime itemLastTransmissionDate )
    {
        rememberChangedField("ItemLastTransmissionDate", this.itemLastTransmissionDate);
        this.itemLastTransmissionDate = itemLastTransmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @param noDaysReminder1
     *            Number of Days for First Reminder/Expediter
     */
    public void setNoDaysReminder1( @Nullable final BigDecimal noDaysReminder1 )
    {
        rememberChangedField("NoDaysReminder1", this.noDaysReminder1);
        this.noDaysReminder1 = noDaysReminder1;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @param noDaysReminder2
     *            Number of Days for Second Reminder/Expediter
     */
    public void setNoDaysReminder2( @Nullable final BigDecimal noDaysReminder2 )
    {
        rememberChangedField("NoDaysReminder2", this.noDaysReminder2);
        this.noDaysReminder2 = noDaysReminder2;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @param noDaysReminder3
     *            Number of Days for Third Reminder/Expediter
     */
    public void setNoDaysReminder3( @Nullable final BigDecimal noDaysReminder3 )
    {
        rememberChangedField("NoDaysReminder3", this.noDaysReminder3);
        this.noDaysReminder3 = noDaysReminder3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @param purgDocOrderAcknNumber
     *            Order Acknowledgment Number
     */
    public void setPurgDocOrderAcknNumber( @Nullable final String purgDocOrderAcknNumber )
    {
        rememberChangedField("PurgDocOrderAcknNumber", this.purgDocOrderAcknNumber);
        this.purgDocOrderAcknNumber = purgDocOrderAcknNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @param requirementTracking
     *            Requirement Tracking Number
     */
    public void setRequirementTracking( @Nullable final String requirementTracking )
    {
        rememberChangedField("RequirementTracking", this.requirementTracking);
        this.requirementTracking = requirementTracking;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @param isOrderAcknRqd
     *            Order Acknowledgment Requirement
     */
    public void setIsOrderAcknRqd( @Nullable final Boolean isOrderAcknRqd )
    {
        rememberChangedField("IsOrderAcknRqd", this.isOrderAcknRqd);
        this.isOrderAcknRqd = isOrderAcknRqd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocEstimatedPrice</b>
     * </p>
     *
     * @param purgDocEstimatedPrice
     *            Indicator: Estimated Price
     */
    public void setPurgDocEstimatedPrice( @Nullable final Boolean purgDocEstimatedPrice )
    {
        rememberChangedField("PurgDocEstimatedPrice", this.purgDocEstimatedPrice);
        this.purgDocEstimatedPrice = purgDocEstimatedPrice;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @param priceIsToBePrinted
     *            Price Printout
     */
    public void setPriceIsToBePrinted( @Nullable final Boolean priceIsToBePrinted )
    {
        rememberChangedField("PriceIsToBePrinted", this.priceIsToBePrinted);
        this.priceIsToBePrinted = priceIsToBePrinted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistribution
     *            The multipleAcctAssgmtDistribution to set.
     */
    public void setMultipleAcctAssgmtDistribution( @Nullable final String multipleAcctAssgmtDistribution )
    {
        rememberChangedField("MultipleAcctAssgmtDistribution", this.multipleAcctAssgmtDistribution);
        this.multipleAcctAssgmtDistribution = multipleAcctAssgmtDistribution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialInvoiceDistribution</b>
     * </p>
     *
     * @param partialInvoiceDistribution
     *            The partialInvoiceDistribution to set.
     */
    public void setPartialInvoiceDistribution( @Nullable final String partialInvoiceDistribution )
    {
        rememberChangedField("PartialInvoiceDistribution", this.partialInvoiceDistribution);
        this.partialInvoiceDistribution = partialInvoiceDistribution;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price in Purchasing Document (in Document Currency)
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Price Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @param orderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setOrderPriceUnit( @Nullable final String orderPriceUnit )
    {
        rememberChangedField("OrderPriceUnit", this.orderPriceUnit);
        this.orderPriceUnit = orderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @param materialType
     *            Material Type
     */
    public void setMaterialType( @Nullable final String materialType )
    {
        rememberChangedField("MaterialType", this.materialType);
        this.materialType = materialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @param isInfoRecordUpdated
     *            Indicator: Update Info Record
     */
    public void setIsInfoRecordUpdated( @Nullable final String isInfoRecordUpdated )
    {
        rememberChangedField("IsInfoRecordUpdated", this.isInfoRecordUpdated);
        this.isInfoRecordUpdated = isInfoRecordUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @param ordPriceUnitToOrderUnitDnmntr
     *            Denominator for Conv. of Order Price Unit into Order Unit
     */
    public void setOrdPriceUnitToOrderUnitDnmntr( @Nullable final BigDecimal ordPriceUnitToOrderUnitDnmntr )
    {
        rememberChangedField("OrdPriceUnitToOrderUnitDnmntr", this.ordPriceUnitToOrderUnitDnmntr);
        this.ordPriceUnitToOrderUnitDnmntr = ordPriceUnitToOrderUnitDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @param orderPriceUnitToOrderUnitNmrtr
     *            Numerator for Conversion of Order Price Unit into Order Unit
     */
    public void setOrderPriceUnitToOrderUnitNmrtr( @Nullable final BigDecimal orderPriceUnitToOrderUnitNmrtr )
    {
        rememberChangedField("OrderPriceUnitToOrderUnitNmrtr", this.orderPriceUnitToOrderUnitNmrtr);
        this.orderPriceUnitToOrderUnitNmrtr = orderPriceUnitToOrderUnitNmrtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoAtRegistration</b>
     * </p>
     *
     * @param isInfoAtRegistration
     *            Indicator: Action at Registration
     */
    public void setIsInfoAtRegistration( @Nullable final String isInfoAtRegistration )
    {
        rememberChangedField("IsInfoAtRegistration", this.isInfoAtRegistration);
        this.isInfoAtRegistration = isInfoAtRegistration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @param goodsReceiptIsExpected
     *            Goods Receipt Indicator
     */
    public void setGoodsReceiptIsExpected( @Nullable final Boolean goodsReceiptIsExpected )
    {
        rememberChangedField("GoodsReceiptIsExpected", this.goodsReceiptIsExpected);
        this.goodsReceiptIsExpected = goodsReceiptIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @param goodsReceiptIsNonValuated
     *            Goods Receipt, Non-Valuated
     */
    public void setGoodsReceiptIsNonValuated( @Nullable final Boolean goodsReceiptIsNonValuated )
    {
        rememberChangedField("GoodsReceiptIsNonValuated", this.goodsReceiptIsNonValuated);
        this.goodsReceiptIsNonValuated = goodsReceiptIsNonValuated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @param invoiceIsExpected
     *            Invoice Receipt Indicator
     */
    public void setInvoiceIsExpected( @Nullable final Boolean invoiceIsExpected )
    {
        rememberChangedField("InvoiceIsExpected", this.invoiceIsExpected);
        this.invoiceIsExpected = invoiceIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @param invoiceIsGoodsReceiptBased
     *            Indicator: GR-Based Invoice Verification
     */
    public void setInvoiceIsGoodsReceiptBased( @Nullable final Boolean invoiceIsGoodsReceiptBased )
    {
        rememberChangedField("InvoiceIsGoodsReceiptBased", this.invoiceIsGoodsReceiptBased);
        this.invoiceIsGoodsReceiptBased = invoiceIsGoodsReceiptBased;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @param evaldRcptSettlmtIsAllowed
     *            Evaluated Receipt Settlement (ERS)
     */
    public void setEvaldRcptSettlmtIsAllowed( @Nullable final Boolean evaldRcptSettlmtIsAllowed )
    {
        rememberChangedField("EvaldRcptSettlmtIsAllowed", this.evaldRcptSettlmtIsAllowed);
        this.evaldRcptSettlmtIsAllowed = evaldRcptSettlmtIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @param minRemainingShelfLife
     *            Minimum Remaining Shelf Life
     */
    public void setMinRemainingShelfLife( @Nullable final BigDecimal minRemainingShelfLife )
    {
        rememberChangedField("MinRemainingShelfLife", this.minRemainingShelfLife);
        this.minRemainingShelfLife = minRemainingShelfLife;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QualityMgmtCtrlKey</b>
     * </p>
     *
     * @param qualityMgmtCtrlKey
     *            Control Key for Quality Management in Procurement
     */
    public void setQualityMgmtCtrlKey( @Nullable final String qualityMgmtCtrlKey )
    {
        rememberChangedField("QualityMgmtCtrlKey", this.qualityMgmtCtrlKey);
        this.qualityMgmtCtrlKey = qualityMgmtCtrlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityCertificateType</b>
     * </p>
     *
     * @param qualityCertificateType
     *            Certificate Type
     */
    public void setQualityCertificateType( @Nullable final String qualityCertificateType )
    {
        rememberChangedField("QualityCertificateType", this.qualityCertificateType);
        this.qualityCertificateType = qualityCertificateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedAgrmtCumulativeQtyControl</b>
     * </p>
     *
     * @param schedAgrmtCumulativeQtyControl
     *            CQ Control Type
     */
    public void setSchedAgrmtCumulativeQtyControl( @Nullable final String schedAgrmtCumulativeQtyControl )
    {
        rememberChangedField("SchedAgrmtCumulativeQtyControl", this.schedAgrmtCumulativeQtyControl);
        this.schedAgrmtCumulativeQtyControl = schedAgrmtCumulativeQtyControl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CumulativeQuantityIsNotSent</b>
     * </p>
     *
     * @param cumulativeQuantityIsNotSent
     *            No Transmission of Cumulative Quantities in SA Release
     */
    public void setCumulativeQuantityIsNotSent( @Nullable final Boolean cumulativeQuantityIsNotSent )
    {
        rememberChangedField("CumulativeQuantityIsNotSent", this.cumulativeQuantityIsNotSent);
        this.cumulativeQuantityIsNotSent = cumulativeQuantityIsNotSent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SchedgAgrmtRelCreationProfile</b>
     * </p>
     *
     * @param schedgAgrmtRelCreationProfile
     *            Release Creation Profile
     */
    public void setSchedgAgrmtRelCreationProfile( @Nullable final String schedgAgrmtRelCreationProfile )
    {
        rememberChangedField("SchedgAgrmtRelCreationProfile", this.schedgAgrmtRelCreationProfile);
        this.schedgAgrmtRelCreationProfile = schedgAgrmtRelCreationProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForJITDelivSchedule</b>
     * </p>
     *
     * @param isRelevantForJITDelivSchedule
     *            JIT Delivery Schedules
     */
    public void setIsRelevantForJITDelivSchedule( @Nullable final String isRelevantForJITDelivSchedule )
    {
        rememberChangedField("IsRelevantForJITDelivSchedule", this.isRelevantForJITDelivSchedule);
        this.isRelevantForJITDelivSchedule = isRelevantForJITDelivSchedule;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextFcstDelivSchedSendingDate</b>
     * </p>
     *
     * @param nextFcstDelivSchedSendingDate
     *            Next Forecast Delivery Schedule Transmission
     */
    public void setNextFcstDelivSchedSendingDate( @Nullable final LocalDateTime nextFcstDelivSchedSendingDate )
    {
        rememberChangedField("NextFcstDelivSchedSendingDate", this.nextFcstDelivSchedSendingDate);
        this.nextFcstDelivSchedSendingDate = nextFcstDelivSchedSendingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextJITDelivSchedSendingDate</b>
     * </p>
     *
     * @param nextJITDelivSchedSendingDate
     *            Next JIT Delivery Schedule Transmission
     */
    public void setNextJITDelivSchedSendingDate( @Nullable final LocalDateTime nextJITDelivSchedSendingDate )
    {
        rememberChangedField("NextJITDelivSchedSendingDate", this.nextJITDelivSchedSendingDate);
        this.nextJITDelivSchedSendingDate = nextJITDelivSchedSendingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LoadingPointForDelivery</b>
     * </p>
     *
     * @param loadingPointForDelivery
     *            Loading/Unloading Point
     */
    public void setLoadingPointForDelivery( @Nullable final String loadingPointForDelivery )
    {
        rememberChangedField("LoadingPointForDelivery", this.loadingPointForDelivery);
        this.loadingPointForDelivery = loadingPointForDelivery;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineFirmOrderInDays</b>
     * </p>
     *
     * @param scheduleLineFirmOrderInDays
     *            Firm Zone (Go-Ahead for Production)
     */
    public void setScheduleLineFirmOrderInDays( @Nullable final BigDecimal scheduleLineFirmOrderInDays )
    {
        rememberChangedField("ScheduleLineFirmOrderInDays", this.scheduleLineFirmOrderInDays);
        this.scheduleLineFirmOrderInDays = scheduleLineFirmOrderInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineSemiFirmOrderInDays</b>
     * </p>
     *
     * @param schedLineSemiFirmOrderInDays
     *            Trade-Off Zone (Go-Ahead for Materials Procurement)
     */
    public void setSchedLineSemiFirmOrderInDays( @Nullable final BigDecimal schedLineSemiFirmOrderInDays )
    {
        rememberChangedField("SchedLineSemiFirmOrderInDays", this.schedLineSemiFirmOrderInDays);
        this.schedLineSemiFirmOrderInDays = schedLineSemiFirmOrderInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FirmTradeOffZoneBindMRP</b>
     * </p>
     *
     * @param firmTradeOffZoneBindMRP
     *            Firm/Trade-Off Zones Binding with Regard to Mat. Planning
     */
    public void setFirmTradeOffZoneBindMRP( @Nullable final String firmTradeOffZoneBindMRP )
    {
        rememberChangedField("FirmTradeOffZoneBindMRP", this.firmTradeOffZoneBindMRP);
        this.firmTradeOffZoneBindMRP = firmTradeOffZoneBindMRP;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @param purgProdCmplncSupplierStatus
     *            Product Compliance Supplier Check Status (Item)
     */
    public void setPurgProdCmplncSupplierStatus( @Nullable final String purgProdCmplncSupplierStatus )
    {
        rememberChangedField("PurgProdCmplncSupplierStatus", this.purgProdCmplncSupplierStatus);
        this.purgProdCmplncSupplierStatus = purgProdCmplncSupplierStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsToBeAcceptedAtOrigin</b>
     * </p>
     *
     * @param isToBeAcceptedAtOrigin
     *            Acceptance At Origin
     */
    public void setIsToBeAcceptedAtOrigin( @Nullable final Boolean isToBeAcceptedAtOrigin )
    {
        rememberChangedField("IsToBeAcceptedAtOrigin", this.isToBeAcceptedAtOrigin);
        this.isToBeAcceptedAtOrigin = isToBeAcceptedAtOrigin;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchAgrmtItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        result.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("PurchasingDocumentItemText", getPurchasingDocumentItemText());
        values.put("Material", getMaterial());
        values.put("ManufacturerMaterial", getManufacturerMaterial());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Plant", getPlant());
        values.put("ReferenceDeliveryAddressID", getReferenceDeliveryAddressID());
        values.put("Customer", getCustomer());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsLocation1Identifier", getIncotermsLocation1Identifier());
        values.put("IncotermsSupChnLoc1AddlUUID", getIncotermsSupChnLoc1AddlUUID());
        values.put("IncotermsLocation2Identifier", getIncotermsLocation2Identifier());
        values.put("IncotermsSupChnLoc2AddlUUID", getIncotermsSupChnLoc2AddlUUID());
        values.put("IncotermsSupChnDvtgLocAddlUUID", getIncotermsSupChnDvtgLocAddlUUID());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("TargetQuantity", getTargetQuantity());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("SchedAgrmtAgreedCumQty", getSchedAgrmtAgreedCumQty());
        values.put("SchedAgrmtCumQtyReconcileDate", getSchedAgrmtCumQtyReconcileDate());
        values.put("ItemLastTransmissionDate", getItemLastTransmissionDate());
        values.put("NoDaysReminder1", getNoDaysReminder1());
        values.put("NoDaysReminder2", getNoDaysReminder2());
        values.put("NoDaysReminder3", getNoDaysReminder3());
        values.put("PurgDocOrderAcknNumber", getPurgDocOrderAcknNumber());
        values.put("RequirementTracking", getRequirementTracking());
        values.put("IsOrderAcknRqd", getIsOrderAcknRqd());
        values.put("PurgDocEstimatedPrice", getPurgDocEstimatedPrice());
        values.put("PriceIsToBePrinted", getPriceIsToBePrinted());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("MultipleAcctAssgmtDistribution", getMultipleAcctAssgmtDistribution());
        values.put("PartialInvoiceDistribution", getPartialInvoiceDistribution());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("OrderPriceUnit", getOrderPriceUnit());
        values.put("ProductType", getProductType());
        values.put("MaterialType", getMaterialType());
        values.put("StorageLocation", getStorageLocation());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("IsInfoRecordUpdated", getIsInfoRecordUpdated());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("OrdPriceUnitToOrderUnitDnmntr", getOrdPriceUnitToOrderUnitDnmntr());
        values.put("OrderPriceUnitToOrderUnitNmrtr", getOrderPriceUnitToOrderUnitNmrtr());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("StockType", getStockType());
        values.put("TaxCode", getTaxCode());
        values.put("TaxCountry", getTaxCountry());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("IsInfoAtRegistration", getIsInfoAtRegistration());
        values.put("GoodsReceiptIsExpected", getGoodsReceiptIsExpected());
        values.put("GoodsReceiptIsNonValuated", getGoodsReceiptIsNonValuated());
        values.put("InvoiceIsExpected", getInvoiceIsExpected());
        values.put("InvoiceIsGoodsReceiptBased", getInvoiceIsGoodsReceiptBased());
        values.put("EvaldRcptSettlmtIsAllowed", getEvaldRcptSettlmtIsAllowed());
        values.put("MinRemainingShelfLife", getMinRemainingShelfLife());
        values.put("QualityMgmtCtrlKey", getQualityMgmtCtrlKey());
        values.put("QualityCertificateType", getQualityCertificateType());
        values.put("SchedAgrmtCumulativeQtyControl", getSchedAgrmtCumulativeQtyControl());
        values.put("CumulativeQuantityIsNotSent", getCumulativeQuantityIsNotSent());
        values.put("SchedgAgrmtRelCreationProfile", getSchedgAgrmtRelCreationProfile());
        values.put("IsRelevantForJITDelivSchedule", getIsRelevantForJITDelivSchedule());
        values.put("NextFcstDelivSchedSendingDate", getNextFcstDelivSchedSendingDate());
        values.put("NextJITDelivSchedSendingDate", getNextJITDelivSchedSendingDate());
        values.put("LoadingPointForDelivery", getLoadingPointForDelivery());
        values.put("ScheduleLineFirmOrderInDays", getScheduleLineFirmOrderInDays());
        values.put("SchedLineSemiFirmOrderInDays", getSchedLineSemiFirmOrderInDays());
        values.put("FirmTradeOffZoneBindMRP", getFirmTradeOffZoneBindMRP());
        values.put("PurgProdCmplncSupplierStatus", getPurgProdCmplncSupplierStatus());
        values.put("IsToBeAcceptedAtOrigin", getIsToBeAcceptedAtOrigin());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementItem") ) {
                final Object value = values.remove("SchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSchedulingAgreementItem())) ) {
                    setSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemText") ) {
                final Object value = values.remove("PurchasingDocumentItemText");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemText())) ) {
                    setPurchasingDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ManufacturerMaterial") ) {
                final Object value = values.remove("ManufacturerMaterial");
                if( (value == null) || (!value.equals(getManufacturerMaterial())) ) {
                    setManufacturerMaterial(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ReferenceDeliveryAddressID") ) {
                final Object value = values.remove("ReferenceDeliveryAddressID");
                if( (value == null) || (!value.equals(getReferenceDeliveryAddressID())) ) {
                    setReferenceDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1Identifier") ) {
                final Object value = values.remove("IncotermsLocation1Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation1Identifier())) ) {
                    setIncotermsLocation1Identifier(((String) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc1AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc1AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc1AddlUUID())) ) {
                    setIncotermsSupChnLoc1AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsLocation2Identifier") ) {
                final Object value = values.remove("IncotermsLocation2Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation2Identifier())) ) {
                    setIncotermsLocation2Identifier(((String) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc2AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc2AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc2AddlUUID())) ) {
                    setIncotermsSupChnLoc2AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsSupChnDvtgLocAddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnDvtgLocAddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnDvtgLocAddlUUID())) ) {
                    setIncotermsSupChnDvtgLocAddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("TargetQuantity") ) {
                final Object value = values.remove("TargetQuantity");
                if( (value == null) || (!value.equals(getTargetQuantity())) ) {
                    setTargetQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("SchedAgrmtAgreedCumQty") ) {
                final Object value = values.remove("SchedAgrmtAgreedCumQty");
                if( (value == null) || (!value.equals(getSchedAgrmtAgreedCumQty())) ) {
                    setSchedAgrmtAgreedCumQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("SchedAgrmtCumQtyReconcileDate") ) {
                final Object value = values.remove("SchedAgrmtCumQtyReconcileDate");
                if( (value == null) || (!value.equals(getSchedAgrmtCumQtyReconcileDate())) ) {
                    setSchedAgrmtCumQtyReconcileDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ItemLastTransmissionDate") ) {
                final Object value = values.remove("ItemLastTransmissionDate");
                if( (value == null) || (!value.equals(getItemLastTransmissionDate())) ) {
                    setItemLastTransmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NoDaysReminder1") ) {
                final Object value = values.remove("NoDaysReminder1");
                if( (value == null) || (!value.equals(getNoDaysReminder1())) ) {
                    setNoDaysReminder1(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder2") ) {
                final Object value = values.remove("NoDaysReminder2");
                if( (value == null) || (!value.equals(getNoDaysReminder2())) ) {
                    setNoDaysReminder2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder3") ) {
                final Object value = values.remove("NoDaysReminder3");
                if( (value == null) || (!value.equals(getNoDaysReminder3())) ) {
                    setNoDaysReminder3(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgDocOrderAcknNumber") ) {
                final Object value = values.remove("PurgDocOrderAcknNumber");
                if( (value == null) || (!value.equals(getPurgDocOrderAcknNumber())) ) {
                    setPurgDocOrderAcknNumber(((String) value));
                }
            }
            if( values.containsKey("RequirementTracking") ) {
                final Object value = values.remove("RequirementTracking");
                if( (value == null) || (!value.equals(getRequirementTracking())) ) {
                    setRequirementTracking(((String) value));
                }
            }
            if( values.containsKey("IsOrderAcknRqd") ) {
                final Object value = values.remove("IsOrderAcknRqd");
                if( (value == null) || (!value.equals(getIsOrderAcknRqd())) ) {
                    setIsOrderAcknRqd(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocEstimatedPrice") ) {
                final Object value = values.remove("PurgDocEstimatedPrice");
                if( (value == null) || (!value.equals(getPurgDocEstimatedPrice())) ) {
                    setPurgDocEstimatedPrice(((Boolean) value));
                }
            }
            if( values.containsKey("PriceIsToBePrinted") ) {
                final Object value = values.remove("PriceIsToBePrinted");
                if( (value == null) || (!value.equals(getPriceIsToBePrinted())) ) {
                    setPriceIsToBePrinted(((Boolean) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistribution") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistribution");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistribution())) ) {
                    setMultipleAcctAssgmtDistribution(((String) value));
                }
            }
            if( values.containsKey("PartialInvoiceDistribution") ) {
                final Object value = values.remove("PartialInvoiceDistribution");
                if( (value == null) || (!value.equals(getPartialInvoiceDistribution())) ) {
                    setPartialInvoiceDistribution(((String) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnit") ) {
                final Object value = values.remove("OrderPriceUnit");
                if( (value == null) || (!value.equals(getOrderPriceUnit())) ) {
                    setOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("MaterialType") ) {
                final Object value = values.remove("MaterialType");
                if( (value == null) || (!value.equals(getMaterialType())) ) {
                    setMaterialType(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("IsInfoRecordUpdated") ) {
                final Object value = values.remove("IsInfoRecordUpdated");
                if( (value == null) || (!value.equals(getIsInfoRecordUpdated())) ) {
                    setIsInfoRecordUpdated(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("OrdPriceUnitToOrderUnitDnmntr") ) {
                final Object value = values.remove("OrdPriceUnitToOrderUnitDnmntr");
                if( (value == null) || (!value.equals(getOrdPriceUnitToOrderUnitDnmntr())) ) {
                    setOrdPriceUnitToOrderUnitDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnitToOrderUnitNmrtr") ) {
                final Object value = values.remove("OrderPriceUnitToOrderUnitNmrtr");
                if( (value == null) || (!value.equals(getOrderPriceUnitToOrderUnitNmrtr())) ) {
                    setOrderPriceUnitToOrderUnitNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("IsInfoAtRegistration") ) {
                final Object value = values.remove("IsInfoAtRegistration");
                if( (value == null) || (!value.equals(getIsInfoAtRegistration())) ) {
                    setIsInfoAtRegistration(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsExpected") ) {
                final Object value = values.remove("GoodsReceiptIsExpected");
                if( (value == null) || (!value.equals(getGoodsReceiptIsExpected())) ) {
                    setGoodsReceiptIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsNonValuated") ) {
                final Object value = values.remove("GoodsReceiptIsNonValuated");
                if( (value == null) || (!value.equals(getGoodsReceiptIsNonValuated())) ) {
                    setGoodsReceiptIsNonValuated(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsExpected") ) {
                final Object value = values.remove("InvoiceIsExpected");
                if( (value == null) || (!value.equals(getInvoiceIsExpected())) ) {
                    setInvoiceIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsGoodsReceiptBased") ) {
                final Object value = values.remove("InvoiceIsGoodsReceiptBased");
                if( (value == null) || (!value.equals(getInvoiceIsGoodsReceiptBased())) ) {
                    setInvoiceIsGoodsReceiptBased(((Boolean) value));
                }
            }
            if( values.containsKey("EvaldRcptSettlmtIsAllowed") ) {
                final Object value = values.remove("EvaldRcptSettlmtIsAllowed");
                if( (value == null) || (!value.equals(getEvaldRcptSettlmtIsAllowed())) ) {
                    setEvaldRcptSettlmtIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("MinRemainingShelfLife") ) {
                final Object value = values.remove("MinRemainingShelfLife");
                if( (value == null) || (!value.equals(getMinRemainingShelfLife())) ) {
                    setMinRemainingShelfLife(((BigDecimal) value));
                }
            }
            if( values.containsKey("QualityMgmtCtrlKey") ) {
                final Object value = values.remove("QualityMgmtCtrlKey");
                if( (value == null) || (!value.equals(getQualityMgmtCtrlKey())) ) {
                    setQualityMgmtCtrlKey(((String) value));
                }
            }
            if( values.containsKey("QualityCertificateType") ) {
                final Object value = values.remove("QualityCertificateType");
                if( (value == null) || (!value.equals(getQualityCertificateType())) ) {
                    setQualityCertificateType(((String) value));
                }
            }
            if( values.containsKey("SchedAgrmtCumulativeQtyControl") ) {
                final Object value = values.remove("SchedAgrmtCumulativeQtyControl");
                if( (value == null) || (!value.equals(getSchedAgrmtCumulativeQtyControl())) ) {
                    setSchedAgrmtCumulativeQtyControl(((String) value));
                }
            }
            if( values.containsKey("CumulativeQuantityIsNotSent") ) {
                final Object value = values.remove("CumulativeQuantityIsNotSent");
                if( (value == null) || (!value.equals(getCumulativeQuantityIsNotSent())) ) {
                    setCumulativeQuantityIsNotSent(((Boolean) value));
                }
            }
            if( values.containsKey("SchedgAgrmtRelCreationProfile") ) {
                final Object value = values.remove("SchedgAgrmtRelCreationProfile");
                if( (value == null) || (!value.equals(getSchedgAgrmtRelCreationProfile())) ) {
                    setSchedgAgrmtRelCreationProfile(((String) value));
                }
            }
            if( values.containsKey("IsRelevantForJITDelivSchedule") ) {
                final Object value = values.remove("IsRelevantForJITDelivSchedule");
                if( (value == null) || (!value.equals(getIsRelevantForJITDelivSchedule())) ) {
                    setIsRelevantForJITDelivSchedule(((String) value));
                }
            }
            if( values.containsKey("NextFcstDelivSchedSendingDate") ) {
                final Object value = values.remove("NextFcstDelivSchedSendingDate");
                if( (value == null) || (!value.equals(getNextFcstDelivSchedSendingDate())) ) {
                    setNextFcstDelivSchedSendingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NextJITDelivSchedSendingDate") ) {
                final Object value = values.remove("NextJITDelivSchedSendingDate");
                if( (value == null) || (!value.equals(getNextJITDelivSchedSendingDate())) ) {
                    setNextJITDelivSchedSendingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LoadingPointForDelivery") ) {
                final Object value = values.remove("LoadingPointForDelivery");
                if( (value == null) || (!value.equals(getLoadingPointForDelivery())) ) {
                    setLoadingPointForDelivery(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineFirmOrderInDays") ) {
                final Object value = values.remove("ScheduleLineFirmOrderInDays");
                if( (value == null) || (!value.equals(getScheduleLineFirmOrderInDays())) ) {
                    setScheduleLineFirmOrderInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SchedLineSemiFirmOrderInDays") ) {
                final Object value = values.remove("SchedLineSemiFirmOrderInDays");
                if( (value == null) || (!value.equals(getSchedLineSemiFirmOrderInDays())) ) {
                    setSchedLineSemiFirmOrderInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("FirmTradeOffZoneBindMRP") ) {
                final Object value = values.remove("FirmTradeOffZoneBindMRP");
                if( (value == null) || (!value.equals(getFirmTradeOffZoneBindMRP())) ) {
                    setFirmTradeOffZoneBindMRP(((String) value));
                }
            }
            if( values.containsKey("PurgProdCmplncSupplierStatus") ) {
                final Object value = values.remove("PurgProdCmplncSupplierStatus");
                if( (value == null) || (!value.equals(getPurgProdCmplncSupplierStatus())) ) {
                    setPurgProdCmplncSupplierStatus(((String) value));
                }
            }
            if( values.containsKey("IsToBeAcceptedAtOrigin") ) {
                final Object value = values.remove("IsToBeAcceptedAtOrigin");
                if( (value == null) || (!value.equals(getIsToBeAcceptedAtOrigin())) ) {
                    setIsToBeAcceptedAtOrigin(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SchAgrmtAcCnt") ) {
                final Object value = (values).remove("to_SchAgrmtAcCnt");
                if( value instanceof Iterable ) {
                    if( toSchAgrmtAcCnt == null ) {
                        toSchAgrmtAcCnt = Lists.newArrayList();
                    } else {
                        toSchAgrmtAcCnt = Lists.newArrayList(toSchAgrmtAcCnt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchAgrmtAcCnt entity;
                        if( toSchAgrmtAcCnt.size() > i ) {
                            entity = toSchAgrmtAcCnt.get(i);
                        } else {
                            entity = new SchAgrmtAcCnt();
                            toSchAgrmtAcCnt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SchAgrmtSchLine") ) {
                final Object value = (values).remove("to_SchAgrmtSchLine");
                if( value instanceof Iterable ) {
                    if( toSchAgrmtSchLine == null ) {
                        toSchAgrmtSchLine = Lists.newArrayList();
                    } else {
                        toSchAgrmtSchLine = Lists.newArrayList(toSchAgrmtSchLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchAgrmtSchLine entity;
                        if( toSchAgrmtSchLine.size() > i ) {
                            entity = toSchAgrmtSchLine.get(i);
                        } else {
                            entity = new SchAgrmtSchLine();
                            toSchAgrmtSchLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SchedgAgrmtDeliveryAddress") ) {
                final Object value = (values).remove("to_SchedgAgrmtDeliveryAddress");
                if( value instanceof Map ) {
                    if( toSchedgAgrmtDeliveryAddress == null ) {
                        toSchedgAgrmtDeliveryAddress = new SchedgAgrmtDeliveryAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSchedgAgrmtDeliveryAddress.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SchedgAgrmtItmNotes") ) {
                final Object value = (values).remove("to_SchedgAgrmtItmNotes");
                if( value instanceof Iterable ) {
                    if( toSchedgAgrmtItmNotes == null ) {
                        toSchedgAgrmtItmNotes = Lists.newArrayList();
                    } else {
                        toSchedgAgrmtItmNotes = Lists.newArrayList(toSchedgAgrmtItmNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchedgAgrmtItmNotes entity;
                        if( toSchedgAgrmtItmNotes.size() > i ) {
                            entity = toSchedgAgrmtItmNotes.get(i);
                        } else {
                            entity = new SchedgAgrmtItmNotes();
                            toSchedgAgrmtItmNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SchAgrmtItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchAgrmtItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchAgrmtItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchAgrmtItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSchAgrmtAcCnt != null ) {
            (values).put("to_SchAgrmtAcCnt", toSchAgrmtAcCnt);
        }
        if( toSchAgrmtSchLine != null ) {
            (values).put("to_SchAgrmtSchLine", toSchAgrmtSchLine);
        }
        if( toSchedgAgrmtDeliveryAddress != null ) {
            (values).put("to_SchedgAgrmtDeliveryAddress", toSchedgAgrmtDeliveryAddress);
        }
        if( toSchedgAgrmtItmNotes != null ) {
            (values).put("to_SchedgAgrmtItmNotes", toSchedgAgrmtItmNotes);
        }
        return values;
    }

    /**
     * Fetches the <b>SchAgrmtAcCnt</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SchAgrmtAcCnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchAgrmtAcCnt</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtAcCnt> fetchSchAgrmtAcCnt()
    {
        return fetchFieldAsList("to_SchAgrmtAcCnt", SchAgrmtAcCnt.class);
    }

    /**
     * Retrieval of associated <b>SchAgrmtAcCnt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtAcCnt</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtAcCnt</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchAgrmtAcCnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtAcCnt> getSchAgrmtAcCntOrFetch()
    {
        if( toSchAgrmtAcCnt == null ) {
            toSchAgrmtAcCnt = fetchSchAgrmtAcCnt();
        }
        return toSchAgrmtAcCnt;
    }

    /**
     * Retrieval of associated <b>SchAgrmtAcCnt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtAcCnt</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchAgrmtAcCnt</b> is already loaded, the result will
     *         contain the <b>SchAgrmtAcCnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchAgrmtAcCnt>> getSchAgrmtAcCntIfPresent()
    {
        return Option.of(toSchAgrmtAcCnt);
    }

    /**
     * Overwrites the list of associated <b>SchAgrmtAcCnt</b> entities for the loaded navigation property
     * <b>to_SchAgrmtAcCnt</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtAcCnt</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchAgrmtAcCnt</b> entities.
     */
    public void setSchAgrmtAcCnt( @Nonnull final List<SchAgrmtAcCnt> value )
    {
        if( toSchAgrmtAcCnt == null ) {
            toSchAgrmtAcCnt = Lists.newArrayList();
        }
        toSchAgrmtAcCnt.clear();
        toSchAgrmtAcCnt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchAgrmtAcCnt</b> entities. This corresponds to the OData navigation
     * property <b>to_SchAgrmtAcCnt</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtAcCnt</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchAgrmtAcCnt</b> entities.
     */
    public void addSchAgrmtAcCnt( SchAgrmtAcCnt... entity )
    {
        if( toSchAgrmtAcCnt == null ) {
            toSchAgrmtAcCnt = Lists.newArrayList();
        }
        toSchAgrmtAcCnt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SchAgrmtSchLine</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SchAgrmtSchLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchAgrmtSchLine</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtSchLine> fetchSchAgrmtSchLine()
    {
        return fetchFieldAsList("to_SchAgrmtSchLine", SchAgrmtSchLine.class);
    }

    /**
     * Retrieval of associated <b>SchAgrmtSchLine</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtSchLine</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtSchLine</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchAgrmtSchLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchAgrmtSchLine> getSchAgrmtSchLineOrFetch()
    {
        if( toSchAgrmtSchLine == null ) {
            toSchAgrmtSchLine = fetchSchAgrmtSchLine();
        }
        return toSchAgrmtSchLine;
    }

    /**
     * Retrieval of associated <b>SchAgrmtSchLine</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SchAgrmtSchLine</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchAgrmtSchLine</b> is already loaded, the result will
     *         contain the <b>SchAgrmtSchLine</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchAgrmtSchLine>> getSchAgrmtSchLineIfPresent()
    {
        return Option.of(toSchAgrmtSchLine);
    }

    /**
     * Overwrites the list of associated <b>SchAgrmtSchLine</b> entities for the loaded navigation property
     * <b>to_SchAgrmtSchLine</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtSchLine</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchAgrmtSchLine</b> entities.
     */
    public void setSchAgrmtSchLine( @Nonnull final List<SchAgrmtSchLine> value )
    {
        if( toSchAgrmtSchLine == null ) {
            toSchAgrmtSchLine = Lists.newArrayList();
        }
        toSchAgrmtSchLine.clear();
        toSchAgrmtSchLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchAgrmtSchLine</b> entities. This corresponds to the OData navigation
     * property <b>to_SchAgrmtSchLine</b>.
     * <p>
     * If the navigation property <b>to_SchAgrmtSchLine</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchAgrmtSchLine</b> entities.
     */
    public void addSchAgrmtSchLine( SchAgrmtSchLine... entity )
    {
        if( toSchAgrmtSchLine == null ) {
            toSchAgrmtSchLine = Lists.newArrayList();
        }
        toSchAgrmtSchLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SchedgAgrmtDeliveryAddress</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SchedgAgrmtDeliveryAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SchedgAgrmtDeliveryAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SchedgAgrmtDeliveryAddress fetchSchedgAgrmtDeliveryAddress()
    {
        return fetchFieldAsSingle("to_SchedgAgrmtDeliveryAddress", SchedgAgrmtDeliveryAddress.class);
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtDeliveryAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtDeliveryAddress</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtDeliveryAddress</b> of a queried <b>SchAgrmtItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchedgAgrmtDeliveryAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SchedgAgrmtDeliveryAddress getSchedgAgrmtDeliveryAddressOrFetch()
    {
        if( toSchedgAgrmtDeliveryAddress == null ) {
            toSchedgAgrmtDeliveryAddress = fetchSchedgAgrmtDeliveryAddress();
        }
        return toSchedgAgrmtDeliveryAddress;
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtDeliveryAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtDeliveryAddress</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchedgAgrmtDeliveryAddress</b> is already loaded, the
     *         result will contain the <b>SchedgAgrmtDeliveryAddress</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SchedgAgrmtDeliveryAddress> getSchedgAgrmtDeliveryAddressIfPresent()
    {
        return Option.of(toSchedgAgrmtDeliveryAddress);
    }

    /**
     * Overwrites the associated <b>SchedgAgrmtDeliveryAddress</b> entity for the loaded navigation property
     * <b>to_SchedgAgrmtDeliveryAddress</b>.
     *
     * @param value
     *            New <b>SchedgAgrmtDeliveryAddress</b> entity.
     */
    public void setSchedgAgrmtDeliveryAddress( final SchedgAgrmtDeliveryAddress value )
    {
        toSchedgAgrmtDeliveryAddress = value;
    }

    /**
     * Fetches the <b>SchedgAgrmtItmNotes</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SchedgAgrmtItmNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchedgAgrmtItmNotes</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtItmNotes> fetchSchedgAgrmtItmNotes()
    {
        return fetchFieldAsList("to_SchedgAgrmtItmNotes", SchedgAgrmtItmNotes.class);
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtItmNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtItmNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItmNotes</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchedgAgrmtItmNotes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtItmNotes> getSchedgAgrmtItmNotesOrFetch()
    {
        if( toSchedgAgrmtItmNotes == null ) {
            toSchedgAgrmtItmNotes = fetchSchedgAgrmtItmNotes();
        }
        return toSchedgAgrmtItmNotes;
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtItmNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtItmNotes</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchedgAgrmtItmNotes</b> is already loaded, the result
     *         will contain the <b>SchedgAgrmtItmNotes</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchedgAgrmtItmNotes>> getSchedgAgrmtItmNotesIfPresent()
    {
        return Option.of(toSchedgAgrmtItmNotes);
    }

    /**
     * Overwrites the list of associated <b>SchedgAgrmtItmNotes</b> entities for the loaded navigation property
     * <b>to_SchedgAgrmtItmNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItmNotes</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchedgAgrmtItmNotes</b> entities.
     */
    public void setSchedgAgrmtItmNotes( @Nonnull final List<SchedgAgrmtItmNotes> value )
    {
        if( toSchedgAgrmtItmNotes == null ) {
            toSchedgAgrmtItmNotes = Lists.newArrayList();
        }
        toSchedgAgrmtItmNotes.clear();
        toSchedgAgrmtItmNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchedgAgrmtItmNotes</b> entities. This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtItmNotes</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtItmNotes</b> of a queried <b>SchAgrmtItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchedgAgrmtItmNotes</b> entities.
     */
    public void addSchedgAgrmtItmNotes( SchedgAgrmtItmNotes... entity )
    {
        if( toSchedgAgrmtItmNotes == null ) {
            toSchedgAgrmtItmNotes = Lists.newArrayList();
        }
        toSchedgAgrmtItmNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SchAgrmtItem instances.
     *
     */
    public final static class SchAgrmtItemBuilder
    {

        private List<SchAgrmtAcCnt> toSchAgrmtAcCnt = Lists.newArrayList();
        private List<SchAgrmtSchLine> toSchAgrmtSchLine = Lists.newArrayList();
        private SchedgAgrmtDeliveryAddress toSchedgAgrmtDeliveryAddress;
        private List<SchedgAgrmtItmNotes> toSchedgAgrmtItmNotes = Lists.newArrayList();

        private SchAgrmtItem.SchAgrmtItemBuilder toSchAgrmtAcCnt( final List<SchAgrmtAcCnt> value )
        {
            toSchAgrmtAcCnt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchAgrmtAcCnt</b> for <b>SchAgrmtItem</b> to multiple <b>SchAgrmtAcCnt</b>.
         *
         * @param value
         *            The SchAgrmtAcCnts to build this SchAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtItem.SchAgrmtItemBuilder schAgrmtAcCnt( SchAgrmtAcCnt... value )
        {
            return toSchAgrmtAcCnt(Lists.newArrayList(value));
        }

        private SchAgrmtItem.SchAgrmtItemBuilder toSchAgrmtSchLine( final List<SchAgrmtSchLine> value )
        {
            toSchAgrmtSchLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchAgrmtSchLine</b> for <b>SchAgrmtItem</b> to multiple <b>SchAgrmtSchLine</b>.
         *
         * @param value
         *            The SchAgrmtSchLines to build this SchAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtItem.SchAgrmtItemBuilder schAgrmtSchLine( SchAgrmtSchLine... value )
        {
            return toSchAgrmtSchLine(Lists.newArrayList(value));
        }

        private SchAgrmtItem.SchAgrmtItemBuilder toSchedgAgrmtDeliveryAddress( final SchedgAgrmtDeliveryAddress value )
        {
            toSchedgAgrmtDeliveryAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_SchedgAgrmtDeliveryAddress</b> for <b>SchAgrmtItem</b> to single
         * <b>SchedgAgrmtDeliveryAddress</b>.
         *
         * @param value
         *            The SchedgAgrmtDeliveryAddress to build this SchAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtItem.SchAgrmtItemBuilder schedgAgrmtDeliveryAddress( final SchedgAgrmtDeliveryAddress value )
        {
            return toSchedgAgrmtDeliveryAddress(value);
        }

        private SchAgrmtItem.SchAgrmtItemBuilder toSchedgAgrmtItmNotes( final List<SchedgAgrmtItmNotes> value )
        {
            toSchedgAgrmtItmNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchedgAgrmtItmNotes</b> for <b>SchAgrmtItem</b> to multiple
         * <b>SchedgAgrmtItmNotes</b>.
         *
         * @param value
         *            The SchedgAgrmtItmNotess to build this SchAgrmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtItem.SchAgrmtItemBuilder schedgAgrmtItmNotes( SchedgAgrmtItmNotes... value )
        {
            return toSchedgAgrmtItmNotes(Lists.newArrayList(value));
        }

    }

}
