/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SchAgrmtItemByKeyFluentHelper
    extends
    FluentHelperByKey<SchAgrmtItemByKeyFluentHelper, SchAgrmtItem, SchAgrmtItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SchAgrmtItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SchAgrmtItem}
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public SchAgrmtItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String schedulingAgreement,
        final String schedulingAgreementItem )
    {
        super(servicePath, entityCollection);
        this.key.put("SchedulingAgreement", schedulingAgreement);
        this.key.put("SchedulingAgreementItem", schedulingAgreementItem);
    }

    @Override
    @Nonnull
    protected Class<SchAgrmtItem> getEntityClass()
    {
        return SchAgrmtItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
